/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public abstract class FlushablePool
extends Pool {
    protected Array obtained = new Array();

    public FlushablePool() {
    }

    public FlushablePool(int n2) {
        super(n2);
    }

    public FlushablePool(int n2, int n3) {
        super(n2, n3);
    }

    @Override
    public Object obtain() {
        Object object = super.obtain();
        this.obtained.add(object);
        return object;
    }

    public void flush() {
        FlushablePool flushablePool = this;
        super.freeAll(flushablePool.obtained);
        this.obtained.clear();
    }

    @Override
    public void free(Object object) {
        this.obtained.removeValue(object, true);
        super.free(object);
    }

    @Override
    public void freeAll(Array array) {
        this.obtained.removeAll(array, true);
        super.freeAll(array);
    }
}

