/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;

public class CharArray {
    public char[] items;
    public int size;
    public boolean ordered;

    public CharArray() {
        this(true, 16);
    }

    public CharArray(int n2) {
        this(true, n2);
    }

    public CharArray(boolean bl2, int n2) {
        this.ordered = bl2;
        this.items = new char[n2];
    }

    public CharArray(CharArray charArray) {
        this.ordered = charArray.ordered;
        this.size = charArray.size;
        this.items = new char[this.size];
        System.arraycopy(charArray.items, 0, this.items, 0, this.size);
    }

    public CharArray(char[] cArray) {
        this(true, cArray, 0, cArray.length);
    }

    public CharArray(boolean bl2, char[] cArray, int n2, int n3) {
        this(bl2, n3);
        this.size = n3;
        System.arraycopy(cArray, n2, this.items, 0, n3);
    }

    public void add(char c2) {
        char[] cArray = this.items;
        if (this.size == cArray.length) {
            cArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        cArray[this.size++] = c2;
    }

    public void add(char c2, char c3) {
        char[] cArray = this.items;
        if (this.size + 1 >= cArray.length) {
            cArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        cArray[this.size] = c2;
        cArray[this.size + 1] = c3;
        this.size += 2;
    }

    public void add(char c2, char c3, char c4) {
        char[] cArray = this.items;
        if (this.size + 2 >= cArray.length) {
            cArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        cArray[this.size] = c2;
        cArray[this.size + 1] = c3;
        cArray[this.size + 2] = c4;
        this.size += 3;
    }

    public void add(char c2, char c3, char c4, char c5) {
        char[] cArray = this.items;
        if (this.size + 3 >= cArray.length) {
            cArray = this.resize(Math.max(8, (int)((float)this.size * 1.8f)));
        }
        cArray[this.size] = c2;
        cArray[this.size + 1] = c3;
        cArray[this.size + 2] = c4;
        cArray[this.size + 3] = c5;
        this.size += 4;
    }

    public void addAll(CharArray charArray) {
        this.addAll(charArray.items, 0, charArray.size);
    }

    public void addAll(CharArray charArray, int n2, int n3) {
        if (n2 + n3 > charArray.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n2 + " + " + n3 + " <= " + charArray.size);
        }
        this.addAll(charArray.items, n2, n3);
    }

    public void addAll(char ... cArray) {
        this.addAll(cArray, 0, cArray.length);
    }

    public void addAll(char[] cArray, int n2, int n3) {
        int n4 = this.size + n3;
        char[] cArray2 = this.items;
        if (n4 > cArray2.length) {
            cArray2 = this.resize(Math.max(Math.max(8, n4), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(cArray, n2, cArray2, this.size, n3);
        this.size += n3;
    }

    public char get(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n2 + " >= " + this.size);
        }
        return this.items[n2];
    }

    public void set(int n2, char c2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n2 + " >= " + this.size);
        }
        this.items[n2] = c2;
    }

    public void incr(int n2, char c2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n2 + " >= " + this.size);
        }
        int n3 = n2;
        this.items[n3] = (char)(this.items[n3] + c2);
    }

    public void incr(char c2) {
        char[] cArray = this.items;
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            int n4 = n2++;
            cArray[n4] = (char)(cArray[n4] + c2);
        }
    }

    public void mul(int n2, char c2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n2 + " >= " + this.size);
        }
        int n3 = n2;
        this.items[n3] = (char)(this.items[n3] * c2);
    }

    public void mul(char c2) {
        char[] cArray = this.items;
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            int n4 = n2++;
            cArray[n4] = (char)(cArray[n4] * c2);
        }
    }

    public void insert(int n2, char c2) {
        if (n2 > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n2 + " > " + this.size);
        }
        char[] cArray = this.items;
        if (this.size == cArray.length) {
            cArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(cArray, n2, cArray, n2 + 1, this.size - n2);
        } else {
            cArray[this.size] = cArray[n2];
        }
        ++this.size;
        cArray[n2] = c2;
    }

    public void insertRange(int n2, int n3) {
        if (n2 > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n2 + " > " + this.size);
        }
        int n4 = this.size + n3;
        if (n4 > this.items.length) {
            this.items = this.resize(Math.max(Math.max(8, n4), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(this.items, n2, this.items, n2 + n3, this.size - n2);
        this.size = n4;
    }

    public void swap(int n2, int n3) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + n2 + " >= " + this.size);
        }
        if (n3 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + n3 + " >= " + this.size);
        }
        char[] cArray = this.items;
        char c2 = this.items[n2];
        cArray[n2] = cArray[n3];
        cArray[n3] = c2;
    }

    public boolean replaceFirst(char c2, char c3) {
        char[] cArray = this.items;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] != c2) continue;
            cArray[i2] = c3;
            return true;
        }
        return false;
    }

    public int replaceAll(char c2, char c3) {
        char[] cArray = this.items;
        int n2 = 0;
        int n3 = this.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (cArray[i2] != c2) continue;
            cArray[i2] = c3;
            ++n2;
        }
        return n2;
    }

    public boolean contains(char c2) {
        int n2 = this.size - 1;
        char[] cArray = this.items;
        while (n2 >= 0) {
            if (cArray[n2--] != c2) continue;
            return true;
        }
        return false;
    }

    public int indexOf(char c2) {
        char[] cArray = this.items;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(char c2) {
        char[] cArray = this.items;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (cArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public boolean removeValue(char c2) {
        char[] cArray = this.items;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] != c2) continue;
            this.removeIndex(i2);
            return true;
        }
        return false;
    }

    public char removeIndex(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n2 + " >= " + this.size);
        }
        char[] cArray = this.items;
        char c2 = this.items[n2];
        --this.size;
        if (this.ordered) {
            System.arraycopy(cArray, n2 + 1, cArray, n2, this.size - n2);
        } else {
            cArray[n2] = cArray[this.size];
        }
        return c2;
    }

    public void removeRange(int n2, int n3) {
        int n4 = this.size;
        if (n3 >= n4) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + n3 + " >= " + this.size);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("start can't be > end: " + n2 + " > " + n3);
        }
        int n5 = n3 - n2 + 1;
        int n6 = n4 - n5;
        if (this.ordered) {
            System.arraycopy(this.items, n2 + n5, this.items, n2, n4 - (n2 + n5));
        } else {
            n3 = Math.max(n6, n3 + 1);
            System.arraycopy(this.items, n3, this.items, n2, n4 - n3);
        }
        this.size = n4 - n5;
    }

    public boolean removeAll(CharArray charArray) {
        int n2;
        int n3 = n2 = this.size;
        char[] cArray = this.items;
        int n4 = charArray.size;
        block0: for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = charArray.get(i2);
            for (int i3 = 0; i3 < n2; ++i3) {
                if (c2 != cArray[i3]) continue;
                this.removeIndex(i3);
                --n2;
                continue block0;
            }
        }
        return n2 != n3;
    }

    public char pop() {
        return this.items[--this.size];
    }

    public char peek() {
        return this.items[this.size - 1];
    }

    public char first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public char[] shrink() {
        if (this.items.length != this.size) {
            CharArray charArray = this;
            charArray.resize(charArray.size);
        }
        return this.items;
    }

    public char[] ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: ".concat(String.valueOf(n2)));
        }
        if ((n2 = this.size + n2) > this.items.length) {
            this.resize(Math.max(Math.max(8, n2), (int)((float)this.size * 1.75f)));
        }
        return this.items;
    }

    public char[] setSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("newSize must be >= 0: ".concat(String.valueOf(n2)));
        }
        if (n2 > this.items.length) {
            this.resize(Math.max(8, n2));
        }
        this.size = n2;
        return this.items;
    }

    protected char[] resize(int n2) {
        char[] cArray = new char[n2];
        System.arraycopy(this.items, 0, cArray, 0, Math.min(this.size, cArray.length));
        this.items = cArray;
        return cArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        char[] cArray = this.items;
        int n2 = this.size - 1;
        int n3 = this.size / 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = n2 - i2;
            char c2 = cArray[i2];
            cArray[i2] = cArray[n4];
            cArray[n4] = c2;
        }
    }

    public void shuffle() {
        char[] cArray = this.items;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            int n2 = MathUtils.random(i2);
            char c2 = cArray[i2];
            cArray[i2] = cArray[n2];
            cArray[n2] = c2;
        }
    }

    public void truncate(int n2) {
        if (this.size > n2) {
            this.size = n2;
        }
    }

    public char random() {
        if (this.size == 0) {
            return '\u0000';
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public char[] toArray() {
        char[] cArray = new char[this.size];
        System.arraycopy(this.items, 0, cArray, 0, this.size);
        return cArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        char[] cArray = this.items;
        int n2 = 1;
        int n3 = this.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = n2 * 31 + cArray[i2];
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof CharArray)) {
            return false;
        }
        object = (CharArray)object;
        if (!((CharArray)object).ordered) {
            return false;
        }
        int n2 = this.size;
        if (n2 != ((CharArray)object).size) {
            return false;
        }
        char[] cArray = this.items;
        object = ((CharArray)object).items;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] == object[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        char[] cArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(cArray[0]);
        for (int i2 = 1; i2 < this.size; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(cArray[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (this.size == 0) {
            return "";
        }
        char[] cArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(cArray[0]);
        for (int i2 = 1; i2 < this.size; ++i2) {
            stringBuilder.append(string);
            stringBuilder.append(cArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static CharArray with(char ... cArray) {
        return new CharArray(cArray);
    }
}

