/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.BinaryHeap$Node;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;

public class BinaryHeap {
    public int size;
    private BinaryHeap$Node[] nodes;
    private final boolean isMaxHeap;

    public BinaryHeap() {
        this(16, false);
    }

    public BinaryHeap(int n2, boolean bl2) {
        this.isMaxHeap = bl2;
        this.nodes = new BinaryHeap$Node[n2];
    }

    public BinaryHeap$Node add(BinaryHeap$Node binaryHeap$Node) {
        if (this.size == this.nodes.length) {
            BinaryHeap$Node[] binaryHeap$NodeArray = new BinaryHeap$Node[this.size << 1];
            System.arraycopy(this.nodes, 0, binaryHeap$NodeArray, 0, this.size);
            this.nodes = binaryHeap$NodeArray;
        }
        binaryHeap$Node.index = this.size;
        this.nodes[this.size] = binaryHeap$Node;
        BinaryHeap binaryHeap = this;
        binaryHeap.up(binaryHeap.size++);
        return binaryHeap$Node;
    }

    public BinaryHeap$Node add(BinaryHeap$Node binaryHeap$Node, float f2) {
        binaryHeap$Node.value = f2;
        return this.add(binaryHeap$Node);
    }

    public boolean contains(BinaryHeap$Node binaryHeap$Node, boolean bl2) {
        if (binaryHeap$Node == null) {
            throw new IllegalArgumentException("node cannot be null.");
        }
        if (bl2) {
            BinaryHeap$Node[] binaryHeap$NodeArray = this.nodes;
            int n2 = this.nodes.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (binaryHeap$NodeArray[i2] != binaryHeap$Node) continue;
                return true;
            }
        } else {
            BinaryHeap$Node[] binaryHeap$NodeArray = this.nodes;
            int n3 = this.nodes.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!binaryHeap$NodeArray[i3].equals(binaryHeap$Node)) continue;
                return true;
            }
        }
        return false;
    }

    public BinaryHeap$Node peek() {
        if (this.size == 0) {
            throw new IllegalStateException("The heap is empty.");
        }
        return this.nodes[0];
    }

    public BinaryHeap$Node pop() {
        BinaryHeap$Node binaryHeap$Node = this.nodes[0];
        if (--this.size > 0) {
            this.nodes[0] = this.nodes[this.size];
            this.nodes[this.size] = null;
            this.down(0);
        } else {
            this.nodes[0] = null;
        }
        return binaryHeap$Node;
    }

    public BinaryHeap$Node remove(BinaryHeap$Node binaryHeap$Node) {
        if (--this.size > 0) {
            BinaryHeap$Node binaryHeap$Node2 = this.nodes[this.size];
            this.nodes[this.size] = null;
            this.nodes[binaryHeap$Node.index] = binaryHeap$Node2;
            if (binaryHeap$Node2.value < binaryHeap$Node.value ^ this.isMaxHeap) {
                this.up(binaryHeap$Node.index);
            } else {
                this.down(binaryHeap$Node.index);
            }
        } else {
            this.nodes[0] = null;
        }
        return binaryHeap$Node;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Arrays.fill(this.nodes, 0, this.size, null);
        this.size = 0;
    }

    public void setValue(BinaryHeap$Node binaryHeap$Node, float f2) {
        float f3 = binaryHeap$Node.value;
        binaryHeap$Node.value = f2;
        if (f2 < f3 ^ this.isMaxHeap) {
            this.up(binaryHeap$Node.index);
            return;
        }
        this.down(binaryHeap$Node.index);
    }

    private void up(int n2) {
        BinaryHeap$Node[] binaryHeap$NodeArray = this.nodes;
        BinaryHeap$Node binaryHeap$Node = this.nodes[n2];
        float f2 = binaryHeap$Node.value;
        while (n2 > 0) {
            int n3 = n2 - 1 >> 1;
            BinaryHeap$Node binaryHeap$Node2 = binaryHeap$NodeArray[n3];
            if (!(f2 < binaryHeap$Node2.value ^ this.isMaxHeap)) break;
            binaryHeap$NodeArray[n2] = binaryHeap$Node2;
            binaryHeap$Node2.index = n2;
            n2 = n3;
        }
        binaryHeap$NodeArray[n2] = binaryHeap$Node;
        binaryHeap$Node.index = n2;
    }

    private void down(int n2) {
        int n3;
        BinaryHeap$Node[] binaryHeap$NodeArray = this.nodes;
        int n4 = this.size;
        BinaryHeap$Node binaryHeap$Node = binaryHeap$NodeArray[n2];
        float f2 = binaryHeap$Node.value;
        while ((n3 = 1 + (n2 << 1)) < n4) {
            float f3;
            BinaryHeap$Node binaryHeap$Node2;
            int n5 = n3 + 1;
            BinaryHeap$Node binaryHeap$Node3 = binaryHeap$NodeArray[n3];
            float f4 = binaryHeap$Node3.value;
            if (n5 >= n4) {
                binaryHeap$Node2 = null;
                f3 = this.isMaxHeap ? -3.4028235E38f : Float.MAX_VALUE;
            } else {
                binaryHeap$Node2 = binaryHeap$NodeArray[n5];
                f3 = binaryHeap$Node2.value;
            }
            if (f4 < f3 ^ this.isMaxHeap) {
                if (f4 == f2 || f4 > f2 ^ this.isMaxHeap) break;
                binaryHeap$NodeArray[n2] = binaryHeap$Node3;
                binaryHeap$Node3.index = n2;
                n2 = n3;
                continue;
            }
            if (f3 == f2 || f3 > f2 ^ this.isMaxHeap) break;
            binaryHeap$NodeArray[n2] = binaryHeap$Node2;
            if (binaryHeap$Node2 != null) {
                binaryHeap$Node2.index = n2;
            }
            n2 = n5;
        }
        binaryHeap$NodeArray[n2] = binaryHeap$Node;
        binaryHeap$Node.index = n2;
    }

    public boolean equals(Object binaryHeap$NodeArray) {
        if (!(binaryHeap$NodeArray instanceof BinaryHeap)) {
            return false;
        }
        binaryHeap$NodeArray = (BinaryHeap)binaryHeap$NodeArray;
        if (binaryHeap$NodeArray.size != this.size) {
            return false;
        }
        BinaryHeap$Node[] binaryHeap$NodeArray2 = this.nodes;
        binaryHeap$NodeArray = binaryHeap$NodeArray.nodes;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (binaryHeap$NodeArray2[i2].value == binaryHeap$NodeArray[i2].value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 1;
        BinaryHeap$Node[] binaryHeap$NodeArray = this.nodes;
        int n3 = this.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = n2 * 31 + Float.floatToIntBits(binaryHeap$NodeArray[i2].value);
        }
        return n2;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        BinaryHeap$Node[] binaryHeap$NodeArray = this.nodes;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(binaryHeap$NodeArray[0].value);
        for (int i2 = 1; i2 < this.size; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(binaryHeap$NodeArray[i2].value);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

