/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.ArrayMap$Entries;
import com.badlogic.gdx.utils.ArrayMap$Keys;
import com.badlogic.gdx.utils.ArrayMap$Values;
import com.badlogic.gdx.utils.ArraySupplier;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import java.util.Arrays;
import java.util.Iterator;

public class ArrayMap
implements Iterable {
    public Object[] keys;
    public Object[] values;
    public int size;
    public boolean ordered;
    private transient ArrayMap$Entries entries1;
    private transient ArrayMap$Entries entries2;
    private transient ArrayMap$Values values1;
    private transient ArrayMap$Values values2;
    private transient ArrayMap$Keys keys1;
    private transient ArrayMap$Keys keys2;

    public ArrayMap() {
        this(true, 16);
    }

    public ArrayMap(int n2) {
        this(true, n2);
    }

    public ArrayMap(boolean bl2, int n2) {
        this(bl2, n2, ArraySupplier.object(), ArraySupplier.object());
    }

    public ArrayMap(boolean bl2, int n2, ArraySupplier arraySupplier, ArraySupplier arraySupplier2) {
        this.ordered = bl2;
        this.keys = (Object[])arraySupplier.get(n2);
        this.values = (Object[])arraySupplier2.get(n2);
    }

    public ArrayMap(ArraySupplier arraySupplier, ArraySupplier arraySupplier2) {
        this(false, 16, arraySupplier, arraySupplier2);
    }

    public ArrayMap(boolean bl2, int n3, Class clazz, Class clazz2) {
        this(bl2, n3, (int n2) -> (Object[])ArrayReflection.newInstance(clazz, n2), (int n2) -> (Object[])ArrayReflection.newInstance(clazz2, n2));
    }

    public ArrayMap(Class clazz, Class clazz2) {
        this(false, 16, clazz, clazz2);
    }

    public ArrayMap(ArrayMap arrayMap) {
        this.ordered = arrayMap.ordered;
        this.keys = Arrays.copyOf(arrayMap.keys, arrayMap.keys.length);
        this.values = Arrays.copyOf(arrayMap.values, arrayMap.values.length);
        this.size = arrayMap.size;
    }

    public int put(Object object, Object object2) {
        int n2 = this.indexOfKey(object);
        if (n2 == -1) {
            if (this.size == this.keys.length) {
                this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
            }
            n2 = this.size++;
        }
        this.keys[n2] = object;
        this.values[n2] = object2;
        return n2;
    }

    public int put(Object object, Object object2, int n2) {
        int n3 = this.indexOfKey(object);
        if (n3 != -1) {
            this.removeIndex(n3);
        } else if (this.size == this.keys.length) {
            this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(this.keys, n2, this.keys, n2 + 1, this.size - n2);
        System.arraycopy(this.values, n2, this.values, n2 + 1, this.size - n2);
        this.keys[n2] = object;
        this.values[n2] = object2;
        ++this.size;
        return n2;
    }

    public void putAll(ArrayMap arrayMap) {
        this.putAll(arrayMap, 0, arrayMap.size);
    }

    public void putAll(ArrayMap arrayMap, int n2, int n3) {
        if (n2 + n3 > arrayMap.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n2 + " + " + n3 + " <= " + arrayMap.size);
        }
        int n4 = this.size + n3 - n2;
        if (n4 >= this.keys.length) {
            this.resize(Math.max(8, (int)((float)n4 * 1.75f)));
        }
        System.arraycopy(arrayMap.keys, n2, this.keys, this.size, n3);
        System.arraycopy(arrayMap.values, n2, this.values, this.size, n3);
        this.size += n3;
    }

    public Object get(Object object) {
        return this.get(object, null);
    }

    public Object get(Object object, Object object2) {
        int n2;
        Object[] objectArray = this.keys;
        if (object == null) {
            for (n2 = this.size - 1; n2 >= 0; --n2) {
                if (objectArray[n2] != object) continue;
                return this.values[n2];
            }
        } else {
            while (n2 >= 0) {
                if (object.equals(objectArray[n2])) {
                    return this.values[n2];
                }
                --n2;
            }
        }
        return object2;
    }

    public Object getKey(Object object, boolean bl2) {
        int n2;
        Object[] objectArray = this.values;
        if (bl2 || object == null) {
            for (n2 = this.size - 1; n2 >= 0; --n2) {
                if (objectArray[n2] != object) continue;
                return this.keys[n2];
            }
        } else {
            while (n2 >= 0) {
                if (object.equals(objectArray[n2])) {
                    return this.keys[n2];
                }
                --n2;
            }
        }
        return null;
    }

    public Object getKeyAt(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.keys[n2];
    }

    public Object getValueAt(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.values[n2];
    }

    public Object firstKey() {
        if (this.size == 0) {
            throw new IllegalStateException("Map is empty.");
        }
        return this.keys[0];
    }

    public Object firstValue() {
        if (this.size == 0) {
            throw new IllegalStateException("Map is empty.");
        }
        return this.values[0];
    }

    public void setKey(int n2, Object object) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        this.keys[n2] = object;
    }

    public void setValue(int n2, Object object) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        this.values[n2] = object;
    }

    public void insert(int n2, Object object, Object object2) {
        if (n2 > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        if (this.size == this.keys.length) {
            this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(this.keys, n2, this.keys, n2 + 1, this.size - n2);
            System.arraycopy(this.values, n2, this.values, n2 + 1, this.size - n2);
        } else {
            this.keys[this.size] = this.keys[n2];
            this.values[this.size] = this.values[n2];
        }
        ++this.size;
        this.keys[n2] = object;
        this.values[n2] = object2;
    }

    public boolean containsKey(Object object) {
        Object[] objectArray = this.keys;
        int n2 = this.size - 1;
        if (object == null) {
            while (n2 >= 0) {
                if (objectArray[n2--] != object) continue;
                return true;
            }
        } else {
            while (n2 >= 0) {
                if (!object.equals(objectArray[n2--])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsValue(Object object, boolean bl2) {
        Object[] objectArray = this.values;
        int n2 = this.size - 1;
        if (bl2 || object == null) {
            while (n2 >= 0) {
                if (objectArray[n2--] != object) continue;
                return true;
            }
        } else {
            while (n2 >= 0) {
                if (!object.equals(objectArray[n2--])) continue;
                return true;
            }
        }
        return false;
    }

    public int indexOfKey(Object object) {
        Object[] objectArray = this.keys;
        if (object == null) {
            int n2 = this.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (objectArray[i2] != object) continue;
                return i2;
            }
        } else {
            int n3 = this.size;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!object.equals(objectArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public int indexOfValue(Object object, boolean n2) {
        Object[] objectArray = this.values;
        if (n2 != 0 || object == null) {
            int n3 = this.size;
            for (n2 = 0; n2 < n3; ++n2) {
                if (objectArray[n2] != object) continue;
                return n2;
            }
        } else {
            int n4 = this.size;
            for (n2 = 0; n2 < n4; ++n2) {
                if (!object.equals(objectArray[n2])) continue;
                return n2;
            }
        }
        return -1;
    }

    public Object removeKey(Object object) {
        Object[] objectArray = this.keys;
        if (object == null) {
            int n2 = this.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (objectArray[i2] != object) continue;
                object = this.values[i2];
                this.removeIndex(i2);
                return object;
            }
        } else {
            int n3 = this.size;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!object.equals(objectArray[i3])) continue;
                object = this.values[i3];
                this.removeIndex(i3);
                return object;
            }
        }
        return null;
    }

    public boolean removeValue(Object object, boolean n2) {
        Object[] objectArray = this.values;
        if (n2 != 0 || object == null) {
            int n3 = this.size;
            for (n2 = 0; n2 < n3; ++n2) {
                if (objectArray[n2] != object) continue;
                this.removeIndex(n2);
                return true;
            }
        } else {
            int n4 = this.size;
            for (n2 = 0; n2 < n4; ++n2) {
                if (!object.equals(objectArray[n2])) continue;
                this.removeIndex(n2);
                return true;
            }
        }
        return false;
    }

    public void removeIndex(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        Object[] objectArray = this.keys;
        --this.size;
        if (this.ordered) {
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, this.size - n2);
            System.arraycopy(this.values, n2 + 1, this.values, n2, this.size - n2);
        } else {
            objectArray[n2] = objectArray[this.size];
            this.values[n2] = this.values[this.size];
        }
        objectArray[this.size] = null;
        this.values[this.size] = null;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object peekKey() {
        return this.keys[this.size - 1];
    }

    public Object peekValue() {
        return this.values[this.size - 1];
    }

    public void clear(int n2) {
        if (this.keys.length <= n2) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        Arrays.fill(this.keys, 0, this.size, null);
        Arrays.fill(this.values, 0, this.size, null);
        this.size = 0;
    }

    public void shrink() {
        if (this.keys.length == this.size) {
            return;
        }
        ArrayMap arrayMap = this;
        arrayMap.resize(arrayMap.size);
    }

    public void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: ".concat(String.valueOf(n2)));
        }
        if ((n2 = this.size + n2) > this.keys.length) {
            this.resize(Math.max(Math.max(8, n2), (int)((float)this.size * 1.75f)));
        }
    }

    protected void resize(int n2) {
        this.keys = Arrays.copyOf(this.keys, n2);
        this.values = Arrays.copyOf(this.values, n2);
    }

    public void reverse() {
        int n2 = this.size - 1;
        int n3 = this.size / 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = n2 - i2;
            Object object = this.keys[i2];
            this.keys[i2] = this.keys[n4];
            this.keys[n4] = object;
            object = this.values[i2];
            this.values[i2] = this.values[n4];
            this.values[n4] = object;
        }
    }

    public void shuffle() {
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            int n2 = MathUtils.random(i2);
            Object object = this.keys[i2];
            this.keys[i2] = this.keys[n2];
            this.keys[n2] = object;
            object = this.values[i2];
            this.values[i2] = this.values[n2];
            this.values[n2] = object;
        }
    }

    public void truncate(int n2) {
        if (this.size <= n2) {
            return;
        }
        for (int i2 = n2; i2 < this.size; ++i2) {
            this.keys[i2] = null;
            this.values[i2] = null;
        }
        this.size = n2;
    }

    public int hashCode() {
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int n2 = 0;
        int n3 = this.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray[i2];
            Object object2 = objectArray2[i2];
            if (object != null) {
                n2 += object.hashCode() * 31;
            }
            if (object2 == null) continue;
            n2 += object2.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayMap)) {
            return false;
        }
        object = (ArrayMap)object;
        if (((ArrayMap)object).size != this.size) {
            return false;
        }
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = objectArray[i2];
            Object object3 = objectArray2[i2];
            if (!(object3 == null ? ((ArrayMap)object).get(object2, ObjectMap.dummy) != null : !object3.equals(((ArrayMap)object).get(object2)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayMap)) {
            return false;
        }
        object = (ArrayMap)object;
        if (((ArrayMap)object).size != this.size) {
            return false;
        }
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray2[i2] == ((ArrayMap)object).get(objectArray[i2], ObjectMap.dummy)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        stringBuilder.append(objectArray[0]);
        stringBuilder.append('=');
        stringBuilder.append(objectArray2[0]);
        for (int i2 = 1; i2 < this.size; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(objectArray[i2]);
            stringBuilder.append('=');
            stringBuilder.append(objectArray2[i2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public Iterator iterator() {
        return this.entries();
    }

    public ArrayMap$Entries entries() {
        if (Collections.allocateIterators) {
            return new ArrayMap$Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new ArrayMap$Entries(this);
            this.entries2 = new ArrayMap$Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.index = 0;
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.index = 0;
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public ArrayMap$Values values() {
        if (Collections.allocateIterators) {
            return new ArrayMap$Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new ArrayMap$Values(this);
            this.values2 = new ArrayMap$Values(this);
        }
        if (!this.values1.valid) {
            this.values1.index = 0;
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.index = 0;
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public ArrayMap$Keys keys() {
        if (Collections.allocateIterators) {
            return new ArrayMap$Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new ArrayMap$Keys(this);
            this.keys2 = new ArrayMap$Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.index = 0;
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.index = 0;
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }
}

