/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array$ArrayIterable;
import com.badlogic.gdx.utils.Array$ArrayIterator;
import com.badlogic.gdx.utils.ArraySupplier;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Predicate;
import com.badlogic.gdx.utils.Predicate$PredicateIterable;
import com.badlogic.gdx.utils.Select;
import com.badlogic.gdx.utils.Sort;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import java.util.Arrays;
import java.util.Comparator;

public class Array
implements Iterable {
    public Object[] items;
    public int size;
    public boolean ordered;
    private transient Array$ArrayIterable iterable;
    private transient Predicate$PredicateIterable predicateIterable;

    public Array() {
        this(true, 16);
    }

    public Array(int n2) {
        this(true, n2);
    }

    public Array(boolean bl2, int n2) {
        this(bl2, n2, ArraySupplier.object());
    }

    public Array(boolean bl2, int n2, ArraySupplier arraySupplier) {
        this.ordered = bl2;
        this.items = (Object[])arraySupplier.get(n2);
    }

    public Array(ArraySupplier arraySupplier) {
        this(true, 16, arraySupplier);
    }

    public Array(boolean bl2, int n3, Class clazz) {
        this(bl2, n3, (int n2) -> (Object[])ArrayReflection.newInstance(clazz, n2));
    }

    public Array(Class clazz) {
        this(true, 16, clazz);
    }

    public Array(Array array) {
        this.items = Arrays.copyOf(array.items, array.size);
        this.ordered = array.ordered;
        this.size = array.size;
    }

    public Array(Object[] objectArray) {
        this(true, objectArray, 0, objectArray.length);
    }

    public Array(boolean bl2, Object[] objectArray, int n2, int n3) {
        int n4 = n2;
        this.items = Arrays.copyOfRange(objectArray, n4, n4 + n3);
        this.ordered = bl2;
        this.size = n3;
    }

    public void add(Object object) {
        Object[] objectArray = this.items;
        if (this.size == objectArray.length) {
            objectArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        objectArray[this.size++] = object;
    }

    public void add(Object object, Object object2) {
        Object[] objectArray = this.items;
        if (this.size + 1 >= objectArray.length) {
            objectArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        objectArray[this.size] = object;
        objectArray[this.size + 1] = object2;
        this.size += 2;
    }

    public void add(Object object, Object object2, Object object3) {
        Object[] objectArray = this.items;
        if (this.size + 2 >= objectArray.length) {
            objectArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        objectArray[this.size] = object;
        objectArray[this.size + 1] = object2;
        objectArray[this.size + 2] = object3;
        this.size += 3;
    }

    public void add(Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = this.items;
        if (this.size + 3 >= objectArray.length) {
            objectArray = this.resize(Math.max(8, (int)((float)this.size * 1.8f)));
        }
        objectArray[this.size] = object;
        objectArray[this.size + 1] = object2;
        objectArray[this.size + 2] = object3;
        objectArray[this.size + 3] = object4;
        this.size += 4;
    }

    public void addAll(Array array) {
        this.addAll(array.items, 0, array.size);
    }

    public void addAll(Array array, int n2, int n3) {
        if (n2 + n3 > array.size) {
            throw new IllegalArgumentException("start + count must be <= size: " + n2 + " + " + n3 + " <= " + array.size);
        }
        this.addAll(array.items, n2, n3);
    }

    public void addAll(Object ... objectArray) {
        this.addAll(objectArray, 0, objectArray.length);
    }

    public void addAll(Object[] objectArray, int n2, int n3) {
        int n4 = this.size + n3;
        Object[] objectArray2 = this.items;
        if (n4 > objectArray2.length) {
            objectArray2 = this.resize(Math.max(Math.max(8, n4), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(objectArray, n2, objectArray2, this.size, n3);
        this.size = n4;
    }

    public Object get(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n2 + " >= " + this.size);
        }
        return this.items[n2];
    }

    public void set(int n2, Object object) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n2 + " >= " + this.size);
        }
        this.items[n2] = object;
    }

    public void insert(int n2, Object object) {
        if (n2 > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n2 + " > " + this.size);
        }
        Object[] objectArray = this.items;
        if (this.size == objectArray.length) {
            objectArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(objectArray, n2, objectArray, n2 + 1, this.size - n2);
        } else {
            objectArray[this.size] = objectArray[n2];
        }
        ++this.size;
        objectArray[n2] = object;
    }

    public void insertRange(int n2, int n3) {
        if (n2 > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n2 + " > " + this.size);
        }
        int n4 = this.size + n3;
        if (n4 > this.items.length) {
            this.items = this.resize(Math.max(Math.max(8, n4), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(this.items, n2, this.items, n2 + n3, this.size - n2);
        this.size = n4;
    }

    public void swap(int n2, int n3) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + n2 + " >= " + this.size);
        }
        if (n3 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + n3 + " >= " + this.size);
        }
        Object[] objectArray = this.items;
        Object object = this.items[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object;
    }

    public boolean replaceFirst(Object object, boolean n2, Object object2) {
        Object[] objectArray = this.items;
        if (n2 != 0 || object == null) {
            int n3 = this.size;
            for (n2 = 0; n2 < n3; ++n2) {
                if (objectArray[n2] != object) continue;
                objectArray[n2] = object2;
                return true;
            }
        } else {
            int n4 = this.size;
            for (n2 = 0; n2 < n4; ++n2) {
                if (!object.equals(objectArray[n2])) continue;
                objectArray[n2] = object2;
                return true;
            }
        }
        return false;
    }

    public int replaceAll(Object object, boolean n2, Object object2) {
        Object[] objectArray = this.items;
        int n3 = 0;
        if (n2 != 0 || object == null) {
            int n4 = this.size;
            for (n2 = 0; n2 < n4; ++n2) {
                if (objectArray[n2] != object) continue;
                objectArray[n2] = object2;
                ++n3;
            }
        } else {
            int n5 = this.size;
            for (n2 = 0; n2 < n5; ++n2) {
                if (!object.equals(objectArray[n2])) continue;
                objectArray[n2] = object2;
                ++n3;
            }
        }
        return n3;
    }

    public boolean contains(Object object, boolean bl2) {
        Object[] objectArray = this.items;
        int n2 = this.size - 1;
        if (bl2 || object == null) {
            while (n2 >= 0) {
                if (objectArray[n2--] != object) continue;
                return true;
            }
        } else {
            while (n2 >= 0) {
                if (!object.equals(objectArray[n2--])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAll(Array array, boolean bl2) {
        Object[] objectArray = array.items;
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.contains(objectArray[i2], bl2)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Array array, boolean bl2) {
        Object[] objectArray = array.items;
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.contains(objectArray[i2], bl2)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(Object object, boolean n2) {
        Object[] objectArray = this.items;
        if (n2 != 0 || object == null) {
            int n3 = this.size;
            for (n2 = 0; n2 < n3; ++n2) {
                if (objectArray[n2] != object) continue;
                return n2;
            }
        } else {
            int n4 = this.size;
            for (n2 = 0; n2 < n4; ++n2) {
                if (!object.equals(objectArray[n2])) continue;
                return n2;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object, boolean n2) {
        Object[] objectArray = this.items;
        if (n2 != 0 || object == null) {
            for (n2 = this.size - 1; n2 >= 0; --n2) {
                if (objectArray[n2] != object) continue;
                return n2;
            }
        } else {
            for (n2 = this.size - 1; n2 >= 0; --n2) {
                if (!object.equals(objectArray[n2])) continue;
                return n2;
            }
        }
        return -1;
    }

    public boolean removeValue(Object object, boolean n2) {
        Object[] objectArray = this.items;
        if (n2 != 0 || object == null) {
            int n3 = this.size;
            for (n2 = 0; n2 < n3; ++n2) {
                if (objectArray[n2] != object) continue;
                this.removeIndex(n2);
                return true;
            }
        } else {
            int n4 = this.size;
            for (n2 = 0; n2 < n4; ++n2) {
                if (!object.equals(objectArray[n2])) continue;
                this.removeIndex(n2);
                return true;
            }
        }
        return false;
    }

    public Object removeIndex(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n2 + " >= " + this.size);
        }
        Object[] objectArray = this.items;
        Object object = this.items[n2];
        --this.size;
        if (this.ordered) {
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, this.size - n2);
        } else {
            objectArray[n2] = objectArray[this.size];
        }
        objectArray[this.size] = null;
        return object;
    }

    public void removeRange(int n2, int n3) {
        int n4 = this.size;
        if (n3 >= n4) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + n3 + " >= " + this.size);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("start can't be > end: " + n2 + " > " + n3);
        }
        Object[] objectArray = this.items;
        int n5 = n3 - n2 + 1;
        int n6 = n4 - n5;
        if (this.ordered) {
            System.arraycopy(objectArray, n2 + n5, objectArray, n2, n4 - (n2 + n5));
        } else {
            n3 = Math.max(n6, n3 + 1);
            System.arraycopy(objectArray, n3, objectArray, n2, n4 - n3);
        }
        for (n3 = n6; n3 < n4; ++n3) {
            objectArray[n3] = null;
        }
        this.size = n4 - n5;
    }

    public boolean removeAll(Array array, boolean n2) {
        int n3;
        int n4 = n3 = this.size;
        Object[] objectArray = this.items;
        if (n2 != 0) {
            int n5 = array.size;
            block0: for (n2 = 0; n2 < n5; ++n2) {
                Object object = array.get(n2);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (object != objectArray[i2]) continue;
                    this.removeIndex(i2);
                    --n3;
                    continue block0;
                }
            }
        } else {
            int n6 = array.size;
            block2: for (n2 = 0; n2 < n6; ++n2) {
                Object object = array.get(n2);
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (!object.equals(objectArray[i3])) continue;
                    this.removeIndex(i3);
                    --n3;
                    continue block2;
                }
            }
        }
        return n3 != n4;
    }

    public Object pop() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        --this.size;
        Object object = this.items[this.size];
        this.items[this.size] = null;
        return object;
    }

    public Object peek() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[this.size - 1];
    }

    public Object first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Arrays.fill(this.items, 0, this.size, null);
        this.size = 0;
    }

    public Object[] shrink() {
        if (this.items.length != this.size) {
            Array array = this;
            array.resize(array.size);
        }
        return this.items;
    }

    public Object[] ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: ".concat(String.valueOf(n2)));
        }
        if ((n2 = this.size + n2) > this.items.length) {
            this.resize(Math.max(Math.max(8, n2), (int)((float)this.size * 1.75f)));
        }
        return this.items;
    }

    public Object[] setSize(int n2) {
        this.truncate(n2);
        if (n2 > this.items.length) {
            this.resize(Math.max(8, n2));
        }
        this.size = n2;
        return this.items;
    }

    protected Object[] resize(int n2) {
        this.items = Arrays.copyOf(this.items, n2);
        return this.items;
    }

    public void sort() {
        Sort.instance().sort(this.items, 0, this.size);
    }

    public void sort(Comparator comparator) {
        Sort.instance().sort(this.items, comparator, 0, this.size);
    }

    public Object selectRanked(Comparator comparator, int n2) {
        if (n2 <= 0) {
            throw new GdxRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.instance().select(this.items, comparator, n2, this.size);
    }

    public int selectRankedIndex(Comparator comparator, int n2) {
        if (n2 <= 0) {
            throw new GdxRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.instance().selectIndex(this.items, comparator, n2, this.size);
    }

    public void reverse() {
        Object[] objectArray = this.items;
        int n2 = this.size - 1;
        int n3 = this.size / 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = n2 - i2;
            Object object = objectArray[i2];
            objectArray[i2] = objectArray[n4];
            objectArray[n4] = object;
        }
    }

    public void shuffle() {
        Object[] objectArray = this.items;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            int n2 = MathUtils.random(i2);
            Object object = objectArray[i2];
            objectArray[i2] = objectArray[n2];
            objectArray[n2] = object;
        }
    }

    public Array$ArrayIterator iterator() {
        if (Collections.allocateIterators) {
            return new Array$ArrayIterator(this, true);
        }
        if (this.iterable == null) {
            this.iterable = new Array$ArrayIterable(this);
        }
        return this.iterable.iterator();
    }

    public Iterable select(Predicate predicate) {
        if (Collections.allocateIterators) {
            return new Predicate$PredicateIterable(this, predicate);
        }
        if (this.predicateIterable == null) {
            this.predicateIterable = new Predicate$PredicateIterable(this, predicate);
        } else {
            this.predicateIterable.set(this, predicate);
        }
        return this.predicateIterable;
    }

    public void truncate(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("newSize must be >= 0: ".concat(String.valueOf(n2)));
        }
        if (this.size <= n2) {
            return;
        }
        for (int i2 = n2; i2 < this.size; ++i2) {
            this.items[i2] = null;
        }
        this.size = n2;
    }

    public Object random() {
        if (this.size == 0) {
            return null;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public Object[] toArray() {
        return Arrays.copyOf(this.items, this.size);
    }

    public Object[] toArray(ArraySupplier objectArray) {
        objectArray = (Object[])objectArray.get(this.size);
        System.arraycopy(this.items, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object[] toArray(Class objectArray) {
        objectArray = (Object[])ArrayReflection.newInstance((Class)objectArray, this.size);
        System.arraycopy(this.items, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        Object[] objectArray = this.items;
        int n2 = 1;
        int n3 = this.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 *= 31;
            Object object = objectArray[i2];
            if (object == null) continue;
            n2 += object.hashCode();
        }
        return n2;
    }

    public boolean equals(Object objectArray) {
        if (objectArray == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(objectArray instanceof Array)) {
            return false;
        }
        objectArray = (Array)objectArray;
        if (!objectArray.ordered) {
            return false;
        }
        int n2 = this.size;
        if (n2 != objectArray.size) {
            return false;
        }
        Object[] objectArray2 = this.items;
        objectArray = objectArray.items;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray2[i2];
            Object object2 = objectArray[i2];
            if (object != null ? object.equals(object2) : object2 == null) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object objectArray) {
        if (objectArray == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(objectArray instanceof Array)) {
            return false;
        }
        objectArray = (Array)objectArray;
        if (!objectArray.ordered) {
            return false;
        }
        int n2 = this.size;
        if (n2 != objectArray.size) {
            return false;
        }
        Object[] objectArray2 = this.items;
        objectArray = objectArray.items;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray2[i2] == objectArray[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        Object[] objectArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(objectArray[0]);
        for (int i2 = 1; i2 < this.size; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(objectArray[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (this.size == 0) {
            return "";
        }
        Object[] objectArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(objectArray[0]);
        for (int i2 = 1; i2 < this.size; ++i2) {
            stringBuilder.append(string);
            stringBuilder.append(objectArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static Array of(ArraySupplier arraySupplier) {
        return new Array(arraySupplier);
    }

    public static Array of(boolean bl2, int n2, ArraySupplier arraySupplier) {
        return new Array(bl2, n2, arraySupplier);
    }

    public static Array of(Class clazz) {
        return new Array(clazz);
    }

    public static Array of(boolean bl2, int n2, Class clazz) {
        return new Array(bl2, n2, clazz);
    }

    public static Array with(Object ... objectArray) {
        return new Array(objectArray);
    }
}

