/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.j;
import com.badlogic.gdx.scenes.scene2d.l;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Label$LabelStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Styleable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Window$WindowStyle;
import com.badlogic.gdx.scenes.scene2d.ui.av;
import com.badlogic.gdx.scenes.scene2d.ui.aw;
import com.badlogic.gdx.scenes.scene2d.ui.ax;

public class Window
extends Table
implements Styleable {
    private static final Vector2 tmpPosition = new Vector2();
    private static final Vector2 tmpSize = new Vector2();
    private static final int MOVE = 32;
    private Window$WindowStyle style;
    boolean isMovable = true;
    boolean isModal;
    boolean isResizable;
    int resizeBorder = 8;
    boolean keepWithinStage = true;
    Label titleLabel;
    Table titleTable;
    boolean drawTitleTable;
    protected int edge;
    protected boolean dragging;

    public Window(String string, Skin skin) {
        this(string, (Window$WindowStyle)skin.get(Window$WindowStyle.class));
        this.setSkin(skin);
    }

    public Window(String string, Skin skin, String string2) {
        this(string, (Window$WindowStyle)skin.get(string2, Window$WindowStyle.class));
        this.setSkin(skin);
    }

    public Window(String string, Window$WindowStyle window$WindowStyle) {
        if (string == null) {
            throw new IllegalArgumentException("title cannot be null.");
        }
        this.setTouchable(l.a);
        this.setClip(true);
        this.titleLabel = this.newLabel(string, new Label$LabelStyle(window$WindowStyle.titleFont, window$WindowStyle.titleFontColor));
        this.titleLabel.setEllipsis(true);
        this.titleTable = new av(this);
        this.titleTable.add((b)this.titleLabel).growX().minWidth(0.0f);
        Window window = this;
        window.addActor(window.titleTable);
        this.setStyle(window$WindowStyle);
        this.setWidth(150.0f);
        this.setHeight(150.0f);
        this.addCaptureListener(new aw(this));
        this.addListener(new ax(this));
    }

    protected Label newLabel(String string, Label$LabelStyle label$LabelStyle) {
        return new Label((CharSequence)string, label$LabelStyle);
    }

    public void setStyle(Window$WindowStyle window$WindowStyle) {
        if (window$WindowStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = window$WindowStyle;
        this.setBackground(window$WindowStyle.background);
        this.titleLabel.setStyle(new Label$LabelStyle(window$WindowStyle.titleFont, window$WindowStyle.titleFontColor));
        this.invalidateHierarchy();
    }

    @Override
    public Window$WindowStyle getStyle() {
        return this.style;
    }

    public void keepWithinStage() {
        if (!this.keepWithinStage) {
            return;
        }
        j j2 = this.getStage();
        if (j2 == null) {
            return;
        }
        Camera camera = j2.i();
        if (camera instanceof OrthographicCamera) {
            OrthographicCamera orthographicCamera = (OrthographicCamera)camera;
            float f2 = j2.g();
            float f3 = j2.h();
            if (this.getX(16) - camera.position.x > f2 / 2.0f / orthographicCamera.zoom) {
                this.setPosition(camera.position.x + f2 / 2.0f / orthographicCamera.zoom, this.getY(16), 16);
            }
            if (this.getX(8) - camera.position.x < -f2 / 2.0f / orthographicCamera.zoom) {
                this.setPosition(camera.position.x - f2 / 2.0f / orthographicCamera.zoom, this.getY(8), 8);
            }
            if (this.getY(2) - camera.position.y > f3 / 2.0f / orthographicCamera.zoom) {
                Window window = this;
                window.setPosition(window.getX(2), camera.position.y + f3 / 2.0f / orthographicCamera.zoom, 2);
            }
            if (this.getY(4) - camera.position.y < -f3 / 2.0f / orthographicCamera.zoom) {
                Window window = this;
                window.setPosition(window.getX(4), camera.position.y - f3 / 2.0f / orthographicCamera.zoom, 4);
            }
            return;
        }
        if (this.getParent() == j2.j()) {
            float f4 = j2.g();
            float f5 = j2.h();
            if (this.getX() < 0.0f) {
                this.setX(0.0f);
            }
            if (this.getRight() > f4) {
                this.setX(f4 - this.getWidth());
            }
            if (this.getY() < 0.0f) {
                this.setY(0.0f);
            }
            if (this.getTop() > f5) {
                this.setY(f5 - this.getHeight());
            }
        }
    }

    @Override
    public void draw(Batch batch, float f2) {
        j j2 = this.getStage();
        if (j2 != null) {
            if (j2.e() == null) {
                j2.d(this);
            }
            this.keepWithinStage();
            if (this.style.stageBackground != null) {
                this.stageToLocalCoordinates(tmpPosition.set(0.0f, 0.0f));
                this.stageToLocalCoordinates(tmpSize.set(j2.g(), j2.h()));
                this.drawStageBackground(batch, f2, this.getX() + Window.tmpPosition.x, this.getY() + Window.tmpPosition.y, this.getX() + Window.tmpSize.x, this.getY() + Window.tmpSize.y);
            }
        }
        super.draw(batch, f2);
    }

    protected void drawStageBackground(Batch batch, float f2, float f3, float f4, float f5, float f6) {
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * f2);
        this.style.stageBackground.a(batch, f3, f4, f5, f6);
    }

    @Override
    protected void drawBackground(Batch batch, float f2, float f3, float f4) {
        super.drawBackground(batch, f2, f3, f4);
        this.titleTable.getColor().a = this.getColor().a;
        f3 = this.getPadTop();
        f4 = this.getPadLeft();
        this.titleTable.setSize(this.getWidth() - f4 - this.getPadRight(), f3);
        this.titleTable.setPosition(f4, this.getHeight() - f3);
        this.drawTitleTable = true;
        ((b)this.titleTable).draw(batch, f2);
        this.drawTitleTable = false;
    }

    @Override
    public b hit(float f2, float f3, boolean bl2) {
        if (!this.isVisible()) {
            return null;
        }
        b b2 = super.hit(f2, f3, bl2);
        if (b2 == null && this.isModal && (!bl2 || this.getTouchable() == l.a)) {
            return this;
        }
        float f4 = this.getHeight();
        if (b2 == null || b2 == this) {
            return b2;
        }
        if (f3 <= f4 && f3 >= f4 - this.getPadTop() && f2 >= 0.0f && f2 <= this.getWidth()) {
            b b3 = b2;
            while (b3.getParent() != this) {
                b3 = b3.getParent();
            }
            if (this.getCell(b3) != null) {
                return this;
            }
        }
        return b2;
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public void setMovable(boolean bl2) {
        this.isMovable = bl2;
    }

    public boolean isModal() {
        return this.isModal;
    }

    public void setModal(boolean bl2) {
        this.isModal = bl2;
    }

    public void setKeepWithinStage(boolean bl2) {
        this.keepWithinStage = bl2;
    }

    public boolean isResizable() {
        return this.isResizable;
    }

    public void setResizable(boolean bl2) {
        this.isResizable = bl2;
    }

    public void setResizeBorder(int n2) {
        this.resizeBorder = n2;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public float getPrefWidth() {
        return Math.max(super.getPrefWidth(), ((WidgetGroup)this.titleTable).getPrefWidth() + this.getPadLeft() + this.getPadRight());
    }

    public Table getTitleTable() {
        return this.titleTable;
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }
}

