/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.c;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.h;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.b.p;
import com.badlogic.gdx.scenes.scene2d.b.s;
import com.badlogic.gdx.scenes.scene2d.b.x;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Styleable;
import com.badlogic.gdx.scenes.scene2d.ui.Tree$Node;
import com.badlogic.gdx.scenes.scene2d.ui.Tree$TreeStyle;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.aj;
import com.badlogic.gdx.scenes.scene2d.ui.ak;
import com.badlogic.gdx.utils.Array;

public class Tree
extends WidgetGroup
implements Styleable {
    private static final Vector2 tmp = new Vector2();
    Tree$TreeStyle style;
    final Array rootNodes = new Array();
    final s selection = new aj(this);
    float ySpacing = 4.0f;
    float iconSpacingLeft = 2.0f;
    float iconSpacingRight = 2.0f;
    float paddingLeft;
    float paddingRight;
    float indentSpacing;
    private float prefWidth;
    private float prefHeight;
    private boolean sizeInvalid = true;
    private Tree$Node foundNode;
    private Tree$Node overNode;
    Tree$Node rangeStart;
    private h clickListener;

    public Tree(Skin skin) {
        this((Tree$TreeStyle)skin.get(Tree$TreeStyle.class));
    }

    public Tree(Skin skin, String string) {
        this((Tree$TreeStyle)skin.get(string, Tree$TreeStyle.class));
    }

    public Tree(Tree$TreeStyle tree$TreeStyle) {
        this.selection.a(this);
        this.selection.o();
        this.setStyle(tree$TreeStyle);
        this.initialize();
    }

    private void initialize() {
        this.clickListener = new ak(this);
        this.addListener(this.clickListener);
    }

    public void setStyle(Tree$TreeStyle tree$TreeStyle) {
        this.style = tree$TreeStyle;
        if (this.indentSpacing == 0.0f) {
            this.indentSpacing = this.plusMinusWidth();
        }
    }

    public void add(Tree$Node tree$Node) {
        Tree tree = this;
        tree.insert(tree.rootNodes.size, tree$Node);
    }

    public void insert(int n2, Tree$Node tree$Node) {
        int n3;
        if (tree$Node.parent != null) {
            tree$Node.parent.remove(tree$Node);
            tree$Node.parent = null;
        } else {
            n3 = this.rootNodes.indexOf(tree$Node, true);
            if (n3 != -1) {
                if (n3 == n2) {
                    return;
                }
                if (n3 < n2) {
                    --n2;
                }
                this.rootNodes.removeIndex(n3);
                n3 = tree$Node.actor.getZIndex();
                if (n3 != -1) {
                    tree$Node.removeFromTree(this, n3);
                }
            }
        }
        this.rootNodes.insert(n2, tree$Node);
        if (n2 == 0) {
            n3 = 0;
        } else if (n2 < this.rootNodes.size - 1) {
            n3 = ((Tree$Node)this.rootNodes.get((int)(n2 + 1))).actor.getZIndex();
        } else {
            Tree$Node tree$Node2 = (Tree$Node)this.rootNodes.get(n2 - 1);
            n3 = tree$Node2.actor.getZIndex() + tree$Node2.countActors();
        }
        tree$Node.addToTree(this, n3);
    }

    public void remove(Tree$Node tree$Node) {
        if (tree$Node.parent != null) {
            tree$Node.parent.remove(tree$Node);
            return;
        }
        if (!this.rootNodes.removeValue(tree$Node, true)) {
            return;
        }
        int n2 = tree$Node.actor.getZIndex();
        if (n2 != -1) {
            tree$Node.removeFromTree(this, n2);
        }
    }

    @Override
    public void clearChildren(boolean bl2) {
        super.clearChildren(bl2);
        this.setOverNode(null);
        this.rootNodes.clear();
        this.selection.l();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    private float plusMinusWidth() {
        float f2 = Math.max(this.style.plus.e(), this.style.minus.e());
        if (this.style.plusOver != null) {
            f2 = Math.max(f2, this.style.plusOver.e());
        }
        if (this.style.minusOver != null) {
            f2 = Math.max(f2, this.style.minusOver.e());
        }
        return f2;
    }

    private void computeSize() {
        this.sizeInvalid = false;
        this.prefWidth = this.plusMinusWidth();
        this.prefHeight = 0.0f;
        Tree tree = this;
        tree.computeSize(tree.rootNodes, 0.0f, this.prefWidth);
        this.prefWidth += this.paddingLeft + this.paddingRight;
    }

    private void computeSize(Array array, float f2, float f3) {
        float f4 = this.ySpacing;
        float f5 = this.iconSpacingLeft + this.iconSpacingRight;
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            float f6 = f2 + f3;
            Object object = tree$Node.actor;
            if (object instanceof p) {
                object = (p)object;
                f6 += object.getPrefWidth();
                tree$Node.height = object.getPrefHeight();
            } else {
                f6 += ((b)object).getWidth();
                tree$Node.height = ((b)object).getHeight();
            }
            if (tree$Node.icon != null) {
                f6 += f5 + tree$Node.icon.e();
                tree$Node.height = Math.max(tree$Node.height, tree$Node.icon.f());
            }
            this.prefWidth = Math.max(this.prefWidth, f6);
            this.prefHeight += tree$Node.height + f4;
            if (!tree$Node.expanded) continue;
            this.computeSize(tree$Node.children, f2 + this.indentSpacing, f3);
        }
    }

    @Override
    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        Tree tree = this;
        tree.layout(tree.rootNodes, this.paddingLeft, this.getHeight() - this.ySpacing / 2.0f, this.plusMinusWidth());
    }

    private float layout(Array array, float f2, float f3, float f4) {
        float f5 = this.ySpacing;
        float f6 = this.iconSpacingLeft;
        float f7 = f6 + this.iconSpacingRight;
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            float f8 = f2 + f4;
            f8 = tree$Node.icon != null ? (f8 += f7 + tree$Node.icon.e()) : (f8 += f6);
            if (tree$Node.actor instanceof p) {
                ((p)((Object)tree$Node.actor)).pack();
            }
            tree$Node.actor.setPosition(f8, f3 -= tree$Node.getHeight());
            f3 -= f5;
            if (!tree$Node.expanded) continue;
            f3 = this.layout(tree$Node.children, f2 + this.indentSpacing, f3, f4);
        }
        return f3;
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.drawBackground(batch, f2);
        Color color = this.getColor();
        float f3 = color.a * f2;
        batch.setColor(color.r, color.g, color.b, f3);
        this.drawIcons(batch, color.r, color.g, color.b, f3, null, this.rootNodes, this.paddingLeft, this.plusMinusWidth());
        super.draw(batch, f2);
    }

    protected void drawBackground(Batch batch, float f2) {
        if (this.style.background != null) {
            Color color = this.getColor();
            batch.setColor(color.r, color.g, color.b, color.a * f2);
            this.style.background.a(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    protected float drawIcons(Batch batch, float f2, float f3, float f4, float f5, Tree$Node object, Array array, float f6, float f7) {
        object = this.getCullingArea();
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (object != null) {
            f8 = ((Rectangle)object).y;
            f9 = f8 + ((Rectangle)object).height;
        }
        Tree$TreeStyle tree$TreeStyle = this.style;
        float f10 = this.getX();
        float f11 = this.getY();
        float f12 = f10 + f6;
        float f13 = f12 + f7 + this.iconSpacingLeft;
        float f14 = 0.0f;
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            Object object2 = tree$Node.actor;
            f14 = ((b)object2).getY();
            float f15 = tree$Node.height;
            if (object == null || f14 + f15 >= f8 && f14 <= f9) {
                if (this.selection.c(tree$Node) && tree$TreeStyle.selection != null) {
                    this.drawSelection(tree$Node, tree$TreeStyle.selection, batch, f10, f11 + f14 - this.ySpacing / 2.0f, this.getWidth(), f15 + this.ySpacing);
                } else if (tree$Node == this.overNode && tree$TreeStyle.over != null) {
                    this.drawOver(tree$Node, tree$TreeStyle.over, batch, f10, f11 + f14 - this.ySpacing / 2.0f, this.getWidth(), f15 + this.ySpacing);
                }
                if (tree$Node.icon != null) {
                    float f16 = f11 + f14 + (float)Math.round((f15 - tree$Node.icon.f()) / 2.0f);
                    object2 = ((b)object2).getColor();
                    batch.setColor(((Color)object2).r, ((Color)object2).g, ((Color)object2).b, ((Color)object2).a * f5);
                    Tree$Node tree$Node2 = tree$Node;
                    this.drawIcon(tree$Node2, tree$Node2.icon, batch, f13, f16);
                    batch.setColor(f2, f3, f4, f5);
                }
                if (tree$Node.children.size > 0) {
                    k k2 = this.getExpandIcon(tree$Node, f13);
                    float f17 = f11 + f14 + (float)Math.round((f15 - k2.f()) / 2.0f);
                    this.drawExpandIcon(tree$Node, k2, batch, f12, f17);
                }
            } else if (f14 < f8) break;
            if (!tree$Node.expanded || tree$Node.children.size <= 0) continue;
            Tree$Node tree$Node3 = tree$Node;
            this.drawIcons(batch, f2, f3, f4, f5, tree$Node3, tree$Node3.children, f6 + this.indentSpacing, f7);
        }
        return f14;
    }

    protected void drawSelection(Tree$Node tree$Node, k k2, Batch batch, float f2, float f3, float f4, float f5) {
        k2.a(batch, f2, f3, f4, f5);
    }

    protected void drawOver(Tree$Node tree$Node, k k2, Batch batch, float f2, float f3, float f4, float f5) {
        k2.a(batch, f2, f3, f4, f5);
    }

    protected void drawExpandIcon(Tree$Node tree$Node, k k2, Batch batch, float f2, float f3) {
        k2.a(batch, f2, f3, k2.e(), k2.f());
    }

    protected void drawIcon(Tree$Node tree$Node, k k2, Batch batch, float f2, float f3) {
        k2.a(batch, f2, f3, k2.e(), k2.f());
    }

    protected k getExpandIcon(Tree$Node tree$Node, float f2) {
        if (!(tree$Node != this.overNode || Gdx.a.e() != c.b || this.selection.n() && (x.b() || x.a()))) {
            k k2;
            float f3;
            float f4 = this.screenToLocalCoordinates((Vector2)Tree.tmp.set((float)((float)Gdx.d.a()), (float)0.0f)).x + this.getX();
            if (f3 >= 0.0f && f4 < f2 && (k2 = tree$Node.expanded ? this.style.minusOver : this.style.plusOver) != null) {
                return k2;
            }
        }
        if (tree$Node.expanded) {
            return this.style.minus;
        }
        return this.style.plus;
    }

    public Tree$Node getNodeAt(float f2) {
        this.foundNode = null;
        Tree tree = this;
        tree.getNodeAt(tree.rootNodes, f2, this.getHeight());
        try {
            Tree$Node tree$Node = this.foundNode;
            return tree$Node;
        }
        finally {
            this.foundNode = null;
        }
    }

    private float getNodeAt(Array array, float f2, float f3) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            float f4 = tree$Node.height;
            if (f2 >= (f3 -= tree$Node.getHeight() - f4) - f4 - this.ySpacing && f2 < f3) {
                this.foundNode = tree$Node;
                return -1.0f;
            }
            f3 -= f4 + this.ySpacing;
            if (!tree$Node.expanded || (f3 = this.getNodeAt(tree$Node.children, f2, f3)) != -1.0f) continue;
            return -1.0f;
        }
        return f3;
    }

    void selectNodes(Array array, float f2, float f3) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            if (tree$Node.actor.getY() < f2) break;
            if (!tree$Node.isSelectable()) continue;
            if (tree$Node.actor.getY() <= f3) {
                this.selection.a(tree$Node);
            }
            if (!tree$Node.expanded) continue;
            this.selectNodes(tree$Node.children, f2, f3);
        }
    }

    public s getSelection() {
        return this.selection;
    }

    public Tree$Node getSelectedNode() {
        return (Tree$Node)this.selection.h();
    }

    public Object getSelectedValue() {
        Tree$Node tree$Node = (Tree$Node)this.selection.h();
        if (tree$Node == null) {
            return null;
        }
        return tree$Node.getValue();
    }

    @Override
    public Tree$TreeStyle getStyle() {
        return this.style;
    }

    public Array getRootNodes() {
        return this.rootNodes;
    }

    public Array getNodes() {
        return this.rootNodes;
    }

    public void updateRootNodes() {
        int n2;
        int n3 = this.rootNodes.size;
        for (n2 = 0; n2 < n3; ++n2) {
            Tree$Node tree$Node = (Tree$Node)this.rootNodes.get(n2);
            int n4 = tree$Node.actor.getZIndex();
            if (n4 == -1) continue;
            tree$Node.removeFromTree(this, n4);
        }
        n3 = this.rootNodes.size;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n5 += ((Tree$Node)this.rootNodes.get(n2)).addToTree(this, n5);
        }
    }

    public Tree$Node getOverNode() {
        return this.overNode;
    }

    public Object getOverValue() {
        if (this.overNode == null) {
            return null;
        }
        return this.overNode.getValue();
    }

    public void setOverNode(Tree$Node tree$Node) {
        this.overNode = tree$Node;
    }

    public void setPadding(float f2) {
        this.paddingLeft = f2;
        this.paddingRight = f2;
    }

    public void setPadding(float f2, float f3) {
        this.paddingLeft = f2;
        this.paddingRight = f3;
    }

    public void setIndentSpacing(float f2) {
        this.indentSpacing = f2;
    }

    public float getIndentSpacing() {
        return this.indentSpacing;
    }

    public void setYSpacing(float f2) {
        this.ySpacing = f2;
    }

    public float getYSpacing() {
        return this.ySpacing;
    }

    public void setIconSpacing(float f2, float f3) {
        this.iconSpacingLeft = f2;
        this.iconSpacingRight = f3;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    public void findExpandedValues(Array array) {
        Tree.findExpandedValues(this.rootNodes, array);
    }

    public void restoreExpandedValues(Array array) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = this.findNode(array.get(i2));
            if (tree$Node == null) continue;
            tree$Node.setExpanded(true);
            tree$Node.expandTo();
        }
    }

    static boolean findExpandedValues(Array array, Array array2) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            if (!tree$Node.expanded || Tree.findExpandedValues(tree$Node.children, array2)) continue;
            array2.add(tree$Node.value);
        }
        return false;
    }

    public Tree$Node findNode(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        return Tree.findNode(this.rootNodes, object);
    }

    static Tree$Node findNode(Array array, Object object) {
        Tree$Node tree$Node;
        int n2;
        int n3 = array.size;
        for (n2 = 0; n2 < n3; ++n2) {
            tree$Node = (Tree$Node)array.get(n2);
            if (!object.equals(tree$Node.value)) continue;
            return tree$Node;
        }
        n3 = array.size;
        for (n2 = 0; n2 < n3; ++n2) {
            tree$Node = Tree.findNode(((Tree$Node)array.get((int)n2)).children, object);
            if (tree$Node == null) continue;
            return tree$Node;
        }
        return null;
    }

    public void collapseAll() {
        Tree.collapseAll(this.rootNodes);
    }

    static void collapseAll(Array array) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = (Tree$Node)array.get(i2);
            tree$Node.setExpanded(false);
            Tree.collapseAll(tree$Node.children);
        }
    }

    public void expandAll() {
        Tree.expandAll(this.rootNodes);
    }

    static void expandAll(Array array) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Tree$Node)array.get(i2)).expandAll();
        }
    }

    public h getClickListener() {
        return this.clickListener;
    }
}

