/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.e;
import com.badlogic.gdx.scenes.scene2d.ui.Tree;
import com.badlogic.gdx.utils.Array;

public abstract class Tree$Node {
    b actor;
    Tree$Node parent;
    final Array children = new Array(0);
    boolean selectable = true;
    boolean expanded;
    k icon;
    float height;
    Object value;

    public Tree$Node(b b2) {
        if (b2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        this.actor = b2;
    }

    public Tree$Node() {
    }

    public void setExpanded(boolean n2) {
        if (n2 == this.expanded) {
            return;
        }
        this.expanded = n2;
        if (this.children.size == 0) {
            return;
        }
        Tree tree = this.getTree();
        if (tree == null) {
            return;
        }
        Object[] objectArray = this.children.items;
        int n3 = this.actor.getZIndex() + 1;
        if (n2 != 0) {
            int n4 = this.children.size;
            for (n2 = 0; n2 < n4; ++n2) {
                n3 += ((Tree$Node)objectArray[n2]).addToTree(tree, n3);
            }
            return;
        }
        int n5 = this.children.size;
        for (n2 = 0; n2 < n5; ++n2) {
            ((Tree$Node)objectArray[n2]).removeFromTree(tree, n3);
        }
    }

    protected int addToTree(Tree tree, int n2) {
        tree.addActorAt(n2, this.actor);
        if (!this.expanded) {
            return 1;
        }
        int n3 = n2 + 1;
        Object[] objectArray = this.children.items;
        int n4 = this.children.size;
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 += ((Tree$Node)objectArray[i2]).addToTree(tree, n3);
        }
        return n3 - n2;
    }

    protected void removeFromTree(Tree tree, int n2) {
        tree.removeActorAt(n2, true);
        if (!this.expanded) {
            return;
        }
        Object[] objectArray = this.children.items;
        int n3 = this.children.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            ((Tree$Node)objectArray[i2]).removeFromTree(tree, n2);
        }
    }

    public void add(Tree$Node tree$Node) {
        Tree$Node tree$Node2 = this;
        tree$Node2.insert(tree$Node2.children.size, tree$Node);
    }

    public void addAll(Array array) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = this;
            tree$Node.insert(tree$Node.children.size, (Tree$Node)array.get(i2));
        }
    }

    public void insert(int n2, Tree$Node tree$Node) {
        tree$Node.parent = this;
        this.children.insert(n2, tree$Node);
        if (!this.expanded) {
            return;
        }
        Tree tree = this.getTree();
        if (tree != null) {
            if (n2 == 0) {
                n2 = this.actor.getZIndex() + 1;
            } else if (n2 < this.children.size - 1) {
                n2 = ((Tree$Node)this.children.get((int)(n2 + 1))).actor.getZIndex();
            } else {
                Tree$Node tree$Node2 = (Tree$Node)this.children.get(n2 - 1);
                n2 = tree$Node2.actor.getZIndex() + tree$Node2.countActors();
            }
            tree$Node.addToTree(tree, n2);
        }
    }

    int countActors() {
        if (!this.expanded) {
            return 1;
        }
        int n2 = 1;
        Object[] objectArray = this.children.items;
        int n3 = this.children.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += ((Tree$Node)objectArray[i2]).countActors();
        }
        return n2;
    }

    public void remove() {
        Tree tree = this.getTree();
        if (tree != null) {
            tree.remove(this);
            return;
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public void remove(Tree$Node tree$Node) {
        if (!this.children.removeValue(tree$Node, true)) {
            return;
        }
        if (!this.expanded) {
            return;
        }
        Tree tree = this.getTree();
        if (tree != null) {
            tree$Node.removeFromTree(tree, tree$Node.actor.getZIndex());
        }
    }

    public void clearChildren() {
        Tree tree;
        if (this.expanded && (tree = this.getTree()) != null) {
            int n2 = this.actor.getZIndex() + 1;
            Object[] objectArray = this.children.items;
            int n3 = this.children.size;
            for (int i2 = 0; i2 < n3; ++i2) {
                ((Tree$Node)objectArray[i2]).removeFromTree(tree, n2);
            }
        }
        this.children.clear();
    }

    public Tree getTree() {
        e e2 = this.actor.getParent();
        if (e2 instanceof Tree) {
            return (Tree)e2;
        }
        return null;
    }

    public void setActor(b b2) {
        Tree tree;
        if (this.actor != null && (tree = this.getTree()) != null) {
            int n2 = this.actor.getZIndex();
            tree.removeActorAt(n2, true);
            tree.addActorAt(n2, b2);
        }
        this.actor = b2;
    }

    public b getActor() {
        return this.actor;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public Array getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size > 0;
    }

    public void updateChildren() {
        int n2;
        if (!this.expanded) {
            return;
        }
        Tree tree = this.getTree();
        if (tree == null) {
            return;
        }
        Object[] objectArray = this.children.items;
        int n3 = this.children.size;
        int n4 = this.actor.getZIndex() + 1;
        for (n2 = 0; n2 < n3; ++n2) {
            ((Tree$Node)objectArray[n2]).removeFromTree(tree, n4);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += ((Tree$Node)objectArray[n2]).addToTree(tree, n4);
        }
    }

    public Tree$Node getParent() {
        return this.parent;
    }

    public void setIcon(k k2) {
        this.icon = k2;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public k getIcon() {
        return this.icon;
    }

    public int getLevel() {
        int n2 = 0;
        Tree$Node tree$Node = this;
        do {
            ++n2;
        } while ((tree$Node = tree$Node.getParent()) != null);
        return n2;
    }

    public Tree$Node findNode(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        if (object.equals(this.value)) {
            return this;
        }
        return Tree.findNode(this.children, object);
    }

    public void collapseAll() {
        this.setExpanded(false);
        Tree.collapseAll(this.children);
    }

    public void expandAll() {
        this.setExpanded(true);
        if (this.children.size > 0) {
            Tree.expandAll(this.children);
        }
    }

    public void expandTo() {
        Tree$Node tree$Node = this.parent;
        while (tree$Node != null) {
            tree$Node.setExpanded(true);
            tree$Node = tree$Node.parent;
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean bl2) {
        this.selectable = bl2;
    }

    public void findExpandedValues(Array array) {
        if (this.expanded && !Tree.findExpandedValues(this.children, array)) {
            array.add(this.value);
        }
    }

    public void restoreExpandedValues(Array array) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Tree$Node tree$Node = this.findNode(array.get(i2));
            if (tree$Node == null) continue;
            tree$Node.setExpanded(true);
            tree$Node.expandTo();
        }
    }

    public float getHeight() {
        return this.height;
    }

    public boolean isAscendantOf(Tree$Node tree$Node) {
        if (tree$Node == null) {
            throw new IllegalArgumentException("node cannot be null.");
        }
        do {
            if (tree$Node != this) continue;
            return true;
        } while ((tree$Node = tree$Node.parent) != null);
        return false;
    }

    public boolean isDescendantOf(Tree$Node tree$Node) {
        if (tree$Node == null) {
            throw new IllegalArgumentException("node cannot be null.");
        }
        Tree$Node tree$Node2 = this;
        do {
            if (tree$Node2 != tree$Node) continue;
            return true;
        } while ((tree$Node2 = tree$Node2.parent) != null);
        return false;
    }
}

