/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.g;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.l;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Styleable;
import com.badlogic.gdx.scenes.scene2d.ui.Touchpad$TouchpadStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.ui.ai;
import com.badlogic.gdx.utils.Pools;

public class Touchpad
extends Widget
implements Styleable {
    private Touchpad$TouchpadStyle style;
    boolean touched;
    boolean resetOnTouchUp = true;
    private float deadzoneRadius;
    private final Circle knobBounds = new Circle(0.0f, 0.0f, 0.0f);
    private final Circle touchBounds = new Circle(0.0f, 0.0f, 0.0f);
    private final Circle deadzoneBounds = new Circle(0.0f, 0.0f, 0.0f);
    private final Vector2 knobPosition = new Vector2();
    private final Vector2 knobPercent = new Vector2();

    public Touchpad(float f2, Skin skin) {
        this(f2, (Touchpad$TouchpadStyle)skin.get(Touchpad$TouchpadStyle.class));
    }

    public Touchpad(float f2, Skin skin, String string) {
        this(f2, (Touchpad$TouchpadStyle)skin.get(string, Touchpad$TouchpadStyle.class));
    }

    public Touchpad(float f2, Touchpad$TouchpadStyle touchpad$TouchpadStyle) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("deadzoneRadius must be > 0");
        }
        this.deadzoneRadius = f2;
        this.knobPosition.set(this.getWidth() / 2.0f, this.getHeight() / 2.0f);
        this.setStyle(touchpad$TouchpadStyle);
        Touchpad touchpad = this;
        touchpad.setSize(((Widget)touchpad).getPrefWidth(), ((Widget)this).getPrefHeight());
        this.addListener(new ai(this));
    }

    void calculatePositionAndValue(float f2, float f3, boolean bl2) {
        float f4 = this.knobPosition.x;
        float f5 = this.knobPosition.y;
        float f6 = this.knobPercent.x;
        float f7 = this.knobPercent.y;
        float f8 = this.knobBounds.x;
        float f9 = this.knobBounds.y;
        this.knobPosition.set(f8, f9);
        this.knobPercent.set(0.0f, 0.0f);
        if (!bl2 && !this.deadzoneBounds.contains(f2, f3)) {
            float f10;
            this.knobPercent.set((f2 - f8) / this.knobBounds.radius, (f3 - f9) / this.knobBounds.radius);
            float f11 = this.knobPercent.len();
            if (f10 > 1.0f) {
                this.knobPercent.scl(1.0f / f11);
            }
            if (this.knobBounds.contains(f2, f3)) {
                this.knobPosition.set(f2, f3);
            } else {
                this.knobPosition.set(this.knobPercent).nor().scl(this.knobBounds.radius).add(this.knobBounds.x, this.knobBounds.y);
            }
        }
        if (f6 != this.knobPercent.x || f7 != this.knobPercent.y) {
            g g2 = (g)Pools.obtain(g::new);
            if (this.fire(g2)) {
                this.knobPercent.set(f6, f7);
                this.knobPosition.set(f4, f5);
            }
            Pools.free(g2);
        }
    }

    public void setStyle(Touchpad$TouchpadStyle touchpad$TouchpadStyle) {
        if (touchpad$TouchpadStyle == null) {
            throw new IllegalArgumentException("style cannot be null");
        }
        this.style = touchpad$TouchpadStyle;
        this.invalidateHierarchy();
    }

    @Override
    public Touchpad$TouchpadStyle getStyle() {
        return this.style;
    }

    @Override
    public b hit(float f2, float f3, boolean bl2) {
        if (bl2 && this.getTouchable() != l.a) {
            return null;
        }
        if (!this.isVisible()) {
            return null;
        }
        if (this.touchBounds.contains(f2, f3)) {
            return this;
        }
        return null;
    }

    @Override
    public void layout() {
        float f2 = this.getWidth() / 2.0f;
        float f3 = this.getHeight() / 2.0f;
        float f4 = Math.min(f2, f3);
        this.touchBounds.set(f2, f3, f4);
        if (this.style.knob != null) {
            f4 -= Math.max(this.style.knob.e(), this.style.knob.f()) / 2.0f;
        }
        this.knobBounds.set(f2, f3, f4);
        this.deadzoneBounds.set(f2, f3, this.deadzoneRadius);
        this.knobPosition.set(f2, f3);
        this.knobPercent.set(0.0f, 0.0f);
    }

    @Override
    public void draw(Batch batch, float f2) {
        k k2;
        this.validate();
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * f2);
        f2 = this.getX();
        float f3 = this.getY();
        float f4 = this.getWidth();
        float f5 = this.getHeight();
        k k3 = this.style.background;
        if (k3 != null) {
            k3.a(batch, f2, f3, f4, f5);
        }
        if ((k2 = this.style.knob) != null) {
            k2.a(batch, f2 += this.knobPosition.x - k2.e() / 2.0f, f3 += this.knobPosition.y - k2.f() / 2.0f, k2.e(), k2.f());
        }
    }

    @Override
    public float getPrefWidth() {
        if (this.style.background != null) {
            return this.style.background.e();
        }
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.style.background != null) {
            return this.style.background.f();
        }
        return 0.0f;
    }

    public boolean isTouched() {
        return this.touched;
    }

    public boolean getResetOnTouchUp() {
        return this.resetOnTouchUp;
    }

    public void setResetOnTouchUp(boolean bl2) {
        this.resetOnTouchUp = bl2;
    }

    public void setDeadzone(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("deadzoneRadius must be > 0");
        }
        this.deadzoneRadius = f2;
        this.invalidate();
    }

    public float getKnobX() {
        return this.knobPosition.x;
    }

    public float getKnobY() {
        return this.knobPosition.y;
    }

    public float getKnobPercentX() {
        return this.knobPercent.x;
    }

    public float getKnobPercentY() {
        return this.knobPercent.y;
    }
}

