/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFont$BitmapFontData;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.GlyphLayout$GlyphRun;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.g;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.c;
import com.badlogic.gdx.scenes.scene2d.e;
import com.badlogic.gdx.scenes.scene2d.h;
import com.badlogic.gdx.scenes.scene2d.j;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Styleable;
import com.badlogic.gdx.scenes.scene2d.ui.TextField$DefaultOnscreenKeyboard;
import com.badlogic.gdx.scenes.scene2d.ui.TextField$OnscreenKeyboard;
import com.badlogic.gdx.scenes.scene2d.ui.TextField$TextFieldClickListener;
import com.badlogic.gdx.scenes.scene2d.ui.TextField$TextFieldFilter;
import com.badlogic.gdx.scenes.scene2d.ui.TextField$TextFieldListener;
import com.badlogic.gdx.scenes.scene2d.ui.TextField$TextFieldStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.ui.ad;
import com.badlogic.gdx.scenes.scene2d.ui.ae;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.Timer$Task;

public class TextField
extends Widget
implements Styleable {
    protected static final char BACKSPACE = '\b';
    protected static final char CARRIAGE_RETURN = '\r';
    protected static final char NEWLINE = '\n';
    protected static final char TAB = '\t';
    protected static final char DELETE = '\u007f';
    protected static final char BULLET = '\u0095';
    private static final Vector2 tmp1 = new Vector2();
    private static final Vector2 tmp2 = new Vector2();
    private static final Vector2 tmp3 = new Vector2();
    public static float keyRepeatInitialTime = 0.4f;
    public static float keyRepeatTime = 0.1f;
    protected String text;
    protected int cursor;
    protected int selectionStart;
    protected boolean hasSelection;
    protected boolean writeEnters;
    protected final GlyphLayout layout = new GlyphLayout();
    protected final FloatArray glyphPositions = new FloatArray();
    TextField$TextFieldStyle style;
    private String messageText;
    protected CharSequence displayText;
    Clipboard clipboard;
    h inputListener;
    TextField$TextFieldListener listener;
    TextField$TextFieldFilter filter;
    TextField$OnscreenKeyboard keyboard = new TextField$DefaultOnscreenKeyboard();
    boolean focusTraversal = true;
    boolean onlyFontChars = true;
    boolean disabled;
    private int textHAlign = 8;
    private float selectionX;
    private float selectionWidth;
    String undoText = "";
    long lastChangeTime;
    boolean passwordMode;
    private StringBuilder passwordBuffer;
    private char passwordCharacter = (char)149;
    protected float fontOffset;
    protected float textHeight;
    protected float textOffset;
    float renderOffset;
    protected int visibleTextStart;
    protected int visibleTextEnd;
    private int maxLength;
    boolean focused;
    boolean cursorOn;
    float blinkTime = 0.32f;
    final Timer$Task blinkTask = new ad(this);
    final ae keyRepeatTask = new ae(this);
    boolean programmaticChangeEvents;

    public TextField(String string, Skin skin) {
        this(string, (TextField$TextFieldStyle)skin.get(TextField$TextFieldStyle.class));
    }

    public TextField(String string, Skin skin, String string2) {
        this(string, (TextField$TextFieldStyle)skin.get(string2, TextField$TextFieldStyle.class));
    }

    public TextField(String string, TextField$TextFieldStyle textField$TextFieldStyle) {
        this.setStyle(textField$TextFieldStyle);
        this.clipboard = Gdx.a.f();
        this.initialize();
        this.setText(string);
        TextField textField = this;
        textField.setSize(((Widget)textField).getPrefWidth(), ((Widget)this).getPrefHeight());
    }

    protected void initialize() {
        this.inputListener = this.createInputListener();
        this.addListener(this.inputListener);
    }

    protected h createInputListener() {
        return new TextField$TextFieldClickListener(this);
    }

    protected int letterUnderCursor(float f2) {
        f2 -= this.textOffset + this.fontOffset - this.style.font.getData().cursorX - this.glyphPositions.get(this.visibleTextStart);
        if (this.getBackgroundDrawable() != null) {
            f2 -= this.style.background.a();
        }
        int n2 = this.glyphPositions.size;
        float[] fArray = this.glyphPositions.items;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (!(fArray[i2] > f2)) continue;
            if (fArray[i2] - f2 <= f2 - fArray[i2 - 1]) {
                return i2;
            }
            return i2 - 1;
        }
        return n2 - 1;
    }

    protected boolean isWordCharacter(char c2) {
        return Character.isLetterOrDigit(c2);
    }

    protected int[] wordUnderCursor(int n2) {
        String string = this.text;
        int n3 = n2;
        int n4 = string.length();
        int n5 = 0;
        if (n2 >= string.length()) {
            n5 = string.length();
            n4 = 0;
        } else {
            int n6;
            for (n6 = n3; n6 < n4; ++n6) {
                if (this.isWordCharacter(string.charAt(n6))) continue;
                n4 = n6;
                break;
            }
            for (n6 = n3 - 1; n6 >= 0; --n6) {
                if (this.isWordCharacter(string.charAt(n6))) continue;
                n5 = n6 + 1;
                break;
            }
        }
        return new int[]{n5, n4};
    }

    int[] wordUnderCursor(float f2) {
        TextField textField = this;
        return textField.wordUnderCursor(textField.letterUnderCursor(f2));
    }

    boolean withinMaxLength(int n2) {
        return this.maxLength <= 0 || n2 < this.maxLength;
    }

    public void setMaxLength(int n2) {
        this.maxLength = n2;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setOnlyFontChars(boolean bl2) {
        this.onlyFontChars = bl2;
    }

    public void setStyle(TextField$TextFieldStyle textField$TextFieldStyle) {
        if (textField$TextFieldStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = textField$TextFieldStyle;
        this.textHeight = textField$TextFieldStyle.font.getCapHeight() - textField$TextFieldStyle.font.getDescent() * 2.0f;
        if (this.text != null) {
            this.updateDisplayText();
        }
        this.invalidateHierarchy();
    }

    @Override
    public TextField$TextFieldStyle getStyle() {
        return this.style;
    }

    protected void calculateOffsets() {
        int n2;
        float f2;
        float f3;
        float f4;
        float f5 = this.getWidth();
        k k2 = this.getBackgroundDrawable();
        if (k2 != null) {
            f5 -= k2.a() + k2.b();
        }
        int n3 = this.glyphPositions.size;
        float[] fArray = this.glyphPositions.items;
        this.cursor = MathUtils.clamp(this.cursor, 0, n3 - 1);
        float f6 = fArray[Math.max(0, this.cursor - 1)] + this.renderOffset;
        if (f4 <= 0.0f) {
            this.renderOffset -= f6;
        } else {
            int n4 = Math.min(n3 - 1, this.cursor + 1);
            f3 = fArray[n4] - f5;
            if (-this.renderOffset < f3) {
                this.renderOffset = -f3;
            }
        }
        f6 = 0.0f;
        f3 = fArray[n3 - 1];
        for (int i2 = n3 - 2; i2 >= 0 && !(f3 - (f2 = fArray[i2]) > f5); --i2) {
            f6 = f2;
        }
        if (-this.renderOffset > f6) {
            this.renderOffset = -f6;
        }
        this.visibleTextStart = 0;
        float f7 = 0.0f;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(fArray[n2] >= -this.renderOffset)) continue;
            this.visibleTextStart = n2;
            f7 = fArray[n2];
            break;
        }
        f6 = f5 - this.renderOffset;
        n3 = Math.min(this.displayText.length(), n3);
        for (n2 = this.visibleTextStart + 1; n2 <= n3 && !(fArray[n2] > f6); ++n2) {
        }
        this.visibleTextEnd = Math.max(0, n2 - 1);
        if ((this.textHAlign & 8) == 0) {
            this.textOffset = f5 - fArray[this.visibleTextEnd] - this.fontOffset + f7;
            if ((this.textHAlign & 1) != 0) {
                this.textOffset = Math.round(this.textOffset * 0.5f);
            }
        } else {
            this.textOffset = f7 + this.renderOffset;
        }
        if (this.hasSelection) {
            n3 = Math.min(this.cursor, this.selectionStart);
            int n5 = Math.max(this.cursor, this.selectionStart);
            float f8 = Math.max(fArray[n3] - fArray[this.visibleTextStart], -this.textOffset);
            f5 = Math.min(fArray[n5] - fArray[this.visibleTextStart], f5 - this.textOffset);
            this.selectionX = f8;
            this.selectionWidth = f5 - f8 - this.style.font.getData().cursorX;
        }
    }

    protected k getBackgroundDrawable() {
        if (this.disabled && this.style.disabledBackground != null) {
            return this.style.disabledBackground;
        }
        if (this.style.focusedBackground != null && this.hasKeyboardFocus()) {
            return this.style.focusedBackground;
        }
        return this.style.background;
    }

    @Override
    public void draw(Batch batch, float f2) {
        float f3;
        boolean bl2 = this.hasKeyboardFocus();
        if (bl2 != this.focused || bl2 && !this.blinkTask.isScheduled()) {
            this.focused = bl2;
            this.blinkTask.cancel();
            this.cursorOn = bl2;
            if (bl2) {
                Timer.schedule(this.blinkTask, this.blinkTime, this.blinkTime);
            } else {
                this.keyRepeatTask.cancel();
            }
        } else if (!bl2) {
            this.cursorOn = false;
        }
        BitmapFont bitmapFont = this.style.font;
        Color color = this.disabled && this.style.disabledFontColor != null ? this.style.disabledFontColor : (bl2 && this.style.focusedFontColor != null ? this.style.focusedFontColor : this.style.fontColor);
        k k2 = this.style.selection;
        k k3 = this.style.cursor;
        k k4 = this.getBackgroundDrawable();
        Color color2 = this.getColor();
        float f4 = this.getX();
        float f5 = this.getY();
        float f6 = this.getWidth();
        float f7 = this.getHeight();
        batch.setColor(color2.r, color2.g, color2.b, color2.a * f2);
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (k4 != null) {
            this.drawBackground(k4, batch, f4, f5, f6, f7);
            f8 = k4.a();
            f9 = k4.b();
        }
        float f10 = this.getTextY(bitmapFont, k4);
        this.calculateOffsets();
        if (bl2 && this.hasSelection && k2 != null) {
            this.drawSelection(k2, batch, bitmapFont, f4 + f8, f5 + f10);
        }
        float f11 = f3 = bitmapFont.isFlipped() ? -this.textHeight : 0.0f;
        if (this.displayText.length() == 0) {
            if ((!bl2 || this.disabled) && this.messageText != null) {
                BitmapFont bitmapFont2;
                BitmapFont bitmapFont3 = bitmapFont2 = this.style.messageFont != null ? this.style.messageFont : bitmapFont;
                if (this.style.messageFontColor != null) {
                    bitmapFont2.setColor(this.style.messageFontColor.r, this.style.messageFontColor.g, this.style.messageFontColor.b, this.style.messageFontColor.a * color2.a * f2);
                } else {
                    bitmapFont2.setColor(0.7f, 0.7f, 0.7f, color2.a * f2);
                }
                this.drawMessageText(batch, bitmapFont2, f4 + f8, f5 + f10 + f3, f6 - f8 - f9);
            }
        } else {
            BitmapFont$BitmapFontData bitmapFont$BitmapFontData = bitmapFont.getData();
            boolean bl3 = bitmapFont$BitmapFontData.markupEnabled;
            bitmapFont$BitmapFontData.markupEnabled = false;
            bitmapFont.setColor(color.r, color.g, color.b, color.a * color2.a * f2);
            this.drawText(batch, bitmapFont, f4 + f8, f5 + f10 + f3);
            bitmapFont$BitmapFontData.markupEnabled = bl3;
        }
        if (!this.disabled && this.cursorOn && k3 != null) {
            this.drawCursor(k3, batch, bitmapFont, f4 + f8, f5 + f10);
        }
    }

    protected float getTextY(BitmapFont bitmapFont, k k2) {
        float f2 = this.getHeight();
        float f3 = this.textHeight / 2.0f + bitmapFont.getDescent();
        if (k2 != null) {
            float f4 = k2.d();
            f3 = f3 + (f2 - k2.c() - f4) / 2.0f + f4;
        } else {
            f3 += f2 / 2.0f;
        }
        if (bitmapFont.usesIntegerPositions()) {
            f3 = (int)f3;
        }
        return f3;
    }

    protected void drawBackground(k k2, Batch batch, float f2, float f3, float f4, float f5) {
        k2.a(batch, f2, f3, f4, f5);
    }

    protected void drawSelection(k k2, Batch batch, BitmapFont bitmapFont, float f2, float f3) {
        k2.a(batch, f2 + this.textOffset + this.selectionX + this.fontOffset, f3 - this.textHeight - bitmapFont.getDescent(), this.selectionWidth, this.textHeight);
    }

    protected void drawText(Batch batch, BitmapFont bitmapFont, float f2, float f3) {
        bitmapFont.draw(batch, this.displayText, f2 + this.textOffset, f3, this.visibleTextStart, this.visibleTextEnd, 0.0f, 8, false);
    }

    protected void drawMessageText(Batch batch, BitmapFont bitmapFont, float f2, float f3, float f4) {
        bitmapFont.draw(batch, this.messageText, f2, f3, 0, this.messageText.length(), f4, this.textHAlign, false, "...");
    }

    protected void drawCursor(k k2, Batch batch, BitmapFont bitmapFont, float f2, float f3) {
        k2.a(batch, f2 + this.textOffset + this.glyphPositions.get(this.cursor) - this.glyphPositions.get(this.visibleTextStart) + this.fontOffset + bitmapFont.getData().cursorX, f3 - this.textHeight - bitmapFont.getDescent(), k2.e(), this.textHeight);
    }

    protected void updateDisplayText() {
        int n2;
        BitmapFont bitmapFont = this.style.font;
        Object object = bitmapFont.getData();
        String string = this.text;
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = string.charAt(i2);
            stringBuilder.append((char)(((BitmapFont$BitmapFontData)object).hasGlyph((char)n2) ? n2 : 32));
        }
        String string2 = stringBuilder.toString();
        if (this.passwordMode && ((BitmapFont$BitmapFontData)object).hasGlyph(this.passwordCharacter)) {
            if (this.passwordBuffer == null) {
                this.passwordBuffer = new StringBuilder(string2.length());
            }
            if (this.passwordBuffer.length() > n3) {
                this.passwordBuffer.setLength(n3);
            } else {
                for (n2 = this.passwordBuffer.length(); n2 < n3; ++n2) {
                    this.passwordBuffer.append(this.passwordCharacter);
                }
            }
            this.displayText = this.passwordBuffer;
        } else {
            this.displayText = string2;
        }
        n2 = ((BitmapFont$BitmapFontData)object).markupEnabled ? 1 : 0;
        ((BitmapFont$BitmapFontData)object).markupEnabled = false;
        this.layout.setText(bitmapFont, this.displayText.toString().replace('\r', ' ').replace('\n', ' '));
        ((BitmapFont$BitmapFontData)object).markupEnabled = n2;
        this.glyphPositions.clear();
        float f2 = 0.0f;
        if (this.layout.runs.size > 0) {
            object = ((GlyphLayout$GlyphRun)this.layout.runs.first()).xAdvances;
            this.fontOffset = ((FloatArray)object).first();
            int n4 = ((FloatArray)object).size;
            for (int i3 = 1; i3 < n4; ++i3) {
                this.glyphPositions.add(f2);
                f2 += ((FloatArray)object).get(i3);
            }
        } else {
            this.fontOffset = 0.0f;
        }
        this.glyphPositions.add(f2);
        this.visibleTextStart = Math.min(this.visibleTextStart, this.glyphPositions.size - 1);
        this.visibleTextEnd = MathUtils.clamp(this.visibleTextEnd, this.visibleTextStart, this.glyphPositions.size - 1);
        if (this.selectionStart > string2.length()) {
            this.selectionStart = n3;
        }
    }

    public void copy() {
        if (this.hasSelection && !this.passwordMode) {
            this.clipboard.setContents(this.text.substring(Math.min(this.cursor, this.selectionStart), Math.max(this.cursor, this.selectionStart)));
        }
    }

    public void cut() {
        TextField textField = this;
        textField.cut(textField.programmaticChangeEvents);
    }

    void cut(boolean bl2) {
        if (this.hasSelection && !this.passwordMode) {
            this.copy();
            this.cursor = this.delete(bl2);
            this.updateDisplayText();
        }
    }

    void paste(String string, boolean bl2) {
        if (string == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.text.length();
        if (this.hasSelection) {
            n2 -= Math.abs(this.cursor - this.selectionStart);
        }
        BitmapFont$BitmapFontData bitmapFont$BitmapFontData = this.style.font.getData();
        int n3 = string.length();
        for (int i2 = 0; i2 < n3 && this.withinMaxLength(n2 + stringBuilder.length()); ++i2) {
            char c2 = string.charAt(i2);
            if ((!this.writeEnters || c2 != '\n' && c2 != '\r') && (c2 == '\r' || c2 == '\n' || this.onlyFontChars && !bitmapFont$BitmapFontData.hasGlyph(c2) || this.filter != null && !this.filter.acceptChar(this, c2))) continue;
            stringBuilder.append(c2);
        }
        string = stringBuilder.toString();
        if (this.hasSelection) {
            this.cursor = this.delete(bl2);
        }
        if (bl2) {
            TextField textField = this;
            TextField textField2 = this;
            textField.changeText(textField.text, textField2.insert(textField2.cursor, string, this.text));
        } else {
            this.text = this.insert(this.cursor, string, this.text);
        }
        this.updateDisplayText();
        this.cursor += string.length();
    }

    String insert(int n2, CharSequence charSequence, String string) {
        if (string.length() == 0) {
            return charSequence.toString();
        }
        return string.substring(0, n2) + charSequence + string.substring(n2, string.length());
    }

    int delete(boolean bl2) {
        String string;
        int n2 = this.selectionStart;
        int n3 = this.cursor;
        int n4 = Math.min(n2, n3);
        n2 = Math.max(n2, n3);
        StringBuilder stringBuilder = new StringBuilder().append(n4 > 0 ? this.text.substring(0, n4) : "");
        if (n2 < this.text.length()) {
            String string2 = this.text;
            string = string2.substring(n2, string2.length());
        } else {
            string = "";
        }
        String string3 = stringBuilder.append(string).toString();
        if (bl2) {
            TextField textField = this;
            textField.changeText(textField.text, string3);
        } else {
            this.text = string3;
        }
        this.clearSelection();
        return n4;
    }

    public void next(boolean bl2) {
        j j2 = this.getStage();
        if (j2 == null) {
            return;
        }
        TextField textField = this;
        Vector2 vector2 = textField.getParent().localToStageCoordinates(tmp2.set(textField.getX(), textField.getY()));
        Vector2 vector22 = tmp1;
        while (true) {
            TextField textField2;
            if ((textField2 = textField.findNextTextField(j2.c(), null, vector22, vector2, bl2)) == null) {
                if (bl2) {
                    vector2.set(-3.4028235E38f, -3.4028235E38f);
                } else {
                    vector2.set(Float.MAX_VALUE, Float.MAX_VALUE);
                }
                textField2 = textField.findNextTextField(j2.c(), null, vector22, vector2, bl2);
            }
            if (textField2 == null) {
                return;
            }
            if (j2.d(textField2)) {
                textField2.selectAll();
                return;
            }
            textField = textField2;
            vector2.set(vector22);
        }
    }

    private TextField findNextTextField(Array array, TextField textField, Vector2 vector2, Vector2 vector22, boolean bl2) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            b b2 = (b)array.get(i2);
            if (b2 instanceof TextField) {
                boolean bl3;
                boolean bl4;
                Object object;
                if (b2 == this || ((TextField)(object = (TextField)b2)).isDisabled() || !((TextField)object).focusTraversal || !((b)object).ascendantsVisible()) continue;
                object = b2.getParent().localToStageCoordinates(tmp3.set(b2.getX(), b2.getY()));
                boolean bl5 = ((Vector2)object).y != vector22.y && ((Vector2)object).y < vector22.y ^ bl2 ? true : (bl4 = false);
                boolean bl6 = ((Vector2)object).y == vector22.y && ((Vector2)object).x > vector22.x ^ bl2 ? true : (bl3 = false);
                if (!bl4 && !bl3) continue;
                if (!(textField == null || ((Vector2)object).y != vector2.y && ((Vector2)object).y > vector2.y ^ bl2 ? true : (bl4 = false))) {
                    boolean bl7 = ((Vector2)object).y == vector2.y && ((Vector2)object).x < vector2.x ^ bl2 ? true : (bl4 = false);
                }
                if (!bl4) continue;
                textField = (TextField)b2;
                vector2.set((Vector2)object);
                continue;
            }
            if (!(b2 instanceof e)) continue;
            textField = this.findNextTextField(((e)b2).getChildren(), textField, vector2, vector22, bl2);
        }
        return textField;
    }

    public h getDefaultInputListener() {
        return this.inputListener;
    }

    public void setTextFieldListener(TextField$TextFieldListener textField$TextFieldListener) {
        this.listener = textField$TextFieldListener;
    }

    public void setTextFieldFilter(TextField$TextFieldFilter textField$TextFieldFilter) {
        this.filter = textField$TextFieldFilter;
    }

    public TextField$TextFieldFilter getTextFieldFilter() {
        return this.filter;
    }

    public void setFocusTraversal(boolean bl2) {
        this.focusTraversal = bl2;
    }

    public boolean getFocusTraversal() {
        return this.focusTraversal;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String string) {
        this.messageText = string;
    }

    public void appendText(String string) {
        if (string == null) {
            string = "";
        }
        this.clearSelection();
        this.cursor = this.text.length();
        this.paste(string, this.programmaticChangeEvents);
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this.text)) {
            return;
        }
        this.clearSelection();
        String string2 = this.text;
        this.text = "";
        this.paste(string, false);
        if (this.programmaticChangeEvents) {
            this.changeText(string2, this.text);
        }
        this.cursor = 0;
    }

    public String getText() {
        return this.text;
    }

    boolean changeText(String string, String object) {
        if (((String)object).equals(string)) {
            return false;
        }
        this.text = object;
        object = (g)Pools.obtain(g::new);
        boolean bl2 = this.fire((c)object);
        if (bl2) {
            this.text = string;
        }
        Pools.free(object);
        return !bl2;
    }

    public void setProgrammaticChangeEvents(boolean bl2) {
        this.programmaticChangeEvents = bl2;
    }

    public boolean getProgrammaticChangeEvents() {
        return this.programmaticChangeEvents;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public String getSelection() {
        if (this.hasSelection) {
            return this.text.substring(Math.min(this.selectionStart, this.cursor), Math.max(this.selectionStart, this.cursor));
        }
        return "";
    }

    public void setSelection(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("selectionStart must be >= 0");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("selectionEnd must be >= 0");
        }
        n2 = Math.min(this.text.length(), n2);
        n3 = Math.min(this.text.length(), n3);
        if (n3 == n2) {
            this.clearSelection();
            return;
        }
        if (n3 < n2) {
            int n4 = n3;
            n3 = n2;
            n2 = n4;
        }
        this.hasSelection = true;
        this.selectionStart = n2;
        this.cursor = n3;
    }

    public void selectAll() {
        this.setSelection(0, this.text.length());
    }

    public void clearSelection() {
        this.hasSelection = false;
    }

    public void setCursorPosition(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("cursorPosition must be >= 0");
        }
        this.clearSelection();
        this.cursor = Math.min(n2, this.text.length());
    }

    public int getCursorPosition() {
        return this.cursor;
    }

    public TextField$OnscreenKeyboard getOnscreenKeyboard() {
        return this.keyboard;
    }

    public void setOnscreenKeyboard(TextField$OnscreenKeyboard textField$OnscreenKeyboard) {
        this.keyboard = textField$OnscreenKeyboard;
    }

    public void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    @Override
    public float getPrefWidth() {
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.style.background != null) {
            f2 = Math.max(0.0f, this.style.background.d() + this.style.background.c());
            f3 = Math.max(0.0f, this.style.background.f());
        }
        if (this.style.focusedBackground != null) {
            f2 = Math.max(f2, this.style.focusedBackground.d() + this.style.focusedBackground.c());
            f3 = Math.max(f3, this.style.focusedBackground.f());
        }
        if (this.style.disabledBackground != null) {
            f2 = Math.max(f2, this.style.disabledBackground.d() + this.style.disabledBackground.c());
            f3 = Math.max(f3, this.style.disabledBackground.f());
        }
        return Math.max(f2 + this.textHeight, f3);
    }

    public void setAlignment(int n2) {
        this.textHAlign = n2;
    }

    public int getAlignment() {
        return this.textHAlign;
    }

    public void setPasswordMode(boolean bl2) {
        this.passwordMode = bl2;
        this.updateDisplayText();
    }

    public boolean isPasswordMode() {
        return this.passwordMode;
    }

    public void setPasswordCharacter(char c2) {
        this.passwordCharacter = c2;
        if (this.passwordMode) {
            this.updateDisplayText();
        }
    }

    public void setBlinkTime(float f2) {
        this.blinkTime = f2;
    }

    public void setDisabled(boolean bl2) {
        this.disabled = bl2;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    protected void moveCursor(boolean bl2, boolean bl3) {
        int n2;
        int n3 = bl2 ? this.text.length() : 0;
        int n4 = n2 = bl2 ? 0 : -1;
        while ((bl2 ? ++this.cursor < n3 : --this.cursor > n3) && bl3) {
            TextField textField = this;
            if (textField.continueCursor(textField.cursor, n2)) continue;
        }
    }

    protected boolean continueCursor(int n2, int n3) {
        n2 = this.text.charAt(n2 + n3);
        return this.isWordCharacter((char)n2);
    }
}

