/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer$ShapeType;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.b.p;
import com.badlogic.gdx.scenes.scene2d.e;
import com.badlogic.gdx.scenes.scene2d.l;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Label$LabelStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table$Debug;
import com.badlogic.gdx.scenes.scene2d.ui.Table$DebugRect;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.ui.Value$Fixed;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.aa;
import com.badlogic.gdx.scenes.scene2d.ui.ab;
import com.badlogic.gdx.scenes.scene2d.ui.ac;
import com.badlogic.gdx.scenes.scene2d.ui.y;
import com.badlogic.gdx.scenes.scene2d.ui.z;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.SnapshotArray;
import java.util.Arrays;

public class Table
extends WidgetGroup {
    public static Color debugTableColor = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static Color debugCellColor = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    public static Color debugActorColor = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    static final Pool cellPool = new y();
    private static float[] columnWeightedWidth;
    private static float[] rowWeightedHeight;
    private int columns;
    private int rows;
    private boolean implicitEndRow;
    private final Array cells = new Array(4);
    private final Cell cellDefaults;
    private final Array columnDefaults = new Array(2);
    private Cell rowDefaults;
    private boolean sizeInvalid = true;
    private float[] columnMinWidth;
    private float[] rowMinHeight;
    private float[] columnPrefWidth;
    private float[] rowPrefHeight;
    private float tableMinWidth;
    private float tableMinHeight;
    private float tablePrefWidth;
    private float tablePrefHeight;
    private float[] columnWidth;
    private float[] rowHeight;
    private float[] expandWidth;
    private float[] expandHeight;
    Value padTop = backgroundTop;
    Value padLeft = backgroundLeft;
    Value padBottom = backgroundBottom;
    Value padRight = backgroundRight;
    int align = 1;
    Table$Debug debug = Table$Debug.none;
    Array debugRects;
    k background;
    private boolean clip;
    private Skin skin;
    boolean round = true;
    public static Value backgroundTop;
    public static Value backgroundLeft;
    public static Value backgroundBottom;
    public static Value backgroundRight;

    public Table() {
        this((Skin)null);
    }

    public Table(Skin skin) {
        this.skin = skin;
        this.cellDefaults = this.obtainCell();
        this.setTransform(false);
        this.setTouchable(l.c);
    }

    private Cell obtainCell() {
        Cell cell = (Cell)cellPool.obtain();
        cell.setTable(this);
        return cell;
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(batch, this.computeTransform());
            this.drawBackground(batch, f2, 0.0f, 0.0f);
            if (this.clip) {
                batch.flush();
                float f3 = this.padLeft.get(this);
                float f4 = this.padBottom.get(this);
                if (this.clipBegin(f3, f4, this.getWidth() - f3 - this.padRight.get(this), this.getHeight() - f4 - this.padTop.get(this))) {
                    this.drawChildren(batch, f2);
                    batch.flush();
                    this.clipEnd();
                }
            } else {
                this.drawChildren(batch, f2);
            }
            this.resetTransform(batch);
            return;
        }
        this.drawBackground(batch, f2, this.getX(), this.getY());
        super.draw(batch, f2);
    }

    protected void drawBackground(Batch batch, float f2, float f3, float f4) {
        if (this.background == null) {
            return;
        }
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * f2);
        this.background.a(batch, f3, f4, this.getWidth(), this.getHeight());
    }

    public void setBackground(String string) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        Table table = this;
        table.setBackground(table.skin.getDrawable(string));
    }

    public void setBackground(k k2) {
        if (this.background == k2) {
            return;
        }
        float f2 = this.getPadTop();
        float f3 = this.getPadLeft();
        float f4 = this.getPadBottom();
        float f5 = this.getPadRight();
        this.background = k2;
        float f6 = this.getPadTop();
        float f7 = this.getPadLeft();
        float f8 = this.getPadBottom();
        float f9 = this.getPadRight();
        if (f2 + f4 != f6 + f8 || f3 + f5 != f7 + f9) {
            this.invalidateHierarchy();
            return;
        }
        if (f2 != f6 || f3 != f7 || f4 != f8 || f5 != f9) {
            ((WidgetGroup)this).invalidate();
        }
    }

    public Table background(k k2) {
        this.setBackground(k2);
        return this;
    }

    public Table background(String string) {
        this.setBackground(string);
        return this;
    }

    public k getBackground() {
        return this.background;
    }

    @Override
    public b hit(float f2, float f3, boolean bl2) {
        if (this.clip) {
            if (bl2 && this.getTouchable() == l.b) {
                return null;
            }
            if (f2 < 0.0f || f2 >= this.getWidth() || f3 < 0.0f || f3 >= this.getHeight()) {
                return null;
            }
        }
        return super.hit(f2, f3, bl2);
    }

    public Table clip() {
        this.setClip(true);
        return this;
    }

    public Table clip(boolean bl2) {
        this.setClip(bl2);
        return this;
    }

    public void setClip(boolean bl2) {
        this.clip = bl2;
        this.setTransform(bl2);
        ((WidgetGroup)this).invalidate();
    }

    public boolean getClip() {
        return this.clip;
    }

    @Override
    public void invalidate() {
        this.sizeInvalid = true;
        super.invalidate();
    }

    public Cell add(b b2) {
        Cell cell;
        block10: {
            int n2;
            cell = this.obtainCell();
            this.obtainCell().actor = b2;
            if (this.implicitEndRow) {
                this.implicitEndRow = false;
                --this.rows;
                ((Cell)this.cells.peek()).endRow = false;
            }
            if ((n2 = this.cells.size) > 0) {
                Object[] objectArray = (Object[])this.cells.peek();
                if (!objectArray.endRow) {
                    cell.column = objectArray.column + objectArray.colspan;
                    cell.row = objectArray.row;
                } else {
                    cell.column = 0;
                    cell.row = objectArray.row + 1;
                }
                if (cell.row > 0) {
                    objectArray = this.cells.items;
                    --n2;
                    while (n2 >= 0) {
                        int n3;
                        Cell cell2 = (Cell)objectArray[n2];
                        int n4 = n3 + cell2.colspan;
                        for (n3 = cell2.column; n3 < n4; ++n3) {
                            if (n3 != cell.column) continue;
                            cell.cellAboveIndex = n2;
                            break block10;
                        }
                        --n2;
                    }
                }
            } else {
                cell.column = 0;
                cell.row = 0;
            }
        }
        this.cells.add(cell);
        cell.set(this.cellDefaults);
        if (cell.column < this.columnDefaults.size) {
            cell.merge((Cell)this.columnDefaults.get(cell.column));
        }
        cell.merge(this.rowDefaults);
        if (b2 != null) {
            this.addActor(b2);
        }
        return cell;
    }

    public Table add(b ... bArray) {
        int n2 = bArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add(bArray[i2]);
        }
        return this;
    }

    public Cell add(CharSequence charSequence) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((b)new Label(charSequence, this.skin));
    }

    public Cell add(CharSequence charSequence, String string) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((b)new Label(charSequence, (Label$LabelStyle)this.skin.get(string, Label$LabelStyle.class)));
    }

    public Cell add(CharSequence charSequence, String string, Color color) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((b)new Label(charSequence, new Label$LabelStyle(this.skin.getFont(string), color)));
    }

    public Cell add(CharSequence charSequence, String string, String string2) {
        if (this.skin == null) {
            throw new IllegalStateException("Table must have a skin set to use this method.");
        }
        return this.add((b)new Label(charSequence, new Label$LabelStyle(this.skin.getFont(string), this.skin.getColor(string2))));
    }

    public Cell add() {
        return this.add((b)null);
    }

    public Cell stack(b ... bArray) {
        Stack stack = new Stack();
        if (bArray != null) {
            int n2 = bArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                stack.addActor(bArray[i2]);
            }
        }
        return this.add((b)stack);
    }

    @Override
    public boolean removeActor(b b2) {
        return ((e)this).removeActor(b2, true);
    }

    @Override
    public boolean removeActor(b object, boolean bl2) {
        if (!super.removeActor((b)object, bl2)) {
            return false;
        }
        if ((object = this.getCell((b)object)) != null) {
            ((Cell)object).actor = null;
        }
        return true;
    }

    @Override
    public b removeActorAt(int n2, boolean bl2) {
        b b2 = super.removeActorAt(n2, bl2);
        Cell cell = this.getCell(b2);
        if (cell != null) {
            cell.actor = null;
        }
        return b2;
    }

    @Override
    public void clearChildren(boolean bl2) {
        Object[] objectArray = this.cells.items;
        for (int i2 = this.cells.size - 1; i2 >= 0; --i2) {
            b b2 = ((Cell)objectArray[i2]).actor;
            if (b2 == null) continue;
            b2.remove();
        }
        cellPool.freeAll(this.cells);
        this.cells.clear();
        this.rows = 0;
        this.columns = 0;
        if (this.rowDefaults != null) {
            cellPool.free(this.rowDefaults);
        }
        this.rowDefaults = null;
        this.implicitEndRow = false;
        super.clearChildren(bl2);
    }

    public void reset() {
        this.clearChildren();
        this.padTop = backgroundTop;
        this.padLeft = backgroundLeft;
        this.padBottom = backgroundBottom;
        this.padRight = backgroundRight;
        this.align = 1;
        this.debug(Table$Debug.none);
        this.cellDefaults.reset();
        int n2 = this.columnDefaults.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Cell cell = (Cell)this.columnDefaults.get(i2);
            if (cell == null) continue;
            cellPool.free(cell);
        }
        this.columnDefaults.clear();
    }

    public Cell row() {
        if (this.cells.size > 0) {
            if (!this.implicitEndRow) {
                if (((Cell)this.cells.peek()).endRow) {
                    return this.rowDefaults;
                }
                this.endRow();
            }
            ((WidgetGroup)this).invalidate();
        }
        this.implicitEndRow = false;
        if (this.rowDefaults != null) {
            cellPool.free(this.rowDefaults);
        }
        this.rowDefaults = this.obtainCell();
        this.rowDefaults.clear();
        return this.rowDefaults;
    }

    private void endRow() {
        Object[] objectArray = this.cells.items;
        int n2 = 0;
        for (int i2 = this.cells.size - 1; i2 >= 0; --i2) {
            Cell cell = (Cell)objectArray[i2];
            if (cell.endRow) break;
            n2 += cell.colspan.intValue();
        }
        this.columns = Math.max(this.columns, n2);
        ++this.rows;
        ((Cell)this.cells.peek()).endRow = true;
    }

    public Cell columnDefaults(int n2) {
        Cell cell = this.columnDefaults.size > n2 ? (Cell)this.columnDefaults.get(n2) : null;
        if (cell == null) {
            cell = this.obtainCell();
            cell.clear();
            if (n2 >= this.columnDefaults.size) {
                for (int i2 = this.columnDefaults.size; i2 < n2; ++i2) {
                    this.columnDefaults.add(null);
                }
                this.columnDefaults.add(cell);
            } else {
                this.columnDefaults.set(n2, cell);
            }
        }
        return cell;
    }

    public Cell getCell(b b2) {
        if (b2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        Object[] objectArray = this.cells.items;
        int n2 = this.cells.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Cell cell = (Cell)objectArray[i2];
            if (cell.actor != b2) continue;
            return cell;
        }
        return null;
    }

    public Array getCells() {
        return this.cells;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float f2 = this.tablePrefWidth;
        if (this.background != null) {
            return Math.max(f2, this.background.e());
        }
        return f2;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float f2 = this.tablePrefHeight;
        if (this.background != null) {
            return Math.max(f2, this.background.f());
        }
        return f2;
    }

    @Override
    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinWidth;
    }

    @Override
    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinHeight;
    }

    public Cell defaults() {
        return this.cellDefaults;
    }

    public Table pad(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("pad cannot be null.");
        }
        this.padTop = value;
        this.padLeft = value;
        this.padBottom = value;
        this.padRight = value;
        this.sizeInvalid = true;
        return this;
    }

    public Table pad(Value value, Value value2, Value value3, Value value4) {
        if (value == null) {
            throw new IllegalArgumentException("top cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("left cannot be null.");
        }
        if (value3 == null) {
            throw new IllegalArgumentException("bottom cannot be null.");
        }
        if (value4 == null) {
            throw new IllegalArgumentException("right cannot be null.");
        }
        this.padTop = value;
        this.padLeft = value2;
        this.padBottom = value3;
        this.padRight = value4;
        this.sizeInvalid = true;
        return this;
    }

    public Table padTop(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padTop cannot be null.");
        }
        this.padTop = value;
        this.sizeInvalid = true;
        return this;
    }

    public Table padLeft(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padLeft cannot be null.");
        }
        this.padLeft = value;
        this.sizeInvalid = true;
        return this;
    }

    public Table padBottom(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padBottom cannot be null.");
        }
        this.padBottom = value;
        this.sizeInvalid = true;
        return this;
    }

    public Table padRight(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padRight cannot be null.");
        }
        this.padRight = value;
        this.sizeInvalid = true;
        return this;
    }

    public Table pad(float f2) {
        this.pad(Value$Fixed.valueOf(f2));
        return this;
    }

    public Table pad(float f2, float f3, float f4, float f5) {
        this.padTop = Value$Fixed.valueOf(f2);
        this.padLeft = Value$Fixed.valueOf(f3);
        this.padBottom = Value$Fixed.valueOf(f4);
        this.padRight = Value$Fixed.valueOf(f5);
        this.sizeInvalid = true;
        return this;
    }

    public Table padTop(float f2) {
        this.padTop = Value$Fixed.valueOf(f2);
        this.sizeInvalid = true;
        return this;
    }

    public Table padLeft(float f2) {
        this.padLeft = Value$Fixed.valueOf(f2);
        this.sizeInvalid = true;
        return this;
    }

    public Table padBottom(float f2) {
        this.padBottom = Value$Fixed.valueOf(f2);
        this.sizeInvalid = true;
        return this;
    }

    public Table padRight(float f2) {
        this.padRight = Value$Fixed.valueOf(f2);
        this.sizeInvalid = true;
        return this;
    }

    public Table align(int n2) {
        this.align = n2;
        return this;
    }

    public Table center() {
        this.align = 1;
        return this;
    }

    public Table top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return this;
    }

    public Table left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return this;
    }

    public Table bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return this;
    }

    public Table right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return this;
    }

    @Override
    public void setDebug(boolean bl2) {
        this.debug(bl2 ? Table$Debug.all : Table$Debug.none);
    }

    @Override
    public Table debug() {
        super.debug();
        return this;
    }

    @Override
    public Table debugAll() {
        super.debugAll();
        return this;
    }

    public Table debugTable() {
        super.setDebug(true);
        if (this.debug != Table$Debug.table) {
            this.debug = Table$Debug.table;
            ((WidgetGroup)this).invalidate();
        }
        return this;
    }

    public Table debugCell() {
        super.setDebug(true);
        if (this.debug != Table$Debug.cell) {
            this.debug = Table$Debug.cell;
            ((WidgetGroup)this).invalidate();
        }
        return this;
    }

    public Table debugActor() {
        super.setDebug(true);
        if (this.debug != Table$Debug.actor) {
            this.debug = Table$Debug.actor;
            ((WidgetGroup)this).invalidate();
        }
        return this;
    }

    public Table debug(Table$Debug table$Debug) {
        super.setDebug(table$Debug != Table$Debug.none);
        if (this.debug != table$Debug) {
            this.debug = table$Debug;
            if (table$Debug == Table$Debug.none) {
                this.clearDebugRects();
            } else {
                ((WidgetGroup)this).invalidate();
            }
        }
        return this;
    }

    public Table$Debug getTableDebug() {
        return this.debug;
    }

    public Value getPadTopValue() {
        return this.padTop;
    }

    public float getPadTop() {
        return this.padTop.get(this);
    }

    public Value getPadLeftValue() {
        return this.padLeft;
    }

    public float getPadLeft() {
        return this.padLeft.get(this);
    }

    public Value getPadBottomValue() {
        return this.padBottom;
    }

    public float getPadBottom() {
        return this.padBottom.get(this);
    }

    public Value getPadRightValue() {
        return this.padRight;
    }

    public float getPadRight() {
        return this.padRight.get(this);
    }

    public float getPadX() {
        return this.padLeft.get(this) + this.padRight.get(this);
    }

    public float getPadY() {
        return this.padTop.get(this) + this.padBottom.get(this);
    }

    public int getAlign() {
        return this.align;
    }

    public int getRow(float f2) {
        int n2 = this.cells.size;
        if (n2 == 0) {
            return -1;
        }
        f2 += this.getPadTop();
        Object[] objectArray = this.cells.items;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            Cell cell;
            Cell cell2 = (Cell)objectArray[n3++];
            if (cell.actorY + cell2.computedPadTop < f2) {
                return n4;
            }
            if (!cell2.endRow) continue;
            ++n4;
        }
        return -1;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public void setRound(boolean bl2) {
        this.round = bl2;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public float getRowHeight(int n2) {
        if (this.rowHeight == null) {
            return 0.0f;
        }
        return this.rowHeight[n2];
    }

    public float getRowMinHeight(int n2) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.rowMinHeight[n2];
    }

    public float getRowPrefHeight(int n2) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.rowPrefHeight[n2];
    }

    public float getColumnWidth(int n2) {
        if (this.columnWidth == null) {
            return 0.0f;
        }
        return this.columnWidth[n2];
    }

    public float getColumnMinWidth(int n2) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.columnMinWidth[n2];
    }

    public float getColumnPrefWidth(int n2) {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.columnPrefWidth[n2];
    }

    private float[] ensureSize(float[] fArray, int n2) {
        if (fArray == null || fArray.length < n2) {
            return new float[n2];
        }
        Arrays.fill(fArray, 0, n2, 0.0f);
        return fArray;
    }

    private void computeSize() {
        int n2;
        float f2;
        float f3;
        int n3;
        this.sizeInvalid = false;
        Object[] objectArray = this.cells.items;
        int n4 = this.cells.size;
        if (n4 > 0 && !((Cell)objectArray[n4 - 1]).endRow) {
            this.endRow();
            this.implicitEndRow = true;
        }
        int n5 = this.columns;
        int n6 = this.rows;
        this.columnMinWidth = this.ensureSize(this.columnMinWidth, n5);
        float[] fArray = this.columnMinWidth;
        this.rowMinHeight = this.ensureSize(this.rowMinHeight, n6);
        float[] fArray2 = this.rowMinHeight;
        this.columnPrefWidth = this.ensureSize(this.columnPrefWidth, n5);
        float[] fArray3 = this.columnPrefWidth;
        this.rowPrefHeight = this.ensureSize(this.rowPrefHeight, n6);
        float[] fArray4 = this.rowPrefHeight;
        this.columnWidth = this.ensureSize(this.columnWidth, n5);
        this.rowHeight = this.ensureSize(this.rowHeight, n6);
        this.expandWidth = this.ensureSize(this.expandWidth, n5);
        float[] fArray5 = this.expandWidth;
        this.expandHeight = this.ensureSize(this.expandHeight, n6);
        float[] fArray6 = this.expandHeight;
        float f4 = 0.0f;
        for (int i2 = 0; i2 < n4; ++i2) {
            Cell cell = (Cell)objectArray[i2];
            int n7 = cell.column;
            int n8 = cell.row;
            n3 = cell.colspan;
            b b2 = cell.actor;
            if (cell.expandY != 0 && fArray6[n8] == 0.0f) {
                fArray6[n8] = cell.expandY.intValue();
            }
            if (n3 == 1 && cell.expandX != 0 && fArray5[n7] == 0.0f) {
                fArray5[n7] = cell.expandX.intValue();
            }
            cell.computedPadLeft = cell.padLeft.get(b2) + (n7 == 0 ? 0.0f : Math.max(0.0f, cell.spaceLeft.get(b2) - f4));
            cell.computedPadTop = cell.padTop.get(b2);
            if (cell.cellAboveIndex != -1) {
                Cell cell2 = (Cell)objectArray[cell.cellAboveIndex];
                cell.computedPadTop += Math.max(0.0f, cell.spaceTop.get(b2) - cell2.spaceBottom.get(b2));
            }
            f4 = cell.spaceRight.get(b2);
            cell.computedPadRight = cell.padRight.get(b2) + (n7 + n3 == n5 ? 0.0f : f4);
            cell.computedPadBottom = cell.padBottom.get(b2) + (n8 == n6 - 1 ? 0.0f : cell.spaceBottom.get(b2));
            float f5 = cell.prefWidth.get(b2);
            float f6 = cell.prefHeight.get(b2);
            float f7 = cell.minWidth.get(b2);
            f3 = cell.minHeight.get(b2);
            f2 = cell.maxWidth.get(b2);
            float f8 = cell.maxHeight.get(b2);
            if (f5 < f7) {
                f5 = f7;
            }
            if (f6 < f3) {
                f6 = f3;
            }
            if (f2 > 0.0f && f5 > f2) {
                f5 = f2;
            }
            if (f8 > 0.0f && f6 > f8) {
                f6 = f8;
            }
            if (this.round) {
                f7 = (float)Math.ceil(f7);
                f3 = (float)Math.ceil(f3);
                f5 = (float)Math.ceil(f5);
                f6 = (float)Math.ceil(f6);
            }
            if (n3 == 1) {
                f2 = cell.computedPadLeft + cell.computedPadRight;
                fArray3[n7] = Math.max(fArray3[n7], f5 + f2);
                fArray[n7] = Math.max(fArray[n7], f7 + f2);
            }
            f2 = cell.computedPadTop + cell.computedPadBottom;
            fArray4[n8] = Math.max(fArray4[n8], f6 + f2);
            fArray2[n8] = Math.max(fArray2[n8], f3 + f2);
        }
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        for (n3 = 0; n3 < n4; ++n3) {
            int n9;
            Cell cell;
            block28: {
                cell = (Cell)objectArray[n3];
                n9 = cell.column;
                int n10 = cell.expandX;
                if (n10 != 0) {
                    int n11;
                    int n12 = n9 + cell.colspan;
                    for (n11 = n9; n11 < n12; ++n11) {
                        if (fArray5[n11] == 0.0f) {
                            continue;
                        }
                        break block28;
                    }
                    for (n11 = n9; n11 < n12; ++n11) {
                        fArray5[n11] = n10;
                    }
                }
            }
            if (cell.uniformX == Boolean.TRUE && cell.colspan == 1) {
                float f13 = cell.computedPadLeft + cell.computedPadRight;
                f9 = Math.max(f9, fArray[n9] - f13);
                f11 = Math.max(f11, fArray3[n9] - f13);
            }
            if (cell.uniformY != Boolean.TRUE) continue;
            float f14 = cell.computedPadTop + cell.computedPadBottom;
            f10 = Math.max(f10, fArray2[cell.row] - f14);
            f12 = Math.max(f12, fArray4[cell.row] - f14);
        }
        if (f11 > 0.0f || f12 > 0.0f) {
            for (n3 = 0; n3 < n4; ++n3) {
                Cell cell = (Cell)objectArray[n3];
                if (f11 > 0.0f && cell.uniformX == Boolean.TRUE && cell.colspan == 1) {
                    f4 = cell.computedPadLeft + cell.computedPadRight;
                    fArray[cell.column] = f9 + f4;
                    fArray3[cell.column] = f11 + f4;
                }
                if (!(f12 > 0.0f) || cell.uniformY != Boolean.TRUE) continue;
                f4 = cell.computedPadTop + cell.computedPadBottom;
                fArray2[cell.row] = f10 + f4;
                fArray4[cell.row] = f12 + f4;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n13;
            float f15;
            Cell cell = (Cell)objectArray[n3];
            int n14 = cell.colspan;
            if (n14 == 1) continue;
            int n15 = cell.column;
            b b3 = cell.actor;
            float f16 = cell.minWidth.get(b3);
            f3 = cell.prefWidth.get(b3);
            f2 = cell.maxWidth.get(b3);
            if (f3 < f16) {
                f3 = f16;
            }
            if (f2 > 0.0f && f3 > f2) {
                f3 = f2;
            }
            if (this.round) {
                f16 = (float)Math.ceil(f16);
                f3 = (float)Math.ceil(f3);
            }
            f2 = f15 = -(cell.computedPadLeft + cell.computedPadRight);
            float f17 = 0.0f;
            int n16 = n13 + n14;
            for (n13 = n15; n13 < n16; ++n13) {
                f15 += fArray[n13];
                f2 += fArray3[n13];
                f17 += fArray5[n13];
            }
            f9 = Math.max(0.0f, f16 - f15);
            f10 = Math.max(0.0f, f3 - f2);
            int n17 = n15;
            int n18 = n17 + n14;
            while (n17 < n18) {
                f15 = f17 == 0.0f ? 1.0f / (float)n14 : fArray5[n17] / f17;
                int n19 = n17;
                fArray[n19] = fArray[n19] + f9 * f15;
                int n20 = n17++;
                fArray3[n20] = fArray3[n20] + f10 * f15;
            }
        }
        float f18 = this.padLeft.get(this) + this.padRight.get(this);
        float f19 = this.padTop.get(this) + this.padBottom.get(this);
        this.tableMinWidth = f18;
        this.tablePrefWidth = f18;
        for (n2 = 0; n2 < n5; ++n2) {
            this.tableMinWidth += fArray[n2];
            this.tablePrefWidth += fArray3[n2];
        }
        this.tableMinHeight = f19;
        this.tablePrefHeight = f19;
        for (n2 = 0; n2 < n6; ++n2) {
            this.tableMinHeight += fArray2[n2];
            this.tablePrefHeight += Math.max(fArray2[n2], fArray4[n2]);
        }
        this.tablePrefWidth = Math.max(this.tableMinWidth, this.tablePrefWidth);
        this.tablePrefHeight = Math.max(this.tableMinHeight, this.tablePrefHeight);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void layout() {
        int n2;
        float n21;
        float i10;
        float f2;
        float n7;
        int f26;
        float[] fArray;
        int n4;
        Object[] objectArray;
        float[] fArray2;
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float f6 = this.getWidth();
        float f7 = this.getHeight();
        int n5 = this.columns;
        int n6 = this.rows;
        float[] fArray3 = this.columnWidth;
        float[] fArray4 = this.rowHeight;
        float f8 = this.padLeft.get(this);
        float f9 = f8 + this.padRight.get(this);
        float f10 = this.padTop.get(this);
        float f11 = f10 + this.padBottom.get(this);
        float f12 = this.tablePrefWidth - this.tableMinWidth;
        if (f12 == 0.0f) {
            fArray2 = this.columnMinWidth;
        } else {
            float f13 = Math.min(f12, Math.max(0.0f, f6 - this.tableMinWidth));
            columnWeightedWidth = this.ensureSize(columnWeightedWidth, n5);
            fArray2 = columnWeightedWidth;
            float[] fArray5 = this.columnMinWidth;
            objectArray = this.columnPrefWidth;
            for (n4 = 0; n4 < n5; ++n4) {
                reference var18_33 = (objectArray[n4] - fArray5[n4]) / f12;
                fArray2[n4] = fArray5[n4] + f13 * var18_33;
            }
        }
        float f14 = this.tablePrefHeight - this.tableMinHeight;
        if (f14 == 0.0f) {
            fArray = this.rowMinHeight;
        } else {
            void cell;
            rowWeightedHeight = this.ensureSize(rowWeightedHeight, n6);
            fArray = rowWeightedHeight;
            float f15 = Math.min(f14, Math.max(0.0f, f7 - this.tableMinHeight));
            float[] fArray6 = this.rowMinHeight;
            float[] i3 = this.rowPrefHeight;
            boolean i2 = false;
            while (cell < n6) {
                float n9 = (i3[cell] - fArray6[cell]) / f14;
                fArray[cell] = fArray6[cell] + f15 * n9;
                ++cell;
            }
        }
        objectArray = this.cells.items;
        n4 = this.cells.size;
        for (int fArray8 = 0; fArray8 < n4; ++fArray8) {
            int n17;
            Cell fArray9 = (Cell)objectArray[fArray8];
            int n8 = fArray9.column;
            int i4 = fArray9.row;
            b b2 = fArray9.actor;
            float n11 = 0.0f;
            f26 = fArray9.colspan;
            int n19 = n17 + f26;
            for (n17 = n8; n17 < n19; ++n17) {
                n11 += fArray2[n17];
            }
            n7 = fArray[i4];
            float n10 = fArray9.prefWidth.get(b2);
            f2 = fArray9.prefHeight.get(b2);
            float i9 = fArray9.minWidth.get(b2);
            float cell = fArray9.minHeight.get(b2);
            i10 = fArray9.maxWidth.get(b2);
            n21 = fArray9.maxHeight.get(b2);
            if (n10 < i9) {
                n10 = i9;
            }
            if (f2 < cell) {
                f2 = cell;
            }
            if (i10 > 0.0f && n10 > i10) {
                n10 = i10;
            }
            if (n21 > 0.0f && f2 > n21) {
                f2 = n21;
            }
            fArray9.actorWidth = Math.min(n11 - fArray9.computedPadLeft - fArray9.computedPadRight, n10);
            fArray9.actorHeight = Math.min(n7 - fArray9.computedPadTop - fArray9.computedPadBottom, f2);
            if (f26 == 1) {
                fArray3[n8] = Math.max(fArray3[n8], n11);
            }
            fArray4[i4] = Math.max(fArray4[i4], n7);
        }
        float[] fArray5 = this.expandWidth;
        float[] fArray6 = this.expandHeight;
        f12 = 0.0f;
        for (int f21 = 0; f21 < n5; ++f21) {
            f12 += fArray5[f21];
        }
        if (f12 > 0.0f) {
            float i6 = f6 - f9;
            for (int i5 = 0; i5 < n5; ++i5) {
                i6 -= fArray3[i5];
            }
            if (i6 > 0.0f) {
                float f22 = 0.0f;
                int n3 = 0;
                for (f26 = 0; f26 < n5; ++f26) {
                    if (fArray5[f26] == 0.0f) continue;
                    n7 = i6 * fArray5[f26] / f12;
                    int n8 = f26;
                    fArray3[n8] = fArray3[n8] + n7;
                    f22 += n7;
                    n3 = f26;
                }
                int n9 = n3;
                fArray3[n9] = fArray3[n9] + (i6 - f22);
            }
        }
        f12 = 0.0f;
        for (int f23 = 0; f23 < n6; ++f23) {
            f12 += fArray6[f23];
        }
        if (f12 > 0.0f) {
            float i8 = f7 - f11;
            for (int i7 = 0; i7 < n6; ++i7) {
                i8 -= fArray4[i7];
            }
            if (i8 > 0.0f) {
                float f24 = 0.0f;
                int n18 = 0;
                for (f26 = 0; f26 < n6; ++f26) {
                    if (fArray6[f26] == 0.0f) continue;
                    n7 = i8 * fArray6[f26] / f12;
                    int n10 = f26;
                    fArray4[n10] = fArray4[n10] + n7;
                    f24 += n7;
                    n18 = f26;
                }
                int n11 = n18;
                fArray4[n11] = fArray4[n11] + (i8 - f24);
            }
        }
        for (int f27 = 0; f27 < n4; ++f27) {
            float f3;
            int f30;
            Cell cell = (Cell)objectArray[f27];
            int n22 = cell.colspan;
            if (n22 == 1) continue;
            float f29 = 0.0f;
            int f31 = f30 + n22;
            for (f30 = cell.column; f30 < f31; ++f30) {
                f29 += fArray2[f30] - fArray3[f30];
            }
            f29 = (f29 - Math.max(0.0f, cell.computedPadLeft + cell.computedPadRight)) / (float)n22;
            if (!(f3 > 0.0f)) continue;
            f30 = cell.column;
            f31 = f30 + n22;
            while (f30 < f31) {
                int n12 = f30++;
                fArray3[n12] = fArray3[n12] + f29;
            }
        }
        float f4 = f9;
        float f28 = f11;
        for (n2 = 0; n2 < n5; ++n2) {
            f4 += fArray3[n2];
        }
        for (n2 = 0; n2 < n6; ++n2) {
            f28 += fArray4[n2];
        }
        n2 = this.align;
        float f5 = f8;
        if ((n2 & 0x10) != 0) {
            f5 += f6 - f4;
        } else if ((n2 & 8) == 0) {
            f5 += (f6 - f4) / 2.0f;
        }
        float f13 = f10;
        if ((n2 & 4) != 0) {
            f13 += f7 - f28;
        } else if ((n2 & 2) == 0) {
            f13 += (f7 - f28) / 2.0f;
        }
        float f15 = f5;
        f2 = f13;
        for (int snapshotArray = 0; snapshotArray < n4; ++snapshotArray) {
            int n23;
            Cell bArray = (Cell)objectArray[snapshotArray];
            i10 = 0.0f;
            int n22 = n23 + bArray.colspan;
            for (n23 = bArray.column; n23 < n22; ++n23) {
                i10 += fArray3[n23];
            }
            i10 -= bArray.computedPadLeft + bArray.computedPadRight;
            f15 += bArray.computedPadLeft;
            n21 = bArray.fillX.floatValue();
            f6 = bArray.fillY.floatValue();
            if (n21 > 0.0f) {
                float f16;
                bArray.actorWidth = Math.max(i10 * n21, bArray.minWidth.get(bArray.actor));
                float f33 = bArray.maxWidth.get(bArray.actor);
                if (f16 > 0.0f) {
                    bArray.actorWidth = Math.min(bArray.actorWidth, f33);
                }
            }
            if (f6 > 0.0f) {
                float f17;
                bArray.actorHeight = Math.max(fArray4[bArray.row] * f6 - bArray.computedPadTop - bArray.computedPadBottom, bArray.minHeight.get(bArray.actor));
                float f35 = bArray.maxHeight.get(bArray.actor);
                if (f17 > 0.0f) {
                    bArray.actorHeight = Math.min(bArray.actorHeight, f35);
                }
            }
            bArray.actorX = ((n2 = bArray.align.intValue()) & 8) != 0 ? f15 : ((n2 & 0x10) != 0 ? f15 + i10 - bArray.actorWidth : f15 + (i10 - bArray.actorWidth) / 2.0f);
            bArray.actorY = (n2 & 2) != 0 ? bArray.computedPadTop : ((n2 & 4) != 0 ? fArray4[bArray.row] - bArray.actorHeight - bArray.computedPadBottom : (fArray4[bArray.row] - bArray.actorHeight + bArray.computedPadTop - bArray.computedPadBottom) / 2.0f);
            bArray.actorY = f7 - f2 - bArray.actorY - bArray.actorHeight;
            if (this.round) {
                bArray.actorWidth = (float)Math.ceil(bArray.actorWidth);
                bArray.actorHeight = (float)Math.ceil(bArray.actorHeight);
                bArray.actorX = (float)Math.floor(bArray.actorX);
                bArray.actorY = (float)Math.floor(bArray.actorY);
            }
            if (bArray.actor != null) {
                bArray.actor.setBounds(bArray.actorX, bArray.actorY, bArray.actorWidth, bArray.actorHeight);
            }
            if (bArray.endRow) {
                f15 = f5;
                f2 += fArray4[bArray.row];
                continue;
            }
            f15 += i10 + bArray.computedPadRight;
        }
        SnapshotArray snapshotArray = this.getChildren();
        b[] bArray = (b[])snapshotArray.items;
        int n13 = snapshotArray.size;
        for (int i2 = 0; i2 < n13; ++i2) {
            b b3 = bArray[i2];
            if (!(b3 instanceof p)) continue;
            ((p)((Object)b3)).validate();
        }
        if (this.debug != Table$Debug.none) {
            this.addDebugRects(f5, f13, f4 - f9, f28 - f11);
        }
    }

    private void addDebugRects(float f2, float f3, float f4, float f5) {
        this.clearDebugRects();
        if (this.debug == Table$Debug.table || this.debug == Table$Debug.all) {
            this.addDebugRect(0.0f, 0.0f, this.getWidth(), this.getHeight(), debugTableColor);
            this.addDebugRect(f2, this.getHeight() - f3, f4, -f5, debugTableColor);
        }
        f4 = f2;
        int n2 = this.cells.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            Cell cell = (Cell)this.cells.get(i2);
            if (this.debug == Table$Debug.actor || this.debug == Table$Debug.all) {
                this.addDebugRect(cell.actorX, cell.actorY, cell.actorWidth, cell.actorHeight, debugActorColor);
            }
            float f6 = 0.0f;
            int n4 = n3 + cell.colspan;
            for (n3 = cell.column; n3 < n4; ++n3) {
                f6 += this.columnWidth[n3];
            }
            f6 -= cell.computedPadLeft + cell.computedPadRight;
            f2 += cell.computedPadLeft;
            if (this.debug == Table$Debug.cell || this.debug == Table$Debug.all) {
                float f7 = this.rowHeight[cell.row] - cell.computedPadTop - cell.computedPadBottom;
                float f8 = f3 + cell.computedPadTop;
                this.addDebugRect(f2, this.getHeight() - f8, f6, -f7, debugCellColor);
            }
            if (cell.endRow) {
                f2 = f4;
                f3 += this.rowHeight[cell.row];
                continue;
            }
            f2 += f6 + cell.computedPadRight;
        }
    }

    private void clearDebugRects() {
        if (this.debugRects == null) {
            this.debugRects = new Array();
        }
        Table$DebugRect.pool.freeAll(this.debugRects);
        this.debugRects.clear();
    }

    private void addDebugRect(float f2, float f3, float f4, float f5, Color color) {
        Table$DebugRect table$DebugRect = (Table$DebugRect)Table$DebugRect.pool.obtain();
        ((Table$DebugRect)Table$DebugRect.pool.obtain()).color = color;
        table$DebugRect.set(f2, f3, f4, f5);
        this.debugRects.add(table$DebugRect);
    }

    @Override
    public void drawDebug(ShapeRenderer shapeRenderer) {
        if (this.isTransform()) {
            this.applyTransform(shapeRenderer, this.computeTransform());
            this.drawDebugRects(shapeRenderer);
            if (this.clip) {
                shapeRenderer.flush();
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = this.getWidth();
                float f5 = this.getHeight();
                if (this.background != null) {
                    f2 = this.padLeft.get(this);
                    f3 = this.padBottom.get(this);
                    f4 -= f2 + this.padRight.get(this);
                    f5 -= f3 + this.padTop.get(this);
                }
                if (this.clipBegin(f2, f3, f4, f5)) {
                    this.drawDebugChildren(shapeRenderer);
                    this.clipEnd();
                }
            } else {
                this.drawDebugChildren(shapeRenderer);
            }
            this.resetTransform(shapeRenderer);
            return;
        }
        this.drawDebugRects(shapeRenderer);
        super.drawDebug(shapeRenderer);
    }

    @Override
    protected void drawDebugBounds(ShapeRenderer shapeRenderer) {
    }

    private void drawDebugRects(ShapeRenderer shapeRenderer) {
        if (this.debugRects == null || !this.getDebug()) {
            return;
        }
        shapeRenderer.set(ShapeRenderer$ShapeType.Line);
        if (this.getStage() != null) {
            shapeRenderer.setColor(this.getStage().l());
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (!this.isTransform()) {
            f2 = this.getX();
            f3 = this.getY();
        }
        int n2 = this.debugRects.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Table$DebugRect table$DebugRect = (Table$DebugRect)this.debugRects.get(i2);
            shapeRenderer.setColor(table$DebugRect.color);
            shapeRenderer.rect(f2 + table$DebugRect.x, f3 + table$DebugRect.y, table$DebugRect.width, table$DebugRect.height);
        }
    }

    public Skin getSkin() {
        return this.skin;
    }

    static {
        backgroundTop = new z();
        backgroundLeft = new aa();
        backgroundBottom = new ab();
        backgroundRight = new ac();
    }
}

