/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.p;
import com.badlogic.gdx.scenes.scene2d.l;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.SnapshotArray;

public class Stack
extends WidgetGroup {
    private float prefWidth;
    private float prefHeight;
    private float minWidth;
    private float minHeight;
    private float maxWidth;
    private float maxHeight;
    private boolean sizeInvalid = true;

    public Stack() {
        this.setTransform(false);
        this.setWidth(150.0f);
        this.setHeight(150.0f);
        this.setTouchable(l.c);
    }

    public Stack(b ... bArray) {
        this();
        for (b b2 : bArray) {
            this.addActor(b2);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    private void computeSize() {
        this.sizeInvalid = false;
        this.prefWidth = 0.0f;
        this.prefHeight = 0.0f;
        this.minWidth = 0.0f;
        this.minHeight = 0.0f;
        this.maxWidth = 0.0f;
        this.maxHeight = 0.0f;
        SnapshotArray snapshotArray = this.getChildren();
        int n2 = snapshotArray.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2;
            float f3;
            b b2 = (b)snapshotArray.get(i2);
            if (b2 instanceof p) {
                p p2 = (p)((Object)b2);
                this.prefWidth = Math.max(this.prefWidth, p2.getPrefWidth());
                this.prefHeight = Math.max(this.prefHeight, p2.getPrefHeight());
                this.minWidth = Math.max(this.minWidth, p2.getMinWidth());
                this.minHeight = Math.max(this.minHeight, p2.getMinHeight());
                f3 = p2.getMaxWidth();
                f2 = p2.getMaxHeight();
            } else {
                this.prefWidth = Math.max(this.prefWidth, b2.getWidth());
                this.prefHeight = Math.max(this.prefHeight, b2.getHeight());
                this.minWidth = Math.max(this.minWidth, b2.getWidth());
                this.minHeight = Math.max(this.minHeight, b2.getHeight());
                f3 = 0.0f;
                f2 = 0.0f;
            }
            if (f3 > 0.0f) {
                float f4 = this.maxWidth = this.maxWidth == 0.0f ? f3 : Math.min(this.maxWidth, f3);
            }
            if (!(f2 > 0.0f)) continue;
            this.maxHeight = this.maxHeight == 0.0f ? f2 : Math.min(this.maxHeight, f2);
        }
    }

    public void add(b b2) {
        this.addActor(b2);
    }

    @Override
    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        SnapshotArray snapshotArray = this.getChildren();
        int n2 = snapshotArray.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            b b2 = (b)snapshotArray.get(i2);
            b2.setBounds(0.0f, 0.0f, f2, f3);
            if (!(b2 instanceof p)) continue;
            ((p)((Object)b2)).validate();
        }
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    @Override
    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.minWidth;
    }

    @Override
    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.minHeight;
    }

    @Override
    public float getMaxWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.maxWidth;
    }

    @Override
    public float getMaxHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.maxHeight;
    }
}

