/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.b.p;
import com.badlogic.gdx.scenes.scene2d.b.r;
import com.badlogic.gdx.scenes.scene2d.j;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane$SplitPaneStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Styleable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.x;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class SplitPane
extends WidgetGroup
implements Styleable {
    SplitPane$SplitPaneStyle style;
    private b firstWidget;
    private b secondWidget;
    boolean vertical;
    float splitAmount = 0.5f;
    float minAmount;
    float maxAmount = 1.0f;
    private final Rectangle firstWidgetBounds = new Rectangle();
    private final Rectangle secondWidgetBounds = new Rectangle();
    final Rectangle handleBounds = new Rectangle();
    boolean cursorOverHandle;
    private final Rectangle tempScissors = new Rectangle();
    Vector2 lastPoint = new Vector2();
    Vector2 handlePosition = new Vector2();

    public SplitPane(b b2, b b3, boolean bl2, Skin skin) {
        this(b2, b3, bl2, skin, "default-" + (bl2 ? "vertical" : "horizontal"));
    }

    public SplitPane(b b2, b b3, boolean bl2, Skin skin, String string) {
        this(b2, b3, bl2, (SplitPane$SplitPaneStyle)skin.get(string, SplitPane$SplitPaneStyle.class));
    }

    public SplitPane(b b2, b b3, boolean bl2, SplitPane$SplitPaneStyle splitPane$SplitPaneStyle) {
        this.vertical = bl2;
        this.setStyle(splitPane$SplitPaneStyle);
        this.setFirstWidget(b2);
        this.setSecondWidget(b3);
        SplitPane splitPane = this;
        splitPane.setSize(((WidgetGroup)splitPane).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
        this.initialize();
    }

    private void initialize() {
        this.addListener(new x(this));
    }

    public void setStyle(SplitPane$SplitPaneStyle splitPane$SplitPaneStyle) {
        this.style = splitPane$SplitPaneStyle;
        this.invalidateHierarchy();
    }

    @Override
    public SplitPane$SplitPaneStyle getStyle() {
        return this.style;
    }

    @Override
    public void layout() {
        Object object;
        this.clampSplitAmount();
        if (!this.vertical) {
            this.calculateHorizBoundsAndPositions();
        } else {
            this.calculateVertBoundsAndPositions();
        }
        Object object2 = this.firstWidget;
        if (object2 != null) {
            object = this.firstWidgetBounds;
            ((b)object2).setBounds(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            if (object2 instanceof p) {
                ((p)object2).validate();
            }
        }
        if ((object = this.secondWidget) != null) {
            object2 = this.secondWidgetBounds;
            ((b)object).setBounds(((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height);
            if (object instanceof p) {
                ((p)object).validate();
            }
        }
    }

    @Override
    public float getPrefWidth() {
        float f2;
        float f3;
        float f4 = this.firstWidget == null ? 0.0f : (f3 = this.firstWidget instanceof p ? ((p)((Object)this.firstWidget)).getPrefWidth() : this.firstWidget.getWidth());
        float f5 = this.secondWidget == null ? 0.0f : (f2 = this.secondWidget instanceof p ? ((p)((Object)this.secondWidget)).getPrefWidth() : this.secondWidget.getWidth());
        if (this.vertical) {
            return Math.max(f3, f2);
        }
        return f3 + this.style.handle.e() + f2;
    }

    @Override
    public float getPrefHeight() {
        float f2;
        float f3;
        float f4 = this.firstWidget == null ? 0.0f : (f3 = this.firstWidget instanceof p ? ((p)((Object)this.firstWidget)).getPrefHeight() : this.firstWidget.getHeight());
        float f5 = this.secondWidget == null ? 0.0f : (f2 = this.secondWidget instanceof p ? ((p)((Object)this.secondWidget)).getPrefHeight() : this.secondWidget.getHeight());
        if (!this.vertical) {
            return Math.max(f3, f2);
        }
        return f3 + this.style.handle.f() + f2;
    }

    @Override
    public float getMinWidth() {
        float f2;
        float f3 = this.firstWidget instanceof p ? ((p)((Object)this.firstWidget)).getMinWidth() : 0.0f;
        float f4 = f2 = this.secondWidget instanceof p ? ((p)((Object)this.secondWidget)).getMinWidth() : 0.0f;
        if (this.vertical) {
            return Math.max(f3, f2);
        }
        return f3 + this.style.handle.e() + f2;
    }

    @Override
    public float getMinHeight() {
        float f2;
        float f3 = this.firstWidget instanceof p ? ((p)((Object)this.firstWidget)).getMinHeight() : 0.0f;
        float f4 = f2 = this.secondWidget instanceof p ? ((p)((Object)this.secondWidget)).getMinHeight() : 0.0f;
        if (!this.vertical) {
            return Math.max(f3, f2);
        }
        return f3 + this.style.handle.f() + f2;
    }

    public void setVertical(boolean bl2) {
        if (this.vertical == bl2) {
            return;
        }
        this.vertical = bl2;
        this.invalidateHierarchy();
    }

    public boolean isVertical() {
        return this.vertical;
    }

    private void calculateHorizBoundsAndPositions() {
        k k2 = this.style.handle;
        float f2 = this.getHeight();
        float f3 = this.getWidth() - k2.e();
        float f4 = (int)(f3 * this.splitAmount);
        float f5 = k2.e();
        this.firstWidgetBounds.set(0.0f, 0.0f, f4, f2);
        this.secondWidgetBounds.set(f4 + f5, 0.0f, f3 -= f4, f2);
        this.handleBounds.set(f4, 0.0f, f5, f2);
    }

    private void calculateVertBoundsAndPositions() {
        k k2 = this.style.handle;
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        float f4 = f3 - k2.f();
        float f5 = (int)(f4 * this.splitAmount);
        float f6 = k2.f();
        this.firstWidgetBounds.set(0.0f, f3 - f5, f2, f5);
        this.secondWidgetBounds.set(0.0f, 0.0f, f2, f4 -= f5);
        this.handleBounds.set(0.0f, f4, f2, f6);
    }

    @Override
    public void draw(Batch batch, float f2) {
        j j2 = this.getStage();
        if (j2 == null) {
            return;
        }
        this.validate();
        Color color = this.getColor();
        f2 = color.a * f2;
        this.applyTransform(batch, this.computeTransform());
        if (this.firstWidget != null && this.firstWidget.isVisible()) {
            batch.flush();
            j2.a(this.firstWidgetBounds, this.tempScissors);
            if (r.a(this.tempScissors)) {
                this.firstWidget.draw(batch, f2);
                batch.flush();
                r.a();
            }
        }
        if (this.secondWidget != null && this.secondWidget.isVisible()) {
            batch.flush();
            j2.a(this.secondWidgetBounds, this.tempScissors);
            if (r.a(this.tempScissors)) {
                this.secondWidget.draw(batch, f2);
                batch.flush();
                r.a();
            }
        }
        batch.setColor(color.r, color.g, color.b, f2);
        this.style.handle.a(batch, this.handleBounds.x, this.handleBounds.y, this.handleBounds.width, this.handleBounds.height);
        this.resetTransform(batch);
    }

    public void setSplitAmount(float f2) {
        this.splitAmount = f2;
        this.invalidate();
    }

    public float getSplitAmount() {
        return this.splitAmount;
    }

    protected void clampSplitAmount() {
        float f2 = this.minAmount;
        float f3 = this.maxAmount;
        if (this.vertical) {
            float f4 = this.getHeight() - this.style.handle.f();
            if (this.firstWidget instanceof p) {
                f2 = Math.max(f2, Math.min(((p)((Object)this.firstWidget)).getMinHeight() / f4, 1.0f));
            }
            if (this.secondWidget instanceof p) {
                f3 = Math.min(f3, 1.0f - Math.min(((p)((Object)this.secondWidget)).getMinHeight() / f4, 1.0f));
            }
        } else {
            float f5 = this.getWidth() - this.style.handle.e();
            if (this.firstWidget instanceof p) {
                f2 = Math.max(f2, Math.min(((p)((Object)this.firstWidget)).getMinWidth() / f5, 1.0f));
            }
            if (this.secondWidget instanceof p) {
                f3 = Math.min(f3, 1.0f - Math.min(((p)((Object)this.secondWidget)).getMinWidth() / f5, 1.0f));
            }
        }
        if (f2 > f3) {
            this.splitAmount = 0.5f * (f2 + f3);
            return;
        }
        this.splitAmount = Math.max(Math.min(this.splitAmount, f3), f2);
    }

    public float getMinSplitAmount() {
        return this.minAmount;
    }

    public void setMinSplitAmount(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new GdxRuntimeException("minAmount has to be >= 0 and <= 1");
        }
        this.minAmount = f2;
    }

    public float getMaxSplitAmount() {
        return this.maxAmount;
    }

    public void setMaxSplitAmount(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new GdxRuntimeException("maxAmount has to be >= 0 and <= 1");
        }
        this.maxAmount = f2;
    }

    public void setFirstWidget(b b2) {
        if (this.firstWidget != null) {
            SplitPane splitPane = this;
            super.removeActor(splitPane.firstWidget);
        }
        this.firstWidget = b2;
        if (b2 != null) {
            super.addActor(b2);
        }
        this.invalidate();
    }

    public void setSecondWidget(b b2) {
        if (this.secondWidget != null) {
            SplitPane splitPane = this;
            super.removeActor(splitPane.secondWidget);
        }
        this.secondWidget = b2;
        if (b2 != null) {
            super.addActor(b2);
        }
        this.invalidate();
    }

    @Override
    public void addActor(b b2) {
        throw new UnsupportedOperationException("Use SplitPane#setWidget.");
    }

    @Override
    public void addActorAt(int n2, b b2) {
        throw new UnsupportedOperationException("Use SplitPane#setWidget.");
    }

    @Override
    public void addActorBefore(b b2, b b3) {
        throw new UnsupportedOperationException("Use SplitPane#setWidget.");
    }

    @Override
    public boolean removeActor(b b2) {
        if (b2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (b2 == this.firstWidget) {
            this.setFirstWidget(null);
            return true;
        }
        if (b2 == this.secondWidget) {
            this.setSecondWidget(null);
            return true;
        }
        return true;
    }

    @Override
    public boolean removeActor(b b2, boolean bl2) {
        if (b2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (b2 == this.firstWidget) {
            super.removeActor(b2, bl2);
            this.firstWidget = null;
            this.invalidate();
            return true;
        }
        if (b2 == this.secondWidget) {
            super.removeActor(b2, bl2);
            this.secondWidget = null;
            this.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public b removeActorAt(int n2, boolean bl2) {
        b b2 = super.removeActorAt(n2, bl2);
        if (b2 == this.firstWidget) {
            super.removeActor(b2, bl2);
            this.firstWidget = null;
            this.invalidate();
        } else if (b2 == this.secondWidget) {
            super.removeActor(b2, bl2);
            this.secondWidget = null;
            this.invalidate();
        }
        return b2;
    }

    public boolean isCursorOverHandle() {
        return this.cursorOverHandle;
    }
}

