/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider$SliderStyle;
import com.badlogic.gdx.scenes.scene2d.ui.w;

public class Slider
extends ProgressBar {
    int button = -1;
    int draggingPointer = -1;
    boolean mouseOver;
    private Interpolation visualInterpolationInverse = Interpolation.linear;
    private float[] snapValues;
    private float threshold;

    public Slider(float f2, float f3, float f4, boolean bl2, Skin skin) {
        this(f2, f3, f4, bl2, (Slider$SliderStyle)skin.get("default-" + (bl2 ? "vertical" : "horizontal"), Slider$SliderStyle.class));
    }

    public Slider(float f2, float f3, float f4, boolean bl2, Skin skin, String string) {
        this(f2, f3, f4, bl2, (Slider$SliderStyle)skin.get(string, Slider$SliderStyle.class));
    }

    public Slider(float f2, float f3, float f4, boolean bl2, Slider$SliderStyle slider$SliderStyle) {
        super(f2, f3, f4, bl2, slider$SliderStyle);
        this.addListener(new w(this));
    }

    @Override
    public Slider$SliderStyle getStyle() {
        return (Slider$SliderStyle)super.getStyle();
    }

    public boolean isOver() {
        return this.mouseOver;
    }

    @Override
    protected k getBackgroundDrawable() {
        Slider$SliderStyle slider$SliderStyle = (Slider$SliderStyle)super.getStyle();
        if (this.disabled && slider$SliderStyle.disabledBackground != null) {
            return slider$SliderStyle.disabledBackground;
        }
        if (this.isDragging() && slider$SliderStyle.backgroundDown != null) {
            return slider$SliderStyle.backgroundDown;
        }
        if (this.mouseOver && slider$SliderStyle.backgroundOver != null) {
            return slider$SliderStyle.backgroundOver;
        }
        return slider$SliderStyle.background;
    }

    @Override
    protected k getKnobDrawable() {
        Slider$SliderStyle slider$SliderStyle = (Slider$SliderStyle)super.getStyle();
        if (this.disabled && slider$SliderStyle.disabledKnob != null) {
            return slider$SliderStyle.disabledKnob;
        }
        if (this.isDragging() && slider$SliderStyle.knobDown != null) {
            return slider$SliderStyle.knobDown;
        }
        if (this.mouseOver && slider$SliderStyle.knobOver != null) {
            return slider$SliderStyle.knobOver;
        }
        return slider$SliderStyle.knob;
    }

    @Override
    protected k getKnobBeforeDrawable() {
        Slider$SliderStyle slider$SliderStyle = (Slider$SliderStyle)super.getStyle();
        if (this.disabled && slider$SliderStyle.disabledKnobBefore != null) {
            return slider$SliderStyle.disabledKnobBefore;
        }
        if (this.isDragging() && slider$SliderStyle.knobBeforeDown != null) {
            return slider$SliderStyle.knobBeforeDown;
        }
        if (this.mouseOver && slider$SliderStyle.knobBeforeOver != null) {
            return slider$SliderStyle.knobBeforeOver;
        }
        return slider$SliderStyle.knobBefore;
    }

    @Override
    protected k getKnobAfterDrawable() {
        Slider$SliderStyle slider$SliderStyle = (Slider$SliderStyle)super.getStyle();
        if (this.disabled && slider$SliderStyle.disabledKnobAfter != null) {
            return slider$SliderStyle.disabledKnobAfter;
        }
        if (this.isDragging() && slider$SliderStyle.knobAfterDown != null) {
            return slider$SliderStyle.knobAfterDown;
        }
        if (this.mouseOver && slider$SliderStyle.knobAfterOver != null) {
            return slider$SliderStyle.knobAfterOver;
        }
        return slider$SliderStyle.knobAfter;
    }

    boolean calculatePositionAndValue(float f2, float f3) {
        float f4;
        float f5;
        k k2 = this.getStyle().knob;
        k k3 = this.getBackgroundDrawable();
        float f6 = this.position;
        float f7 = this.getMinValue();
        float f8 = this.getMaxValue();
        if (this.vertical) {
            f5 = this.getHeight() - k3.c() - k3.d();
            f4 = k2 == null ? 0.0f : k2.f();
            this.position = f3 - k3.d() - f4 * 0.5f;
            f2 = f7 + (f8 - f7) * this.visualInterpolationInverse.apply(this.position / (f5 - f4));
            this.position = Math.max(Math.min(0.0f, k3.d()), this.position);
            this.position = Math.min(f5 - f4, this.position);
        } else {
            f5 = this.getWidth() - k3.a() - k3.b();
            f4 = k2 == null ? 0.0f : k2.e();
            this.position = f2 - k3.a() - f4 * 0.5f;
            f2 = f7 + (f8 - f7) * this.visualInterpolationInverse.apply(this.position / (f5 - f4));
            this.position = Math.max(Math.min(0.0f, k3.a()), this.position);
            this.position = Math.min(f5 - f4, this.position);
        }
        f5 = f2;
        if (!Gdx.d.a(59) && !Gdx.d.a(60)) {
            f2 = this.snap(f2);
        }
        boolean bl2 = this.setValue(f2);
        if (f2 == f5) {
            this.position = f6;
        }
        return bl2;
    }

    protected float snap(float f2) {
        if (this.snapValues == null || this.snapValues.length == 0) {
            return f2;
        }
        float f3 = -1.0f;
        float f4 = 0.0f;
        for (int i2 = 0; i2 < this.snapValues.length; ++i2) {
            float f5;
            float f6 = this.snapValues[i2];
            float f7 = Math.abs(f2 - f6);
            if (!(f5 <= this.threshold) || f3 != -1.0f && !(f7 < f3)) continue;
            f3 = f7;
            f4 = f6;
        }
        if (f3 == -1.0f) {
            return f2;
        }
        return f4;
    }

    public void setSnapToValues(float f2, float ... fArray) {
        if (fArray != null && fArray.length == 0) {
            throw new IllegalArgumentException("values cannot be empty.");
        }
        this.snapValues = fArray;
        this.threshold = f2;
    }

    public void setSnapToValues(float[] fArray, float f2) {
        this.setSnapToValues(f2, fArray);
    }

    public float[] getSnapToValues() {
        return this.snapValues;
    }

    public float getSnapToValuesThreshold() {
        return this.threshold;
    }

    public boolean isDragging() {
        return this.draggingPointer != -1;
    }

    public void setButton(int n2) {
        this.button = n2;
    }

    public void setVisualInterpolationInverse(Interpolation interpolation) {
        this.visualInterpolationInverse = interpolation;
    }

    public void setVisualPercent(float f2) {
        Slider slider = this;
        slider.setValue(slider.min + (this.max - this.min) * this.visualInterpolationInverse.apply(f2));
    }
}

