/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.a;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.d;
import com.badlogic.gdx.scenes.scene2d.b.h;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.j;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.List$ListStyle;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane$ScrollPaneStyle;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox$SelectBoxScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox$SelectBoxStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Styleable;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.ui.l;
import com.badlogic.gdx.scenes.scene2d.ui.m;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.OrderedSet;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class SelectBox
extends Widget
implements Styleable {
    static final Vector2 temp = new Vector2();
    SelectBox$SelectBoxStyle style;
    final Array items = new Array();
    SelectBox$SelectBoxScrollPane scrollPane;
    private float prefWidth;
    private float prefHeight;
    private h clickListener;
    boolean disabled;
    private int alignment = 8;
    boolean selectedPrefWidth;
    final d selection;

    public SelectBox(Skin skin) {
        this((SelectBox$SelectBoxStyle)skin.get(SelectBox$SelectBoxStyle.class));
    }

    public SelectBox(Skin skin, String string) {
        this((SelectBox$SelectBoxStyle)skin.get(string, SelectBox$SelectBoxStyle.class));
    }

    public SelectBox(SelectBox$SelectBoxStyle selectBox$SelectBoxStyle) {
        SelectBox selectBox = this;
        this.selection = new l(selectBox, selectBox.items);
        this.setStyle(selectBox$SelectBoxStyle);
        SelectBox selectBox2 = this;
        selectBox2.setSize(((Widget)selectBox2).getPrefWidth(), ((Widget)this).getPrefHeight());
        this.selection.a(this);
        this.selection.q();
        this.scrollPane = this.newScrollPane();
        this.clickListener = new m(this);
        this.addListener(this.clickListener);
    }

    protected SelectBox$SelectBoxScrollPane newScrollPane() {
        return new SelectBox$SelectBoxScrollPane(this);
    }

    public void setMaxListCount(int n2) {
        this.scrollPane.maxListCount = n2;
    }

    public int getMaxListCount() {
        return this.scrollPane.maxListCount;
    }

    @Override
    protected void setStage(j j2) {
        if (j2 == null) {
            this.scrollPane.hide();
        }
        super.setStage(j2);
    }

    public void setStyle(SelectBox$SelectBoxStyle selectBox$SelectBoxStyle) {
        if (selectBox$SelectBoxStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = selectBox$SelectBoxStyle;
        if (this.scrollPane != null) {
            this.scrollPane.setStyle(selectBox$SelectBoxStyle.scrollStyle);
            this.scrollPane.list.setStyle(selectBox$SelectBoxStyle.listStyle);
        }
        this.invalidateHierarchy();
    }

    @Override
    public SelectBox$SelectBoxStyle getStyle() {
        return this.style;
    }

    public void setItems(Object ... objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float f2 = ((Widget)this).getPrefWidth();
        this.items.clear();
        this.items.addAll(objectArray);
        this.selection.c();
        this.scrollPane.list.setItems(this.items);
        this.invalidate();
        if (f2 != ((Widget)this).getPrefWidth()) {
            this.invalidateHierarchy();
        }
    }

    public void setItems(Array array) {
        if (array == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float f2 = ((Widget)this).getPrefWidth();
        if (array != this.items) {
            this.items.clear();
            this.items.addAll(array);
        }
        this.selection.c();
        this.scrollPane.list.setItems(this.items);
        this.invalidate();
        if (f2 != ((Widget)this).getPrefWidth()) {
            this.invalidateHierarchy();
        }
    }

    public void clearItems() {
        if (this.items.size == 0) {
            return;
        }
        this.items.clear();
        this.selection.l();
        this.scrollPane.list.clearItems();
        this.invalidateHierarchy();
    }

    public Array getItems() {
        return this.items;
    }

    @Override
    public void layout() {
        Object object = this.style.background;
        BitmapFont bitmapFont = this.style.font;
        this.prefHeight = object != null ? Math.max(object.c() + object.d() + bitmapFont.getCapHeight() - bitmapFont.getDescent() * 2.0f, object.f()) : bitmapFont.getCapHeight() - bitmapFont.getDescent() * 2.0f;
        Pool pool = Pools.get(GlyphLayout::new);
        GlyphLayout glyphLayout = (GlyphLayout)pool.obtain();
        if (this.selectedPrefWidth) {
            Object object2;
            this.prefWidth = 0.0f;
            if (object != null) {
                this.prefWidth = object.a() + object.b();
            }
            if ((object2 = this.getSelected()) != null) {
                glyphLayout.setText(bitmapFont, this.toString(object2));
                this.prefWidth += glyphLayout.width;
            }
        } else {
            float f2 = 0.0f;
            for (int i2 = 0; i2 < this.items.size; ++i2) {
                SelectBox selectBox = this;
                glyphLayout.setText(bitmapFont, selectBox.toString(selectBox.items.get(i2)));
                f2 = Math.max(glyphLayout.width, f2);
            }
            this.prefWidth = f2;
            if (object != null) {
                this.prefWidth = Math.max(this.prefWidth + object.a() + object.b(), object.e());
            }
            List$ListStyle list$ListStyle = this.style.listStyle;
            object = this.style.scrollStyle;
            float f3 = f2 + list$ListStyle.selection.a() + list$ListStyle.selection.b();
            object = ((ScrollPane$ScrollPaneStyle)object).background;
            if (object != null) {
                f3 = Math.max(f3 + object.a() + object.b(), object.e());
            }
            if (this.scrollPane == null || !this.scrollPane.disableY) {
                f3 += Math.max(this.style.scrollStyle.vScroll != null ? this.style.scrollStyle.vScroll.e() : 0.0f, this.style.scrollStyle.vScrollKnob != null ? this.style.scrollStyle.vScrollKnob.e() : 0.0f);
            }
            this.prefWidth = Math.max(this.prefWidth, f3);
        }
        pool.free(glyphLayout);
    }

    protected k getBackgroundDrawable() {
        if (this.isDisabled() && this.style.backgroundDisabled != null) {
            return this.style.backgroundDisabled;
        }
        if (this.scrollPane.hasParent() && this.style.backgroundOpen != null) {
            return this.style.backgroundOpen;
        }
        if (this.isOver() && this.style.backgroundOver != null) {
            return this.style.backgroundOver;
        }
        return this.style.background;
    }

    protected Color getFontColor() {
        if (this.isDisabled() && this.style.disabledFontColor != null) {
            return this.style.disabledFontColor;
        }
        if (this.style.overFontColor != null && (this.isOver() || this.scrollPane.hasParent())) {
            return this.style.overFontColor;
        }
        return this.style.fontColor;
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.validate();
        k k2 = this.getBackgroundDrawable();
        Color color = this.getFontColor();
        BitmapFont bitmapFont = this.style.font;
        Object object = this.getColor();
        float f3 = this.getX();
        float f4 = this.getY();
        float f5 = this.getWidth();
        float f6 = this.getHeight();
        batch.setColor(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a * f2);
        if (k2 != null) {
            k2.a(batch, f3, f4, f5, f6);
        }
        if ((object = this.selection.h()) != null) {
            if (k2 != null) {
                f5 -= k2.a() + k2.b();
                f3 += k2.a();
                f4 += (float)((int)((f6 -= k2.d() + k2.c()) / 2.0f + k2.d() + bitmapFont.getData().capHeight / 2.0f));
            } else {
                f4 += (float)((int)(f6 / 2.0f + bitmapFont.getData().capHeight / 2.0f));
            }
            bitmapFont.setColor(color.r, color.g, color.b, color.a * f2);
            this.drawItem(batch, bitmapFont, object, f3, f4, f5);
        }
    }

    protected GlyphLayout drawItem(Batch batch, BitmapFont bitmapFont, Object object, float f2, float f3, float f4) {
        object = this.toString(object);
        return bitmapFont.draw(batch, (CharSequence)object, f2, f3, 0, ((String)object).length(), f4, this.alignment, false, "...");
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public d getSelection() {
        return this.selection;
    }

    public Object getSelected() {
        return this.selection.h();
    }

    public void setSelected(Object object) {
        if (this.items.contains(object, false)) {
            this.selection.b(object);
            return;
        }
        if (this.items.size > 0) {
            this.selection.b(this.items.first());
            return;
        }
        this.selection.l();
    }

    public int getSelectedIndex() {
        OrderedSet orderedSet = this.selection.g();
        if (orderedSet.size == 0) {
            return -1;
        }
        return this.items.indexOf(((ObjectSet)orderedSet).first(), false);
    }

    public void setSelectedIndex(int n2) {
        this.selection.b(this.items.get(n2));
    }

    public void setSelectedPrefWidth(boolean bl2) {
        this.selectedPrefWidth = bl2;
    }

    public boolean getSelectedPrefWidth() {
        return this.selectedPrefWidth;
    }

    public float getMaxSelectedPrefWidth() {
        GlyphLayout glyphLayout = (GlyphLayout)Pools.get(GlyphLayout::new).obtain();
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.items.size; ++i2) {
            SelectBox selectBox = this;
            glyphLayout.setText(this.style.font, selectBox.toString(selectBox.items.get(i2)));
            f2 = Math.max(glyphLayout.width, f2);
        }
        k k2 = this.style.background;
        if (k2 != null) {
            f2 = Math.max(f2 + k2.a() + k2.b(), k2.e());
        }
        return f2;
    }

    public void setDisabled(boolean bl2) {
        if (bl2 && !this.disabled) {
            this.hideScrollPane();
        }
        this.disabled = bl2;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public float getPrefWidth() {
        this.validate();
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        this.validate();
        return this.prefHeight;
    }

    protected String toString(Object object) {
        return object.toString();
    }

    public void showList() {
        this.showScrollPane();
    }

    public void showScrollPane() {
        if (this.items.size == 0) {
            return;
        }
        if (this.getStage() != null) {
            this.scrollPane.show(this.getStage());
        }
    }

    public void hideList() {
        this.hideScrollPane();
    }

    public void hideScrollPane() {
        this.scrollPane.hide();
    }

    public List getList() {
        return this.scrollPane.list;
    }

    public void setScrollingDisabled(boolean bl2) {
        this.scrollPane.setScrollingDisabled(true, bl2);
        this.invalidateHierarchy();
    }

    public SelectBox$SelectBoxScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public boolean isOver() {
        return this.clickListener.isOver();
    }

    public h getClickListener() {
        return this.clickListener;
    }

    protected void onShow(b b2, boolean bl2) {
        b2.getColor().a = 0.0f;
        b2.addAction(com.badlogic.gdx.scenes.scene2d.a.a.b(0.3f, Interpolation.fade));
    }

    protected void onHide(b b2) {
        b2.getColor().a = 1.0f;
        b2.addAction(com.badlogic.gdx.scenes.scene2d.a.a.a((a)com.badlogic.gdx.scenes.scene2d.a.a.a(0.15f, Interpolation.fade), com.badlogic.gdx.scenes.scene2d.a.a.c()));
    }
}

