/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.a;
import com.badlogic.gdx.scenes.scene2d.b.p;
import com.badlogic.gdx.scenes.scene2d.j;
import com.badlogic.gdx.scenes.scene2d.l;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane$ScrollPaneStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Styleable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.i;
import com.badlogic.gdx.scenes.scene2d.ui.k;

public class ScrollPane
extends WidgetGroup
implements Styleable {
    private ScrollPane$ScrollPaneStyle style;
    private b actor;
    final Rectangle actorArea = new Rectangle();
    final Rectangle hScrollBounds = new Rectangle();
    final Rectangle hKnobBounds = new Rectangle();
    final Rectangle vScrollBounds = new Rectangle();
    final Rectangle vKnobBounds = new Rectangle();
    private final Rectangle actorCullingArea = new Rectangle();
    private a flickScrollListener;
    boolean scrollX;
    boolean scrollY;
    boolean vScrollOnRight = true;
    boolean hScrollOnBottom = true;
    float amountX;
    float amountY;
    float visualAmountX;
    float visualAmountY;
    float maxX;
    float maxY;
    boolean touchScrollH;
    boolean touchScrollV;
    final Vector2 lastPoint = new Vector2();
    boolean fadeScrollBars = true;
    boolean smoothScrolling = true;
    boolean scrollBarTouch = true;
    float fadeAlpha;
    float fadeAlphaSeconds = 1.0f;
    float fadeDelay;
    float fadeDelaySeconds = 1.0f;
    boolean cancelTouchFocus = true;
    boolean flickScroll = true;
    float flingTime = 1.0f;
    float flingTimer;
    float velocityX;
    float velocityY;
    private boolean overscrollX = true;
    private boolean overscrollY = true;
    private float overscrollDistance = 50.0f;
    private float overscrollSpeedMin = 30.0f;
    private float overscrollSpeedMax = 200.0f;
    private boolean forceScrollX;
    private boolean forceScrollY;
    boolean disableX;
    boolean disableY;
    private boolean clamp = true;
    private boolean scrollbarsOnTop;
    private boolean variableSizeKnobs = true;
    int draggingPointer = -1;

    public ScrollPane(b b2) {
        this(b2, new ScrollPane$ScrollPaneStyle());
    }

    public ScrollPane(b b2, Skin skin) {
        this(b2, (ScrollPane$ScrollPaneStyle)skin.get(ScrollPane$ScrollPaneStyle.class));
    }

    public ScrollPane(b b2, Skin skin, String string) {
        this(b2, (ScrollPane$ScrollPaneStyle)skin.get(string, ScrollPane$ScrollPaneStyle.class));
    }

    public ScrollPane(b b2, ScrollPane$ScrollPaneStyle scrollPane$ScrollPaneStyle) {
        if (scrollPane$ScrollPaneStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = scrollPane$ScrollPaneStyle;
        this.setActor(b2);
        this.setSize(150.0f, 150.0f);
        this.addCaptureListener();
        this.flickScrollListener = this.getFlickScrollListener();
        ScrollPane scrollPane = this;
        scrollPane.addListener(scrollPane.flickScrollListener);
        this.addScrollListener();
    }

    protected void addCaptureListener() {
        this.addCaptureListener(new i(this));
    }

    protected a getFlickScrollListener() {
        return new com.badlogic.gdx.scenes.scene2d.ui.j(this);
    }

    protected void addScrollListener() {
        this.addListener(new k(this));
    }

    public void setScrollbarsVisible(boolean bl2) {
        if (bl2) {
            this.fadeAlpha = this.fadeAlphaSeconds;
            this.fadeDelay = this.fadeDelaySeconds;
            return;
        }
        this.fadeAlpha = 0.0f;
        this.fadeDelay = 0.0f;
    }

    public void cancelTouchFocus() {
        j j2 = this.getStage();
        if (j2 != null) {
            j2.a(this.flickScrollListener, this);
        }
    }

    public void cancel() {
        this.draggingPointer = -1;
        this.touchScrollH = false;
        this.touchScrollV = false;
        this.flickScrollListener.b().cancel();
    }

    void clamp() {
        if (!this.clamp) {
            return;
        }
        ScrollPane scrollPane = this;
        scrollPane.scrollX(scrollPane.overscrollX ? MathUtils.clamp(this.amountX, -this.overscrollDistance, this.maxX + this.overscrollDistance) : MathUtils.clamp(this.amountX, 0.0f, this.maxX));
        ScrollPane scrollPane2 = this;
        scrollPane2.scrollY(scrollPane2.overscrollY ? MathUtils.clamp(this.amountY, -this.overscrollDistance, this.maxY + this.overscrollDistance) : MathUtils.clamp(this.amountY, 0.0f, this.maxY));
    }

    public void setStyle(ScrollPane$ScrollPaneStyle scrollPane$ScrollPaneStyle) {
        if (scrollPane$ScrollPaneStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = scrollPane$ScrollPaneStyle;
        this.invalidateHierarchy();
    }

    @Override
    public ScrollPane$ScrollPaneStyle getStyle() {
        return this.style;
    }

    @Override
    public void act(float f2) {
        j j2;
        super.act(f2);
        boolean bl2 = this.flickScrollListener.b().isPanning();
        boolean bl3 = false;
        if (this.fadeAlpha > 0.0f && this.fadeScrollBars && !bl2 && !this.touchScrollH && !this.touchScrollV) {
            this.fadeDelay -= f2;
            if (this.fadeDelay <= 0.0f) {
                this.fadeAlpha = Math.max(0.0f, this.fadeAlpha - f2);
            }
            bl3 = true;
        }
        if (this.flingTimer > 0.0f) {
            this.setScrollbarsVisible(true);
            float f3 = this.flingTimer / this.flingTime;
            this.amountX -= this.velocityX * f3 * f2;
            this.amountY -= this.velocityY * f3 * f2;
            this.clamp();
            if (this.amountX == -this.overscrollDistance) {
                this.velocityX = 0.0f;
            }
            if (this.amountX >= this.maxX + this.overscrollDistance) {
                this.velocityX = 0.0f;
            }
            if (this.amountY == -this.overscrollDistance) {
                this.velocityY = 0.0f;
            }
            if (this.amountY >= this.maxY + this.overscrollDistance) {
                this.velocityY = 0.0f;
            }
            this.flingTimer -= f2;
            if (this.flingTimer <= 0.0f) {
                this.velocityX = 0.0f;
                this.velocityY = 0.0f;
            }
            bl3 = true;
        }
        if (this.smoothScrolling && this.flingTimer <= 0.0f && !bl2 && (!this.touchScrollH || this.scrollX && this.maxX / (this.hScrollBounds.width - this.hKnobBounds.width) > this.actorArea.width * 0.1f) && (!this.touchScrollV || this.scrollY && this.maxY / (this.vScrollBounds.height - this.vKnobBounds.height) > this.actorArea.height * 0.1f)) {
            if (this.visualAmountX != this.amountX) {
                if (this.visualAmountX < this.amountX) {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollX(Math.min(scrollPane.amountX, this.visualAmountX + Math.max(200.0f * f2, (this.amountX - this.visualAmountX) * 7.0f * f2)));
                } else {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollX(Math.max(scrollPane.amountX, this.visualAmountX - Math.max(200.0f * f2, (this.visualAmountX - this.amountX) * 7.0f * f2)));
                }
                bl3 = true;
            }
            if (this.visualAmountY != this.amountY) {
                if (this.visualAmountY < this.amountY) {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollY(Math.min(scrollPane.amountY, this.visualAmountY + Math.max(200.0f * f2, (this.amountY - this.visualAmountY) * 7.0f * f2)));
                } else {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollY(Math.max(scrollPane.amountY, this.visualAmountY - Math.max(200.0f * f2, (this.visualAmountY - this.amountY) * 7.0f * f2)));
                }
                bl3 = true;
            }
        } else {
            if (this.visualAmountX != this.amountX) {
                ScrollPane scrollPane = this;
                scrollPane.visualScrollX(scrollPane.amountX);
            }
            if (this.visualAmountY != this.amountY) {
                ScrollPane scrollPane = this;
                scrollPane.visualScrollY(scrollPane.amountY);
            }
        }
        if (!bl2) {
            if (this.overscrollX && this.scrollX) {
                if (this.amountX < 0.0f) {
                    this.setScrollbarsVisible(true);
                    this.amountX += (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -this.amountX / this.overscrollDistance) * f2;
                    if (this.amountX > 0.0f) {
                        this.scrollX(0.0f);
                    }
                    bl3 = true;
                } else if (this.amountX > this.maxX) {
                    this.setScrollbarsVisible(true);
                    this.amountX -= (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -(this.maxX - this.amountX) / this.overscrollDistance) * f2;
                    if (this.amountX < this.maxX) {
                        ScrollPane scrollPane = this;
                        scrollPane.scrollX(scrollPane.maxX);
                    }
                    bl3 = true;
                }
            }
            if (this.overscrollY && this.scrollY) {
                if (this.amountY < 0.0f) {
                    this.setScrollbarsVisible(true);
                    this.amountY += (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -this.amountY / this.overscrollDistance) * f2;
                    if (this.amountY > 0.0f) {
                        this.scrollY(0.0f);
                    }
                    bl3 = true;
                } else if (this.amountY > this.maxY) {
                    this.setScrollbarsVisible(true);
                    this.amountY -= (this.overscrollSpeedMin + (this.overscrollSpeedMax - this.overscrollSpeedMin) * -(this.maxY - this.amountY) / this.overscrollDistance) * f2;
                    if (this.amountY < this.maxY) {
                        ScrollPane scrollPane = this;
                        scrollPane.scrollY(scrollPane.maxY);
                    }
                    bl3 = true;
                }
            }
        }
        if (bl3 && (j2 = this.getStage()) != null && j2.k()) {
            Gdx.b.p();
        }
    }

    @Override
    public void layout() {
        float f2;
        float f3;
        com.badlogic.gdx.scenes.scene2d.b.k k2 = this.style.background;
        com.badlogic.gdx.scenes.scene2d.b.k k3 = this.style.hScrollKnob;
        com.badlogic.gdx.scenes.scene2d.b.k k4 = this.style.vScrollKnob;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (k2 != null) {
            f4 = k2.a();
            f5 = k2.b();
            f6 = k2.c();
            f7 = k2.d();
        }
        float f8 = this.getWidth();
        float f9 = this.getHeight();
        this.actorArea.set(f4, f7, f8 - f4 - f5, f9 - f6 - f7);
        if (this.actor == null) {
            return;
        }
        float f10 = 0.0f;
        float f11 = 0.0f;
        if (k3 != null) {
            f10 = k3.f();
        }
        if (this.style.hScroll != null) {
            f10 = Math.max(f10, this.style.hScroll.f());
        }
        if (k4 != null) {
            f11 = k4.e();
        }
        if (this.style.vScroll != null) {
            f11 = Math.max(f11, this.style.vScroll.e());
        }
        if (this.actor instanceof p) {
            p p2 = (p)((Object)this.actor);
            f3 = p2.getPrefWidth();
            f2 = p2.getPrefHeight();
        } else {
            f3 = this.actor.getWidth();
            f2 = this.actor.getHeight();
        }
        this.scrollX = this.forceScrollX || f3 > this.actorArea.width && !this.disableX;
        boolean bl2 = this.scrollY = this.forceScrollY || f2 > this.actorArea.height && !this.disableY;
        if (!this.scrollbarsOnTop) {
            if (this.scrollY) {
                this.actorArea.width -= f11;
                if (!this.vScrollOnRight) {
                    this.actorArea.x += f11;
                }
                if (!this.scrollX && f3 > this.actorArea.width && !this.disableX) {
                    this.scrollX = true;
                }
            }
            if (this.scrollX) {
                this.actorArea.height -= f10;
                if (this.hScrollOnBottom) {
                    this.actorArea.y += f10;
                }
                if (!this.scrollY && f2 > this.actorArea.height && !this.disableY) {
                    this.scrollY = true;
                    this.actorArea.width -= f11;
                    if (!this.vScrollOnRight) {
                        this.actorArea.x += f11;
                    }
                }
            }
        }
        f3 = this.disableX ? this.actorArea.width : Math.max(this.actorArea.width, f3);
        f2 = this.disableY ? this.actorArea.height : Math.max(this.actorArea.height, f2);
        this.maxX = f3 - this.actorArea.width;
        this.maxY = f2 - this.actorArea.height;
        ScrollPane scrollPane = this;
        scrollPane.scrollX(MathUtils.clamp(scrollPane.amountX, 0.0f, this.maxX));
        ScrollPane scrollPane2 = this;
        scrollPane2.scrollY(MathUtils.clamp(scrollPane2.amountY, 0.0f, this.maxY));
        if (this.scrollX) {
            if (k3 != null) {
                float f12 = this.scrollbarsOnTop ? f4 : this.actorArea.x;
                f6 = this.hScrollOnBottom ? f7 : f9 - f6 - f10;
                this.hScrollBounds.set(f12, f6, this.actorArea.width, f10);
                if (this.scrollY && this.scrollbarsOnTop) {
                    this.hScrollBounds.width -= f11;
                    if (!this.vScrollOnRight) {
                        this.hScrollBounds.x += f11;
                    }
                }
                this.hKnobBounds.width = this.variableSizeKnobs ? Math.max(k3.e(), (float)((int)(this.hScrollBounds.width * this.actorArea.width / f3))) : k3.e();
                if (this.hKnobBounds.width > f3) {
                    this.hKnobBounds.width = 0.0f;
                }
                this.hKnobBounds.height = k3.f();
                this.hKnobBounds.x = this.hScrollBounds.x + (float)((int)((this.hScrollBounds.width - this.hKnobBounds.width) * this.getScrollPercentX()));
                this.hKnobBounds.y = this.hScrollBounds.y;
            } else {
                this.hScrollBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.hKnobBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        if (this.scrollY) {
            if (k4 != null) {
                float f13 = this.vScrollOnRight ? f8 - f5 - f11 : f4;
                f6 = this.scrollbarsOnTop ? f7 : this.actorArea.y;
                this.vScrollBounds.set(f13, f6, f11, this.actorArea.height);
                if (this.scrollX && this.scrollbarsOnTop) {
                    this.vScrollBounds.height -= f10;
                    if (this.hScrollOnBottom) {
                        this.vScrollBounds.y += f10;
                    }
                }
                this.vKnobBounds.width = k4.e();
                this.vKnobBounds.height = this.variableSizeKnobs ? Math.max(k4.f(), (float)((int)(this.vScrollBounds.height * this.actorArea.height / f2))) : k4.f();
                if (this.vKnobBounds.height > f2) {
                    this.vKnobBounds.height = 0.0f;
                }
                this.vKnobBounds.x = this.vScrollOnRight ? f8 - f5 - k4.e() : f4;
                this.vKnobBounds.y = this.vScrollBounds.y + (float)((int)((this.vScrollBounds.height - this.vKnobBounds.height) * (1.0f - this.getScrollPercentY())));
            } else {
                this.vScrollBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.vKnobBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        this.updateActorPosition();
        if (this.actor instanceof p) {
            this.actor.setSize(f3, f2);
            ((p)((Object)this.actor)).validate();
        }
    }

    private void updateActorPosition() {
        float f2 = this.actorArea.x - (float)(this.scrollX ? (int)this.visualAmountX : 0);
        float f3 = this.actorArea.y - (float)((int)(this.scrollY ? this.maxY - this.visualAmountY : this.maxY));
        this.actor.setPosition(f2, f3);
        if (this.actor instanceof com.badlogic.gdx.scenes.scene2d.b.i) {
            this.actorCullingArea.x = this.actorArea.x - f2;
            this.actorCullingArea.y = this.actorArea.y - f3;
            this.actorCullingArea.width = this.actorArea.width;
            this.actorCullingArea.height = this.actorArea.height;
            ((com.badlogic.gdx.scenes.scene2d.b.i)((Object)this.actor)).setCullingArea(this.actorCullingArea);
        }
    }

    @Override
    public void draw(Batch batch, float f2) {
        if (this.actor == null) {
            return;
        }
        this.validate();
        this.applyTransform(batch, this.computeTransform());
        if (this.scrollX) {
            this.hKnobBounds.x = this.hScrollBounds.x + (float)((int)((this.hScrollBounds.width - this.hKnobBounds.width) * this.getVisualScrollPercentX()));
        }
        if (this.scrollY) {
            this.vKnobBounds.y = this.vScrollBounds.y + (float)((int)((this.vScrollBounds.height - this.vKnobBounds.height) * (1.0f - this.getVisualScrollPercentY())));
        }
        this.updateActorPosition();
        Color color = this.getColor();
        float f3 = color.a * f2;
        if (this.style.background != null) {
            batch.setColor(color.r, color.g, color.b, f3);
            this.style.background.a(batch, 0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        batch.flush();
        ScrollPane scrollPane = this;
        if (scrollPane.clipBegin(scrollPane.actorArea.x, this.actorArea.y, this.actorArea.width, this.actorArea.height)) {
            this.drawChildren(batch, f2);
            batch.flush();
            this.clipEnd();
        }
        batch.setColor(color.r, color.g, color.b, f3);
        if (this.fadeScrollBars) {
            f3 *= Interpolation.fade.apply(this.fadeAlpha / this.fadeAlphaSeconds);
        }
        this.drawScrollBars(batch, color.r, color.g, color.b, f3);
        this.resetTransform(batch);
    }

    protected void drawScrollBars(Batch batch, float f2, float f3, float f4, float f5) {
        boolean bl2;
        if (f5 <= 0.0f) {
            return;
        }
        batch.setColor(f2, f3, f4, f5);
        boolean bl3 = this.scrollX && this.hKnobBounds.width > 0.0f;
        boolean bl4 = bl2 = this.scrollY && this.vKnobBounds.height > 0.0f;
        if (bl3) {
            if (bl2 && this.style.corner != null) {
                this.style.corner.a(batch, this.hScrollBounds.x + this.hScrollBounds.width, this.hScrollBounds.y, this.vScrollBounds.width, this.vScrollBounds.y);
            }
            if (this.style.hScroll != null) {
                this.style.hScroll.a(batch, this.hScrollBounds.x, this.hScrollBounds.y, this.hScrollBounds.width, this.hScrollBounds.height);
            }
            if (this.style.hScrollKnob != null) {
                this.style.hScrollKnob.a(batch, this.hKnobBounds.x, this.hKnobBounds.y, this.hKnobBounds.width, this.hKnobBounds.height);
            }
        }
        if (bl2) {
            if (this.style.vScroll != null) {
                this.style.vScroll.a(batch, this.vScrollBounds.x, this.vScrollBounds.y, this.vScrollBounds.width, this.vScrollBounds.height);
            }
            if (this.style.vScrollKnob != null) {
                this.style.vScrollKnob.a(batch, this.vKnobBounds.x, this.vKnobBounds.y, this.vKnobBounds.width, this.vKnobBounds.height);
            }
        }
    }

    public void fling(float f2, float f3, float f4) {
        this.flingTimer = f2;
        this.velocityX = f3;
        this.velocityY = f4;
    }

    @Override
    public float getPrefWidth() {
        float f2 = 0.0f;
        if (this.actor instanceof p) {
            f2 = ((p)((Object)this.actor)).getPrefWidth();
        } else if (this.actor != null) {
            f2 = this.actor.getWidth();
        }
        com.badlogic.gdx.scenes.scene2d.b.k k2 = this.style.background;
        if (k2 != null) {
            f2 = Math.max(f2 + k2.a() + k2.b(), k2.e());
        }
        if (this.scrollY) {
            float f3 = 0.0f;
            if (this.style.vScrollKnob != null) {
                f3 = this.style.vScrollKnob.e();
            }
            if (this.style.vScroll != null) {
                f3 = Math.max(f3, this.style.vScroll.e());
            }
            f2 += f3;
        }
        return f2;
    }

    @Override
    public float getPrefHeight() {
        float f2 = 0.0f;
        if (this.actor instanceof p) {
            f2 = ((p)((Object)this.actor)).getPrefHeight();
        } else if (this.actor != null) {
            f2 = this.actor.getHeight();
        }
        com.badlogic.gdx.scenes.scene2d.b.k k2 = this.style.background;
        if (k2 != null) {
            f2 = Math.max(f2 + k2.c() + k2.d(), k2.f());
        }
        if (this.scrollX) {
            float f3 = 0.0f;
            if (this.style.hScrollKnob != null) {
                f3 = this.style.hScrollKnob.f();
            }
            if (this.style.hScroll != null) {
                f3 = Math.max(f3, this.style.hScroll.f());
            }
            f2 += f3;
        }
        return f2;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    public void setActor(b b2) {
        if (this.actor == this) {
            throw new IllegalArgumentException("actor cannot be the ScrollPane.");
        }
        if (this.actor != null) {
            ScrollPane scrollPane = this;
            super.removeActor(scrollPane.actor);
        }
        this.actor = b2;
        if (b2 != null) {
            super.addActor(b2);
        }
    }

    public b getActor() {
        return this.actor;
    }

    public void setWidget(b b2) {
        this.setActor(b2);
    }

    public b getWidget() {
        return this.actor;
    }

    @Override
    public void addActor(b b2) {
        throw new UnsupportedOperationException("Use ScrollPane#setActor.");
    }

    @Override
    public void addActorAt(int n2, b b2) {
        throw new UnsupportedOperationException("Use ScrollPane#setActor.");
    }

    @Override
    public void addActorBefore(b b2, b b3) {
        throw new UnsupportedOperationException("Use ScrollPane#setActor.");
    }

    @Override
    public void addActorAfter(b b2, b b3) {
        throw new UnsupportedOperationException("Use ScrollPane#setActor.");
    }

    @Override
    public boolean removeActor(b b2) {
        if (b2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (b2 != this.actor) {
            return false;
        }
        this.setActor(null);
        return true;
    }

    @Override
    public boolean removeActor(b b2, boolean bl2) {
        if (b2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (b2 != this.actor) {
            return false;
        }
        this.actor = null;
        return super.removeActor(b2, bl2);
    }

    @Override
    public b removeActorAt(int n2, boolean bl2) {
        b b2 = super.removeActorAt(n2, bl2);
        if (b2 == this.actor) {
            this.actor = null;
        }
        return b2;
    }

    @Override
    public b hit(float f2, float f3, boolean bl2) {
        if (f2 < 0.0f || f2 >= this.getWidth() || f3 < 0.0f || f3 >= this.getHeight()) {
            return null;
        }
        if (bl2 && this.getTouchable() == l.a && this.isVisible()) {
            if (this.scrollX && this.touchScrollH && this.hScrollBounds.contains(f2, f3)) {
                return this;
            }
            if (this.scrollY && this.touchScrollV && this.vScrollBounds.contains(f2, f3)) {
                return this;
            }
        }
        return super.hit(f2, f3, bl2);
    }

    protected void scrollX(float f2) {
        this.amountX = f2;
    }

    protected void scrollY(float f2) {
        this.amountY = f2;
    }

    protected void visualScrollX(float f2) {
        this.visualAmountX = f2;
    }

    protected void visualScrollY(float f2) {
        this.visualAmountY = f2;
    }

    protected float getMouseWheelX() {
        return Math.min(this.actorArea.width, Math.max(this.actorArea.width * 0.9f, this.maxX * 0.1f) / 4.0f);
    }

    protected float getMouseWheelY() {
        return Math.min(this.actorArea.height, Math.max(this.actorArea.height * 0.9f, this.maxY * 0.1f) / 4.0f);
    }

    public void setScrollX(float f2) {
        this.scrollX(MathUtils.clamp(f2, 0.0f, this.maxX));
    }

    public float getScrollX() {
        return this.amountX;
    }

    public void setScrollY(float f2) {
        this.scrollY(MathUtils.clamp(f2, 0.0f, this.maxY));
    }

    public float getScrollY() {
        return this.amountY;
    }

    public void updateVisualScroll() {
        this.visualAmountX = this.amountX;
        this.visualAmountY = this.amountY;
    }

    public float getVisualScrollX() {
        if (!this.scrollX) {
            return 0.0f;
        }
        return this.visualAmountX;
    }

    public float getVisualScrollY() {
        if (!this.scrollY) {
            return 0.0f;
        }
        return this.visualAmountY;
    }

    public float getVisualScrollPercentX() {
        if (this.maxX == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.visualAmountX / this.maxX, 0.0f, 1.0f);
    }

    public float getVisualScrollPercentY() {
        if (this.maxY == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.visualAmountY / this.maxY, 0.0f, 1.0f);
    }

    public float getScrollPercentX() {
        if (this.maxX == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.amountX / this.maxX, 0.0f, 1.0f);
    }

    public void setScrollPercentX(float f2) {
        ScrollPane scrollPane = this;
        scrollPane.scrollX(scrollPane.maxX * MathUtils.clamp(f2, 0.0f, 1.0f));
    }

    public float getScrollPercentY() {
        if (this.maxY == 0.0f) {
            return 0.0f;
        }
        return MathUtils.clamp(this.amountY / this.maxY, 0.0f, 1.0f);
    }

    public void setScrollPercentY(float f2) {
        ScrollPane scrollPane = this;
        scrollPane.scrollY(scrollPane.maxY * MathUtils.clamp(f2, 0.0f, 1.0f));
    }

    public void setFlickScroll(boolean bl2) {
        if (this.flickScroll == bl2) {
            return;
        }
        this.flickScroll = bl2;
        if (bl2) {
            ScrollPane scrollPane = this;
            scrollPane.addListener(scrollPane.flickScrollListener);
        } else {
            ScrollPane scrollPane = this;
            scrollPane.removeListener(scrollPane.flickScrollListener);
        }
        this.invalidate();
    }

    public void setFlickScrollTapSquareSize(float f2) {
        this.flickScrollListener.b().setTapSquareSize(f2);
    }

    public void scrollTo(float f2, float f3, float f4, float f5) {
        this.scrollTo(f2, f3, f4, f5, false, false);
    }

    public void scrollTo(float f2, float f3, float f4, float f5, boolean bl2, boolean bl3) {
        this.validate();
        float f6 = this.amountX;
        if (bl2) {
            f6 = f2 + (f4 - this.actorArea.width) / 2.0f;
        } else {
            float f7 = f2;
            f6 = MathUtils.clamp(f6, f7, f7 + f4 - this.actorArea.width);
        }
        this.scrollX(MathUtils.clamp(f6, 0.0f, this.maxX));
        f2 = this.amountY;
        f3 = this.maxY - f3;
        f2 = bl3 ? f3 + (this.actorArea.height + f5) / 2.0f : MathUtils.clamp(f2, f3 + f5, f3 + this.actorArea.height);
        this.scrollY(MathUtils.clamp(f2, 0.0f, this.maxY));
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getScrollBarHeight() {
        if (!this.scrollX) {
            return 0.0f;
        }
        float f2 = 0.0f;
        if (this.style.hScrollKnob != null) {
            f2 = this.style.hScrollKnob.f();
        }
        if (this.style.hScroll != null) {
            f2 = Math.max(f2, this.style.hScroll.f());
        }
        return f2;
    }

    public float getScrollBarWidth() {
        if (!this.scrollY) {
            return 0.0f;
        }
        float f2 = 0.0f;
        if (this.style.vScrollKnob != null) {
            f2 = this.style.vScrollKnob.e();
        }
        if (this.style.vScroll != null) {
            f2 = Math.max(f2, this.style.vScroll.e());
        }
        return f2;
    }

    public float getScrollWidth() {
        return this.actorArea.width;
    }

    public float getScrollHeight() {
        return this.actorArea.height;
    }

    public boolean isScrollX() {
        return this.scrollX;
    }

    public boolean isScrollY() {
        return this.scrollY;
    }

    public void setScrollingDisabled(boolean bl2, boolean bl3) {
        if (bl2 == this.disableX && bl3 == this.disableY) {
            return;
        }
        this.disableX = bl2;
        this.disableY = bl3;
        this.invalidate();
    }

    public boolean isScrollingDisabledX() {
        return this.disableX;
    }

    public boolean isScrollingDisabledY() {
        return this.disableY;
    }

    public boolean isLeftEdge() {
        return !this.scrollX || this.amountX <= 0.0f;
    }

    public boolean isRightEdge() {
        return !this.scrollX || this.amountX >= this.maxX;
    }

    public boolean isTopEdge() {
        return !this.scrollY || this.amountY <= 0.0f;
    }

    public boolean isBottomEdge() {
        return !this.scrollY || this.amountY >= this.maxY;
    }

    public boolean isDragging() {
        return this.draggingPointer != -1;
    }

    public boolean isPanning() {
        return this.flickScrollListener.b().isPanning();
    }

    public boolean isFlinging() {
        return this.flingTimer > 0.0f;
    }

    public void setVelocityX(float f2) {
        this.velocityX = f2;
    }

    public float getVelocityX() {
        return this.velocityX;
    }

    public void setVelocityY(float f2) {
        this.velocityY = f2;
    }

    public float getVelocityY() {
        return this.velocityY;
    }

    public void setOverscroll(boolean bl2, boolean bl3) {
        this.overscrollX = bl2;
        this.overscrollY = bl3;
    }

    public void setupOverscroll(float f2, float f3, float f4) {
        this.overscrollDistance = f2;
        this.overscrollSpeedMin = f3;
        this.overscrollSpeedMax = f4;
    }

    public float getOverscrollDistance() {
        return this.overscrollDistance;
    }

    public void setForceScroll(boolean bl2, boolean bl3) {
        this.forceScrollX = bl2;
        this.forceScrollY = bl3;
    }

    public boolean isForceScrollX() {
        return this.forceScrollX;
    }

    public boolean isForceScrollY() {
        return this.forceScrollY;
    }

    public void setFlingTime(float f2) {
        this.flingTime = f2;
    }

    public void setClamp(boolean bl2) {
        this.clamp = bl2;
    }

    public void setScrollBarPositions(boolean bl2, boolean bl3) {
        this.hScrollOnBottom = bl2;
        this.vScrollOnRight = bl3;
    }

    public void setFadeScrollBars(boolean bl2) {
        if (this.fadeScrollBars == bl2) {
            return;
        }
        this.fadeScrollBars = bl2;
        if (!bl2) {
            this.fadeAlpha = this.fadeAlphaSeconds;
        }
        this.invalidate();
    }

    public void setupFadeScrollBars(float f2, float f3) {
        this.fadeAlphaSeconds = f2;
        this.fadeDelaySeconds = f3;
    }

    public boolean getFadeScrollBars() {
        return this.fadeScrollBars;
    }

    public void setScrollBarTouch(boolean bl2) {
        this.scrollBarTouch = bl2;
    }

    public void setSmoothScrolling(boolean bl2) {
        this.smoothScrolling = bl2;
    }

    public void setScrollbarsOnTop(boolean bl2) {
        this.scrollbarsOnTop = bl2;
        this.invalidate();
    }

    public boolean getVariableSizeKnobs() {
        return this.variableSizeKnobs;
    }

    public void setVariableSizeKnobs(boolean bl2) {
        this.variableSizeKnobs = bl2;
    }

    public void setCancelTouchFocus(boolean bl2) {
        this.cancelTouchFocus = bl2;
    }

    @Override
    public void drawDebug(ShapeRenderer shapeRenderer) {
        this.drawDebugBounds(shapeRenderer);
        this.applyTransform(shapeRenderer, this.computeTransform());
        ScrollPane scrollPane = this;
        if (scrollPane.clipBegin(scrollPane.actorArea.x, this.actorArea.y, this.actorArea.width, this.actorArea.height)) {
            this.drawDebugChildren(shapeRenderer);
            shapeRenderer.flush();
            this.clipEnd();
        }
        this.resetTransform(shapeRenderer);
    }
}

