/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.b.g;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.j;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar$ProgressBarStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Styleable;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.utils.Pools;

public class ProgressBar
extends Widget
implements Styleable {
    private ProgressBar$ProgressBarStyle style;
    float min;
    float max;
    float stepSize;
    private float value;
    private float animateFromValue;
    float position;
    final boolean vertical;
    private float animateDuration;
    private float animateTime;
    private Interpolation animateInterpolation = Interpolation.linear;
    private Interpolation visualInterpolation = Interpolation.linear;
    boolean disabled;
    private boolean round = true;
    private boolean programmaticChangeEvents = true;

    public ProgressBar(float f2, float f3, float f4, boolean bl2, Skin skin) {
        this(f2, f3, f4, bl2, (ProgressBar$ProgressBarStyle)skin.get("default-" + (bl2 ? "vertical" : "horizontal"), ProgressBar$ProgressBarStyle.class));
    }

    public ProgressBar(float f2, float f3, float f4, boolean bl2, Skin skin, String string) {
        this(f2, f3, f4, bl2, (ProgressBar$ProgressBarStyle)skin.get(string, ProgressBar$ProgressBarStyle.class));
    }

    public ProgressBar(float f2, float f3, float f4, boolean bl2, ProgressBar$ProgressBarStyle progressBar$ProgressBarStyle) {
        if (f2 > f3) {
            throw new IllegalArgumentException("max must be > min. min,max: " + f2 + ", " + f3);
        }
        if (f4 <= 0.0f) {
            throw new IllegalArgumentException("stepSize must be > 0: ".concat(String.valueOf(f4)));
        }
        this.setStyle(progressBar$ProgressBarStyle);
        this.min = f2;
        this.max = f3;
        this.stepSize = f4;
        this.vertical = bl2;
        this.value = f2;
        ProgressBar progressBar = this;
        progressBar.setSize(((Widget)progressBar).getPrefWidth(), ((Widget)this).getPrefHeight());
    }

    public void setStyle(ProgressBar$ProgressBarStyle progressBar$ProgressBarStyle) {
        if (progressBar$ProgressBarStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = progressBar$ProgressBarStyle;
        this.invalidateHierarchy();
    }

    @Override
    public ProgressBar$ProgressBarStyle getStyle() {
        return this.style;
    }

    @Override
    public void act(float f2) {
        super.act(f2);
        if (this.animateTime > 0.0f) {
            this.animateTime -= f2;
            j j2 = this.getStage();
            if (j2 != null && j2.k()) {
                Gdx.b.p();
            }
        }
    }

    @Override
    public void draw(Batch batch, float f2) {
        Object object = this.style;
        object = ((ProgressBar$ProgressBarStyle)object).knob;
        k k2 = this.getKnobDrawable();
        k k3 = this.getBackgroundDrawable();
        k k4 = this.getKnobBeforeDrawable();
        k k5 = this.getKnobAfterDrawable();
        Color color = this.getColor();
        float f3 = this.getX();
        float f4 = this.getY();
        float f5 = this.getWidth();
        float f6 = this.getHeight();
        float f7 = object == null ? 0.0f : object.f();
        float f8 = object == null ? 0.0f : object.e();
        float f9 = this.getVisualPercent();
        batch.setColor(color.r, color.g, color.b, color.a * f2);
        if (this.vertical) {
            float f10 = 0.0f;
            if (k3 != null) {
                this.drawRound(batch, k3, f3 + (f5 - k3.e()) * 0.5f, f4, k3.e(), f6);
                f2 = k3.c();
                f10 = k3.d();
                f6 -= f2 + f10;
            }
            float f11 = f6 - f7;
            f9 = MathUtils.clamp(f11 * f9, 0.0f, f11);
            this.position = f10 + f9;
            float f12 = f7 * 0.5f;
            if (k4 != null) {
                this.drawRound(batch, k4, f3 + (f5 - k4.e()) * 0.5f, f4 + f10, k4.e(), f9 + f12);
            }
            if (k5 != null) {
                this.drawRound(batch, k5, f3 + (f5 - k5.e()) * 0.5f, f4 + this.position + f12, k5.e(), f11 - (this.round ? (float)Math.ceil(f9 - f12) : f9 - f12));
            }
            if (k2 != null) {
                f2 = k2.e();
                f11 = k2.f();
                this.drawRound(batch, k2, f3 + (f5 - f2) * 0.5f, f4 + this.position + (f7 - f11) * 0.5f, f2, f11);
            }
            return;
        }
        f2 = 0.0f;
        if (k3 != null) {
            this.drawRound(batch, k3, f3, Math.round(f4 + (f6 - k3.f()) * 0.5f), f5, Math.round(k3.f()));
            f2 = k3.a();
            float f13 = k3.b();
            f5 -= f2 + f13;
        }
        float f14 = f5 - f8;
        f9 = MathUtils.clamp(f14 * f9, 0.0f, f14);
        this.position = f2 + f9;
        float f15 = f8 * 0.5f;
        if (k4 != null) {
            this.drawRound(batch, k4, f3 + f2, f4 + (f6 - k4.f()) * 0.5f, f9 + f15, k4.f());
        }
        if (k5 != null) {
            this.drawRound(batch, k5, f3 + this.position + f15, f4 + (f6 - k5.f()) * 0.5f, f14 - (this.round ? (float)Math.ceil(f9 - f15) : f9 - f15), k5.f());
        }
        if (k2 != null) {
            f2 = k2.e();
            f14 = k2.f();
            this.drawRound(batch, k2, f3 + this.position + (f8 - f2) * 0.5f, f4 + (f6 - f14) * 0.5f, f2, f14);
        }
    }

    private void drawRound(Batch batch, k k2, float f2, float f3, float f4, float f5) {
        if (this.round) {
            f2 = (float)Math.floor(f2);
            f3 = (float)Math.floor(f3);
            f4 = (float)Math.ceil(f4);
            f5 = (float)Math.ceil(f5);
        }
        k2.a(batch, f2, f3, f4, f5);
    }

    public float getValue() {
        return this.value;
    }

    public float getVisualValue() {
        if (this.animateTime > 0.0f) {
            return this.animateInterpolation.apply(this.animateFromValue, this.value, 1.0f - this.animateTime / this.animateDuration);
        }
        return this.value;
    }

    public void updateVisualValue() {
        this.animateTime = 0.0f;
    }

    public float getPercent() {
        if (this.min == this.max) {
            return 0.0f;
        }
        return (this.value - this.min) / (this.max - this.min);
    }

    public float getVisualPercent() {
        if (this.min == this.max) {
            return 0.0f;
        }
        return this.visualInterpolation.apply((this.getVisualValue() - this.min) / (this.max - this.min));
    }

    protected k getBackgroundDrawable() {
        if (this.disabled && this.style.disabledBackground != null) {
            return this.style.disabledBackground;
        }
        return this.style.background;
    }

    protected k getKnobDrawable() {
        if (this.disabled && this.style.disabledKnob != null) {
            return this.style.disabledKnob;
        }
        return this.style.knob;
    }

    protected k getKnobBeforeDrawable() {
        if (this.disabled && this.style.disabledKnobBefore != null) {
            return this.style.disabledKnobBefore;
        }
        return this.style.knobBefore;
    }

    protected k getKnobAfterDrawable() {
        if (this.disabled && this.style.disabledKnobAfter != null) {
            return this.style.disabledKnobAfter;
        }
        return this.style.knobAfter;
    }

    protected float getKnobPosition() {
        return this.position;
    }

    public boolean setValue(float f2) {
        float f3;
        ProgressBar progressBar = this;
        if ((f2 = progressBar.clamp(progressBar.round(f2))) == (f3 = this.value)) {
            return false;
        }
        float f4 = this.getVisualValue();
        this.value = f2;
        if (this.programmaticChangeEvents) {
            g g2 = (g)Pools.obtain(g::new);
            boolean bl2 = this.fire(g2);
            Pools.free(g2);
            if (bl2) {
                this.value = f3;
                return false;
            }
        }
        if (this.animateDuration > 0.0f) {
            this.animateFromValue = f4;
            this.animateTime = this.animateDuration;
        }
        return true;
    }

    protected float round(float f2) {
        return (float)Math.round(f2 / this.stepSize) * this.stepSize;
    }

    protected float clamp(float f2) {
        return MathUtils.clamp(f2, this.min, this.max);
    }

    public void setRange(float f2, float f3) {
        if (f2 > f3) {
            throw new IllegalArgumentException("min must be <= max: " + f2 + " <= " + f3);
        }
        this.min = f2;
        this.max = f3;
        if (this.value < f2) {
            this.setValue(f2);
            return;
        }
        if (this.value > f3) {
            this.setValue(f3);
        }
    }

    public void setStepSize(float f2) {
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("steps must be > 0: ".concat(String.valueOf(f2)));
        }
        this.stepSize = f2;
    }

    @Override
    public float getPrefWidth() {
        if (this.vertical) {
            k k2 = this.style.knob;
            k k3 = this.getBackgroundDrawable();
            return Math.max(k2 == null ? 0.0f : k2.e(), k3 == null ? 0.0f : k3.e());
        }
        return 140.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.vertical) {
            return 140.0f;
        }
        k k2 = this.style.knob;
        k k3 = this.getBackgroundDrawable();
        return Math.max(k2 == null ? 0.0f : k2.f(), k3 == null ? 0.0f : k3.f());
    }

    public float getMinValue() {
        return this.min;
    }

    public float getMaxValue() {
        return this.max;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setAnimateDuration(float f2) {
        this.animateDuration = f2;
    }

    public void setAnimateInterpolation(Interpolation interpolation) {
        if (interpolation == null) {
            throw new IllegalArgumentException("animateInterpolation cannot be null.");
        }
        this.animateInterpolation = interpolation;
    }

    public void setVisualInterpolation(Interpolation interpolation) {
        this.visualInterpolation = interpolation;
    }

    public void setRound(boolean bl2) {
        this.round = bl2;
    }

    public void setDisabled(boolean bl2) {
        this.disabled = bl2;
    }

    public boolean isAnimating() {
        return this.animateTime > 0.0f;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setProgrammaticChangeEvents(boolean bl2) {
        this.programmaticChangeEvents = bl2;
    }
}

