/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.b.d;
import com.badlogic.gdx.scenes.scene2d.b.i;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.h;
import com.badlogic.gdx.scenes.scene2d.ui.List$ListStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Styleable;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.ui.g;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.OrderedSet;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class List
extends Widget
implements i,
Styleable {
    List$ListStyle style;
    final Array items = new Array();
    d selection = new d(this.items);
    private Rectangle cullingArea;
    private float prefWidth;
    private float prefHeight;
    float itemHeight;
    private int alignment = 8;
    int pressedIndex = -1;
    int overIndex = -1;
    private h keyListener;
    boolean typeToSelect;

    public List(Skin skin) {
        this((List$ListStyle)skin.get(List$ListStyle.class));
    }

    public List(Skin skin, String string) {
        this((List$ListStyle)skin.get(string, List$ListStyle.class));
    }

    public List(List$ListStyle list$ListStyle) {
        this.selection.a(this);
        this.selection.q();
        this.setStyle(list$ListStyle);
        List list = this;
        list.setSize(((Widget)list).getPrefWidth(), ((Widget)this).getPrefHeight());
        this.keyListener = new g(this);
        this.addListener(this.keyListener);
        this.addListener(new com.badlogic.gdx.scenes.scene2d.ui.h(this));
    }

    public void setStyle(List$ListStyle list$ListStyle) {
        if (list$ListStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = list$ListStyle;
        this.invalidateHierarchy();
    }

    @Override
    public List$ListStyle getStyle() {
        return this.style;
    }

    @Override
    public void layout() {
        BitmapFont bitmapFont = this.style.font;
        k k2 = this.style.selection;
        this.itemHeight = bitmapFont.getCapHeight() - bitmapFont.getDescent() * 2.0f;
        this.itemHeight += k2.c() + k2.d();
        this.prefWidth = 0.0f;
        Pool pool = Pools.get(GlyphLayout::new);
        GlyphLayout glyphLayout = (GlyphLayout)pool.obtain();
        for (int i2 = 0; i2 < this.items.size; ++i2) {
            List list = this;
            glyphLayout.setText(bitmapFont, list.toString(list.items.get(i2)));
            this.prefWidth = Math.max(glyphLayout.width, this.prefWidth);
        }
        pool.free(glyphLayout);
        this.prefWidth += k2.a() + k2.b();
        this.prefHeight = (float)this.items.size * this.itemHeight;
        k k3 = this.style.background;
        if (k3 != null) {
            this.prefWidth = Math.max(this.prefWidth + k3.a() + k3.b(), k3.e());
            this.prefHeight = Math.max(this.prefHeight + k3.c() + k3.d(), k3.f());
        }
    }

    @Override
    public void draw(Batch batch, float f2) {
        float f3;
        this.validate();
        this.drawBackground(batch, f2);
        BitmapFont bitmapFont = this.style.font;
        k k2 = this.style.selection;
        Color color = this.style.fontColorSelected;
        Color color2 = this.style.fontColorUnselected;
        Color color3 = this.getColor();
        batch.setColor(color3.r, color3.g, color3.b, color3.a * f2);
        float f4 = this.getX();
        float f5 = this.getY();
        float f6 = this.getWidth();
        float f7 = this.getHeight();
        k k3 = this.style.background;
        if (k3 != null) {
            f3 = k3.a();
            f4 += f3;
            f7 -= k3.c();
            f6 -= f3 + k3.b();
        }
        f3 = k2.a();
        float f8 = f6 - f3 - k2.b();
        float f9 = k2.c() - bitmapFont.getDescent();
        bitmapFont.setColor(color2.r, color2.g, color2.b, color2.a * f2);
        for (int i2 = 0; i2 < this.items.size; ++i2) {
            if (this.cullingArea == null || f7 - this.itemHeight <= this.cullingArea.y + this.cullingArea.height && f7 >= this.cullingArea.y) {
                Object object = this.items.get(i2);
                boolean bl2 = this.selection.c(object);
                k k4 = null;
                if (this.pressedIndex == i2 && this.style.down != null) {
                    k4 = this.style.down;
                } else if (bl2) {
                    k4 = k2;
                    bitmapFont.setColor(color.r, color.g, color.b, color.a * f2);
                } else if (this.overIndex == i2 && this.style.over != null) {
                    k4 = this.style.over;
                }
                this.drawSelection(batch, k4, f4, f5 + f7 - this.itemHeight, f6, this.itemHeight);
                this.drawItem(batch, bitmapFont, i2, object, f4 + f3, f5 + f7 - f9, f8);
                if (bl2) {
                    bitmapFont.setColor(color2.r, color2.g, color2.b, color2.a * f2);
                }
            } else if (f7 < this.cullingArea.y) break;
            f7 -= this.itemHeight;
        }
    }

    protected void drawSelection(Batch batch, k k2, float f2, float f3, float f4, float f5) {
        if (k2 != null) {
            k2.a(batch, f2, f3, f4, f5);
        }
    }

    protected void drawBackground(Batch batch, float f2) {
        if (this.style.background != null) {
            Color color = this.getColor();
            batch.setColor(color.r, color.g, color.b, color.a * f2);
            this.style.background.a(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    protected GlyphLayout drawItem(Batch batch, BitmapFont bitmapFont, int n2, Object object, float f2, float f3, float f4) {
        String string = this.toString(object);
        return bitmapFont.draw(batch, string, f2, f3, 0, string.length(), f4, this.alignment, false, "...");
    }

    public d getSelection() {
        return this.selection;
    }

    public void setSelection(d d2) {
        this.selection = d2;
    }

    public Object getSelected() {
        return this.selection.h();
    }

    public void setSelected(Object object) {
        if (this.items.contains(object, false)) {
            this.selection.b(object);
            return;
        }
        if (this.selection.p() && this.items.size > 0) {
            this.selection.b(this.items.first());
            return;
        }
        this.selection.l();
    }

    public int getSelectedIndex() {
        OrderedSet orderedSet = this.selection.g();
        if (orderedSet.size == 0) {
            return -1;
        }
        return this.items.indexOf(((ObjectSet)orderedSet).first(), false);
    }

    public void setSelectedIndex(int n2) {
        if (n2 < -1 || n2 >= this.items.size) {
            throw new IllegalArgumentException("index must be >= -1 and < " + this.items.size + ": " + n2);
        }
        if (n2 == -1) {
            this.selection.l();
            return;
        }
        this.selection.b(this.items.get(n2));
    }

    public Object getOverItem() {
        if (this.overIndex == -1) {
            return null;
        }
        return this.items.get(this.overIndex);
    }

    public Object getPressedItem() {
        if (this.pressedIndex == -1) {
            return null;
        }
        return this.items.get(this.pressedIndex);
    }

    public Object getItemAt(float f2) {
        int n2 = this.getItemIndexAt(f2);
        if (n2 == -1) {
            return null;
        }
        return this.items.get(n2);
    }

    public int getItemIndexAt(float f2) {
        int n2;
        float f3 = this.getHeight();
        k k2 = this.style.background;
        if (k2 != null) {
            f3 -= k2.c() + k2.d();
            f2 -= k2.d();
        }
        if ((n2 = (int)((f3 - f2) / this.itemHeight)) < 0 || n2 >= this.items.size) {
            return -1;
        }
        return n2;
    }

    public void setItems(Object ... objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float f2 = ((Widget)this).getPrefWidth();
        float f3 = ((Widget)this).getPrefHeight();
        this.items.clear();
        this.items.addAll(objectArray);
        this.overIndex = -1;
        this.pressedIndex = -1;
        this.selection.c();
        this.invalidate();
        if (f2 != ((Widget)this).getPrefWidth() || f3 != ((Widget)this).getPrefHeight()) {
            this.invalidateHierarchy();
        }
    }

    public void setItems(Array array) {
        if (array == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float f2 = ((Widget)this).getPrefWidth();
        float f3 = ((Widget)this).getPrefHeight();
        if (array != this.items) {
            this.items.clear();
            this.items.addAll(array);
        }
        this.overIndex = -1;
        this.pressedIndex = -1;
        this.selection.c();
        this.invalidate();
        if (f2 != ((Widget)this).getPrefWidth() || f3 != ((Widget)this).getPrefHeight()) {
            this.invalidateHierarchy();
        }
    }

    public void clearItems() {
        if (this.items.size == 0) {
            return;
        }
        this.items.clear();
        this.overIndex = -1;
        this.pressedIndex = -1;
        this.selection.l();
        this.invalidateHierarchy();
    }

    public Array getItems() {
        return this.items;
    }

    public float getItemHeight() {
        return this.itemHeight;
    }

    @Override
    public float getPrefWidth() {
        this.validate();
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        this.validate();
        return this.prefHeight;
    }

    public String toString(Object object) {
        return object.toString();
    }

    @Override
    public void setCullingArea(Rectangle rectangle) {
        this.cullingArea = rectangle;
    }

    public Rectangle getCullingArea() {
        return this.cullingArea;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setTypeToSelect(boolean bl2) {
        this.typeToSelect = bl2;
    }

    public h getKeyListener() {
        return this.keyListener;
    }
}

