/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Button$ButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton$ImageTextButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Label$LabelStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton$TextButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.Scaling;

public class ImageTextButton
extends Button {
    private final Image image;
    private Label label;
    private ImageTextButton$ImageTextButtonStyle style;

    public ImageTextButton(String string, Skin skin) {
        this(string, (ImageTextButton$ImageTextButtonStyle)skin.get(ImageTextButton$ImageTextButtonStyle.class));
        this.setSkin(skin);
    }

    public ImageTextButton(String string, Skin skin, String string2) {
        this(string, (ImageTextButton$ImageTextButtonStyle)skin.get(string2, ImageTextButton$ImageTextButtonStyle.class));
        this.setSkin(skin);
    }

    public ImageTextButton(String string, ImageTextButton$ImageTextButtonStyle imageTextButton$ImageTextButtonStyle) {
        super(imageTextButton$ImageTextButtonStyle);
        this.style = imageTextButton$ImageTextButtonStyle;
        this.defaults().space(3.0f);
        this.image = this.newImage();
        this.label = this.newLabel(string, new Label$LabelStyle(imageTextButton$ImageTextButtonStyle.font, imageTextButton$ImageTextButtonStyle.fontColor));
        this.label.setAlignment(1);
        ImageTextButton imageTextButton = this;
        imageTextButton.add((b)imageTextButton.image);
        ImageTextButton imageTextButton2 = this;
        imageTextButton2.add((b)imageTextButton2.label);
        ((Button)this).setStyle(imageTextButton$ImageTextButtonStyle);
        ImageTextButton imageTextButton3 = this;
        imageTextButton3.setSize(((WidgetGroup)imageTextButton3).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    protected Image newImage() {
        return new Image(null, Scaling.fit);
    }

    protected Label newLabel(String string, Label$LabelStyle label$LabelStyle) {
        return new Label((CharSequence)string, label$LabelStyle);
    }

    @Override
    public void setStyle(Button$ButtonStyle button$ButtonStyle) {
        if (!(button$ButtonStyle instanceof ImageTextButton$ImageTextButtonStyle)) {
            throw new IllegalArgumentException("style must be a ImageTextButtonStyle.");
        }
        this.style = (ImageTextButton$ImageTextButtonStyle)button$ButtonStyle;
        super.setStyle(button$ButtonStyle);
        if (this.image != null) {
            this.updateImage();
        }
        if (this.label != null) {
            button$ButtonStyle = (ImageTextButton$ImageTextButtonStyle)button$ButtonStyle;
            Label$LabelStyle label$LabelStyle = this.label.getStyle();
            this.label.getStyle().font = ((TextButton$TextButtonStyle)button$ButtonStyle).font;
            label$LabelStyle.fontColor = this.getFontColor();
            this.label.setStyle(label$LabelStyle);
        }
    }

    @Override
    public ImageTextButton$ImageTextButtonStyle getStyle() {
        return this.style;
    }

    protected k getImageDrawable() {
        if (this.isDisabled() && this.style.imageDisabled != null) {
            return this.style.imageDisabled;
        }
        if (this.isPressed()) {
            if (this.isChecked() && this.style.imageCheckedDown != null) {
                return this.style.imageCheckedDown;
            }
            if (this.style.imageDown != null) {
                return this.style.imageDown;
            }
        }
        if (this.isOver()) {
            if (this.isChecked()) {
                if (this.style.imageCheckedOver != null) {
                    return this.style.imageCheckedOver;
                }
            } else if (this.style.imageOver != null) {
                return this.style.imageOver;
            }
        }
        if (this.isChecked()) {
            if (this.style.imageChecked != null) {
                return this.style.imageChecked;
            }
            if (this.isOver() && this.style.imageOver != null) {
                return this.style.imageOver;
            }
        }
        return this.style.imageUp;
    }

    protected void updateImage() {
        this.image.setDrawable(this.getImageDrawable());
    }

    protected Color getFontColor() {
        if (this.isDisabled() && this.style.disabledFontColor != null) {
            return this.style.disabledFontColor;
        }
        if (this.isPressed()) {
            if (this.isChecked() && this.style.checkedDownFontColor != null) {
                return this.style.checkedDownFontColor;
            }
            if (this.style.downFontColor != null) {
                return this.style.downFontColor;
            }
        }
        if (this.isOver()) {
            if (this.isChecked()) {
                if (this.style.checkedOverFontColor != null) {
                    return this.style.checkedOverFontColor;
                }
            } else if (this.style.overFontColor != null) {
                return this.style.overFontColor;
            }
        }
        boolean bl2 = this.hasKeyboardFocus();
        if (this.isChecked()) {
            if (bl2 && this.style.checkedFocusedFontColor != null) {
                return this.style.checkedFocusedFontColor;
            }
            if (this.style.checkedFontColor != null) {
                return this.style.checkedFontColor;
            }
            if (this.isOver() && this.style.overFontColor != null) {
                return this.style.overFontColor;
            }
        }
        if (bl2 && this.style.focusedFontColor != null) {
            return this.style.focusedFontColor;
        }
        return this.style.fontColor;
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.updateImage();
        this.label.getStyle().fontColor = this.getFontColor();
        super.draw(batch, f2);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        ImageTextButton imageTextButton = this;
        return imageTextButton.getCell(imageTextButton.image);
    }

    public void setLabel(Label label) {
        this.getLabelCell().setActor(label);
        this.label = label;
    }

    public Label getLabel() {
        return this.label;
    }

    public Cell getLabelCell() {
        ImageTextButton imageTextButton = this;
        return imageTextButton.getCell(imageTextButton.label);
    }

    public void setText(CharSequence charSequence) {
        this.label.setText(charSequence);
    }

    public CharSequence getText() {
        return this.label.getText();
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        return (string.indexOf(36) != -1 ? "ImageTextButton " : "") + string + ": " + this.image.getDrawable() + " " + this.label.getText();
    }
}

