/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Button$ButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton$ImageButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.Scaling;

public class ImageButton
extends Button {
    private final Image image = this.newImage();
    private ImageButton$ImageButtonStyle style;

    public ImageButton(Skin skin) {
        this((ImageButton$ImageButtonStyle)skin.get(ImageButton$ImageButtonStyle.class));
        this.setSkin(skin);
    }

    public ImageButton(Skin skin, String string) {
        this((ImageButton$ImageButtonStyle)skin.get(string, ImageButton$ImageButtonStyle.class));
        this.setSkin(skin);
    }

    public ImageButton(ImageButton$ImageButtonStyle imageButton$ImageButtonStyle) {
        super(imageButton$ImageButtonStyle);
        ImageButton imageButton = this;
        imageButton.add((b)imageButton.image);
        ((Button)this).setStyle(imageButton$ImageButtonStyle);
        ImageButton imageButton2 = this;
        imageButton2.setSize(((WidgetGroup)imageButton2).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    public ImageButton(k k2) {
        this(new ImageButton$ImageButtonStyle(null, null, null, k2, null, null));
    }

    public ImageButton(k k2, k k3) {
        this(new ImageButton$ImageButtonStyle(null, null, null, k2, k3, null));
    }

    public ImageButton(k k2, k k3, k k4) {
        this(new ImageButton$ImageButtonStyle(null, null, null, k2, k3, k4));
    }

    protected Image newImage() {
        return new Image(null, Scaling.fit);
    }

    @Override
    public void setStyle(Button$ButtonStyle button$ButtonStyle) {
        if (!(button$ButtonStyle instanceof ImageButton$ImageButtonStyle)) {
            throw new IllegalArgumentException("style must be an ImageButtonStyle.");
        }
        this.style = (ImageButton$ImageButtonStyle)button$ButtonStyle;
        super.setStyle(button$ButtonStyle);
        if (this.image != null) {
            this.updateImage();
        }
    }

    @Override
    public ImageButton$ImageButtonStyle getStyle() {
        return this.style;
    }

    protected k getImageDrawable() {
        if (this.isDisabled() && this.style.imageDisabled != null) {
            return this.style.imageDisabled;
        }
        if (this.isPressed()) {
            if (this.isChecked() && this.style.imageCheckedDown != null) {
                return this.style.imageCheckedDown;
            }
            if (this.style.imageDown != null) {
                return this.style.imageDown;
            }
        }
        if (this.isOver()) {
            if (this.isChecked()) {
                if (this.style.imageCheckedOver != null) {
                    return this.style.imageCheckedOver;
                }
            } else if (this.style.imageOver != null) {
                return this.style.imageOver;
            }
        }
        if (this.isChecked()) {
            if (this.style.imageChecked != null) {
                return this.style.imageChecked;
            }
            if (this.isOver() && this.style.imageOver != null) {
                return this.style.imageOver;
            }
        }
        return this.style.imageUp;
    }

    protected void updateImage() {
        this.image.setDrawable(this.getImageDrawable());
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.updateImage();
        super.draw(batch, f2);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        ImageButton imageButton = this;
        return imageButton.getCell(imageButton.image);
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        return (string.indexOf(36) != -1 ? "ImageButton " : "") + string + ": " + this.image.getDrawable();
    }
}

