/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.b.q;
import com.badlogic.gdx.scenes.scene2d.b.u;
import com.badlogic.gdx.scenes.scene2d.b.w;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.utils.Scaling;

public class Image
extends Widget {
    private Scaling scaling;
    private int align = 1;
    private float imageX;
    private float imageY;
    private float imageWidth;
    private float imageHeight;
    private k drawable;

    public Image() {
        this((k)null);
    }

    public Image(NinePatch ninePatch) {
        this(new q(ninePatch), Scaling.stretch, 1);
    }

    public Image(TextureRegion textureRegion) {
        this(new u(textureRegion), Scaling.stretch, 1);
    }

    public Image(Texture texture) {
        this(new u(new TextureRegion(texture)));
    }

    public Image(Skin skin, String string) {
        this(skin.getDrawable(string), Scaling.stretch, 1);
    }

    public Image(k k2) {
        this(k2, Scaling.stretch, 1);
    }

    public Image(k k2, Scaling scaling) {
        this(k2, scaling, 1);
    }

    public Image(k k2, Scaling scaling, int n2) {
        this.setDrawable(k2);
        this.scaling = scaling;
        this.align = n2;
        Image image = this;
        image.setSize(((Widget)image).getPrefWidth(), ((Widget)this).getPrefHeight());
    }

    @Override
    public void layout() {
        if (this.drawable == null) {
            return;
        }
        float f2 = this.drawable.e();
        float f3 = this.drawable.f();
        float f4 = this.getWidth();
        float f5 = this.getHeight();
        Vector2 vector2 = this.scaling.apply(f2, f3, f4, f5);
        this.imageWidth = vector2.x;
        this.imageHeight = vector2.y;
        this.imageX = (this.align & 8) != 0 ? 0.0f : ((this.align & 0x10) != 0 ? (float)((int)(f4 - this.imageWidth)) : (float)((int)(f4 / 2.0f - this.imageWidth / 2.0f)));
        if ((this.align & 2) != 0) {
            this.imageY = (int)(f5 - this.imageHeight);
            return;
        }
        if ((this.align & 4) != 0) {
            this.imageY = 0.0f;
            return;
        }
        this.imageY = (int)(f5 / 2.0f - this.imageHeight / 2.0f);
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.validate();
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * f2);
        f2 = this.getX();
        float f3 = this.getY();
        float f4 = this.getScaleX();
        float f5 = this.getScaleY();
        if (this.drawable instanceof w) {
            float f6 = this.getRotation();
            if (f4 != 1.0f || f5 != 1.0f || f6 != 0.0f) {
                ((w)this.drawable).a(batch, f2 + this.imageX, f3 + this.imageY, this.getOriginX() - this.imageX, this.getOriginY() - this.imageY, this.imageWidth, this.imageHeight, f4, f5, f6);
                return;
            }
        }
        if (this.drawable != null) {
            this.drawable.a(batch, f2 + this.imageX, f3 + this.imageY, this.imageWidth * f4, this.imageHeight * f5);
        }
    }

    public void setDrawable(Skin skin, String string) {
        this.setDrawable(skin.getDrawable(string));
    }

    public void setDrawable(k k2) {
        if (this.drawable == k2) {
            return;
        }
        if (k2 != null) {
            if (((Widget)this).getPrefWidth() != k2.e() || ((Widget)this).getPrefHeight() != k2.f()) {
                this.invalidateHierarchy();
            }
        } else {
            this.invalidateHierarchy();
        }
        this.drawable = k2;
    }

    public k getDrawable() {
        return this.drawable;
    }

    public void setScaling(Scaling scaling) {
        if (scaling == null) {
            throw new IllegalArgumentException("scaling cannot be null.");
        }
        this.scaling = scaling;
        this.invalidate();
    }

    public void setAlign(int n2) {
        this.align = n2;
        this.invalidate();
    }

    public int getAlign() {
        return this.align;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public float getPrefWidth() {
        if (this.drawable != null) {
            return this.drawable.e();
        }
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.drawable != null) {
            return this.drawable.f();
        }
        return 0.0f;
    }

    public float getImageX() {
        return this.imageX;
    }

    public float getImageY() {
        return this.imageY;
    }

    public float getImageWidth() {
        return this.imageWidth;
    }

    public float getImageHeight() {
        return this.imageHeight;
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        return (string.indexOf(36) != -1 ? "Image " : "") + string + ": " + this.drawable;
    }
}

