/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.a;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.l;
import com.badlogic.gdx.scenes.scene2d.h;
import com.badlogic.gdx.scenes.scene2d.j;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Label$LabelStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton$TextButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.ui.Window$WindowStyle;
import com.badlogic.gdx.scenes.scene2d.ui.c;
import com.badlogic.gdx.scenes.scene2d.ui.d;
import com.badlogic.gdx.scenes.scene2d.ui.e;
import com.badlogic.gdx.utils.ObjectMap;

public class Dialog
extends Window {
    Table contentTable;
    Table buttonTable;
    private Skin skin;
    ObjectMap values = new ObjectMap();
    boolean cancelHide;
    b previousKeyboardFocus;
    b previousScrollFocus;
    l focusListener;
    protected h ignoreTouchDown = new com.badlogic.gdx.scenes.scene2d.ui.b(this);

    public Dialog(String string, Skin skin) {
        super(string, (Window$WindowStyle)skin.get(Window$WindowStyle.class));
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public Dialog(String string, Skin skin, String string2) {
        super(string, (Window$WindowStyle)skin.get(string2, Window$WindowStyle.class));
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public Dialog(String string, Window$WindowStyle window$WindowStyle) {
        super(string, window$WindowStyle);
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        this.defaults().space(6.0f);
        this.contentTable = new Table(this.skin);
        this.add((b)this.contentTable).grow();
        this.row();
        this.buttonTable = new Table(this.skin);
        this.add((b)this.buttonTable).fillX();
        this.contentTable.defaults().space(6.0f);
        this.buttonTable.defaults().space(6.0f);
        this.buttonTable.addListener(new c(this));
        this.focusListener = new d(this);
    }

    @Override
    protected void setStage(j j2) {
        if (j2 == null) {
            Dialog dialog = this;
            dialog.addListener(dialog.focusListener);
        } else {
            Dialog dialog = this;
            dialog.removeListener(dialog.focusListener);
        }
        super.setStage(j2);
    }

    public Table getContentTable() {
        return this.contentTable;
    }

    public Table getButtonTable() {
        return this.buttonTable;
    }

    public Dialog text(String string) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.text(string, (Label$LabelStyle)this.skin.get(Label$LabelStyle.class));
    }

    public Dialog text(String string, Label$LabelStyle label$LabelStyle) {
        return this.text(new Label((CharSequence)string, label$LabelStyle));
    }

    public Dialog text(Label label) {
        this.contentTable.add((b)label);
        return this;
    }

    public Dialog button(String string) {
        return this.button(string, null);
    }

    public Dialog button(String string, Object object) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.button(string, object, (TextButton$TextButtonStyle)this.skin.get(TextButton$TextButtonStyle.class));
    }

    public Dialog button(String string, Object object, TextButton$TextButtonStyle textButton$TextButtonStyle) {
        return this.button(new TextButton(string, textButton$TextButtonStyle), object);
    }

    public Dialog button(Button button) {
        return this.button(button, null);
    }

    public Dialog button(Button button, Object object) {
        this.buttonTable.add((b)button);
        this.setObject(button, object);
        return this;
    }

    public Dialog show(j j2, a a2) {
        this.clearActions();
        Dialog dialog = this;
        dialog.removeCaptureListener(dialog.ignoreTouchDown);
        this.previousKeyboardFocus = null;
        b b2 = j2.e();
        if (b2 != null && !b2.isDescendantOf(this)) {
            this.previousKeyboardFocus = b2;
        }
        this.previousScrollFocus = null;
        b2 = j2.f();
        if (b2 != null && !b2.isDescendantOf(this)) {
            this.previousScrollFocus = b2;
        }
        j2.a(this);
        this.pack();
        j2.b();
        j2.d(this);
        j2.e(this);
        if (a2 != null) {
            this.addAction(a2);
        }
        return this;
    }

    public Dialog show(j j2) {
        this.show(j2, com.badlogic.gdx.scenes.scene2d.a.a.a((a)com.badlogic.gdx.scenes.scene2d.a.a.c(0.0f), com.badlogic.gdx.scenes.scene2d.a.a.b(0.4f, Interpolation.fade)));
        this.setPosition(Math.round((j2.g() - this.getWidth()) / 2.0f), Math.round((j2.h() - this.getHeight()) / 2.0f));
        return this;
    }

    public void hide(a a2) {
        j j2 = this.getStage();
        if (j2 != null) {
            b b2;
            Dialog dialog = this;
            dialog.removeListener(dialog.focusListener);
            if (this.previousKeyboardFocus != null && this.previousKeyboardFocus.getStage() == null) {
                this.previousKeyboardFocus = null;
            }
            if ((b2 = j2.e()) == null || b2.isDescendantOf(this)) {
                j2.d(this.previousKeyboardFocus);
            }
            if (this.previousScrollFocus != null && this.previousScrollFocus.getStage() == null) {
                this.previousScrollFocus = null;
            }
            if ((b2 = j2.f()) == null || b2.isDescendantOf(this)) {
                j2.e(this.previousScrollFocus);
            }
        }
        if (a2 != null) {
            Dialog dialog = this;
            dialog.addCaptureListener(dialog.ignoreTouchDown);
            this.addAction(com.badlogic.gdx.scenes.scene2d.a.a.a(a2, com.badlogic.gdx.scenes.scene2d.a.a.a(this.ignoreTouchDown), com.badlogic.gdx.scenes.scene2d.a.a.c()));
            return;
        }
        this.remove();
    }

    public void hide() {
        this.hide(com.badlogic.gdx.scenes.scene2d.a.a.a(0.4f, Interpolation.fade));
    }

    public void setObject(b b2, Object object) {
        this.values.put(b2, object);
    }

    public Dialog key(int n2, Object object) {
        this.addListener(new e(this, n2, object));
        return this;
    }

    protected void result(Object object) {
    }

    public void cancel() {
        this.cancelHide = true;
    }
}

