/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.i;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.b.p;
import com.badlogic.gdx.scenes.scene2d.l;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.ui.Value$Fixed;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;

public class Container
extends WidgetGroup {
    private b actor;
    private Value minWidth = Value.minWidth;
    private Value minHeight = Value.minHeight;
    private Value prefWidth = Value.prefWidth;
    private Value prefHeight = Value.prefHeight;
    private Value maxWidth = Value.zero;
    private Value maxHeight = Value.zero;
    private Value padTop = Value.zero;
    private Value padLeft = Value.zero;
    private Value padBottom = Value.zero;
    private Value padRight = Value.zero;
    private float fillX;
    private float fillY;
    private int align;
    private k background;
    private boolean clip;
    private boolean round = true;
    private Rectangle actorCulling;

    public Container() {
        this.setTouchable(l.c);
        this.setTransform(false);
    }

    public Container(b b2) {
        this();
        this.setActor(b2);
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(batch, this.computeTransform());
            this.drawBackground(batch, f2, 0.0f, 0.0f);
            if (this.clip) {
                batch.flush();
                float f3 = this.padLeft.get(this);
                float f4 = this.padBottom.get(this);
                if (this.clipBegin(f3, f4, this.getWidth() - f3 - this.padRight.get(this), this.getHeight() - f4 - this.padTop.get(this))) {
                    this.drawChildren(batch, f2);
                    batch.flush();
                    this.clipEnd();
                }
            } else {
                this.drawChildren(batch, f2);
            }
            this.resetTransform(batch);
            return;
        }
        this.drawBackground(batch, f2, this.getX(), this.getY());
        super.draw(batch, f2);
    }

    protected void drawBackground(Batch batch, float f2, float f3, float f4) {
        if (this.background == null) {
            return;
        }
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * f2);
        this.background.a(batch, f3, f4, this.getWidth(), this.getHeight());
    }

    public void setBackground(k k2) {
        this.setBackground(k2, true);
    }

    public void setBackground(k k2, boolean bl2) {
        if (this.background == k2) {
            return;
        }
        this.background = k2;
        if (bl2) {
            if (k2 == null) {
                this.pad(Value.zero);
            } else {
                this.pad(k2.c(), k2.a(), k2.d(), k2.b());
            }
            this.invalidate();
        }
    }

    public Container background(k k2) {
        this.setBackground(k2);
        return this;
    }

    public k getBackground() {
        return this.background;
    }

    @Override
    public void layout() {
        if (this.actor == null) {
            return;
        }
        float f2 = this.padLeft.get(this);
        float f3 = this.padBottom.get(this);
        float f4 = this.getWidth() - f2 - this.padRight.get(this);
        float f5 = this.getHeight() - f3 - this.padTop.get(this);
        float f6 = this.minWidth.get(this.actor);
        float f7 = this.minHeight.get(this.actor);
        float f8 = this.prefWidth.get(this.actor);
        float f9 = this.prefHeight.get(this.actor);
        float f10 = this.maxWidth.get(this.actor);
        float f11 = this.maxHeight.get(this.actor);
        f8 = this.fillX > 0.0f ? f4 * this.fillX : Math.min(f8, f4);
        if (f8 < f6) {
            f8 = f6;
        }
        if (f10 > 0.0f && f8 > f10) {
            f8 = f10;
        }
        if ((f6 = this.fillY > 0.0f ? f5 * this.fillY : Math.min(f9, f5)) < f7) {
            f6 = f7;
        }
        if (f11 > 0.0f && f6 > f11) {
            f6 = f11;
        }
        if ((this.align & 0x10) != 0) {
            f2 += f4 - f8;
        } else if ((this.align & 8) == 0) {
            f2 += (f4 - f8) / 2.0f;
        }
        if ((this.align & 2) != 0) {
            f3 += f5 - f6;
        } else if ((this.align & 4) == 0) {
            f3 += (f5 - f6) / 2.0f;
        }
        if (this.round) {
            f2 = (float)Math.floor(f2);
            f3 = (float)Math.floor(f3);
            f8 = (float)Math.ceil(f8);
            f6 = (float)Math.ceil(f6);
        }
        this.actor.setBounds(f2, f3, f8, f6);
        if (this.actor instanceof p) {
            ((p)((Object)this.actor)).validate();
        }
    }

    @Override
    public void setCullingArea(Rectangle rectangle) {
        super.setCullingArea(rectangle);
        if (this.actor instanceof i) {
            if (rectangle != null) {
                if (this.actorCulling == null) {
                    this.actorCulling = new Rectangle();
                }
                this.actorCulling.x = rectangle.x - this.actor.getX();
                this.actorCulling.y = rectangle.y - this.actor.getY();
                this.actorCulling.width = rectangle.width;
                this.actorCulling.height = rectangle.height;
                rectangle = this.actorCulling;
            }
            ((i)((Object)this.actor)).setCullingArea(rectangle);
        }
    }

    public void setActor(b b2) {
        if (b2 == this) {
            throw new IllegalArgumentException("actor cannot be the Container.");
        }
        if (b2 == this.actor) {
            return;
        }
        if (this.actor != null) {
            Container container = this;
            super.removeActor(container.actor);
        }
        this.actor = b2;
        if (b2 != null) {
            super.addActor(b2);
        }
    }

    public b getActor() {
        return this.actor;
    }

    @Override
    public void addActor(b b2) {
        throw new UnsupportedOperationException("Use Container#setActor.");
    }

    @Override
    public void addActorAt(int n2, b b2) {
        throw new UnsupportedOperationException("Use Container#setActor.");
    }

    @Override
    public void addActorBefore(b b2, b b3) {
        throw new UnsupportedOperationException("Use Container#setActor.");
    }

    @Override
    public void addActorAfter(b b2, b b3) {
        throw new UnsupportedOperationException("Use Container#setActor.");
    }

    @Override
    public boolean removeActor(b b2) {
        if (b2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (b2 != this.actor) {
            return false;
        }
        this.setActor(null);
        return true;
    }

    @Override
    public boolean removeActor(b b2, boolean bl2) {
        if (b2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (b2 != this.actor) {
            return false;
        }
        this.actor = null;
        return super.removeActor(b2, bl2);
    }

    @Override
    public b removeActorAt(int n2, boolean bl2) {
        b b2 = super.removeActorAt(n2, bl2);
        if (b2 == this.actor) {
            this.actor = null;
        }
        return b2;
    }

    public Container size(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("size cannot be null.");
        }
        this.minWidth = value;
        this.minHeight = value;
        this.prefWidth = value;
        this.prefHeight = value;
        this.maxWidth = value;
        this.maxHeight = value;
        return this;
    }

    public Container size(Value value, Value value2) {
        if (value == null) {
            throw new IllegalArgumentException("width cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("height cannot be null.");
        }
        this.minWidth = value;
        this.minHeight = value2;
        this.prefWidth = value;
        this.prefHeight = value2;
        this.maxWidth = value;
        this.maxHeight = value2;
        return this;
    }

    public Container size(float f2) {
        this.size(Value$Fixed.valueOf(f2));
        return this;
    }

    public Container size(float f2, float f3) {
        this.size(Value$Fixed.valueOf(f2), Value$Fixed.valueOf(f3));
        return this;
    }

    public Container width(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("width cannot be null.");
        }
        this.minWidth = value;
        this.prefWidth = value;
        this.maxWidth = value;
        return this;
    }

    public Container width(float f2) {
        this.width(Value$Fixed.valueOf(f2));
        return this;
    }

    public Container height(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("height cannot be null.");
        }
        this.minHeight = value;
        this.prefHeight = value;
        this.maxHeight = value;
        return this;
    }

    public Container height(float f2) {
        this.height(Value$Fixed.valueOf(f2));
        return this;
    }

    public Container minSize(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("size cannot be null.");
        }
        this.minWidth = value;
        this.minHeight = value;
        return this;
    }

    public Container minSize(Value value, Value value2) {
        if (value == null) {
            throw new IllegalArgumentException("width cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("height cannot be null.");
        }
        this.minWidth = value;
        this.minHeight = value2;
        return this;
    }

    public Container minWidth(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("minWidth cannot be null.");
        }
        this.minWidth = value;
        return this;
    }

    public Container minHeight(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("minHeight cannot be null.");
        }
        this.minHeight = value;
        return this;
    }

    public Container minSize(float f2) {
        this.minSize(Value$Fixed.valueOf(f2));
        return this;
    }

    public Container minSize(float f2, float f3) {
        this.minSize(Value$Fixed.valueOf(f2), Value$Fixed.valueOf(f3));
        return this;
    }

    public Container minWidth(float f2) {
        this.minWidth = Value$Fixed.valueOf(f2);
        return this;
    }

    public Container minHeight(float f2) {
        this.minHeight = Value$Fixed.valueOf(f2);
        return this;
    }

    public Container prefSize(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("size cannot be null.");
        }
        this.prefWidth = value;
        this.prefHeight = value;
        return this;
    }

    public Container prefSize(Value value, Value value2) {
        if (value == null) {
            throw new IllegalArgumentException("width cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("height cannot be null.");
        }
        this.prefWidth = value;
        this.prefHeight = value2;
        return this;
    }

    public Container prefWidth(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("prefWidth cannot be null.");
        }
        this.prefWidth = value;
        return this;
    }

    public Container prefHeight(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("prefHeight cannot be null.");
        }
        this.prefHeight = value;
        return this;
    }

    public Container prefSize(float f2, float f3) {
        this.prefSize(Value$Fixed.valueOf(f2), Value$Fixed.valueOf(f3));
        return this;
    }

    public Container prefSize(float f2) {
        this.prefSize(Value$Fixed.valueOf(f2));
        return this;
    }

    public Container prefWidth(float f2) {
        this.prefWidth = Value$Fixed.valueOf(f2);
        return this;
    }

    public Container prefHeight(float f2) {
        this.prefHeight = Value$Fixed.valueOf(f2);
        return this;
    }

    public Container maxSize(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("size cannot be null.");
        }
        this.maxWidth = value;
        this.maxHeight = value;
        return this;
    }

    public Container maxSize(Value value, Value value2) {
        if (value == null) {
            throw new IllegalArgumentException("width cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("height cannot be null.");
        }
        this.maxWidth = value;
        this.maxHeight = value2;
        return this;
    }

    public Container maxWidth(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("maxWidth cannot be null.");
        }
        this.maxWidth = value;
        return this;
    }

    public Container maxHeight(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("maxHeight cannot be null.");
        }
        this.maxHeight = value;
        return this;
    }

    public Container maxSize(float f2) {
        this.maxSize(Value$Fixed.valueOf(f2));
        return this;
    }

    public Container maxSize(float f2, float f3) {
        this.maxSize(Value$Fixed.valueOf(f2), Value$Fixed.valueOf(f3));
        return this;
    }

    public Container maxWidth(float f2) {
        this.maxWidth = Value$Fixed.valueOf(f2);
        return this;
    }

    public Container maxHeight(float f2) {
        this.maxHeight = Value$Fixed.valueOf(f2);
        return this;
    }

    public Container pad(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("pad cannot be null.");
        }
        this.padTop = value;
        this.padLeft = value;
        this.padBottom = value;
        this.padRight = value;
        return this;
    }

    public Container pad(Value value, Value value2, Value value3, Value value4) {
        if (value == null) {
            throw new IllegalArgumentException("top cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("left cannot be null.");
        }
        if (value3 == null) {
            throw new IllegalArgumentException("bottom cannot be null.");
        }
        if (value4 == null) {
            throw new IllegalArgumentException("right cannot be null.");
        }
        this.padTop = value;
        this.padLeft = value2;
        this.padBottom = value3;
        this.padRight = value4;
        return this;
    }

    public Container padTop(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padTop cannot be null.");
        }
        this.padTop = value;
        return this;
    }

    public Container padLeft(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padLeft cannot be null.");
        }
        this.padLeft = value;
        return this;
    }

    public Container padBottom(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padBottom cannot be null.");
        }
        this.padBottom = value;
        return this;
    }

    public Container padRight(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padRight cannot be null.");
        }
        this.padRight = value;
        return this;
    }

    public Container pad(float f2) {
        Value$Fixed value$Fixed = Value$Fixed.valueOf(f2);
        this.padTop = value$Fixed;
        this.padLeft = value$Fixed;
        this.padBottom = value$Fixed;
        this.padRight = value$Fixed;
        return this;
    }

    public Container pad(float f2, float f3, float f4, float f5) {
        this.padTop = Value$Fixed.valueOf(f2);
        this.padLeft = Value$Fixed.valueOf(f3);
        this.padBottom = Value$Fixed.valueOf(f4);
        this.padRight = Value$Fixed.valueOf(f5);
        return this;
    }

    public Container padTop(float f2) {
        this.padTop = Value$Fixed.valueOf(f2);
        return this;
    }

    public Container padLeft(float f2) {
        this.padLeft = Value$Fixed.valueOf(f2);
        return this;
    }

    public Container padBottom(float f2) {
        this.padBottom = Value$Fixed.valueOf(f2);
        return this;
    }

    public Container padRight(float f2) {
        this.padRight = Value$Fixed.valueOf(f2);
        return this;
    }

    public Container fill() {
        this.fillX = 1.0f;
        this.fillY = 1.0f;
        return this;
    }

    public Container fillX() {
        this.fillX = 1.0f;
        return this;
    }

    public Container fillY() {
        this.fillY = 1.0f;
        return this;
    }

    public Container fill(float f2, float f3) {
        this.fillX = f2;
        this.fillY = f3;
        return this;
    }

    public Container fill(boolean bl2, boolean bl3) {
        this.fillX = bl2 ? 1.0f : 0.0f;
        this.fillY = bl3 ? 1.0f : 0.0f;
        return this;
    }

    public Container fill(boolean bl2) {
        this.fillX = bl2 ? 1.0f : 0.0f;
        this.fillY = bl2 ? 1.0f : 0.0f;
        return this;
    }

    public Container align(int n2) {
        this.align = n2;
        return this;
    }

    public Container center() {
        this.align = 1;
        return this;
    }

    public Container top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return this;
    }

    public Container left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return this;
    }

    public Container bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return this;
    }

    public Container right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return this;
    }

    @Override
    public float getMinWidth() {
        return this.minWidth.get(this.actor) + this.padLeft.get(this) + this.padRight.get(this);
    }

    public Value getMinHeightValue() {
        return this.minHeight;
    }

    @Override
    public float getMinHeight() {
        return this.minHeight.get(this.actor) + this.padTop.get(this) + this.padBottom.get(this);
    }

    public Value getPrefWidthValue() {
        return this.prefWidth;
    }

    @Override
    public float getPrefWidth() {
        float f2 = this.prefWidth.get(this.actor);
        if (this.background != null) {
            f2 = Math.max(f2, this.background.e());
        }
        return Math.max(((WidgetGroup)this).getMinWidth(), f2 + this.padLeft.get(this) + this.padRight.get(this));
    }

    public Value getPrefHeightValue() {
        return this.prefHeight;
    }

    @Override
    public float getPrefHeight() {
        float f2 = this.prefHeight.get(this.actor);
        if (this.background != null) {
            f2 = Math.max(f2, this.background.f());
        }
        return Math.max(((WidgetGroup)this).getMinHeight(), f2 + this.padTop.get(this) + this.padBottom.get(this));
    }

    public Value getMaxWidthValue() {
        return this.maxWidth;
    }

    @Override
    public float getMaxWidth() {
        float f2;
        float f3 = this.maxWidth.get(this.actor);
        if (f2 > 0.0f) {
            f3 += this.padLeft.get(this) + this.padRight.get(this);
        }
        return f3;
    }

    public Value getMaxHeightValue() {
        return this.maxHeight;
    }

    @Override
    public float getMaxHeight() {
        float f2;
        float f3 = this.maxHeight.get(this.actor);
        if (f2 > 0.0f) {
            f3 += this.padTop.get(this) + this.padBottom.get(this);
        }
        return f3;
    }

    public Value getPadTopValue() {
        return this.padTop;
    }

    public float getPadTop() {
        return this.padTop.get(this);
    }

    public Value getPadLeftValue() {
        return this.padLeft;
    }

    public float getPadLeft() {
        return this.padLeft.get(this);
    }

    public Value getPadBottomValue() {
        return this.padBottom;
    }

    public float getPadBottom() {
        return this.padBottom.get(this);
    }

    public Value getPadRightValue() {
        return this.padRight;
    }

    public float getPadRight() {
        return this.padRight.get(this);
    }

    public float getPadX() {
        return this.padLeft.get(this) + this.padRight.get(this);
    }

    public float getPadY() {
        return this.padTop.get(this) + this.padBottom.get(this);
    }

    public float getFillX() {
        return this.fillX;
    }

    public float getFillY() {
        return this.fillY;
    }

    public int getAlign() {
        return this.align;
    }

    public void setRound(boolean bl2) {
        this.round = bl2;
    }

    public Container clip() {
        this.setClip(true);
        return this;
    }

    public Container clip(boolean bl2) {
        this.setClip(bl2);
        return this;
    }

    public void setClip(boolean bl2) {
        this.clip = bl2;
        this.setTransform(bl2);
        this.invalidate();
    }

    public boolean getClip() {
        return this.clip;
    }

    @Override
    public b hit(float f2, float f3, boolean bl2) {
        if (this.clip) {
            if (bl2 && this.getTouchable() == l.b) {
                return null;
            }
            if (f2 < 0.0f || f2 >= this.getWidth() || f3 < 0.0f || f3 >= this.getHeight()) {
                return null;
            }
        }
        return super.hit(f2, f3, bl2);
    }

    @Override
    public void drawDebug(ShapeRenderer shapeRenderer) {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(shapeRenderer, this.computeTransform());
            if (this.clip) {
                shapeRenderer.flush();
                float f2 = this.padLeft.get(this);
                float f3 = this.padBottom.get(this);
                if (this.background == null ? this.clipBegin(0.0f, 0.0f, this.getWidth(), this.getHeight()) : this.clipBegin(f2, f3, this.getWidth() - f2 - this.padRight.get(this), this.getHeight() - f3 - this.padTop.get(this))) {
                    this.drawDebugChildren(shapeRenderer);
                    this.clipEnd();
                }
            } else {
                this.drawDebugChildren(shapeRenderer);
            }
            this.resetTransform(shapeRenderer);
            return;
        }
        super.drawDebug(shapeRenderer);
    }
}

