/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.ui.Button$ButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox$CheckBoxStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.Scaling;

public class CheckBox
extends TextButton {
    private Image image;
    private Cell imageCell;
    private CheckBox$CheckBoxStyle style;

    public CheckBox(String string, Skin skin) {
        this(string, (CheckBox$CheckBoxStyle)skin.get(CheckBox$CheckBoxStyle.class));
    }

    public CheckBox(String string, Skin skin, String string2) {
        this(string, (CheckBox$CheckBoxStyle)skin.get(string2, CheckBox$CheckBoxStyle.class));
    }

    public CheckBox(String object, CheckBox$CheckBoxStyle checkBox$CheckBoxStyle) {
        super((String)object, checkBox$CheckBoxStyle);
        object = this.getLabel();
        ((Label)object).setAlignment(8);
        this.image = this.newImage();
        this.image.setDrawable(checkBox$CheckBoxStyle.checkboxOff);
        this.clearChildren();
        this.imageCell = this.add((b)this.image);
        this.add((b)object);
        CheckBox checkBox = this;
        checkBox.setSize(((WidgetGroup)checkBox).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    protected Image newImage() {
        return new Image(null, Scaling.none);
    }

    @Override
    public void setStyle(Button$ButtonStyle button$ButtonStyle) {
        if (!(button$ButtonStyle instanceof CheckBox$CheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a CheckBoxStyle.");
        }
        this.style = (CheckBox$CheckBoxStyle)button$ButtonStyle;
        super.setStyle(button$ButtonStyle);
    }

    @Override
    public CheckBox$CheckBoxStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(Batch batch, float f2) {
        this.image.setDrawable(this.getImageDrawable());
        super.draw(batch, f2);
    }

    protected k getImageDrawable() {
        boolean bl2;
        if (this.isDisabled()) {
            if (this.isChecked && this.style.checkboxOnDisabled != null) {
                return this.style.checkboxOnDisabled;
            }
            return this.style.checkboxOffDisabled;
        }
        boolean bl3 = bl2 = this.isOver() && !this.isDisabled();
        if (this.isChecked && this.style.checkboxOn != null) {
            if (bl2 && this.style.checkboxOnOver != null) {
                return this.style.checkboxOnOver;
            }
            return this.style.checkboxOn;
        }
        if (bl2 && this.style.checkboxOver != null) {
            return this.style.checkboxOver;
        }
        return this.style.checkboxOff;
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.imageCell;
    }
}

