/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.f;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.ui.Value$Fixed;
import com.badlogic.gdx.utils.Pool$Poolable;

public class Cell
implements Pool$Poolable {
    private static final Float zerof = Float.valueOf(0.0f);
    private static final Float onef = Float.valueOf(1.0f);
    private static final Integer zeroi = 0;
    private static final Integer onei;
    private static final Integer centeri;
    private static final Integer topi;
    private static final Integer bottomi;
    private static final Integer lefti;
    private static final Integer righti;
    private static f files;
    private static Cell defaults;
    Value minWidth;
    Value minHeight;
    Value prefWidth;
    Value prefHeight;
    Value maxWidth;
    Value maxHeight;
    Value spaceTop;
    Value spaceLeft;
    Value spaceBottom;
    Value spaceRight;
    Value padTop;
    Value padLeft;
    Value padBottom;
    Value padRight;
    Float fillX;
    Float fillY;
    Integer align;
    Integer expandX;
    Integer expandY;
    Integer colspan;
    Boolean uniformX;
    Boolean uniformY;
    b actor;
    float actorX;
    float actorY;
    float actorWidth;
    float actorHeight;
    private Table table;
    boolean endRow;
    int column;
    int row;
    int cellAboveIndex = -1;
    float computedPadTop;
    float computedPadLeft;
    float computedPadBottom;
    float computedPadRight;

    public Cell() {
        Cell cell = Cell.defaults();
        if (cell != null) {
            this.set(cell);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Cell setActor(b b2) {
        if (this.actor != b2) {
            if (this.actor != null && this.actor.getParent() == this.table) {
                this.actor.remove();
            }
            this.actor = b2;
            if (b2 != null) {
                this.table.addActor(b2);
            }
        }
        return this;
    }

    public Cell clearActor() {
        this.setActor(null);
        return this;
    }

    public b getActor() {
        return this.actor;
    }

    public boolean hasActor() {
        return this.actor != null;
    }

    public Cell size(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("size cannot be null.");
        }
        this.minWidth = value;
        this.minHeight = value;
        this.prefWidth = value;
        this.prefHeight = value;
        this.maxWidth = value;
        this.maxHeight = value;
        return this;
    }

    public Cell size(Value value, Value value2) {
        if (value == null) {
            throw new IllegalArgumentException("width cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("height cannot be null.");
        }
        this.minWidth = value;
        this.minHeight = value2;
        this.prefWidth = value;
        this.prefHeight = value2;
        this.maxWidth = value;
        this.maxHeight = value2;
        return this;
    }

    public Cell size(float f2) {
        this.size(Value$Fixed.valueOf(f2));
        return this;
    }

    public Cell size(float f2, float f3) {
        this.size(Value$Fixed.valueOf(f2), Value$Fixed.valueOf(f3));
        return this;
    }

    public Cell width(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("width cannot be null.");
        }
        this.minWidth = value;
        this.prefWidth = value;
        this.maxWidth = value;
        return this;
    }

    public Cell width(float f2) {
        this.width(Value$Fixed.valueOf(f2));
        return this;
    }

    public Cell height(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("height cannot be null.");
        }
        this.minHeight = value;
        this.prefHeight = value;
        this.maxHeight = value;
        return this;
    }

    public Cell height(float f2) {
        this.height(Value$Fixed.valueOf(f2));
        return this;
    }

    public Cell minSize(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("size cannot be null.");
        }
        this.minWidth = value;
        this.minHeight = value;
        return this;
    }

    public Cell minSize(Value value, Value value2) {
        if (value == null) {
            throw new IllegalArgumentException("width cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("height cannot be null.");
        }
        this.minWidth = value;
        this.minHeight = value2;
        return this;
    }

    public Cell minWidth(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("minWidth cannot be null.");
        }
        this.minWidth = value;
        return this;
    }

    public Cell minHeight(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("minHeight cannot be null.");
        }
        this.minHeight = value;
        return this;
    }

    public Cell minSize(float f2) {
        this.minSize(Value$Fixed.valueOf(f2));
        return this;
    }

    public Cell minSize(float f2, float f3) {
        this.minSize(Value$Fixed.valueOf(f2), Value$Fixed.valueOf(f3));
        return this;
    }

    public Cell minWidth(float f2) {
        this.minWidth = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell minHeight(float f2) {
        this.minHeight = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell prefSize(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("size cannot be null.");
        }
        this.prefWidth = value;
        this.prefHeight = value;
        return this;
    }

    public Cell prefSize(Value value, Value value2) {
        if (value == null) {
            throw new IllegalArgumentException("width cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("height cannot be null.");
        }
        this.prefWidth = value;
        this.prefHeight = value2;
        return this;
    }

    public Cell prefWidth(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("prefWidth cannot be null.");
        }
        this.prefWidth = value;
        return this;
    }

    public Cell prefHeight(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("prefHeight cannot be null.");
        }
        this.prefHeight = value;
        return this;
    }

    public Cell prefSize(float f2, float f3) {
        this.prefSize(Value$Fixed.valueOf(f2), Value$Fixed.valueOf(f3));
        return this;
    }

    public Cell prefSize(float f2) {
        this.prefSize(Value$Fixed.valueOf(f2));
        return this;
    }

    public Cell prefWidth(float f2) {
        this.prefWidth = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell prefHeight(float f2) {
        this.prefHeight = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell maxSize(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("size cannot be null.");
        }
        this.maxWidth = value;
        this.maxHeight = value;
        return this;
    }

    public Cell maxSize(Value value, Value value2) {
        if (value == null) {
            throw new IllegalArgumentException("width cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("height cannot be null.");
        }
        this.maxWidth = value;
        this.maxHeight = value2;
        return this;
    }

    public Cell maxWidth(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("maxWidth cannot be null.");
        }
        this.maxWidth = value;
        return this;
    }

    public Cell maxHeight(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("maxHeight cannot be null.");
        }
        this.maxHeight = value;
        return this;
    }

    public Cell maxSize(float f2) {
        this.maxSize(Value$Fixed.valueOf(f2));
        return this;
    }

    public Cell maxSize(float f2, float f3) {
        this.maxSize(Value$Fixed.valueOf(f2), Value$Fixed.valueOf(f3));
        return this;
    }

    public Cell maxWidth(float f2) {
        this.maxWidth = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell maxHeight(float f2) {
        this.maxHeight = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell space(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("space cannot be null.");
        }
        this.spaceTop = value;
        this.spaceLeft = value;
        this.spaceBottom = value;
        this.spaceRight = value;
        return this;
    }

    public Cell space(Value value, Value value2, Value value3, Value value4) {
        if (value == null) {
            throw new IllegalArgumentException("top cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("left cannot be null.");
        }
        if (value3 == null) {
            throw new IllegalArgumentException("bottom cannot be null.");
        }
        if (value4 == null) {
            throw new IllegalArgumentException("right cannot be null.");
        }
        this.spaceTop = value;
        this.spaceLeft = value2;
        this.spaceBottom = value3;
        this.spaceRight = value4;
        return this;
    }

    public Cell spaceTop(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("spaceTop cannot be null.");
        }
        this.spaceTop = value;
        return this;
    }

    public Cell spaceLeft(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("spaceLeft cannot be null.");
        }
        this.spaceLeft = value;
        return this;
    }

    public Cell spaceBottom(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("spaceBottom cannot be null.");
        }
        this.spaceBottom = value;
        return this;
    }

    public Cell spaceRight(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("spaceRight cannot be null.");
        }
        this.spaceRight = value;
        return this;
    }

    public Cell space(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("space cannot be < 0: ".concat(String.valueOf(f2)));
        }
        this.space(Value$Fixed.valueOf(f2));
        return this;
    }

    public Cell space(float f2, float f3, float f4, float f5) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("top cannot be < 0: ".concat(String.valueOf(f2)));
        }
        if (f3 < 0.0f) {
            throw new IllegalArgumentException("left cannot be < 0: ".concat(String.valueOf(f3)));
        }
        if (f4 < 0.0f) {
            throw new IllegalArgumentException("bottom cannot be < 0: ".concat(String.valueOf(f4)));
        }
        if (f5 < 0.0f) {
            throw new IllegalArgumentException("right cannot be < 0: ".concat(String.valueOf(f5)));
        }
        this.space(Value$Fixed.valueOf(f2), Value$Fixed.valueOf(f3), Value$Fixed.valueOf(f4), Value$Fixed.valueOf(f5));
        return this;
    }

    public Cell spaceTop(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("spaceTop cannot be < 0: ".concat(String.valueOf(f2)));
        }
        this.spaceTop = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell spaceLeft(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("spaceLeft cannot be < 0: ".concat(String.valueOf(f2)));
        }
        this.spaceLeft = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell spaceBottom(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("spaceBottom cannot be < 0: ".concat(String.valueOf(f2)));
        }
        this.spaceBottom = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell spaceRight(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("spaceRight cannot be < 0: ".concat(String.valueOf(f2)));
        }
        this.spaceRight = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell pad(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("pad cannot be null.");
        }
        this.padTop = value;
        this.padLeft = value;
        this.padBottom = value;
        this.padRight = value;
        return this;
    }

    public Cell pad(Value value, Value value2, Value value3, Value value4) {
        if (value == null) {
            throw new IllegalArgumentException("top cannot be null.");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("left cannot be null.");
        }
        if (value3 == null) {
            throw new IllegalArgumentException("bottom cannot be null.");
        }
        if (value4 == null) {
            throw new IllegalArgumentException("right cannot be null.");
        }
        this.padTop = value;
        this.padLeft = value2;
        this.padBottom = value3;
        this.padRight = value4;
        return this;
    }

    public Cell padTop(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padTop cannot be null.");
        }
        this.padTop = value;
        return this;
    }

    public Cell padLeft(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padLeft cannot be null.");
        }
        this.padLeft = value;
        return this;
    }

    public Cell padBottom(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padBottom cannot be null.");
        }
        this.padBottom = value;
        return this;
    }

    public Cell padRight(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("padRight cannot be null.");
        }
        this.padRight = value;
        return this;
    }

    public Cell pad(float f2) {
        this.pad(Value$Fixed.valueOf(f2));
        return this;
    }

    public Cell pad(float f2, float f3, float f4, float f5) {
        this.pad(Value$Fixed.valueOf(f2), Value$Fixed.valueOf(f3), Value$Fixed.valueOf(f4), Value$Fixed.valueOf(f5));
        return this;
    }

    public Cell padTop(float f2) {
        this.padTop = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell padLeft(float f2) {
        this.padLeft = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell padBottom(float f2) {
        this.padBottom = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell padRight(float f2) {
        this.padRight = Value$Fixed.valueOf(f2);
        return this;
    }

    public Cell fill() {
        this.fillX = onef;
        this.fillY = onef;
        return this;
    }

    public Cell fillX() {
        this.fillX = onef;
        return this;
    }

    public Cell fillY() {
        this.fillY = onef;
        return this;
    }

    public Cell fill(float f2, float f3) {
        this.fillX = Float.valueOf(f2);
        this.fillY = Float.valueOf(f3);
        return this;
    }

    public Cell fill(boolean bl2, boolean bl3) {
        this.fillX = bl2 ? onef : zerof;
        this.fillY = bl3 ? onef : zerof;
        return this;
    }

    public Cell fill(boolean bl2) {
        this.fillX = bl2 ? onef : zerof;
        this.fillY = bl2 ? onef : zerof;
        return this;
    }

    public Cell align(int n2) {
        this.align = n2;
        return this;
    }

    public Cell center() {
        this.align = centeri;
        return this;
    }

    public Cell top() {
        this.align = this.align == null ? topi : Integer.valueOf((this.align | 2) & 0xFFFFFFFB);
        return this;
    }

    public Cell left() {
        this.align = this.align == null ? lefti : Integer.valueOf((this.align | 8) & 0xFFFFFFEF);
        return this;
    }

    public Cell bottom() {
        this.align = this.align == null ? bottomi : Integer.valueOf((this.align | 4) & 0xFFFFFFFD);
        return this;
    }

    public Cell right() {
        this.align = this.align == null ? righti : Integer.valueOf((this.align | 0x10) & 0xFFFFFFF7);
        return this;
    }

    public Cell grow() {
        this.expandX = onei;
        this.expandY = onei;
        this.fillX = onef;
        this.fillY = onef;
        return this;
    }

    public Cell growX() {
        this.expandX = onei;
        this.fillX = onef;
        return this;
    }

    public Cell growY() {
        this.expandY = onei;
        this.fillY = onef;
        return this;
    }

    public Cell expand() {
        this.expandX = onei;
        this.expandY = onei;
        return this;
    }

    public Cell expandX() {
        this.expandX = onei;
        return this;
    }

    public Cell expandY() {
        this.expandY = onei;
        return this;
    }

    public Cell expand(int n2, int n3) {
        this.expandX = n2;
        this.expandY = n3;
        return this;
    }

    public Cell expand(boolean bl2, boolean bl3) {
        this.expandX = bl2 ? onei : zeroi;
        this.expandY = bl3 ? onei : zeroi;
        return this;
    }

    public Cell colspan(int n2) {
        this.colspan = n2;
        return this;
    }

    public Cell uniform() {
        this.uniformX = Boolean.TRUE;
        this.uniformY = Boolean.TRUE;
        return this;
    }

    public Cell uniformX() {
        this.uniformX = Boolean.TRUE;
        return this;
    }

    public Cell uniformY() {
        this.uniformY = Boolean.TRUE;
        return this;
    }

    public Cell uniform(boolean bl2) {
        this.uniformX = bl2;
        this.uniformY = bl2;
        return this;
    }

    public Cell uniform(boolean bl2, boolean bl3) {
        this.uniformX = bl2;
        this.uniformY = bl3;
        return this;
    }

    public void setActorBounds(float f2, float f3, float f4, float f5) {
        this.actorX = f2;
        this.actorY = f3;
        this.actorWidth = f4;
        this.actorHeight = f5;
    }

    public float getActorX() {
        return this.actorX;
    }

    public void setActorX(float f2) {
        this.actorX = f2;
    }

    public float getActorY() {
        return this.actorY;
    }

    public void setActorY(float f2) {
        this.actorY = f2;
    }

    public float getActorWidth() {
        return this.actorWidth;
    }

    public void setActorWidth(float f2) {
        this.actorWidth = f2;
    }

    public float getActorHeight() {
        return this.actorHeight;
    }

    public void setActorHeight(float f2) {
        this.actorHeight = f2;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public Value getMinWidthValue() {
        return this.minWidth;
    }

    public float getMinWidth() {
        return this.minWidth.get(this.actor);
    }

    public Value getMinHeightValue() {
        return this.minHeight;
    }

    public float getMinHeight() {
        return this.minHeight.get(this.actor);
    }

    public Value getPrefWidthValue() {
        return this.prefWidth;
    }

    public float getPrefWidth() {
        return this.prefWidth.get(this.actor);
    }

    public Value getPrefHeightValue() {
        return this.prefHeight;
    }

    public float getPrefHeight() {
        return this.prefHeight.get(this.actor);
    }

    public Value getMaxWidthValue() {
        return this.maxWidth;
    }

    public float getMaxWidth() {
        return this.maxWidth.get(this.actor);
    }

    public Value getMaxHeightValue() {
        return this.maxHeight;
    }

    public float getMaxHeight() {
        return this.maxHeight.get(this.actor);
    }

    public Value getSpaceTopValue() {
        return this.spaceTop;
    }

    public float getSpaceTop() {
        return this.spaceTop.get(this.actor);
    }

    public Value getSpaceLeftValue() {
        return this.spaceLeft;
    }

    public float getSpaceLeft() {
        return this.spaceLeft.get(this.actor);
    }

    public Value getSpaceBottomValue() {
        return this.spaceBottom;
    }

    public float getSpaceBottom() {
        return this.spaceBottom.get(this.actor);
    }

    public Value getSpaceRightValue() {
        return this.spaceRight;
    }

    public float getSpaceRight() {
        return this.spaceRight.get(this.actor);
    }

    public Value getPadTopValue() {
        return this.padTop;
    }

    public float getPadTop() {
        return this.padTop.get(this.actor);
    }

    public Value getPadLeftValue() {
        return this.padLeft;
    }

    public float getPadLeft() {
        return this.padLeft.get(this.actor);
    }

    public Value getPadBottomValue() {
        return this.padBottom;
    }

    public float getPadBottom() {
        return this.padBottom.get(this.actor);
    }

    public Value getPadRightValue() {
        return this.padRight;
    }

    public float getPadRight() {
        return this.padRight.get(this.actor);
    }

    public float getPadX() {
        return this.padLeft.get(this.actor) + this.padRight.get(this.actor);
    }

    public float getPadY() {
        return this.padTop.get(this.actor) + this.padBottom.get(this.actor);
    }

    public Float getFillX() {
        return this.fillX;
    }

    public Float getFillY() {
        return this.fillY;
    }

    public Integer getAlign() {
        return this.align;
    }

    public Integer getExpandX() {
        return this.expandX;
    }

    public Integer getExpandY() {
        return this.expandY;
    }

    public Integer getColspan() {
        return this.colspan;
    }

    public Boolean getUniformX() {
        return this.uniformX;
    }

    public Boolean getUniformY() {
        return this.uniformY;
    }

    public boolean isEndRow() {
        return this.endRow;
    }

    public float getComputedPadTop() {
        return this.computedPadTop;
    }

    public float getComputedPadLeft() {
        return this.computedPadLeft;
    }

    public float getComputedPadBottom() {
        return this.computedPadBottom;
    }

    public float getComputedPadRight() {
        return this.computedPadRight;
    }

    public void row() {
        this.table.row();
    }

    public Table getTable() {
        return this.table;
    }

    void clear() {
        this.minWidth = null;
        this.minHeight = null;
        this.prefWidth = null;
        this.prefHeight = null;
        this.maxWidth = null;
        this.maxHeight = null;
        this.spaceTop = null;
        this.spaceLeft = null;
        this.spaceBottom = null;
        this.spaceRight = null;
        this.padTop = null;
        this.padLeft = null;
        this.padBottom = null;
        this.padRight = null;
        this.fillX = null;
        this.fillY = null;
        this.align = null;
        this.expandX = null;
        this.expandY = null;
        this.colspan = null;
        this.uniformX = null;
        this.uniformY = null;
    }

    @Override
    public void reset() {
        this.actor = null;
        this.table = null;
        this.endRow = false;
        this.cellAboveIndex = -1;
        this.set(Cell.defaults());
    }

    void set(Cell cell) {
        this.minWidth = cell.minWidth;
        this.minHeight = cell.minHeight;
        this.prefWidth = cell.prefWidth;
        this.prefHeight = cell.prefHeight;
        this.maxWidth = cell.maxWidth;
        this.maxHeight = cell.maxHeight;
        this.spaceTop = cell.spaceTop;
        this.spaceLeft = cell.spaceLeft;
        this.spaceBottom = cell.spaceBottom;
        this.spaceRight = cell.spaceRight;
        this.padTop = cell.padTop;
        this.padLeft = cell.padLeft;
        this.padBottom = cell.padBottom;
        this.padRight = cell.padRight;
        this.fillX = cell.fillX;
        this.fillY = cell.fillY;
        this.align = cell.align;
        this.expandX = cell.expandX;
        this.expandY = cell.expandY;
        this.colspan = cell.colspan;
        this.uniformX = cell.uniformX;
        this.uniformY = cell.uniformY;
    }

    void merge(Cell cell) {
        if (cell == null) {
            return;
        }
        if (cell.minWidth != null) {
            this.minWidth = cell.minWidth;
        }
        if (cell.minHeight != null) {
            this.minHeight = cell.minHeight;
        }
        if (cell.prefWidth != null) {
            this.prefWidth = cell.prefWidth;
        }
        if (cell.prefHeight != null) {
            this.prefHeight = cell.prefHeight;
        }
        if (cell.maxWidth != null) {
            this.maxWidth = cell.maxWidth;
        }
        if (cell.maxHeight != null) {
            this.maxHeight = cell.maxHeight;
        }
        if (cell.spaceTop != null) {
            this.spaceTop = cell.spaceTop;
        }
        if (cell.spaceLeft != null) {
            this.spaceLeft = cell.spaceLeft;
        }
        if (cell.spaceBottom != null) {
            this.spaceBottom = cell.spaceBottom;
        }
        if (cell.spaceRight != null) {
            this.spaceRight = cell.spaceRight;
        }
        if (cell.padTop != null) {
            this.padTop = cell.padTop;
        }
        if (cell.padLeft != null) {
            this.padLeft = cell.padLeft;
        }
        if (cell.padBottom != null) {
            this.padBottom = cell.padBottom;
        }
        if (cell.padRight != null) {
            this.padRight = cell.padRight;
        }
        if (cell.fillX != null) {
            this.fillX = cell.fillX;
        }
        if (cell.fillY != null) {
            this.fillY = cell.fillY;
        }
        if (cell.align != null) {
            this.align = cell.align;
        }
        if (cell.expandX != null) {
            this.expandX = cell.expandX;
        }
        if (cell.expandY != null) {
            this.expandY = cell.expandY;
        }
        if (cell.colspan != null) {
            this.colspan = cell.colspan;
        }
        if (cell.uniformX != null) {
            this.uniformX = cell.uniformX;
        }
        if (cell.uniformY != null) {
            this.uniformY = cell.uniformY;
        }
    }

    public String toString() {
        if (this.actor != null) {
            return this.actor.toString();
        }
        return super.toString();
    }

    public static Cell defaults() {
        if (files == null || files != Gdx.e) {
            files = Gdx.e;
            defaults = new Cell();
            new Cell().minWidth = Value.minWidth;
            Cell.defaults.minHeight = Value.minHeight;
            Cell.defaults.prefWidth = Value.prefWidth;
            Cell.defaults.prefHeight = Value.prefHeight;
            Cell.defaults.maxWidth = Value.maxWidth;
            Cell.defaults.maxHeight = Value.maxHeight;
            Cell.defaults.spaceTop = Value.zero;
            Cell.defaults.spaceLeft = Value.zero;
            Cell.defaults.spaceBottom = Value.zero;
            Cell.defaults.spaceRight = Value.zero;
            Cell.defaults.padTop = Value.zero;
            Cell.defaults.padLeft = Value.zero;
            Cell.defaults.padBottom = Value.zero;
            Cell.defaults.padRight = Value.zero;
            Cell.defaults.fillX = zerof;
            Cell.defaults.fillY = zerof;
            Cell.defaults.align = centeri;
            Cell.defaults.expandX = zeroi;
            Cell.defaults.expandY = zeroi;
            Cell.defaults.colspan = onei;
            Cell.defaults.uniformX = null;
            Cell.defaults.uniformY = null;
        }
        return defaults;
    }

    static {
        centeri = onei = Integer.valueOf(1);
        topi = 2;
        bottomi = 4;
        lefti = 8;
        righti = 16;
    }
}

