/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.utils.Array;

public class ButtonGroup {
    private final Array buttons = new Array();
    private Array checkedButtons = new Array(1);
    private int minCheckCount;
    private int maxCheckCount = 1;
    private boolean uncheckLast = true;
    private Button lastChecked;

    public ButtonGroup() {
        this.minCheckCount = 1;
    }

    public ButtonGroup(Button ... buttonArray) {
        this.minCheckCount = 0;
        this.add(buttonArray);
        this.minCheckCount = 1;
    }

    public void add(Button button) {
        if (button == null) {
            throw new IllegalArgumentException("button cannot be null.");
        }
        button.buttonGroup = null;
        boolean bl2 = button.isChecked() || this.buttons.size < this.minCheckCount;
        button.setChecked(false);
        button.buttonGroup = this;
        this.buttons.add(button);
        button.setChecked(bl2);
    }

    public void add(Button ... buttonArray) {
        if (buttonArray == null) {
            throw new IllegalArgumentException("buttons cannot be null.");
        }
        int n2 = buttonArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add(buttonArray[i2]);
        }
    }

    public void remove(Button button) {
        if (button == null) {
            throw new IllegalArgumentException("button cannot be null.");
        }
        button.buttonGroup = null;
        this.buttons.removeValue(button, true);
        this.checkedButtons.removeValue(button, true);
    }

    public void remove(Button ... buttonArray) {
        if (buttonArray == null) {
            throw new IllegalArgumentException("buttons cannot be null.");
        }
        int n2 = buttonArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.remove(buttonArray[i2]);
        }
    }

    public void clear() {
        this.buttons.clear();
        this.checkedButtons.clear();
    }

    public void setChecked(String string) {
        if (string == null) {
            throw new IllegalArgumentException("text cannot be null.");
        }
        int n2 = this.buttons.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Button button = (Button)this.buttons.get(i2);
            if (!(button instanceof TextButton) || !string.contentEquals(((TextButton)button).getText())) continue;
            button.setChecked(true);
            return;
        }
    }

    protected boolean canCheck(Button button, boolean bl2) {
        if (button.isChecked == bl2) {
            return false;
        }
        if (!bl2) {
            if (this.checkedButtons.size <= this.minCheckCount) {
                return false;
            }
            this.checkedButtons.removeValue(button, true);
        } else {
            block8: {
                if (this.maxCheckCount != -1 && this.checkedButtons.size >= this.maxCheckCount) {
                    if (!this.uncheckLast) {
                        return false;
                    }
                    int n2 = 0;
                    do {
                        int n3 = this.minCheckCount;
                        this.minCheckCount = 0;
                        this.lastChecked.setChecked(false);
                        this.minCheckCount = n3;
                        if (button.isChecked == bl2) {
                            return false;
                        }
                        if (this.checkedButtons.size < this.maxCheckCount) break block8;
                    } while (n2++ <= 10);
                    return false;
                }
            }
            this.checkedButtons.add(button);
            this.lastChecked = button;
        }
        return true;
    }

    public void uncheckAll() {
        int n2 = this.minCheckCount;
        this.minCheckCount = 0;
        int n3 = this.buttons.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            ((Button)this.buttons.get(i2)).setChecked(false);
        }
        this.minCheckCount = n2;
    }

    public Button getChecked() {
        if (this.checkedButtons.size > 0) {
            return (Button)this.checkedButtons.get(0);
        }
        return null;
    }

    public int getCheckedIndex() {
        if (this.checkedButtons.size > 0) {
            return this.buttons.indexOf((Button)this.checkedButtons.get(0), true);
        }
        return -1;
    }

    public Array getAllChecked() {
        return this.checkedButtons;
    }

    public Array getButtons() {
        return this.buttons;
    }

    public void setMinCheckCount(int n2) {
        this.minCheckCount = n2;
    }

    public void setMaxCheckCount(int n2) {
        if (n2 == 0) {
            n2 = -1;
        }
        this.maxCheckCount = n2;
    }

    public void setUncheckLast(boolean bl2) {
        this.uncheckLast = bl2;
    }
}

