/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.g;
import com.badlogic.gdx.scenes.scene2d.b.h;
import com.badlogic.gdx.scenes.scene2d.b.k;
import com.badlogic.gdx.scenes.scene2d.j;
import com.badlogic.gdx.scenes.scene2d.l;
import com.badlogic.gdx.scenes.scene2d.ui.Button$ButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Styleable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.a;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.SnapshotArray;

public class Button
extends Table
implements Styleable {
    private Button$ButtonStyle style;
    boolean isChecked;
    boolean isDisabled;
    ButtonGroup buttonGroup;
    private h clickListener;
    private boolean programmaticChangeEvents = true;

    public Button(Skin skin) {
        super(skin);
        this.initialize();
        this.setStyle((Button$ButtonStyle)skin.get(Button$ButtonStyle.class));
        Button button = this;
        button.setSize(((WidgetGroup)button).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    public Button(Skin skin, String string) {
        super(skin);
        this.initialize();
        this.setStyle((Button$ButtonStyle)skin.get(string, Button$ButtonStyle.class));
        Button button = this;
        button.setSize(((WidgetGroup)button).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    public Button(b b2, Skin skin, String string) {
        this(b2, (Button$ButtonStyle)skin.get(string, Button$ButtonStyle.class));
        this.setSkin(skin);
    }

    public Button(b b2, Button$ButtonStyle button$ButtonStyle) {
        this.initialize();
        this.add(b2);
        this.setStyle(button$ButtonStyle);
        Button button = this;
        button.setSize(((WidgetGroup)button).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    public Button(Button$ButtonStyle button$ButtonStyle) {
        this.initialize();
        this.setStyle(button$ButtonStyle);
        Button button = this;
        button.setSize(((WidgetGroup)button).getPrefWidth(), ((WidgetGroup)this).getPrefHeight());
    }

    public Button() {
        this.initialize();
    }

    private void initialize() {
        this.setTouchable(l.a);
        this.clickListener = new a(this);
        this.addListener(this.clickListener);
    }

    public Button(k k2) {
        this(new Button$ButtonStyle(k2, null, null));
    }

    public Button(k k2, k k3) {
        this(new Button$ButtonStyle(k2, k3, null));
    }

    public Button(k k2, k k3, k k4) {
        this(new Button$ButtonStyle(k2, k3, k4));
    }

    public Button(b b2, Skin skin) {
        this(b2, (Button$ButtonStyle)skin.get(Button$ButtonStyle.class));
    }

    public void setChecked(boolean bl2) {
        this.setChecked(bl2, this.programmaticChangeEvents);
    }

    void setChecked(boolean bl2, boolean bl3) {
        if (this.isChecked == bl2) {
            return;
        }
        if (this.buttonGroup != null && !this.buttonGroup.canCheck(this, bl2)) {
            return;
        }
        this.isChecked = bl2;
        if (bl3) {
            g g2 = (g)Pools.obtain(g::new);
            if (this.fire(g2)) {
                this.isChecked = !bl2;
            }
            Pools.free(g2);
        }
    }

    public void toggle() {
        Button button = this;
        button.setChecked(!button.isChecked);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public boolean isPressed() {
        return this.clickListener.isVisualPressed();
    }

    public boolean isOver() {
        return this.clickListener.isOver();
    }

    public h getClickListener() {
        return this.clickListener;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(boolean bl2) {
        this.isDisabled = bl2;
    }

    public void setProgrammaticChangeEvents(boolean bl2) {
        this.programmaticChangeEvents = bl2;
    }

    public void setStyle(Button$ButtonStyle button$ButtonStyle) {
        if (button$ButtonStyle == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = button$ButtonStyle;
        Button button = this;
        button.setBackground(button.getBackgroundDrawable());
    }

    @Override
    public Button$ButtonStyle getStyle() {
        return this.style;
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    protected k getBackgroundDrawable() {
        if (this.isDisabled() && this.style.disabled != null) {
            return this.style.disabled;
        }
        if (this.isPressed()) {
            if (this.isChecked() && this.style.checkedDown != null) {
                return this.style.checkedDown;
            }
            if (this.style.down != null) {
                return this.style.down;
            }
        }
        if (this.isOver()) {
            if (this.isChecked()) {
                if (this.style.checkedOver != null) {
                    return this.style.checkedOver;
                }
            } else if (this.style.over != null) {
                return this.style.over;
            }
        }
        boolean bl2 = this.hasKeyboardFocus();
        if (this.isChecked()) {
            if (bl2 && this.style.checkedFocused != null) {
                return this.style.checkedFocused;
            }
            if (this.style.checked != null) {
                return this.style.checked;
            }
            if (this.isOver() && this.style.over != null) {
                return this.style.over;
            }
        }
        if (bl2 && this.style.focused != null) {
            return this.style.focused;
        }
        return this.style.up;
    }

    @Override
    public void draw(Batch batch, float f2) {
        j j2;
        int n2;
        float f3;
        float f4;
        this.validate();
        Button button = this;
        button.setBackground(button.getBackgroundDrawable());
        if (this.isPressed() && !this.isDisabled()) {
            f4 = this.style.pressedOffsetX;
            f3 = this.style.pressedOffsetY;
        } else if (this.isChecked() && !this.isDisabled()) {
            f4 = this.style.checkedOffsetX;
            f3 = this.style.checkedOffsetY;
        } else {
            f4 = this.style.unpressedOffsetX;
            f3 = this.style.unpressedOffsetY;
        }
        boolean bl2 = f4 != 0.0f || f3 != 0.0f;
        SnapshotArray snapshotArray = this.getChildren();
        if (bl2) {
            for (n2 = 0; n2 < snapshotArray.size; ++n2) {
                ((b)snapshotArray.get(n2)).moveBy(f4, f3);
            }
        }
        super.draw(batch, f2);
        if (bl2) {
            for (n2 = 0; n2 < snapshotArray.size; ++n2) {
                ((b)snapshotArray.get(n2)).moveBy(-f4, -f3);
            }
        }
        if ((j2 = this.getStage()) != null && j2.k() && this.isPressed() != this.clickListener.isPressed()) {
            Gdx.b.p();
        }
    }

    @Override
    public float getPrefWidth() {
        float f2 = super.getPrefWidth();
        if (this.style.up != null) {
            f2 = Math.max(f2, this.style.up.e());
        }
        if (this.style.down != null) {
            f2 = Math.max(f2, this.style.down.e());
        }
        if (this.style.checked != null) {
            f2 = Math.max(f2, this.style.checked.e());
        }
        return f2;
    }

    @Override
    public float getPrefHeight() {
        float f2 = super.getPrefHeight();
        if (this.style.up != null) {
            f2 = Math.max(f2, this.style.up.f());
        }
        if (this.style.down != null) {
            f2 = Math.max(f2, this.style.down.f());
        }
        if (this.style.checked != null) {
            f2 = Math.max(f2, this.style.checked.f());
        }
        return f2;
    }

    @Override
    public float getMinWidth() {
        return ((WidgetGroup)this).getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return ((WidgetGroup)this).getPrefHeight();
    }
}

