/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.b;
import com.badlogic.gdx.scenes.scene2d.b.i;
import com.badlogic.gdx.scenes.scene2d.j;
import com.badlogic.gdx.scenes.scene2d.l;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;

public class e
extends b
implements i {
    private static final Vector2 tmp = new Vector2();
    final SnapshotArray children = new SnapshotArray(true, 4, b[]::new);
    private final Affine2 worldTransform = new Affine2();
    private final Matrix4 computedTransform = new Matrix4();
    private final Matrix4 oldTransform = new Matrix4();
    boolean transform = true;
    private Rectangle cullingArea;

    @Override
    public void act(float f2) {
        super.act(f2);
        b[] bArray = (b[])this.children.begin();
        int n2 = this.children.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            bArray[i2].act(f2);
        }
        this.children.end();
    }

    @Override
    public void draw(Batch batch, float f2) {
        if (this.transform) {
            this.applyTransform(batch, this.computeTransform());
        }
        this.drawChildren(batch, f2);
        if (this.transform) {
            this.resetTransform(batch);
        }
    }

    protected void drawChildren(Batch batch, float f2) {
        f2 *= this.color.a;
        SnapshotArray snapshotArray = this.children;
        b[] bArray = (b[])snapshotArray.begin();
        Rectangle rectangle = this.cullingArea;
        if (rectangle != null) {
            float f3 = rectangle.x;
            float f4 = f3 + rectangle.width;
            float f5 = rectangle.y;
            float f6 = f5 + rectangle.height;
            if (this.transform) {
                int n2 = snapshotArray.size;
                for (int i2 = 0; i2 < n2; ++i2) {
                    b b2 = bArray[i2];
                    if (!b2.isVisible()) continue;
                    float f7 = b2.x;
                    float f8 = b2.y;
                    if (!(f7 <= f4) || !(f8 <= f6) || !(f7 + b2.width >= f3) || !(f8 + b2.height >= f5)) continue;
                    b2.draw(batch, f2);
                }
            } else {
                float f9 = this.x;
                float f10 = this.y;
                this.x = 0.0f;
                this.y = 0.0f;
                int n3 = snapshotArray.size;
                for (int i3 = 0; i3 < n3; ++i3) {
                    b b3 = bArray[i3];
                    if (!b3.isVisible()) continue;
                    float f11 = b3.x;
                    float f12 = b3.y;
                    if (!(f11 <= f4) || !(f12 <= f6) || !(f11 + b3.width >= f3) || !(f12 + b3.height >= f5)) continue;
                    b3.x = f11 + f9;
                    b3.y = f12 + f10;
                    b3.draw(batch, f2);
                    b3.x = f11;
                    b3.y = f12;
                }
                this.x = f9;
                this.y = f10;
            }
        } else if (this.transform) {
            int n4 = snapshotArray.size;
            for (int i4 = 0; i4 < n4; ++i4) {
                b b4 = bArray[i4];
                if (!b4.isVisible()) continue;
                b4.draw(batch, f2);
            }
        } else {
            float f13 = this.x;
            float f14 = this.y;
            this.x = 0.0f;
            this.y = 0.0f;
            int n5 = snapshotArray.size;
            for (int i5 = 0; i5 < n5; ++i5) {
                b b5 = bArray[i5];
                if (!b5.isVisible()) continue;
                float f15 = b5.x;
                float f16 = b5.y;
                b5.x = f15 + f13;
                b5.y = f16 + f14;
                b5.draw(batch, f2);
                b5.x = f15;
                b5.y = f16;
            }
            this.x = f13;
            this.y = f14;
        }
        snapshotArray.end();
    }

    @Override
    public void drawDebug(ShapeRenderer shapeRenderer) {
        this.drawDebugBounds(shapeRenderer);
        if (this.transform) {
            this.applyTransform(shapeRenderer, this.computeTransform());
        }
        this.drawDebugChildren(shapeRenderer);
        if (this.transform) {
            this.resetTransform(shapeRenderer);
        }
    }

    protected void drawDebugChildren(ShapeRenderer shapeRenderer) {
        SnapshotArray snapshotArray = this.children;
        b[] bArray = (b[])snapshotArray.begin();
        if (this.transform) {
            int n2 = snapshotArray.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                b b2 = bArray[i2];
                if (!b2.isVisible() || !b2.getDebug() && !(b2 instanceof e)) continue;
                b2.drawDebug(shapeRenderer);
            }
            shapeRenderer.flush();
        } else {
            float f2 = this.x;
            float f3 = this.y;
            this.x = 0.0f;
            this.y = 0.0f;
            int n3 = snapshotArray.size;
            for (int i3 = 0; i3 < n3; ++i3) {
                b b3 = bArray[i3];
                if (!b3.isVisible() || !b3.getDebug() && !(b3 instanceof e)) continue;
                float f4 = b3.x;
                float f5 = b3.y;
                b3.x = f4 + f2;
                b3.y = f5 + f3;
                b3.drawDebug(shapeRenderer);
                b3.x = f4;
                b3.y = f5;
            }
            this.x = f2;
            this.y = f3;
        }
        snapshotArray.end();
    }

    protected Matrix4 computeTransform() {
        Affine2 affine2 = this.worldTransform;
        float f2 = this.originX;
        float f3 = this.originY;
        affine2.setToTrnRotScl(this.x + f2, this.y + f3, this.rotation, this.scaleX, this.scaleY);
        if (f2 != 0.0f || f3 != 0.0f) {
            affine2.translate(-f2, -f3);
        }
        e e2 = this.parent;
        while (e2 != null && !e2.transform) {
            e2 = e2.parent;
        }
        if (e2 != null) {
            affine2.preMul(e2.worldTransform);
        }
        this.computedTransform.set(affine2);
        return this.computedTransform;
    }

    protected void applyTransform(Batch batch, Matrix4 matrix4) {
        this.oldTransform.set(batch.getTransformMatrix());
        batch.setTransformMatrix(matrix4);
    }

    protected void resetTransform(Batch batch) {
        batch.setTransformMatrix(this.oldTransform);
    }

    protected void applyTransform(ShapeRenderer shapeRenderer, Matrix4 matrix4) {
        this.oldTransform.set(shapeRenderer.getTransformMatrix());
        shapeRenderer.setTransformMatrix(matrix4);
        shapeRenderer.flush();
    }

    protected void resetTransform(ShapeRenderer shapeRenderer) {
        shapeRenderer.setTransformMatrix(this.oldTransform);
    }

    @Override
    public void setCullingArea(Rectangle rectangle) {
        this.cullingArea = rectangle;
    }

    public Rectangle getCullingArea() {
        return this.cullingArea;
    }

    @Override
    public b hit(float f2, float f3, boolean bl2) {
        if (bl2 && this.getTouchable() == l.b) {
            return null;
        }
        if (!this.isVisible()) {
            return null;
        }
        Vector2 vector2 = tmp;
        b[] bArray = (b[])this.children.items;
        for (int i2 = this.children.size - 1; i2 >= 0; --i2) {
            b b2 = bArray[i2];
            b2.parentToLocalCoordinates(vector2.set(f2, f3));
            b2 = b2.hit(vector2.x, vector2.y, bl2);
            if (b2 == null) continue;
            return b2;
        }
        return super.hit(f2, f3, bl2);
    }

    protected void childrenChanged() {
    }

    public void addActor(b b2) {
        if (b2.parent != null) {
            if (b2.parent == this) {
                return;
            }
            b2.parent.removeActor(b2, false);
        }
        this.children.add(b2);
        b2.setParent(this);
        b2.setStage(this.getStage());
        this.childrenChanged();
    }

    public void addActorAt(int n2, b b2) {
        if (b2.parent != null) {
            if (b2.parent == this) {
                return;
            }
            b2.parent.removeActor(b2, false);
        }
        if (n2 >= this.children.size) {
            this.children.add(b2);
        } else {
            ((Array)this.children).insert(n2, b2);
        }
        b2.setParent(this);
        b2.setStage(this.getStage());
        this.childrenChanged();
    }

    public void addActorBefore(b b2, b b3) {
        if (b3.parent != null) {
            if (b3.parent == this) {
                return;
            }
            b3.parent.removeActor(b3, false);
        }
        int n2 = this.children.indexOf(b2, true);
        ((Array)this.children).insert(n2, b3);
        b3.setParent(this);
        b3.setStage(this.getStage());
        this.childrenChanged();
    }

    public void addActorAfter(b b2, b b3) {
        int n2;
        if (b3.parent != null) {
            if (b3.parent == this) {
                return;
            }
            b3.parent.removeActor(b3, false);
        }
        if ((n2 = this.children.indexOf(b2, true)) == this.children.size || n2 == -1) {
            this.children.add(b3);
        } else {
            ((Array)this.children).insert(n2 + 1, b3);
        }
        b3.setParent(this);
        b3.setStage(this.getStage());
        this.childrenChanged();
    }

    public boolean removeActor(b b2) {
        return this.removeActor(b2, true);
    }

    public boolean removeActor(b b2, boolean bl2) {
        int n2 = this.children.indexOf(b2, true);
        if (n2 == -1) {
            return false;
        }
        this.removeActorAt(n2, bl2);
        return true;
    }

    public b removeActorAt(int n2, boolean bl2) {
        b b2 = (b)((Array)this.children).removeIndex(n2);
        j j2 = this.getStage();
        if (j2 != null) {
            if (bl2) {
                j2.c(b2);
            }
            j2.b(b2);
        }
        b2.setParent(null);
        b2.setStage(null);
        this.childrenChanged();
        return b2;
    }

    public void clearChildren() {
        this.clearChildren(true);
    }

    public void clearChildren(boolean bl2) {
        b[] bArray = (b[])this.children.begin();
        int n2 = this.children.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            j j2;
            b b2 = bArray[i2];
            if (bl2 && (j2 = this.getStage()) != null) {
                j2.c(b2);
            }
            b2.setStage(null);
            b2.setParent(null);
        }
        this.children.end();
        ((Array)this.children).clear();
        this.childrenChanged();
    }

    @Override
    public void clear() {
        super.clear();
        this.clearChildren(true);
    }

    public void clear(boolean bl2) {
        super.clear();
        this.clearChildren(bl2);
    }

    public b findActor(String string) {
        int n2;
        SnapshotArray snapshotArray = this.children;
        int n3 = snapshotArray.size;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!string.equals(((b)snapshotArray.get(n2)).getName())) continue;
            return (b)snapshotArray.get(n2);
        }
        n3 = snapshotArray.size;
        for (n2 = 0; n2 < n3; ++n2) {
            b b2 = (b)snapshotArray.get(n2);
            if (!(b2 instanceof e) || (b2 = ((e)b2).findActor(string)) == null) continue;
            return b2;
        }
        return null;
    }

    @Override
    protected void setStage(j j2) {
        super.setStage(j2);
        b[] bArray = (b[])this.children.items;
        int n2 = this.children.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            bArray[i2].setStage(j2);
        }
    }

    public boolean swapActor(int n2, int n3) {
        int n4 = this.children.size;
        if (n2 < 0 || n2 >= n4) {
            return false;
        }
        if (n3 < 0 || n3 >= n4) {
            return false;
        }
        ((Array)this.children).swap(n2, n3);
        return true;
    }

    public boolean swapActor(b b2, b b3) {
        int n2 = this.children.indexOf(b2, true);
        int n3 = this.children.indexOf(b3, true);
        if (n2 == -1 || n3 == -1) {
            return false;
        }
        ((Array)this.children).swap(n2, n3);
        return true;
    }

    public b getChild(int n2) {
        return (b)this.children.get(n2);
    }

    public SnapshotArray getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size > 0;
    }

    public void setTransform(boolean bl2) {
        this.transform = bl2;
    }

    public boolean isTransform() {
        return this.transform;
    }

    public Vector2 localToDescendantCoordinates(b b2, Vector2 vector2) {
        e e2 = b2.parent;
        if (e2 == null) {
            throw new IllegalArgumentException("Actor is not a descendant: ".concat(String.valueOf(b2)));
        }
        if (e2 != this) {
            this.localToDescendantCoordinates(e2, vector2);
        }
        b2.parentToLocalCoordinates(vector2);
        return vector2;
    }

    public void setDebug(boolean bl2, boolean bl3) {
        this.setDebug(bl2);
        if (bl3) {
            for (b b2 : this.children) {
                if (b2 instanceof e) {
                    ((e)b2).setDebug(bl2, bl3);
                    continue;
                }
                b2.setDebug(bl2);
            }
        }
    }

    public e debugAll() {
        this.setDebug(true, true);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        this.toString(stringBuilder, 1);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setLength(stringBuilder2.length() - 1);
        return stringBuilder.toString();
    }

    void toString(StringBuilder stringBuilder, int n2) {
        stringBuilder.append(super.toString());
        stringBuilder.append('\n');
        b[] bArray = (b[])this.children.begin();
        int n3 = this.children.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                stringBuilder.append("|  ");
            }
            b b2 = bArray[i2];
            if (b2 instanceof e) {
                ((e)b2).toString(stringBuilder, n2 + 1);
                continue;
            }
            stringBuilder.append(b2);
            stringBuilder.append('\n');
        }
        this.children.end();
    }
}

