/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer$ShapeType;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.a;
import com.badlogic.gdx.scenes.scene2d.b.r;
import com.badlogic.gdx.scenes.scene2d.c;
import com.badlogic.gdx.scenes.scene2d.d;
import com.badlogic.gdx.scenes.scene2d.e;
import com.badlogic.gdx.scenes.scene2d.j;
import com.badlogic.gdx.scenes.scene2d.k;
import com.badlogic.gdx.scenes.scene2d.l;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.reflect.ClassReflection;

public class b {
    private j stage;
    e parent;
    private final DelayedRemovalArray listeners = new DelayedRemovalArray(0);
    private final DelayedRemovalArray captureListeners = new DelayedRemovalArray(0);
    private final Array actions = new Array(0);
    private String name;
    private l touchable = l.a;
    private boolean visible = true;
    private boolean debug;
    float x;
    float y;
    float width;
    float height;
    float originX;
    float originY;
    float scaleX = 1.0f;
    float scaleY = 1.0f;
    float rotation;
    final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private Object userObject;

    public void draw(Batch batch, float f2) {
    }

    public void act(float f2) {
        Array array = this.actions;
        if (array.size == 0) {
            return;
        }
        if (this.stage != null && this.stage.k()) {
            Gdx.b.p();
        }
        try {
            for (int i2 = 0; i2 < array.size; ++i2) {
                int n2;
                a a2 = (a)array.get(i2);
                if (!a2.a(f2) || i2 >= array.size || (n2 = (a)array.get(i2) == a2 ? i2 : array.indexOf(a2, true)) == -1) continue;
                array.removeIndex(n2);
                a2.a((b)null);
                --i2;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            String string = this.toString();
            throw new RuntimeException("Actor: " + string.substring(0, Math.min(string.length(), 128)), runtimeException);
        }
    }

    public boolean fire(c c2) {
        if (c2.j() == null) {
            c2.a(this.getStage());
        }
        c2.a(this);
        Array array = (Array)Pools.obtain(Array::new);
        Object object = this.parent;
        while (object != null) {
            array.add(object);
            object = object.parent;
        }
        try {
            int n2;
            object = array.items;
            for (n2 = array.size - 1; n2 >= 0; --n2) {
                ((e)object[n2]).notify(c2, true);
                if (!c2.h()) continue;
                boolean bl2 = c2.i();
                return bl2;
            }
            this.notify(c2, true);
            if (c2.h()) {
                n2 = c2.i() ? 1 : 0;
                return n2 != 0;
            }
            this.notify(c2, false);
            if (!c2.f()) {
                n2 = c2.i();
                return n2 != 0;
            }
            if (c2.h()) {
                n2 = c2.i();
                return n2 != 0;
            }
            int n3 = array.size;
            for (n2 = 0; n2 < n3; ++n2) {
                ((e)object[n2]).notify(c2, false);
                if (!c2.h()) continue;
                boolean bl3 = c2.i();
                return bl3;
            }
            n2 = c2.i() ? 1 : 0;
            return n2 != 0;
        }
        finally {
            array.clear();
            Pools.free(array);
        }
    }

    public boolean notify(c c2, boolean bl2) {
        DelayedRemovalArray delayedRemovalArray;
        if (c2.d() == null) {
            throw new IllegalArgumentException("The event target cannot be null.");
        }
        if ((delayedRemovalArray = bl2 ? this.captureListeners : this.listeners).size == 0) {
            return c2.i();
        }
        c2.b(this);
        if (c2.j() == null) {
            c2.a(this.stage);
        }
        try {
            delayedRemovalArray.begin();
            int n2 = delayedRemovalArray.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!((d)delayedRemovalArray.get(i2)).handle(c2)) continue;
                c2.a();
            }
            delayedRemovalArray.end();
        }
        catch (RuntimeException runtimeException) {
            String string = this.toString();
            throw new RuntimeException("Actor: " + string.substring(0, Math.min(string.length(), 128)), runtimeException);
        }
        return c2.i();
    }

    public b hit(float f2, float f3, boolean bl2) {
        if (bl2 && this.touchable != l.a) {
            return null;
        }
        if (!this.isVisible()) {
            return null;
        }
        if (f2 >= 0.0f && f2 < this.width && f3 >= 0.0f && f3 < this.height) {
            return this;
        }
        return null;
    }

    public boolean remove() {
        if (this.parent != null) {
            return this.parent.removeActor(this, true);
        }
        return false;
    }

    public boolean addListener(d d2) {
        if (d2 == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        if (!this.listeners.contains(d2, true)) {
            this.listeners.add(d2);
            return true;
        }
        return false;
    }

    public boolean removeListener(d d2) {
        if (d2 == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        return ((Array)this.listeners).removeValue(d2, true);
    }

    public DelayedRemovalArray getListeners() {
        return this.listeners;
    }

    public boolean addCaptureListener(d d2) {
        if (d2 == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        if (!this.captureListeners.contains(d2, true)) {
            this.captureListeners.add(d2);
        }
        return true;
    }

    public boolean removeCaptureListener(d d2) {
        if (d2 == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        return ((Array)this.captureListeners).removeValue(d2, true);
    }

    public DelayedRemovalArray getCaptureListeners() {
        return this.captureListeners;
    }

    public void addAction(a a2) {
        a2.a(this);
        this.actions.add(a2);
        if (this.stage != null && this.stage.k()) {
            Gdx.b.p();
        }
    }

    public void removeAction(a a2) {
        if (a2 != null && this.actions.removeValue(a2, true)) {
            a2.a((b)null);
        }
    }

    public Array getActions() {
        return this.actions;
    }

    public boolean hasActions() {
        return this.actions.size > 0;
    }

    public void clearActions() {
        for (int i2 = this.actions.size - 1; i2 >= 0; --i2) {
            ((a)this.actions.get(i2)).a((b)null);
        }
        this.actions.clear();
    }

    public void clearListeners() {
        ((Array)this.listeners).clear();
        ((Array)this.captureListeners).clear();
    }

    public void clear() {
        this.clearActions();
        this.clearListeners();
    }

    public j getStage() {
        return this.stage;
    }

    protected void setStage(j j2) {
        this.stage = j2;
    }

    public boolean isDescendantOf(b b2) {
        if (b2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        b b3 = this;
        do {
            if (b3 != b2) continue;
            return true;
        } while ((b3 = b3.parent) != null);
        return false;
    }

    public boolean isAscendantOf(b b2) {
        if (b2 == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        do {
            if (b2 != this) continue;
            return true;
        } while ((b2 = b2.parent) != null);
        return false;
    }

    public b firstAscendant(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        b b2 = this;
        do {
            if (!ClassReflection.isInstance(clazz, b2)) continue;
            return b2;
        } while ((b2 = b2.parent) != null);
        return null;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public e getParent() {
        return this.parent;
    }

    protected void setParent(e e2) {
        this.parent = e2;
    }

    public boolean isTouchable() {
        return this.touchable == l.a;
    }

    public l getTouchable() {
        return this.touchable;
    }

    public void setTouchable(l l2) {
        this.touchable = l2;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl2) {
        this.visible = bl2;
    }

    public boolean ascendantsVisible() {
        b b2 = this;
        do {
            if (b2.isVisible()) continue;
            return false;
        } while ((b2 = b2.parent) != null);
        return true;
    }

    public boolean ancestorsVisible() {
        return this.ascendantsVisible();
    }

    public boolean hasKeyboardFocus() {
        j j2 = this.getStage();
        return j2 != null && j2.e() == this;
    }

    public boolean hasScrollFocus() {
        j j2 = this.getStage();
        return j2 != null && j2.f() == this;
    }

    public boolean isTouchFocusTarget() {
        j j2 = this.getStage();
        if (j2 == null) {
            return false;
        }
        int n2 = j2.b.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((k)j2.b.get((int)i2)).c != this) continue;
            return true;
        }
        return false;
    }

    public boolean isTouchFocusListener() {
        j j2 = this.getStage();
        if (j2 == null) {
            return false;
        }
        int n2 = j2.b.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((k)j2.b.get((int)i2)).b != this) continue;
            return true;
        }
        return false;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public float getX() {
        return this.x;
    }

    public float getX(int n2) {
        float f2 = this.x;
        if ((n2 & 0x10) != 0) {
            f2 += this.width;
        } else if ((n2 & 8) == 0) {
            f2 += this.width / 2.0f;
        }
        return f2;
    }

    public void setX(float f2) {
        if (this.x != f2) {
            this.x = f2;
            this.positionChanged();
        }
    }

    public void setX(float f2, int n2) {
        if ((n2 & 0x10) != 0) {
            f2 -= this.width;
        } else if ((n2 & 8) == 0) {
            f2 -= this.width / 2.0f;
        }
        if (this.x != f2) {
            this.x = f2;
            this.positionChanged();
        }
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f2) {
        if (this.y != f2) {
            this.y = f2;
            this.positionChanged();
        }
    }

    public void setY(float f2, int n2) {
        if ((n2 & 2) != 0) {
            f2 -= this.height;
        } else if ((n2 & 4) == 0) {
            f2 -= this.height / 2.0f;
        }
        if (this.y != f2) {
            this.y = f2;
            this.positionChanged();
        }
    }

    public float getY(int n2) {
        float f2 = this.y;
        if ((n2 & 2) != 0) {
            f2 += this.height;
        } else if ((n2 & 4) == 0) {
            f2 += this.height / 2.0f;
        }
        return f2;
    }

    public void setPosition(float f2, float f3) {
        if (this.x != f2 || this.y != f3) {
            this.x = f2;
            this.y = f3;
            this.positionChanged();
        }
    }

    public void setPosition(float f2, float f3, int n2) {
        if ((n2 & 0x10) != 0) {
            f2 -= this.width;
        } else if ((n2 & 8) == 0) {
            f2 -= this.width / 2.0f;
        }
        if ((n2 & 2) != 0) {
            f3 -= this.height;
        } else if ((n2 & 4) == 0) {
            f3 -= this.height / 2.0f;
        }
        if (this.x != f2 || this.y != f3) {
            this.x = f2;
            this.y = f3;
            this.positionChanged();
        }
    }

    public void moveBy(float f2, float f3) {
        if (f2 != 0.0f || f3 != 0.0f) {
            this.x += f2;
            this.y += f3;
            this.positionChanged();
        }
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f2) {
        if (this.width != f2) {
            this.width = f2;
            this.sizeChanged();
        }
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f2) {
        if (this.height != f2) {
            this.height = f2;
            this.sizeChanged();
        }
    }

    public float getTop() {
        return this.y + this.height;
    }

    public float getRight() {
        return this.x + this.width;
    }

    protected void positionChanged() {
    }

    protected void sizeChanged() {
    }

    protected void scaleChanged() {
    }

    protected void rotationChanged() {
    }

    public void setSize(float f2, float f3) {
        if (this.width != f2 || this.height != f3) {
            this.width = f2;
            this.height = f3;
            this.sizeChanged();
        }
    }

    public void sizeBy(float f2) {
        if (f2 != 0.0f) {
            this.width += f2;
            this.height += f2;
            this.sizeChanged();
        }
    }

    public void sizeBy(float f2, float f3) {
        if (f2 != 0.0f || f3 != 0.0f) {
            this.width += f2;
            this.height += f3;
            this.sizeChanged();
        }
    }

    public void setBounds(float f2, float f3, float f4, float f5) {
        if (this.x != f2 || this.y != f3) {
            this.x = f2;
            this.y = f3;
            this.positionChanged();
        }
        if (this.width != f4 || this.height != f5) {
            this.width = f4;
            this.height = f5;
            this.sizeChanged();
        }
    }

    public float getOriginX() {
        return this.originX;
    }

    public void setOriginX(float f2) {
        this.originX = f2;
    }

    public float getOriginY() {
        return this.originY;
    }

    public void setOriginY(float f2) {
        this.originY = f2;
    }

    public void setOrigin(float f2, float f3) {
        this.originX = f2;
        this.originY = f3;
    }

    public void setOrigin(int n2) {
        this.originX = (n2 & 8) != 0 ? 0.0f : ((n2 & 0x10) != 0 ? this.width : this.width / 2.0f);
        if ((n2 & 4) != 0) {
            this.originY = 0.0f;
            return;
        }
        if ((n2 & 2) != 0) {
            this.originY = this.height;
            return;
        }
        this.originY = this.height / 2.0f;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float f2) {
        if (this.scaleX != f2) {
            this.scaleX = f2;
            this.scaleChanged();
        }
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float f2) {
        if (this.scaleY != f2) {
            this.scaleY = f2;
            this.scaleChanged();
        }
    }

    public void setScale(float f2) {
        if (this.scaleX != f2 || this.scaleY != f2) {
            this.scaleX = f2;
            this.scaleY = f2;
            this.scaleChanged();
        }
    }

    public void setScale(float f2, float f3) {
        if (this.scaleX != f2 || this.scaleY != f3) {
            this.scaleX = f2;
            this.scaleY = f3;
            this.scaleChanged();
        }
    }

    public void scaleBy(float f2) {
        if (f2 != 0.0f) {
            this.scaleX += f2;
            this.scaleY += f2;
            this.scaleChanged();
        }
    }

    public void scaleBy(float f2, float f3) {
        if (f2 != 0.0f || f3 != 0.0f) {
            this.scaleX += f2;
            this.scaleY += f3;
            this.scaleChanged();
        }
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float f2) {
        if (this.rotation != f2) {
            this.rotation = f2;
            this.rotationChanged();
        }
    }

    public void rotateBy(float f2) {
        if (f2 != 0.0f) {
            this.rotation = (this.rotation + f2) % 360.0f;
            this.rotationChanged();
        }
    }

    public void setColor(Color color) {
        this.color.set(color);
    }

    public void setColor(float f2, float f3, float f4, float f5) {
        this.color.set(f2, f3, f4, f5);
    }

    public Color getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void toFront() {
        this.setZIndex(Integer.MAX_VALUE);
    }

    public void toBack() {
        this.setZIndex(0);
    }

    public boolean setZIndex(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("ZIndex cannot be < 0.");
        }
        Object object = this.parent;
        if (object == null) {
            return false;
        }
        object = ((e)object).children;
        if (((Array)object).size <= 1) {
            return false;
        }
        if (((Array)object).get(n2 = Math.min(n2, ((Array)object).size - 1)) == this) {
            return false;
        }
        if (!((Array)object).removeValue(this, true)) {
            return false;
        }
        ((Array)object).insert(n2, this);
        return true;
    }

    public int getZIndex() {
        e e2 = this.parent;
        if (e2 == null) {
            return -1;
        }
        return e2.children.indexOf(this, true);
    }

    public boolean clipBegin() {
        b b2 = this;
        return b2.clipBegin(b2.x, this.y, this.width, this.height);
    }

    public boolean clipBegin(float f2, float f3, float f4, float f5) {
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return false;
        }
        j j2 = this.stage;
        if (j2 == null) {
            return false;
        }
        Rectangle rectangle = Rectangle.tmp;
        Rectangle.tmp.x = f2;
        rectangle.y = f3;
        rectangle.width = f4;
        rectangle.height = f5;
        Rectangle rectangle2 = (Rectangle)Pools.obtain(Rectangle::new);
        j2.a(rectangle, rectangle2);
        if (r.a(rectangle2)) {
            return true;
        }
        Pools.free(rectangle2);
        return false;
    }

    public void clipEnd() {
        Pools.free(r.a());
    }

    public Vector2 screenToLocalCoordinates(Vector2 vector2) {
        j j2 = this.stage;
        if (j2 == null) {
            return vector2;
        }
        return this.stageToLocalCoordinates(j2.a(vector2));
    }

    public Vector2 stageToLocalCoordinates(Vector2 vector2) {
        if (this.parent != null) {
            this.parent.stageToLocalCoordinates(vector2);
        }
        this.parentToLocalCoordinates(vector2);
        return vector2;
    }

    public Vector2 parentToLocalCoordinates(Vector2 vector2) {
        float f2 = this.rotation;
        float f3 = this.scaleX;
        float f4 = this.scaleY;
        float f5 = this.x;
        float f6 = this.y;
        if (f2 == 0.0f) {
            if (f3 == 1.0f && f4 == 1.0f) {
                vector2.x -= f5;
                vector2.y -= f6;
            } else {
                float f7 = this.originX;
                f2 = this.originY;
                vector2.x = (vector2.x - f5 - f7) / f3 + f7;
                vector2.y = (vector2.y - f6 - f2) / f4 + f2;
            }
        } else {
            float f8 = (float)Math.cos(f2 * ((float)Math.PI / 180));
            f2 = (float)Math.sin(f2 * ((float)Math.PI / 180));
            float f9 = this.originX;
            float f10 = this.originY;
            f5 = vector2.x - f5 - f9;
            f6 = vector2.y - f6 - f10;
            vector2.x = (f5 * f8 + f6 * f2) / f3 + f9;
            vector2.y = (f5 * -f2 + f6 * f8) / f4 + f10;
        }
        return vector2;
    }

    public Vector2 localToScreenCoordinates(Vector2 vector2) {
        j j2 = this.stage;
        if (j2 == null) {
            return vector2;
        }
        return j2.b(this.localToAscendantCoordinates(null, vector2));
    }

    public Vector2 localToStageCoordinates(Vector2 vector2) {
        return this.localToAscendantCoordinates(null, vector2);
    }

    public Vector2 localToParentCoordinates(Vector2 vector2) {
        float f2 = -this.rotation;
        float f3 = this.scaleX;
        float f4 = this.scaleY;
        float f5 = this.x;
        float f6 = this.y;
        if (f2 == 0.0f) {
            if (f3 == 1.0f && f4 == 1.0f) {
                vector2.x += f5;
                vector2.y += f6;
            } else {
                float f7 = this.originX;
                f2 = this.originY;
                vector2.x = (vector2.x - f7) * f3 + f7 + f5;
                vector2.y = (vector2.y - f2) * f4 + f2 + f6;
            }
        } else {
            float f8 = (float)Math.cos(f2 * ((float)Math.PI / 180));
            f2 = (float)Math.sin(f2 * ((float)Math.PI / 180));
            float f9 = this.originX;
            float f10 = this.originY;
            f3 = (vector2.x - f9) * f3;
            f4 = (vector2.y - f10) * f4;
            vector2.x = f3 * f8 + f4 * f2 + f9 + f5;
            vector2.y = f3 * -f2 + f4 * f8 + f10 + f6;
        }
        return vector2;
    }

    public Vector2 localToAscendantCoordinates(b b2, Vector2 vector2) {
        b b3 = this;
        do {
            b3.localToParentCoordinates(vector2);
            b3 = b3.parent;
            if (b3 != b2) continue;
            return vector2;
        } while (b3 != null);
        throw new IllegalArgumentException("Actor is not an ascendant: ".concat(String.valueOf(b2)));
    }

    public Vector2 localToActorCoordinates(b b2, Vector2 vector2) {
        this.localToStageCoordinates(vector2);
        return b2.stageToLocalCoordinates(vector2);
    }

    public void drawDebug(ShapeRenderer shapeRenderer) {
        this.drawDebugBounds(shapeRenderer);
    }

    protected void drawDebugBounds(ShapeRenderer shapeRenderer) {
        if (!this.debug) {
            return;
        }
        shapeRenderer.set(ShapeRenderer$ShapeType.Line);
        if (this.stage != null) {
            shapeRenderer.setColor(this.stage.l());
        }
        shapeRenderer.rect(this.x, this.y, this.originX, this.originY, this.width, this.height, this.scaleX, this.scaleY, this.rotation);
    }

    public void setDebug(boolean bl2) {
        this.debug = bl2;
        if (bl2) {
            j.a = true;
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public b debug() {
        this.setDebug(true);
        return this;
    }

    public String toString() {
        int n2;
        String string = this.name;
        if (string == null && (n2 = (string = this.getClass().getName()).lastIndexOf(46)) != -1) {
            string = string.substring(n2 + 1);
        }
        return string;
    }
}

