/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Frustum;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Octree;
import com.badlogic.gdx.math.Octree$RayCastResult;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.math.collision.Ray;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectSet;

public class Octree$OctreeNode {
    int level;
    final BoundingBox bounds = new BoundingBox();
    boolean leaf;
    private Octree$OctreeNode[] children;
    private final Array geometries;
    final /* synthetic */ Octree this$0;

    protected Octree$OctreeNode(Octree octree) {
        this.this$0 = octree;
        this.geometries = new Array(Math.min(16, this.this$0.maxItemsPerNode));
    }

    private void split() {
        float f2 = (this.bounds.max.x + this.bounds.min.x) * 0.5f;
        float f3 = (this.bounds.max.y + this.bounds.min.y) * 0.5f;
        float f4 = (this.bounds.max.z + this.bounds.min.z) * 0.5f;
        int n2 = this.level - 1;
        this.leaf = false;
        if (this.children == null) {
            this.children = new Octree$OctreeNode[8];
        }
        this.children[0] = this.this$0.createNode(new Vector3(this.bounds.min.x, f3, f4), new Vector3(f2, this.bounds.max.y, this.bounds.max.z), n2);
        this.children[1] = this.this$0.createNode(new Vector3(f2, f3, f4), new Vector3(this.bounds.max.x, this.bounds.max.y, this.bounds.max.z), n2);
        this.children[2] = this.this$0.createNode(new Vector3(f2, f3, this.bounds.min.z), new Vector3(this.bounds.max.x, this.bounds.max.y, f4), n2);
        this.children[3] = this.this$0.createNode(new Vector3(this.bounds.min.x, f3, this.bounds.min.z), new Vector3(f2, this.bounds.max.y, f4), n2);
        this.children[4] = this.this$0.createNode(new Vector3(this.bounds.min.x, this.bounds.min.y, f4), new Vector3(f2, f3, this.bounds.max.z), n2);
        this.children[5] = this.this$0.createNode(new Vector3(f2, this.bounds.min.y, f4), new Vector3(this.bounds.max.x, f3, this.bounds.max.z), n2);
        this.children[6] = this.this$0.createNode(new Vector3(f2, this.bounds.min.y, this.bounds.min.z), new Vector3(this.bounds.max.x, f3, f4), n2);
        this.children[7] = this.this$0.createNode(new Vector3(this.bounds.min.x, this.bounds.min.y, this.bounds.min.z), new Vector3(f2, f3, f4), n2);
        Octree$OctreeNode[] octree$OctreeNodeArray = this.children;
        int n3 = this.children.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Octree$OctreeNode octree$OctreeNode = octree$OctreeNodeArray[i2];
            for (Object e2 : this.geometries) {
                octree$OctreeNode.add(e2);
            }
        }
        this.geometries.clear();
    }

    private void merge() {
        this.clearChildren();
        this.leaf = true;
    }

    private void free() {
        this.geometries.clear();
        if (!this.leaf) {
            this.clearChildren();
        }
        this.this$0.nodePool.free(this);
    }

    private void clearChildren() {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.children[i2].free();
            this.children[i2] = null;
        }
    }

    protected void add(Object object) {
        if (!this.this$0.collider.intersects(this.bounds, object)) {
            return;
        }
        if (!this.leaf) {
            Octree$OctreeNode[] octree$OctreeNodeArray = this.children;
            int n2 = this.children.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                octree$OctreeNodeArray[i2].add(object);
            }
            return;
        }
        if (this.geometries.size >= this.this$0.maxItemsPerNode && this.level > 0) {
            this.split();
            Octree$OctreeNode[] octree$OctreeNodeArray = this.children;
            int n3 = this.children.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                octree$OctreeNodeArray[i3].add(object);
            }
            return;
        }
        this.geometries.add(object);
    }

    protected boolean remove(Object object) {
        if (!this.leaf) {
            int n2;
            boolean bl2 = false;
            Object object2 = this.children;
            int n3 = this.children.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Octree$OctreeNode octree$OctreeNode = object2[n2];
                bl2 |= octree$OctreeNode.remove(object);
            }
            if (bl2) {
                object2 = new ObjectSet();
                Object object3 = this.children;
                n2 = this.children.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    object3[i2].getAll((ObjectSet)object2);
                }
                if (((ObjectSet)object2).size <= this.this$0.maxItemsPerNode) {
                    object3 = ((ObjectSet)object2).iterator();
                    while (object3.hasNext()) {
                        Object e2 = object3.next();
                        this.geometries.add(e2);
                    }
                    this.merge();
                }
            }
            return bl2;
        }
        return this.geometries.removeValue(object, true);
    }

    protected boolean isLeaf() {
        return this.leaf;
    }

    protected void query(BoundingBox boundingBox, ObjectSet objectSet) {
        if (!boundingBox.intersects(this.bounds)) {
            return;
        }
        if (!this.leaf) {
            Octree$OctreeNode[] octree$OctreeNodeArray = this.children;
            int n2 = this.children.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                octree$OctreeNodeArray[i2].query(boundingBox, objectSet);
            }
            return;
        }
        for (Object e2 : this.geometries) {
            if (!this.this$0.collider.intersects(this.bounds, e2)) continue;
            objectSet.add(e2);
        }
    }

    protected void query(Frustum frustum, ObjectSet objectSet) {
        if (!Intersector.intersectFrustumBounds(frustum, this.bounds)) {
            return;
        }
        if (!this.leaf) {
            Octree$OctreeNode[] octree$OctreeNodeArray = this.children;
            int n2 = this.children.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                octree$OctreeNodeArray[i2].query(frustum, objectSet);
            }
            return;
        }
        for (Object e2 : this.geometries) {
            if (!this.this$0.collider.intersects(frustum, e2)) continue;
            objectSet.add(e2);
        }
    }

    protected void rayCast(Ray ray, Octree$RayCastResult octree$RayCastResult) {
        if (!Intersector.intersectRayBounds(ray, this.bounds, Octree.tmp)) {
            return;
        }
        if (Octree.tmp.dst2(ray.origin) >= octree$RayCastResult.maxDistanceSq) {
            return;
        }
        if (!this.leaf) {
            Octree$OctreeNode[] octree$OctreeNodeArray = this.children;
            int n2 = this.children.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                octree$OctreeNodeArray[i2].rayCast(ray, octree$RayCastResult);
            }
            return;
        }
        for (Object e2 : this.geometries) {
            float f2 = this.this$0.collider.intersects(ray, e2);
            if (octree$RayCastResult.geometry != null && !(f2 < octree$RayCastResult.distance)) continue;
            octree$RayCastResult.geometry = e2;
            octree$RayCastResult.distance = f2;
        }
    }

    protected void getAll(ObjectSet objectSet) {
        if (!this.leaf) {
            Octree$OctreeNode[] octree$OctreeNodeArray = this.children;
            int n2 = this.children.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                octree$OctreeNodeArray[i2].getAll(objectSet);
            }
        }
        objectSet.addAll(this.geometries);
    }

    protected void getBoundingBox(ObjectSet objectSet) {
        if (!this.leaf) {
            Octree$OctreeNode[] octree$OctreeNodeArray = this.children;
            int n2 = this.children.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                octree$OctreeNodeArray[i2].getBoundingBox(objectSet);
            }
        }
        objectSet.add(this.bounds);
    }
}

