/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Frustum;
import com.badlogic.gdx.math.Intersector$MinimumTranslationVector;
import com.badlogic.gdx.math.Intersector$SplitTriangle;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Plane$PlaneSide;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.math.collision.OrientedBoundingBox;
import com.badlogic.gdx.math.collision.Ray;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import java.util.List;

public final class Intersector {
    private static final Vector3 v0 = new Vector3();
    private static final Vector3 v1 = new Vector3();
    private static final Vector3 v2 = new Vector3();
    private static final FloatArray floatArray = new FloatArray();
    private static final FloatArray floatArray2 = new FloatArray();
    private static final Vector2 ip = new Vector2();
    private static final Vector2 ep1 = new Vector2();
    private static final Vector2 ep2 = new Vector2();
    private static final Vector2 s = new Vector2();
    private static final Vector2 e = new Vector2();
    static Vector2 v2a = new Vector2();
    static Vector2 v2b = new Vector2();
    static Vector2 v2c = new Vector2();
    static Vector2 v2d = new Vector2();
    private static final Plane p = new Plane(new Vector3(), 0.0f);
    private static final Vector3 i = new Vector3();
    private static final Vector3 dir = new Vector3();
    private static final Vector3 start = new Vector3();
    static Vector3 best = new Vector3();
    static Vector3 tmp = new Vector3();
    static Vector3 tmp1 = new Vector3();
    static Vector3 tmp2 = new Vector3();
    static Vector3 tmp3 = new Vector3();
    static Vector3 intersection = new Vector3();

    private Intersector() {
    }

    public static boolean isPointInTriangle(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34) {
        v0.set(vector32).sub(vector3);
        v1.set(vector33).sub(vector3);
        v2.set(vector34).sub(vector3);
        v1.crs(v2);
        v2.crs(v0);
        if (v1.dot(v2) < 0.0f) {
            return false;
        }
        v0.crs(v2.set(vector33).sub(vector3));
        return v1.dot(v0) >= 0.0f;
    }

    public static boolean isPointInTriangle(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        return Intersector.isPointInTriangle(vector2.x, vector2.y, vector22.x, vector22.y, vector23.x, vector23.y, vector24.x, vector24.y);
    }

    public static boolean isPointInTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        boolean bl2;
        float f10;
        float f11;
        if ((f8 - f4) * f11 - (f9 - f5) * f10 > 0.0f == (bl2 = (f6 - f4) * (f11 = f3 - f5) - (f7 - f5) * (f10 = f2 - f4) > 0.0f)) {
            return false;
        }
        return (f8 - f6) * (f3 - f7) - (f9 - f7) * (f2 - f6) > 0.0f == bl2;
    }

    public static boolean intersectSegmentPlane(Vector3 vector3, Vector3 vector32, Plane plane, Vector3 vector33) {
        float f2 = (vector32 = v0.set(vector32).sub(vector3)).dot(plane.getNormal());
        if (f2 == 0.0f) {
            return false;
        }
        float f3 = -(vector3.dot(plane.getNormal()) + plane.getD()) / f2;
        if (f3 < 0.0f || f3 > 1.0f) {
            return false;
        }
        vector33.set(vector3).add(vector32.scl(f3));
        return true;
    }

    public static int pointLineSide(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        return (int)Math.signum((vector22.x - vector2.x) * (vector23.y - vector2.y) - (vector22.y - vector2.y) * (vector23.x - vector2.x));
    }

    public static int pointLineSide(float f2, float f3, float f4, float f5, float f6, float f7) {
        return (int)Math.signum((f4 - f2) * (f7 - f3) - (f5 - f3) * (f6 - f2));
    }

    public static boolean isPointInPolygon(Array array, Vector2 vector2) {
        Vector2 vector22 = (Vector2)array.peek();
        float f2 = vector2.x;
        float f3 = vector2.y;
        boolean bl2 = false;
        for (int i2 = 0; i2 < array.size; ++i2) {
            Vector2 vector23;
            Vector2 vector24 = (Vector2)array.get(i2);
            if ((vector23.y < f3 && vector22.y >= f3 || vector22.y < f3 && vector24.y >= f3) && vector24.x + (f3 - vector24.y) / (vector22.y - vector24.y) * (vector22.x - vector24.x) < f2) {
                bl2 = !bl2;
            }
            vector22 = vector24;
        }
        return bl2;
    }

    public static boolean isPointInPolygon(float[] fArray, int n2, int n3, float f2, float f3) {
        float f4;
        boolean bl2 = false;
        float f5 = fArray[n2];
        float f6 = f4 = fArray[n2 + 1];
        int n4 = n2 + 3;
        n2 += n3;
        while (n4 < n2) {
            float f7;
            float f8;
            float f9;
            float f10 = fArray[n4];
            if ((f9 < f3 && f6 >= f3 || f6 < f3 && f10 >= f3) && f8 + (f3 - f10) / (f6 - f10) * (fArray[n4 - 3] - (f7 = fArray[n4 - 1])) < f2) {
                bl2 = !bl2;
            }
            f6 = f10;
            n4 += 2;
        }
        if ((f4 < f3 && f6 >= f3 || f6 < f3 && f4 >= f3) && f5 + (f3 - f4) / (f6 - f4) * (fArray[n4 - 3] - f5) < f2) {
            bl2 = !bl2;
        }
        return bl2;
    }

    public static boolean intersectPolygons(Polygon object, Polygon polygon, Polygon polygon2) {
        if (((Polygon)object).getVertices().length == 0 || polygon.getVertices().length == 0) {
            return false;
        }
        Vector2 vector2 = ip;
        Vector2 vector22 = ep1;
        Vector2 vector23 = ep2;
        Vector2 vector24 = s;
        Vector2 vector25 = e;
        FloatArray floatArray = Intersector.floatArray;
        FloatArray floatArray2 = Intersector.floatArray2;
        floatArray.clear();
        floatArray2.clear();
        floatArray2.addAll(((Polygon)object).getTransformedVertices());
        object = polygon.getTransformedVertices();
        int n2 = ((Object)object).length - 2;
        for (int i2 = 0; i2 <= n2; i2 += 2) {
            vector22.set((float)object[i2], (float)object[i2 + 1]);
            if (i2 < n2) {
                vector23.set((float)object[i2 + 2], (float)object[i2 + 3]);
            } else {
                vector23.set((float)object[0], (float)object[1]);
            }
            if (floatArray2.size == 0) {
                return false;
            }
            FloatArray floatArray3 = floatArray2;
            FloatArray floatArray4 = floatArray2;
            vector24.set(floatArray3.get(floatArray3.size - 2), floatArray4.get(floatArray4.size - 1));
            for (int i3 = 0; i3 < floatArray2.size; i3 += 2) {
                block20: {
                    boolean bl2;
                    block17: {
                        block18: {
                            block19: {
                                vector25.set(floatArray2.get(i3), floatArray2.get(i3 + 1));
                                boolean bl3 = bl2 = Intersector.pointLineSide(vector23, vector22, vector24) > 0;
                                if (Intersector.pointLineSide(vector23, vector22, vector25) <= 0) break block17;
                                if (bl2) break block18;
                                Intersector.intersectLines(vector24, vector25, vector22, vector23, vector2);
                                if (floatArray.size < 2) break block19;
                                FloatArray floatArray5 = floatArray;
                                if (floatArray5.get(floatArray5.size - 2) != vector2.x) break block19;
                                FloatArray floatArray6 = floatArray;
                                if (floatArray6.get(floatArray6.size - 1) == vector2.y) break block18;
                            }
                            floatArray.add(vector2.x);
                            floatArray.add(vector2.y);
                        }
                        floatArray.add(vector25.x);
                        floatArray.add(vector25.y);
                        break block20;
                    }
                    if (bl2) {
                        Intersector.intersectLines(vector24, vector25, vector22, vector23, vector2);
                        floatArray.add(vector2.x);
                        floatArray.add(vector2.y);
                    }
                }
                vector24.set(vector25.x, vector25.y);
            }
            floatArray2.clear();
            floatArray2.addAll(floatArray);
            floatArray.clear();
        }
        if (floatArray2.size >= 6) {
            FloatArray floatArray7 = floatArray2;
            if (floatArray2.get(0) == floatArray7.get(floatArray7.size - 2)) {
                FloatArray floatArray8 = floatArray2;
                if (floatArray2.get(1) == floatArray8.get(floatArray8.size - 1)) {
                    FloatArray floatArray9 = floatArray2;
                    floatArray9.setSize(floatArray9.size - 2);
                }
            }
        }
        if (floatArray2.size >= 6) {
            if (polygon2 != null) {
                polygon2.resetTransformations();
                if (polygon2.getVertices().length == floatArray2.size) {
                    System.arraycopy(floatArray2.items, 0, polygon2.getVertices(), 0, floatArray2.size);
                } else {
                    polygon2.setVertices(floatArray2.toArray());
                }
            }
            return true;
        }
        return false;
    }

    public static boolean intersectPolygons(FloatArray floatArray, FloatArray floatArray2) {
        if (Intersector.isPointInPolygon(floatArray.items, 0, floatArray.size, floatArray2.items[0], floatArray2.items[1])) {
            return true;
        }
        if (Intersector.isPointInPolygon(floatArray2.items, 0, floatArray2.size, floatArray.items[0], floatArray.items[1])) {
            return true;
        }
        return Intersector.intersectPolygonEdges(floatArray, floatArray2);
    }

    public static boolean intersectPolygonEdges(FloatArray object, FloatArray object2) {
        int n2 = ((FloatArray)object).size - 2;
        int n3 = ((FloatArray)object2).size - 2;
        object = ((FloatArray)object).items;
        object2 = ((FloatArray)object2).items;
        Object object3 = object[n2];
        Object object4 = object[n2 + 1];
        for (int i2 = 0; i2 <= n2; i2 += 2) {
            Object object5 = object[i2];
            Object object6 = object[i2 + 1];
            Object object7 = object2[n3];
            Object object8 = object2[n3 + 1];
            for (int i3 = 0; i3 <= n3; i3 += 2) {
                Object object9 = object2[i3];
                Object object10 = object2[i3 + 1];
                if (Intersector.intersectSegments((float)object3, (float)object4, (float)object5, (float)object6, (float)object7, (float)object8, (float)object9, (float)object10, null)) {
                    return true;
                }
                object7 = object9;
                object8 = object10;
            }
            object3 = object5;
            object4 = object6;
        }
        return false;
    }

    public static float distanceLinePoint(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = Vector2.len(f4 - f2, f5 - f3);
        return Math.abs((f6 - f2) * (f5 - f3) - (f7 - f3) * (f4 - f2)) / f8;
    }

    public static float distanceSegmentPoint(float f2, float f3, float f4, float f5, float f6, float f7) {
        return Intersector.nearestSegmentPoint(f2, f3, f4, f5, f6, f7, v2a).dst(f6, f7);
    }

    public static float distanceSegmentPoint(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        return Intersector.nearestSegmentPoint(vector2, vector22, vector23, v2a).dst(vector23);
    }

    public static Vector2 nearestSegmentPoint(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        float f2;
        float f3 = vector2.dst2(vector22);
        if (f3 == 0.0f) {
            return vector24.set(vector2);
        }
        float f4 = ((vector23.x - vector2.x) * (vector22.x - vector2.x) + (vector23.y - vector2.y) * (vector22.y - vector2.y)) / f3;
        if (f2 <= 0.0f) {
            return vector24.set(vector2);
        }
        if (f4 >= 1.0f) {
            return vector24.set(vector22);
        }
        return vector24.set(vector2.x + f4 * (vector22.x - vector2.x), vector2.y + f4 * (vector22.y - vector2.y));
    }

    public static Vector2 nearestSegmentPoint(float f2, float f3, float f4, float f5, float f6, float f7, Vector2 vector2) {
        float f8;
        float f9 = f4 - f2;
        float f10 = f5 - f3;
        float f11 = f9;
        float f12 = f10;
        f9 = f11 * f11 + f12 * f12;
        if (f9 == 0.0f) {
            return vector2.set(f2, f3);
        }
        f6 = ((f6 - f2) * (f4 - f2) + (f7 - f3) * (f5 - f3)) / f9;
        if (f8 <= 0.0f) {
            return vector2.set(f2, f3);
        }
        if (f6 >= 1.0f) {
            return vector2.set(f4, f5);
        }
        return vector2.set(f2 + f6 * (f4 - f2), f3 + f6 * (f5 - f3));
    }

    public static boolean intersectSegmentCircle(Vector2 vector2, Vector2 vector22, Vector2 vector23, float f2) {
        float f3;
        tmp.set(vector22.x - vector2.x, vector22.y - vector2.y, 0.0f);
        tmp1.set(vector23.x - vector2.x, vector23.y - vector2.y, 0.0f);
        float f4 = tmp.len();
        float f5 = tmp1.dot(tmp.nor());
        if (f3 <= 0.0f) {
            tmp2.set(vector2.x, vector2.y, 0.0f);
        } else if (f5 >= f4) {
            tmp2.set(vector22.x, vector22.y, 0.0f);
        } else {
            tmp3.set(tmp.scl(f5));
            tmp2.set(Intersector.tmp3.x + vector2.x, Intersector.tmp3.y + vector2.y, 0.0f);
        }
        float f6 = vector23.x - Intersector.tmp2.x;
        float f7 = vector23.y - Intersector.tmp2.y;
        float f8 = f6;
        float f9 = f7;
        return f8 * f8 + f9 * f9 <= f2;
    }

    public static boolean intersectSegmentCircle(Vector2 vector2, Vector2 vector22, Circle circle, Intersector$MinimumTranslationVector intersector$MinimumTranslationVector) {
        float f2;
        v2a.set(vector22).sub(vector2);
        v2b.set(circle.x - vector2.x, circle.y - vector2.y);
        float f3 = v2a.len();
        float f4 = v2b.dot(v2a.nor());
        if (f2 <= 0.0f) {
            v2c.set(vector2);
        } else if (f4 >= f3) {
            v2c.set(vector22);
        } else {
            v2d.set(v2a.scl(f4));
            v2c.set(v2d).add(vector2);
        }
        v2a.set(Intersector.v2c.x - circle.x, Intersector.v2c.y - circle.y);
        if (intersector$MinimumTranslationVector != null) {
            if (v2a.equals(Vector2.Zero)) {
                v2d.set(vector22.y - vector2.y, vector2.x - vector22.x);
                intersector$MinimumTranslationVector.normal.set(v2d).nor();
                intersector$MinimumTranslationVector.depth = circle.radius;
            } else {
                intersector$MinimumTranslationVector.normal.set(v2a).nor();
                intersector$MinimumTranslationVector.depth = circle.radius - v2a.len();
            }
        }
        return v2a.len2() <= circle.radius * circle.radius;
    }

    public static boolean intersectFrustumBounds(Frustum vector3Array, BoundingBox boundingBox) {
        if (vector3Array.pointInFrustum(boundingBox.getCorner000(tmp)) || vector3Array.pointInFrustum(boundingBox.getCorner001(tmp)) || vector3Array.pointInFrustum(boundingBox.getCorner010(tmp)) || vector3Array.pointInFrustum(boundingBox.getCorner011(tmp)) || vector3Array.pointInFrustum(boundingBox.getCorner100(tmp)) || vector3Array.pointInFrustum(boundingBox.getCorner101(tmp)) || vector3Array.pointInFrustum(boundingBox.getCorner110(tmp)) || vector3Array.pointInFrustum(boundingBox.getCorner111(tmp))) {
            return true;
        }
        boolean bl2 = false;
        vector3Array = vector3Array.planePoints;
        int n2 = vector3Array.planePoints.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Vector3 vector3 = vector3Array[i2];
            bl2 |= boundingBox.contains(vector3);
        }
        return bl2;
    }

    public static boolean intersectFrustumBounds(Frustum object, OrientedBoundingBox orientedBoundingBox) {
        boolean bl2 = false;
        for (Vector3 vector3 : orientedBoundingBox.getVertices()) {
            bl2 |= ((Frustum)object).pointInFrustum(vector3);
        }
        if (bl2) {
            return true;
        }
        boolean bl3 = false;
        Vector3[] vector3Array = ((Frustum)object).planePoints;
        int n2 = ((Frustum)object).planePoints.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = vector3Array[i2];
            bl3 |= orientedBoundingBox.contains((Vector3)object);
        }
        return bl3;
    }

    public static float intersectRayRay(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        float f2 = vector23.x - vector2.x;
        float f3 = vector23.y - vector2.y;
        float f4 = vector22.x * vector24.y - vector22.y * vector24.x;
        if (f4 == 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        float f5 = vector24.x / f4;
        f4 = vector24.y / f4;
        return f2 * f4 - f3 * f5;
    }

    public static boolean intersectRayPlane(Ray ray, Plane plane, Vector3 vector3) {
        float f2 = ray.direction.dot(plane.getNormal());
        if (f2 != 0.0f) {
            float f3;
            float f4 = -(ray.origin.dot(plane.getNormal()) + plane.getD()) / f2;
            if (f3 < 0.0f) {
                return false;
            }
            if (vector3 != null) {
                vector3.set(ray.origin).add(v0.set(ray.direction).scl(f4));
            }
            return true;
        }
        if (plane.testPoint(ray.origin) == Plane$PlaneSide.OnPlane) {
            if (vector3 != null) {
                vector3.set(ray.origin);
            }
            return true;
        }
        return false;
    }

    public static float intersectLinePlane(float f2, float f3, float f4, float f5, float f6, float f7, Plane plane, Vector3 vector3) {
        Vector3 vector32 = tmp.set(f5, f6, f7).sub(f2, f3, f4);
        Vector3 vector33 = tmp2.set(f2, f3, f4);
        f3 = vector32.dot(plane.getNormal());
        if (f3 != 0.0f) {
            f3 = -(vector33.dot(plane.getNormal()) + plane.getD()) / f3;
            if (vector3 != null) {
                vector3.set(vector33).add(vector32.scl(f3));
            }
            return f3;
        }
        if (plane.testPoint(vector33) == Plane$PlaneSide.OnPlane) {
            if (vector3 != null) {
                vector3.set(vector33);
            }
            return 0.0f;
        }
        return -1.0f;
    }

    public static boolean intersectPlanes(Plane plane, Plane plane2, Plane plane3, Vector3 vector3) {
        float f2;
        tmp1.set(plane.normal).crs(plane2.normal);
        tmp2.set(plane2.normal).crs(plane3.normal);
        tmp3.set(plane3.normal).crs(plane.normal);
        float f3 = -plane.normal.dot(tmp2);
        if (Math.abs(f2) < 1.0E-6f) {
            return false;
        }
        tmp1.scl(plane3.d);
        tmp2.scl(plane.d);
        tmp3.scl(plane2.d);
        vector3.set(Intersector.tmp1.x + Intersector.tmp2.x + Intersector.tmp3.x, Intersector.tmp1.y + Intersector.tmp2.y + Intersector.tmp3.y, Intersector.tmp1.z + Intersector.tmp2.z + Intersector.tmp3.z);
        vector3.scl(1.0f / f3);
        return true;
    }

    public static boolean intersectRayTriangle(Ray ray, Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34) {
        float f2;
        Vector3 vector35 = v0.set(vector32).sub(vector3);
        Vector3 vector36 = v1.set(vector33).sub(vector3);
        Vector3 vector37 = v2.set(ray.direction).crs(vector36);
        float f3 = vector35.dot(vector37);
        if (MathUtils.isZero(f3)) {
            p.set(vector3, vector32, vector33);
            if (p.testPoint(ray.origin) == Plane$PlaneSide.OnPlane && Intersector.isPointInTriangle(ray.origin, vector3, vector32, vector33)) {
                if (vector34 != null) {
                    vector34.set(ray.origin);
                }
                return true;
            }
            return false;
        }
        f3 = 1.0f / f3;
        vector3 = i.set(ray.origin).sub(vector3);
        float f4 = vector3.dot(vector37) * f3;
        if (f4 < 0.0f || f4 > 1.0f) {
            return false;
        }
        float f5 = ray.direction.dot(vector3 = vector3.crs(vector35)) * f3;
        if (f5 < 0.0f || f4 + f5 > 1.0f) {
            return false;
        }
        float f6 = vector36.dot(vector3) * f3;
        if (f2 < 0.0f) {
            return false;
        }
        if (vector34 != null) {
            if (f6 <= 1.0E-6f) {
                vector34.set(ray.origin);
            } else {
                ray.getEndPoint(vector34, f6);
            }
        }
        return true;
    }

    public static boolean intersectRaySphere(Ray ray, Vector3 vector3, float f2, Vector3 vector32) {
        float f3;
        float f4 = ray.direction.dot(vector3.x - ray.origin.x, vector3.y - ray.origin.y, vector3.z - ray.origin.z);
        if (f3 < 0.0f) {
            return false;
        }
        float f5 = vector3.dst2(ray.origin.x + ray.direction.x * f4, ray.origin.y + ray.direction.y * f4, ray.origin.z + ray.direction.z * f4);
        float f6 = f2;
        f2 = f6 * f6;
        if (f5 > f2) {
            return false;
        }
        if (vector32 != null) {
            vector32.set(ray.direction).scl(f4 - (float)Math.sqrt(f2 - f5)).add(ray.origin);
        }
        return true;
    }

    public static boolean intersectRayBounds(Ray ray, BoundingBox boundingBox, Vector3 vector3) {
        float f2;
        if (boundingBox.contains(ray.origin)) {
            if (vector3 != null) {
                vector3.set(ray.origin);
            }
            return true;
        }
        float f3 = 0.0f;
        boolean bl2 = false;
        if (ray.origin.x <= boundingBox.min.x && ray.direction.x > 0.0f) {
            float f4;
            f2 = (boundingBox.min.x - ray.origin.x) / ray.direction.x;
            if (f4 >= 0.0f) {
                v2.set(ray.direction).scl(f2).add(ray.origin);
                if (Intersector.v2.y >= boundingBox.min.y && Intersector.v2.y <= boundingBox.max.y && Intersector.v2.z >= boundingBox.min.z && Intersector.v2.z <= boundingBox.max.z) {
                    bl2 = true;
                    f3 = f2;
                }
            }
        }
        if (ray.origin.x >= boundingBox.max.x && ray.direction.x < 0.0f) {
            float f5;
            f2 = (boundingBox.max.x - ray.origin.x) / ray.direction.x;
            if (f5 >= 0.0f) {
                v2.set(ray.direction).scl(f2).add(ray.origin);
                if (Intersector.v2.y >= boundingBox.min.y && Intersector.v2.y <= boundingBox.max.y && Intersector.v2.z >= boundingBox.min.z && Intersector.v2.z <= boundingBox.max.z && (!bl2 || f2 < f3)) {
                    bl2 = true;
                    f3 = f2;
                }
            }
        }
        if (ray.origin.y <= boundingBox.min.y && ray.direction.y > 0.0f) {
            float f6;
            f2 = (boundingBox.min.y - ray.origin.y) / ray.direction.y;
            if (f6 >= 0.0f) {
                v2.set(ray.direction).scl(f2).add(ray.origin);
                if (Intersector.v2.x >= boundingBox.min.x && Intersector.v2.x <= boundingBox.max.x && Intersector.v2.z >= boundingBox.min.z && Intersector.v2.z <= boundingBox.max.z && (!bl2 || f2 < f3)) {
                    bl2 = true;
                    f3 = f2;
                }
            }
        }
        if (ray.origin.y >= boundingBox.max.y && ray.direction.y < 0.0f) {
            float f7;
            f2 = (boundingBox.max.y - ray.origin.y) / ray.direction.y;
            if (f7 >= 0.0f) {
                v2.set(ray.direction).scl(f2).add(ray.origin);
                if (Intersector.v2.x >= boundingBox.min.x && Intersector.v2.x <= boundingBox.max.x && Intersector.v2.z >= boundingBox.min.z && Intersector.v2.z <= boundingBox.max.z && (!bl2 || f2 < f3)) {
                    bl2 = true;
                    f3 = f2;
                }
            }
        }
        if (ray.origin.z <= boundingBox.min.z && ray.direction.z > 0.0f) {
            float f8;
            f2 = (boundingBox.min.z - ray.origin.z) / ray.direction.z;
            if (f8 >= 0.0f) {
                v2.set(ray.direction).scl(f2).add(ray.origin);
                if (Intersector.v2.x >= boundingBox.min.x && Intersector.v2.x <= boundingBox.max.x && Intersector.v2.y >= boundingBox.min.y && Intersector.v2.y <= boundingBox.max.y && (!bl2 || f2 < f3)) {
                    bl2 = true;
                    f3 = f2;
                }
            }
        }
        if (ray.origin.z >= boundingBox.max.z && ray.direction.z < 0.0f) {
            float f9;
            f2 = (boundingBox.max.z - ray.origin.z) / ray.direction.z;
            if (f9 >= 0.0f) {
                v2.set(ray.direction).scl(f2).add(ray.origin);
                if (Intersector.v2.x >= boundingBox.min.x && Intersector.v2.x <= boundingBox.max.x && Intersector.v2.y >= boundingBox.min.y && Intersector.v2.y <= boundingBox.max.y && (!bl2 || f2 < f3)) {
                    bl2 = true;
                    f3 = f2;
                }
            }
        }
        if (bl2 && vector3 != null) {
            vector3.set(ray.direction).scl(f3).add(ray.origin);
            if (vector3.x < boundingBox.min.x) {
                vector3.x = boundingBox.min.x;
            } else if (vector3.x > boundingBox.max.x) {
                vector3.x = boundingBox.max.x;
            }
            if (vector3.y < boundingBox.min.y) {
                vector3.y = boundingBox.min.y;
            } else if (vector3.y > boundingBox.max.y) {
                vector3.y = boundingBox.max.y;
            }
            if (vector3.z < boundingBox.min.z) {
                vector3.z = boundingBox.min.z;
            } else if (vector3.z > boundingBox.max.z) {
                vector3.z = boundingBox.max.z;
            }
        }
        return bl2;
    }

    public static boolean intersectRayBoundsFast(Ray ray, BoundingBox boundingBox) {
        return Intersector.intersectRayBoundsFast(ray, boundingBox.getCenter(tmp1), boundingBox.getDimensions(tmp2));
    }

    public static boolean intersectRayBoundsFast(Ray ray, Vector3 vector3, Vector3 vector32) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6 = 1.0f / ray.direction.x;
        float f7 = 1.0f / ray.direction.y;
        float f8 = 1.0f / ray.direction.z;
        float f9 = (vector3.x - vector32.x * 0.5f - ray.origin.x) * f6;
        if (f9 > (f6 = (vector3.x + vector32.x * 0.5f - ray.origin.x) * f6)) {
            f5 = f9;
            f9 = f6;
            f6 = f5;
        }
        if ((f5 = (vector3.y - vector32.y * 0.5f - ray.origin.y) * f7) > (f7 = (vector3.y + vector32.y * 0.5f - ray.origin.y) * f7)) {
            f4 = f5;
            f5 = f7;
            f7 = f4;
        }
        if ((f4 = (vector3.z - vector32.z * 0.5f - ray.origin.z) * f8) > (f3 = (vector3.z + vector32.z * 0.5f - ray.origin.z) * f8)) {
            float f10 = f4;
            f4 = f3;
            f3 = f10;
        }
        float f11 = Math.max(Math.max(f9, f5), f4);
        f3 = Math.min(Math.min(f6, f7), f3);
        return f2 >= 0.0f && f3 >= f11;
    }

    public static boolean intersectRayOrientedBoundsFast(Ray ray, OrientedBoundingBox orientedBoundingBox) {
        return Intersector.intersectRayOrientedBounds(ray, orientedBoundingBox, null);
    }

    public static boolean intersectRayOrientedBoundsFast(Ray ray, BoundingBox boundingBox, Matrix4 matrix4) {
        return Intersector.intersectRayOrientedBounds(ray, boundingBox, matrix4, null);
    }

    public static boolean intersectRayOrientedBounds(Ray ray, OrientedBoundingBox serializable, Vector3 vector3) {
        BoundingBox boundingBox = serializable.getBounds();
        serializable = serializable.getTransform();
        return Intersector.intersectRayOrientedBounds(ray, boundingBox, (Matrix4)serializable, vector3);
    }

    public static boolean intersectRayOrientedBounds(Ray ray, BoundingBox boundingBox, Matrix4 matrix4, Vector3 vector3) {
        float f2;
        float f3;
        float f4;
        float f5 = 0.0f;
        float f6 = Float.MAX_VALUE;
        Vector3 vector32 = matrix4.getTranslation(tmp).sub(ray.origin);
        Vector3 vector33 = tmp1;
        tmp1.set(matrix4.val[0], matrix4.val[1], matrix4.val[2]);
        float f7 = vector33.dot(vector32);
        float f8 = ray.direction.dot(vector33);
        if (Math.abs(f4) > 1.0E-6f) {
            float f9 = (f7 + boundingBox.min.x) / f8;
            if (f9 > (f7 = (f7 + boundingBox.max.x) / f8)) {
                f8 = f9;
                f9 = f7;
                f7 = f8;
            }
            if (f7 < Float.MAX_VALUE) {
                f6 = f7;
            }
            if (f9 > 0.0f) {
                f5 = f9;
            }
            if (f6 < f5) {
                return false;
            }
        } else if (-f7 + boundingBox.min.x > 0.0f || -f7 + boundingBox.max.x < 0.0f) {
            return false;
        }
        Vector3 vector34 = tmp2;
        tmp2.set(matrix4.val[4], matrix4.val[5], matrix4.val[6]);
        f7 = vector34.dot(vector32);
        float f10 = ray.direction.dot(vector34);
        if (Math.abs(f3) > 1.0E-6f) {
            float f11 = (f7 + boundingBox.min.y) / f10;
            if (f11 > (f7 = (f7 + boundingBox.max.y) / f10)) {
                f10 = f11;
                f11 = f7;
                f7 = f10;
            }
            if (f7 < f6) {
                f6 = f7;
            }
            if (f11 > f5) {
                f5 = f11;
            }
            if (f5 > f6) {
                return false;
            }
        } else if (-f7 + boundingBox.min.y > 0.0f || -f7 + boundingBox.max.y < 0.0f) {
            return false;
        }
        Vector3 vector35 = tmp3;
        tmp3.set(matrix4.val[8], matrix4.val[9], matrix4.val[10]);
        f7 = vector35.dot(vector32);
        float f12 = ray.direction.dot(vector35);
        if (Math.abs(f2) > 1.0E-6f) {
            float f13 = (f7 + boundingBox.min.z) / f12;
            if (f13 > (f7 = (f7 + boundingBox.max.z) / f12)) {
                float f14 = f13;
                f13 = f7;
                f7 = f14;
            }
            if (f7 < f6) {
                f6 = f7;
            }
            if (f13 > f5) {
                f5 = f13;
            }
            if (f5 > f6) {
                return false;
            }
        } else if (-f7 + boundingBox.min.z > 0.0f || -f7 + boundingBox.max.z < 0.0f) {
            return false;
        }
        if (vector3 != null) {
            ray.getEndPoint(vector3, f5);
        }
        return true;
    }

    public static boolean intersectRayTriangles(Ray ray, float[] fArray, Vector3 vector3) {
        float f2 = Float.MAX_VALUE;
        boolean bl2 = false;
        if (fArray.length % 9 != 0) {
            throw new RuntimeException("triangles array size is not a multiple of 9");
        }
        for (int i2 = 0; i2 < fArray.length; i2 += 9) {
            float f3;
            if (!Intersector.intersectRayTriangle(ray, tmp1.set(fArray[i2], fArray[i2 + 1], fArray[i2 + 2]), tmp2.set(fArray[i2 + 3], fArray[i2 + 4], fArray[i2 + 5]), tmp3.set(fArray[i2 + 6], fArray[i2 + 7], fArray[i2 + 8]), tmp)) continue;
            float f4 = ray.origin.dst2(tmp);
            if (!(f3 < f2)) continue;
            f2 = f4;
            best.set(tmp);
            bl2 = true;
        }
        if (!bl2) {
            return false;
        }
        if (vector3 != null) {
            vector3.set(best);
        }
        return true;
    }

    public static boolean intersectRayTriangles(Ray ray, float[] fArray, short[] sArray, int n2, Vector3 vector3) {
        float f2 = Float.MAX_VALUE;
        boolean bl2 = false;
        if (sArray.length % 3 != 0) {
            throw new RuntimeException("triangle list size is not a multiple of 3");
        }
        for (int i2 = 0; i2 < sArray.length; i2 += 3) {
            float f3;
            int n3 = sArray[i2] * n2;
            int n4 = sArray[i2 + 1] * n2;
            int n5 = sArray[i2 + 2] * n2;
            if (!Intersector.intersectRayTriangle(ray, tmp1.set(fArray[n3], fArray[n3 + 1], fArray[n3 + 2]), tmp2.set(fArray[n4], fArray[n4 + 1], fArray[n4 + 2]), tmp3.set(fArray[n5], fArray[n5 + 1], fArray[n5 + 2]), tmp)) continue;
            float f4 = ray.origin.dst2(tmp);
            if (!(f3 < f2)) continue;
            f2 = f4;
            best.set(tmp);
            bl2 = true;
        }
        if (!bl2) {
            return false;
        }
        if (vector3 != null) {
            vector3.set(best);
        }
        return true;
    }

    public static boolean intersectRayTriangles(Ray ray, List list, Vector3 vector3) {
        float f2 = Float.MAX_VALUE;
        boolean bl2 = false;
        if (list.size() % 3 != 0) {
            throw new RuntimeException("triangle list size is not a multiple of 3");
        }
        for (int i2 = 0; i2 < list.size(); i2 += 3) {
            float f3;
            if (!Intersector.intersectRayTriangle(ray, (Vector3)list.get(i2), (Vector3)list.get(i2 + 1), (Vector3)list.get(i2 + 2), tmp)) continue;
            float f4 = ray.origin.dst2(tmp);
            if (!(f3 < f2)) continue;
            f2 = f4;
            best.set(tmp);
            bl2 = true;
        }
        if (!bl2) {
            return false;
        }
        if (vector3 != null) {
            vector3.set(best);
        }
        return true;
    }

    public static boolean intersectBoundsPlaneFast(BoundingBox boundingBox, Plane plane) {
        return Intersector.intersectBoundsPlaneFast(boundingBox.getCenter(tmp1), boundingBox.getDimensions(tmp2).scl(0.5f), plane.normal, plane.d);
    }

    public static boolean intersectBoundsPlaneFast(Vector3 vector3, Vector3 vector32, Vector3 vector33, float f2) {
        float f3 = vector32.x * Math.abs(vector33.x) + vector32.y * Math.abs(vector33.y) + vector32.z * Math.abs(vector33.z);
        return Math.abs(vector33.dot(vector3) - f2) <= f3;
    }

    public static boolean intersectLines(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24, Vector2 vector25) {
        return Intersector.intersectLines(vector2.x, vector2.y, vector22.x, vector22.y, vector23.x, vector23.y, vector24.x, vector24.y, vector25);
    }

    public static boolean intersectLines(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Vector2 vector2) {
        float f10 = (f9 - f7) * (f4 - f2) - (f8 - f6) * (f5 - f3);
        if (f10 == 0.0f) {
            return false;
        }
        if (vector2 != null) {
            f6 = ((f8 - f6) * (f3 - f7) - (f9 - f7) * (f2 - f6)) / f10;
            vector2.set(f2 + (f4 - f2) * f6, f3 + (f5 - f3) * f6);
        }
        return true;
    }

    public static boolean intersectLinePolygon(Vector2 vector2, Vector2 vector22, Polygon object) {
        object = ((Polygon)object).getTransformedVertices();
        float f2 = vector2.x;
        float f3 = vector2.y;
        float f4 = vector22.x;
        float f5 = vector22.y;
        int n2 = ((Object)object).length;
        reference var6_8 = object[n2 - 2];
        Object object2 = object[n2 - 1];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            Object object3 = object[i2 + 1];
            Object object4 = object[i2];
            reference var11_13 = (object3 - object2) * (f4 - f2) - (object4 - var6_8) * (f5 - f3);
            if (var11_13 != 0.0f) {
                reference v0;
                float f6 = f3 - object2;
                float f7 = f2 - var6_8;
                var6_8 = ((object4 - var6_8) * f6 - (object3 - object2) * f7) / var11_13;
                if (v0 >= 0.0f && var6_8 <= 1.0f) {
                    return true;
                }
            }
            var6_8 = object4;
            object2 = object3;
        }
        return false;
    }

    public static boolean intersectRectangles(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (rectangle.overlaps(rectangle2)) {
            rectangle3.x = Math.max(rectangle.x, rectangle2.x);
            rectangle3.width = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width) - rectangle3.x;
            rectangle3.y = Math.max(rectangle.y, rectangle2.y);
            rectangle3.height = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - rectangle3.y;
            return true;
        }
        return false;
    }

    public static boolean intersectSegmentRectangle(float f2, float f3, float f4, float f5, Rectangle rectangle) {
        float f6 = rectangle.x + rectangle.width;
        float f7 = rectangle.y + rectangle.height;
        if (Intersector.intersectSegments(f2, f3, f4, f5, rectangle.x, rectangle.y, rectangle.x, f7, null)) {
            return true;
        }
        if (Intersector.intersectSegments(f2, f3, f4, f5, rectangle.x, rectangle.y, f6, rectangle.y, null)) {
            return true;
        }
        if (Intersector.intersectSegments(f2, f3, f4, f5, f6, rectangle.y, f6, f7, null)) {
            return true;
        }
        if (Intersector.intersectSegments(f2, f3, f4, f5, rectangle.x, f7, f6, f7, null)) {
            return true;
        }
        return rectangle.contains(f2, f3);
    }

    public static boolean intersectSegmentRectangle(Vector2 vector2, Vector2 vector22, Rectangle rectangle) {
        return Intersector.intersectSegmentRectangle(vector2.x, vector2.y, vector22.x, vector22.y, rectangle);
    }

    public static boolean intersectSegmentPolygon(Vector2 vector2, Vector2 vector22, Polygon object) {
        object = ((Polygon)object).getTransformedVertices();
        float f2 = vector2.x;
        float f3 = vector2.y;
        float f4 = vector22.x;
        float f5 = vector22.y;
        int n2 = ((Object)object).length;
        Object object2 = object[n2 - 2];
        Object object3 = object[n2 - 1];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            Object object4 = object[i2 + 1];
            Object object5 = object[i2];
            reference var11_13 = (object4 - object3) * (f4 - f2) - (object5 - object2) * (f5 - f3);
            if (var11_13 != 0.0f) {
                reference v0;
                float f6 = f3 - object3;
                float f7 = f2 - object2;
                object2 = ((object5 - object2) * f6 - (object4 - object3) * f7) / var11_13;
                if (v0 >= 0.0f && object2 <= 1.0f) {
                    float f8 = ((f4 - f2) * f6 - (f5 - f3) * f7) / var11_13;
                    object2 = f8;
                    if (f8 >= 0.0f && object2 <= 1.0f) {
                        return true;
                    }
                }
            }
            object2 = object5;
            object3 = object4;
        }
        return false;
    }

    public static boolean intersectSegments(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24, Vector2 vector25) {
        return Intersector.intersectSegments(vector2.x, vector2.y, vector22.x, vector22.y, vector23.x, vector23.y, vector24.x, vector24.y, vector25);
    }

    public static boolean intersectSegments(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Vector2 vector2) {
        float f10 = (f9 - f7) * (f4 - f2) - (f8 - f6) * (f5 - f3);
        if (f10 == 0.0f) {
            return false;
        }
        float f11 = f3 - f7;
        float f12 = f2 - f6;
        if ((f6 = ((f8 - f6) * f11 - (f9 - f7) * f12) / f10) < 0.0f || f6 > 1.0f) {
            return false;
        }
        f7 = ((f4 - f2) * f11 - (f5 - f3) * f12) / f10;
        if (f7 < 0.0f || f7 > 1.0f) {
            return false;
        }
        if (vector2 != null) {
            vector2.set(f2 + (f4 - f2) * f6, f3 + (f5 - f3) * f6);
        }
        return true;
    }

    static float det(float f2, float f3, float f4, float f5) {
        return f2 * f5 - f3 * f4;
    }

    static double detd(double d2, double d3, double d4, double d5) {
        return d2 * d5 - d3 * d4;
    }

    public static boolean overlaps(Circle circle, Circle circle2) {
        return circle.overlaps(circle2);
    }

    public static boolean overlaps(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.overlaps(rectangle2);
    }

    public static boolean overlaps(Circle circle, Rectangle rectangle) {
        float f2 = circle.x;
        float f3 = circle.y;
        if (circle.x < rectangle.x) {
            f2 = rectangle.x;
        } else if (circle.x > rectangle.x + rectangle.width) {
            f2 = rectangle.x + rectangle.width;
        }
        if (circle.y < rectangle.y) {
            f3 = rectangle.y;
        } else if (circle.y > rectangle.y + rectangle.height) {
            f3 = rectangle.y + rectangle.height;
        }
        float f4 = f2 - circle.x;
        f2 = f4 * f4;
        float f5 = f3 - circle.y;
        f3 = f5 * f5;
        return f2 + f3 < circle.radius * circle.radius;
    }

    public static boolean overlapConvexPolygons(Polygon polygon, Polygon polygon2) {
        return Intersector.overlapConvexPolygons(polygon, polygon2, null);
    }

    public static boolean overlapConvexPolygons(Polygon polygon, Polygon polygon2, Intersector$MinimumTranslationVector intersector$MinimumTranslationVector) {
        return Intersector.overlapConvexPolygons(polygon.getTransformedVertices(), polygon2.getTransformedVertices(), intersector$MinimumTranslationVector);
    }

    public static boolean overlapConvexPolygons(float[] fArray, float[] fArray2, Intersector$MinimumTranslationVector intersector$MinimumTranslationVector) {
        return Intersector.overlapConvexPolygons(fArray, 0, fArray.length, fArray2, 0, fArray2.length, intersector$MinimumTranslationVector);
    }

    public static boolean overlapConvexPolygons(float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, Intersector$MinimumTranslationVector intersector$MinimumTranslationVector) {
        boolean bl2;
        if (intersector$MinimumTranslationVector != null) {
            intersector$MinimumTranslationVector.depth = Float.MAX_VALUE;
            intersector$MinimumTranslationVector.normal.setZero();
        }
        if (bl2 = Intersector.overlapsOnAxisOfShape(fArray2, n4, n5, fArray, n2, n3, intersector$MinimumTranslationVector, true)) {
            bl2 = Intersector.overlapsOnAxisOfShape(fArray, n2, n3, fArray2, n4, n5, intersector$MinimumTranslationVector, false);
        }
        if (!bl2) {
            if (intersector$MinimumTranslationVector != null) {
                intersector$MinimumTranslationVector.depth = 0.0f;
                intersector$MinimumTranslationVector.normal.setZero();
            }
            return false;
        }
        return true;
    }

    private static boolean overlapsOnAxisOfShape(float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, Intersector$MinimumTranslationVector intersector$MinimumTranslationVector, boolean bl2) {
        int n6 = n2 + n3;
        n5 = n4 + n5;
        for (int i2 = n2; i2 < n6; i2 += 2) {
            boolean bl3;
            float f2;
            float f3 = fArray[i2];
            float f4 = fArray[i2 + 1];
            float f5 = fArray[(i2 + 2) % n3];
            float f6 = fArray[(i2 + 3) % n3];
            f3 = -(f3 - f5);
            f5 = Vector2.len(f4 -= f6, f3);
            f4 /= f5;
            f3 /= f5;
            f5 = Float.MAX_VALUE;
            f6 = -3.4028235E38f;
            for (int i3 = n2; i3 < n6; i3 += 2) {
                f2 = fArray[i3] * f4 + fArray[i3 + 1] * f3;
                f5 = Math.min(f5, f2);
                f6 = Math.max(f6, f2);
            }
            float f7 = Float.MAX_VALUE;
            f2 = -3.4028235E38f;
            for (int i4 = n4; i4 < n5; i4 += 2) {
                float f8 = fArray2[i4] * f4 + fArray2[i4 + 1] * f3;
                f7 = Math.min(f7, f8);
                f2 = Math.max(f2, f8);
            }
            if (f6 < f7 || f2 < f5) {
                return false;
            }
            if (intersector$MinimumTranslationVector == null) continue;
            float f9 = Math.min(f6, f2) - Math.max(f5, f7);
            boolean bl4 = f5 < f7 && f6 > f2;
            boolean bl5 = f7 < f5 && f2 > f6;
            float f10 = 0.0f;
            float f11 = 0.0f;
            if (bl4 || bl5) {
                f10 = Math.abs(f5 - f7);
                f11 = Math.abs(f6 - f2);
                f9 += Math.min(f10, f11);
            }
            if (!(intersector$MinimumTranslationVector.depth > f9)) continue;
            intersector$MinimumTranslationVector.depth = f9;
            if (bl2) {
                bl3 = f5 < f7;
                f4 = bl3 ? f4 : -f4;
                f3 = bl3 ? f3 : -f3;
            } else {
                bl3 = f5 > f7;
                f4 = bl3 ? f4 : -f4;
                float f12 = f3 = bl3 ? f3 : -f3;
            }
            if (bl4 || bl5) {
                bl3 = f10 > f11;
                f4 = bl3 ? f4 : -f4;
                f3 = bl3 ? f3 : -f3;
            }
            intersector$MinimumTranslationVector.normal.set(f4, f3);
        }
        return true;
    }

    public static void splitTriangle(float[] fArray, Plane plane, Intersector$SplitTriangle intersector$SplitTriangle) {
        int n2 = fArray.length / 3;
        boolean bl2 = plane.testPoint(fArray[0], fArray[1], fArray[2]) == Plane$PlaneSide.Back;
        boolean bl3 = plane.testPoint(fArray[n2], fArray[n2 + 1], fArray[n2 + 2]) == Plane$PlaneSide.Back;
        boolean bl4 = plane.testPoint(fArray[0 + (n2 << 1)], fArray[1 + (n2 << 1)], fArray[2 + (n2 << 1)]) == Plane$PlaneSide.Back;
        intersector$SplitTriangle.reset();
        if (bl2 == bl3 && bl3 == bl4) {
            intersector$SplitTriangle.total = 1;
            if (bl2) {
                intersector$SplitTriangle.numBack = 1;
                System.arraycopy(fArray, 0, intersector$SplitTriangle.back, 0, fArray.length);
                return;
            }
            intersector$SplitTriangle.numFront = 1;
            System.arraycopy(fArray, 0, intersector$SplitTriangle.front, 0, fArray.length);
            return;
        }
        intersector$SplitTriangle.total = 3;
        intersector$SplitTriangle.numFront = (bl2 ? 0 : 1) + (bl3 ? 0 : 1) + (bl4 ? 0 : 1);
        intersector$SplitTriangle.numBack = intersector$SplitTriangle.total - intersector$SplitTriangle.numFront;
        intersector$SplitTriangle.setSide(!bl2);
        int n3 = n2;
        if (bl2 != bl3) {
            Intersector.splitEdge(fArray, 0, n3, n2, plane, intersector$SplitTriangle.edgeSplit, 0);
            intersector$SplitTriangle.add(fArray, 0, n2);
            Intersector$SplitTriangle intersector$SplitTriangle2 = intersector$SplitTriangle;
            intersector$SplitTriangle2.add(intersector$SplitTriangle2.edgeSplit, 0, n2);
            Intersector$SplitTriangle intersector$SplitTriangle3 = intersector$SplitTriangle;
            intersector$SplitTriangle3.setSide(!intersector$SplitTriangle3.getSide());
            Intersector$SplitTriangle intersector$SplitTriangle4 = intersector$SplitTriangle;
            intersector$SplitTriangle4.add(intersector$SplitTriangle4.edgeSplit, 0, n2);
        } else {
            intersector$SplitTriangle.add(fArray, 0, n2);
        }
        int n4 = n2;
        int n5 = n2;
        n3 = n5 + n5;
        if (bl3 != bl4) {
            Intersector.splitEdge(fArray, n4, n3, n2, plane, intersector$SplitTriangle.edgeSplit, 0);
            intersector$SplitTriangle.add(fArray, n4, n2);
            Intersector$SplitTriangle intersector$SplitTriangle5 = intersector$SplitTriangle;
            intersector$SplitTriangle5.add(intersector$SplitTriangle5.edgeSplit, 0, n2);
            Intersector$SplitTriangle intersector$SplitTriangle6 = intersector$SplitTriangle;
            intersector$SplitTriangle6.setSide(!intersector$SplitTriangle6.getSide());
            Intersector$SplitTriangle intersector$SplitTriangle7 = intersector$SplitTriangle;
            intersector$SplitTriangle7.add(intersector$SplitTriangle7.edgeSplit, 0, n2);
        } else {
            intersector$SplitTriangle.add(fArray, n4, n2);
        }
        int n6 = n2;
        n4 = n6 + n6;
        if (bl4 != bl2) {
            Intersector.splitEdge(fArray, n4, 0, n2, plane, intersector$SplitTriangle.edgeSplit, 0);
            intersector$SplitTriangle.add(fArray, n4, n2);
            Intersector$SplitTriangle intersector$SplitTriangle8 = intersector$SplitTriangle;
            intersector$SplitTriangle8.add(intersector$SplitTriangle8.edgeSplit, 0, n2);
            Intersector$SplitTriangle intersector$SplitTriangle9 = intersector$SplitTriangle;
            intersector$SplitTriangle9.setSide(!intersector$SplitTriangle9.getSide());
            Intersector$SplitTriangle intersector$SplitTriangle10 = intersector$SplitTriangle;
            intersector$SplitTriangle10.add(intersector$SplitTriangle10.edgeSplit, 0, n2);
        } else {
            intersector$SplitTriangle.add(fArray, n4, n2);
        }
        if (intersector$SplitTriangle.numFront == 2) {
            System.arraycopy(intersector$SplitTriangle.front, n2 << 1, intersector$SplitTriangle.front, n2 * 3, n2 << 1);
            System.arraycopy(intersector$SplitTriangle.front, 0, intersector$SplitTriangle.front, n2 * 5, n2);
            return;
        }
        System.arraycopy(intersector$SplitTriangle.back, n2 << 1, intersector$SplitTriangle.back, n2 * 3, n2 << 1);
        System.arraycopy(intersector$SplitTriangle.back, 0, intersector$SplitTriangle.back, n2 * 5, n2);
    }

    private static void splitEdge(float[] fArray, int n2, int n3, int n4, Plane plane, float[] fArray2, int n5) {
        float f2 = Intersector.intersectLinePlane(fArray[n2], fArray[n2 + 1], fArray[n2 + 2], fArray[n3], fArray[n3 + 1], fArray[n3 + 2], plane, intersection);
        fArray2[n5] = Intersector.intersection.x;
        fArray2[n5 + 1] = Intersector.intersection.y;
        fArray2[n5 + 2] = Intersector.intersection.z;
        for (int i2 = 3; i2 < n4; ++i2) {
            float f3 = fArray[n2 + i2];
            float f4 = fArray[n3 + i2];
            fArray2[n5 + i2] = f3 + f2 * (f4 - f3);
        }
    }

    public static boolean hasOverlap(Vector3[] vector3Array, Vector3[] vector3Array2, Vector3[] vector3Array3) {
        for (Vector3 vector3 : vector3Array) {
            float f2 = Float.MAX_VALUE;
            float f3 = -3.4028235E38f;
            Vector3[] vector3Array4 = vector3Array2;
            int n2 = vector3Array2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                float f4 = vector3Array4[i2].dot(vector3);
                f2 = Math.min(f2, f4);
                f3 = Math.max(f3, f4);
            }
            float f5 = Float.MAX_VALUE;
            float f6 = -3.4028235E38f;
            Vector3[] vector3Array5 = vector3Array3;
            int n3 = vector3Array3.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                float f7 = vector3Array5[i3].dot(vector3);
                f5 = Math.min(f5, f7);
                f6 = Math.max(f6, f7);
            }
            if (!(f3 < f5) && !(f6 < f2)) continue;
            return false;
        }
        return true;
    }
}

