/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Interpolation;

public class Interpolation$BounceOut
extends Interpolation {
    final float[] widths;
    final float[] heights;

    public Interpolation$BounceOut(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Must be the same number of widths and heights.");
        }
        this.widths = fArray;
        this.heights = fArray2;
    }

    public Interpolation$BounceOut(int n2) {
        if (n2 < 2 || n2 > 5) {
            throw new IllegalArgumentException("bounces cannot be < 2 or > 5: ".concat(String.valueOf(n2)));
        }
        this.widths = new float[n2];
        this.heights = new float[n2];
        this.heights[0] = 1.0f;
        switch (n2) {
            case 2: {
                this.widths[0] = 0.6f;
                this.widths[1] = 0.4f;
                this.heights[1] = 0.33f;
                break;
            }
            case 3: {
                this.widths[0] = 0.4f;
                this.widths[1] = 0.4f;
                this.widths[2] = 0.2f;
                this.heights[1] = 0.33f;
                this.heights[2] = 0.1f;
                break;
            }
            case 4: {
                this.widths[0] = 0.34f;
                this.widths[1] = 0.34f;
                this.widths[2] = 0.2f;
                this.widths[3] = 0.15f;
                this.heights[1] = 0.26f;
                this.heights[2] = 0.11f;
                this.heights[3] = 0.03f;
                break;
            }
            case 5: {
                this.widths[0] = 0.3f;
                this.widths[1] = 0.3f;
                this.widths[2] = 0.2f;
                this.widths[3] = 0.1f;
                this.widths[4] = 0.1f;
                this.heights[1] = 0.45f;
                this.heights[2] = 0.3f;
                this.heights[3] = 0.15f;
                this.heights[4] = 0.06f;
            }
        }
        this.widths[0] = this.widths[0] * 2.0f;
    }

    @Override
    public float apply(float f2) {
        float f3;
        if (f2 == 1.0f) {
            return 1.0f;
        }
        f2 += this.widths[0] / 2.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n2 = this.widths.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            f4 = this.widths[i2];
            if (f2 <= f4) {
                f5 = this.heights[i2];
                break;
            }
            f2 -= f4;
        }
        float f6 = f3 = 4.0f / f4 * f5 * (f2 /= f4);
        return 1.0f - (f6 - f6 * f2) * f4;
    }
}

