/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Vector2;

public final class GeometryUtils {
    private static final Vector2 tmp1 = new Vector2();
    private static final Vector2 tmp2 = new Vector2();
    private static final Vector2 tmp3 = new Vector2();

    private GeometryUtils() {
    }

    public static Vector2 toBarycoord(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24, Vector2 vector25) {
        vector23 = tmp1.set(vector23).sub(vector22);
        vector24 = tmp2.set(vector24).sub(vector22);
        vector2 = tmp3.set(vector2).sub(vector22);
        Vector2 vector26 = vector23;
        float f2 = vector26.dot(vector26);
        float f3 = vector23.dot(vector24);
        Vector2 vector27 = vector24;
        float f4 = vector27.dot(vector27);
        float f5 = vector2.dot(vector23);
        float f6 = vector2.dot(vector24);
        float f7 = f3;
        float f8 = f2 * f4 - f7 * f7;
        vector25.x = (f4 * f5 - f3 * f6) / f8;
        vector25.y = (f2 * f6 - f3 * f5) / f8;
        return vector25;
    }

    public static boolean barycoordInsideTriangle(Vector2 vector2) {
        return vector2.x >= 0.0f && vector2.y >= 0.0f && vector2.x + vector2.y <= 1.0f;
    }

    public static Vector2 fromBarycoord(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24, Vector2 vector25) {
        float f2 = 1.0f - vector2.x - vector2.y;
        vector25.x = f2 * vector22.x + vector2.x * vector23.x + vector2.y * vector24.x;
        vector25.y = f2 * vector22.y + vector2.x * vector23.y + vector2.y * vector24.y;
        return vector25;
    }

    public static float fromBarycoord(Vector2 vector2, float f2, float f3, float f4) {
        return (1.0f - vector2.x - vector2.y) * f2 + vector2.x * f3 + vector2.y * f4;
    }

    public static float lowestPositiveRoot(float f2, float f3, float f4) {
        float f5;
        float f6 = f3;
        f4 = f6 * f6 - 4.0f * f2 * f4;
        if (f5 < 0.0f) {
            return Float.NaN;
        }
        f4 = (float)Math.sqrt(f4);
        f2 = 1.0f / (f2 * 2.0f);
        float f7 = (-f3 - f4) * f2;
        if (f7 > (f2 = (-f3 + f4) * f2)) {
            f3 = f2;
            f2 = f7;
            f7 = f3;
        }
        if (f7 > 0.0f) {
            return f7;
        }
        if (f2 > 0.0f) {
            return f2;
        }
        return Float.NaN;
    }

    public static boolean colinear(float f2, float f3, float f4, float f5, float f6, float f7) {
        return Math.abs((f4 = f6 - f4) * (f3 = f5 - f3) - (f2 = f4 - f2) * (f5 = f7 - f5)) < 1.0E-6f;
    }

    public static Vector2 triangleCentroid(float f2, float f3, float f4, float f5, float f6, float f7, Vector2 vector2) {
        vector2.x = (f2 + f4 + f6) / 3.0f;
        vector2.y = (f3 + f5 + f7) / 3.0f;
        return vector2;
    }

    public static Vector2 triangleCircumcenter(float f2, float f3, float f4, float f5, float f6, float f7, Vector2 vector2) {
        float f8;
        float f9 = f4 - f2;
        float f10 = f5 - f3;
        float f11 = f6 - f4;
        float f12 = f7 - f5;
        float f13 = f2 - f6;
        float f14 = f3 - f7;
        float f15 = f11 * f10 - f9 * f12;
        if (Math.abs(f8) < 1.0E-6f) {
            throw new IllegalArgumentException("Triangle points must not be colinear.");
        }
        f15 *= 2.0f;
        float f16 = f2;
        float f17 = f3;
        f2 = f16 * f16 + f17 * f17;
        float f18 = f4;
        float f19 = f5;
        f3 = f18 * f18 + f19 * f19;
        float f20 = f6;
        float f21 = f7;
        f4 = f20 * f20 + f21 * f21;
        vector2.set((f2 * f12 + f3 * f14 + f4 * f10) / f15, -(f2 * f11 + f3 * f13 + f4 * f9) / f15);
        return vector2;
    }

    public static float triangleCircumradius(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (Math.abs(f5 - f3) < 1.0E-6f) {
            float f8 = -(f6 - f4) / (f7 - f5);
            f6 = (f4 + f6) / 2.0f;
            f5 = (f5 + f7) / 2.0f;
            f4 = (f4 + f2) / 2.0f;
            f5 = f8 * (f4 - f6) + f5;
        } else if (Math.abs(f7 - f5) < 1.0E-6f) {
            float f9 = -(f4 - f2) / (f5 - f3);
            float f10 = (f2 + f4) / 2.0f;
            float f11 = (f3 + f5) / 2.0f;
            f4 = (f6 + f4) / 2.0f;
            f5 = f9 * (f4 - f10) + f11;
        } else {
            float f12 = -(f4 - f2) / (f5 - f3);
            float f13 = -(f6 - f4) / (f7 - f5);
            float f14 = (f2 + f4) / 2.0f;
            f6 = (f4 + f6) / 2.0f;
            float f15 = (f3 + f5) / 2.0f;
            f5 = (f5 + f7) / 2.0f;
            f4 = (f12 * f14 - f13 * f6 + f5 - f15) / (f12 - f13);
            f5 = f12 * (f4 - f14) + f15;
        }
        float f16 = f2 -= f4;
        float f17 = f3 -= f5;
        return (float)Math.sqrt(f16 * f16 + f17 * f17);
    }

    public static float triangleQuality(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f2;
        float f9 = f3;
        float f10 = f8 * f8 + f9 * f9;
        float f11 = f4;
        float f12 = f5;
        float f13 = f11 * f11 + f12 * f12;
        float f14 = f6;
        float f15 = f7;
        float f16 = f14 * f14 + f15 * f15;
        return (float)Math.sqrt(Math.min(f10, Math.min(f13, f16))) / GeometryUtils.triangleCircumradius(f2, f3, f4, f5, f6, f7);
    }

    public static float triangleArea(float f2, float f3, float f4, float f5, float f6, float f7) {
        return Math.abs((f2 - f6) * (f5 - f3) - (f2 - f4) * (f7 - f3)) * 0.5f;
    }

    public static Vector2 quadrilateralCentroid(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Vector2 vector2) {
        f4 = (f2 + f4 + f6) / 3.0f;
        f5 = (f3 + f5 + f7) / 3.0f;
        f2 = (f2 + f8 + f6) / 3.0f;
        f3 = (f3 + f9 + f7) / 3.0f;
        float f10 = f4;
        vector2.x = f10 - (f10 - f2) / 2.0f;
        float f11 = f5;
        vector2.y = f11 - (f11 - f3) / 2.0f;
        return vector2;
    }

    public static Vector2 polygonCentroid(float[] fArray, int n2, int n3, Vector2 vector2) {
        if (n3 < 6) {
            throw new IllegalArgumentException("A polygon must have 3 or more coordinate pairs.");
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        n3 = n2 + n3 - 2;
        float f5 = fArray[n3];
        float f6 = fArray[n3 + 1];
        while (n2 <= n3) {
            float f7 = fArray[n2];
            float f8 = fArray[n2 + 1];
            float f9 = f5 * f8 - f7 * f6;
            f2 += f9;
            f3 += (f5 + f7) * f9;
            f4 += (f6 + f8) * f9;
            f5 = f7;
            f6 = f8;
            n2 += 2;
        }
        if (f2 == 0.0f) {
            vector2.x = 0.0f;
            vector2.y = 0.0f;
        } else {
            vector2.x = f3 / (6.0f * (f2 *= 0.5f));
            vector2.y = f4 / (6.0f * f2);
        }
        return vector2;
    }

    public static float polygonArea(float[] fArray, int n2, int n3) {
        float f2 = 0.0f;
        n3 = n2 + n3 - 2;
        float f3 = fArray[n3];
        float f4 = fArray[n3 + 1];
        while (n2 <= n3) {
            float f5 = fArray[n2];
            float f6 = fArray[n2 + 1];
            f2 += f3 * f6 - f5 * f4;
            f3 = f5;
            f4 = f6;
            n2 += 2;
        }
        return Math.abs(f2 * 0.5f);
    }

    public static void ensureCCW(float[] fArray) {
        GeometryUtils.ensureCCW(fArray, 0, fArray.length);
    }

    public static void ensureCCW(float[] fArray, int n2, int n3) {
        if (!GeometryUtils.isClockwise(fArray, n2, n3)) {
            return;
        }
        GeometryUtils.reverseVertices(fArray, n2, n3);
    }

    public static void ensureClockwise(float[] fArray) {
        GeometryUtils.ensureClockwise(fArray, 0, fArray.length);
    }

    public static void ensureClockwise(float[] fArray, int n2, int n3) {
        if (GeometryUtils.isClockwise(fArray, n2, n3)) {
            return;
        }
        GeometryUtils.reverseVertices(fArray, n2, n3);
    }

    public static void reverseVertices(float[] fArray, int n2, int n3) {
        int n4 = n2 + n3 - 2;
        int n5 = n2;
        n2 += n3 / 2;
        while (n5 < n2) {
            n3 = n4 - n5;
            float f2 = fArray[n5];
            float f3 = fArray[n5 + 1];
            fArray[n5] = fArray[n3];
            fArray[n5 + 1] = fArray[n3 + 1];
            fArray[n3] = f2;
            fArray[n3 + 1] = f3;
            n5 += 2;
        }
    }

    public static boolean isClockwise(float[] fArray, int n2, int n3) {
        if (n3 <= 2) {
            return false;
        }
        float f2 = 0.0f;
        n3 = n2 + n3 - 2;
        float f3 = fArray[n3];
        float f4 = fArray[n3 + 1];
        while (n2 <= n3) {
            float f5 = fArray[n2];
            float f6 = fArray[n2 + 1];
            f2 += f3 * f6 - f5 * f4;
            f3 = f5;
            f4 = f6;
            n2 += 2;
        }
        return f2 < 0.0f;
    }

    public static boolean isCCW(float[] fArray, int n2, int n3) {
        return !GeometryUtils.isClockwise(fArray, n2, n3);
    }
}

