/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.b;
import com.badlogic.gdx.utils.Array;

public class CumulativeDistribution {
    private final Array values = new Array(false, 10, b[]::new);

    public void add(Object object, float f2) {
        this.values.add(new b(object, f2));
    }

    public void add(Object object) {
        this.values.add(new b(object, 0.0f));
    }

    public void generate() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.values.size; ++i2) {
            ((b[])this.values.items)[i2].b = f2 += ((b[])this.values.items)[i2].c;
        }
    }

    public void generateNormalized() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.values.size; ++i2) {
            f2 += ((b[])this.values.items)[i2].c;
        }
        float f3 = 0.0f;
        for (int i3 = 0; i3 < this.values.size; ++i3) {
            ((b[])this.values.items)[i3].b = f3 += ((b[])this.values.items)[i3].c / f2;
        }
    }

    public void generateUniform() {
        float f2 = 1.0f / (float)this.values.size;
        for (int i2 = 0; i2 < this.values.size; ++i2) {
            ((b[])this.values.items)[i2].c = f2;
            ((b[])this.values.items)[i2].b = (float)(i2 + 1) * f2;
        }
    }

    public Object value(float f2) {
        int n2 = this.values.size - 1;
        int n3 = 0;
        while (n3 <= n2) {
            int n4 = n3 + (n2 - n3) / 2;
            b b2 = ((b[])this.values.items)[n4];
            if (f2 < b2.b) {
                n2 = n4 - 1;
                continue;
            }
            if (!(f2 > b2.b)) break;
            n3 = n4 + 1;
        }
        return ((b[])this.values.items)[n3].a;
    }

    public Object value() {
        return this.value(MathUtils.random());
    }

    public int size() {
        return this.values.size;
    }

    public float getInterval(int n2) {
        return ((b[])this.values.items)[n2].c;
    }

    public Object getValue(int n2) {
        return ((b[])this.values.items)[n2].a;
    }

    public void setInterval(Object object, float f2) {
        for (b b2 : this.values) {
            if (b2.a != object) continue;
            b2.c = f2;
            return;
        }
    }

    public void setInterval(int n2, float f2) {
        ((b[])this.values.items)[n2].c = f2;
    }

    public void clear() {
        this.values.clear();
    }
}

