/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Path;
import com.badlogic.gdx.math.Vector;

public class CatmullRomSpline
implements Path {
    public Vector[] controlPoints;
    public boolean continuous;
    public int spanCount;
    private Vector tmp;
    private Vector tmp2;
    private Vector tmp3;

    public static Vector calculate(Vector vector, float f2, Vector[] vectorArray, boolean bl2, Vector vector2) {
        int n2 = bl2 ? vectorArray.length : vectorArray.length - 3;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return CatmullRomSpline.calculate(vector, n3, f3 -= (float)n3, vectorArray, bl2, vector2);
    }

    public static Vector calculate(Vector vector, int n2, float f2, Vector[] vectorArray, boolean bl2, Vector vector2) {
        int n3 = vectorArray.length;
        float f3 = f2;
        float f4 = f3 * f3;
        float f5 = f4 * f2;
        vector.set(vectorArray[n2]).scl(1.5f * f5 - 2.5f * f4 + 1.0f);
        if (bl2 || n2 > 0) {
            vector.add(vector2.set(vectorArray[(n3 + n2 - 1) % n3]).scl(-0.5f * f5 + f4 - 0.5f * f2));
        }
        if (bl2 || n2 < n3 - 1) {
            vector.add(vector2.set(vectorArray[(n2 + 1) % n3]).scl(-1.5f * f5 + f4 * 2.0f + 0.5f * f2));
        }
        if (bl2 || n2 < n3 - 2) {
            vector.add(vector2.set(vectorArray[(n2 + 2) % n3]).scl(0.5f * f5 - 0.5f * f4));
        }
        return vector;
    }

    public static Vector derivative(Vector vector, float f2, Vector[] vectorArray, boolean bl2, Vector vector2) {
        int n2 = bl2 ? vectorArray.length : vectorArray.length - 3;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return CatmullRomSpline.derivative(vector, n3, f3 -= (float)n3, vectorArray, bl2, vector2);
    }

    public static Vector derivative(Vector vector, int n2, float f2, Vector[] vectorArray, boolean bl2, Vector vector2) {
        int n3 = vectorArray.length;
        float f3 = f2;
        float f4 = f3 * f3;
        vector.set(vectorArray[n2]).scl(-f2 * 5.0f + f4 * 4.5f);
        if (bl2 || n2 > 0) {
            vector.add(vector2.set(vectorArray[(n3 + n2 - 1) % n3]).scl(-0.5f + f2 * 2.0f - f4 * 1.5f));
        }
        if (bl2 || n2 < n3 - 1) {
            vector.add(vector2.set(vectorArray[(n2 + 1) % n3]).scl(0.5f + f2 * 4.0f - f4 * 4.5f));
        }
        if (bl2 || n2 < n3 - 2) {
            vector.add(vector2.set(vectorArray[(n2 + 2) % n3]).scl(-f2 + f4 * 1.5f));
        }
        return vector;
    }

    public CatmullRomSpline() {
    }

    public CatmullRomSpline(Vector[] vectorArray, boolean bl2) {
        this.set(vectorArray, bl2);
    }

    public CatmullRomSpline set(Vector[] vectorArray, boolean bl2) {
        if (this.tmp == null) {
            this.tmp = vectorArray[0].cpy();
        }
        if (this.tmp2 == null) {
            this.tmp2 = vectorArray[0].cpy();
        }
        if (this.tmp3 == null) {
            this.tmp3 = vectorArray[0].cpy();
        }
        this.controlPoints = vectorArray;
        this.continuous = bl2;
        this.spanCount = bl2 ? vectorArray.length : vectorArray.length - 3;
        return this;
    }

    public Vector valueAt(Vector vector, float f2) {
        int n2 = this.spanCount;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return this.valueAt(vector, n3, f3 -= (float)n3);
    }

    public Vector valueAt(Vector vector, int n2, float f2) {
        return CatmullRomSpline.calculate(vector, this.continuous ? n2 : n2 + 1, f2, this.controlPoints, this.continuous, this.tmp);
    }

    public Vector derivativeAt(Vector vector, float f2) {
        int n2 = this.spanCount;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return this.derivativeAt(vector, n3, f3 -= (float)n3);
    }

    public Vector derivativeAt(Vector vector, int n2, float f2) {
        return CatmullRomSpline.derivative(vector, this.continuous ? n2 : n2 + 1, f2, this.controlPoints, this.continuous, this.tmp);
    }

    public int nearest(Vector vector) {
        return this.nearest(vector, 0, this.spanCount);
    }

    public int nearest(Vector vector, int n2, int n3) {
        while (n2 < 0) {
            n2 += this.spanCount;
        }
        int n4 = n2 % this.spanCount;
        float f2 = vector.dst2(this.controlPoints[n4]);
        for (int i2 = 1; i2 < n3; ++i2) {
            float f3;
            int n5 = (n2 + i2) % this.spanCount;
            float f4 = vector.dst2(this.controlPoints[n5]);
            if (!(f3 < f2)) continue;
            f2 = f4;
            n4 = n5;
        }
        return n4;
    }

    public float approximate(Vector vector) {
        return this.approximate(vector, this.nearest(vector));
    }

    public float approximate(Vector vector, int n2, int n3) {
        return this.approximate(vector, this.nearest(vector, n2, n3));
    }

    public float approximate(Vector vector, int n2) {
        Vector vector2 = this.controlPoints[n2];
        Vector vector3 = this.controlPoints[n2 > 0 ? n2 - 1 : this.spanCount - 1];
        Vector vector4 = this.controlPoints[(n2 + 1) % this.spanCount];
        float f2 = vector.dst2(vector3);
        if (vector.dst2(vector4) < f2) {
            vector3 = vector2;
            vector2 = vector4;
        } else {
            n2 = n2 > 0 ? n2 - 1 : this.spanCount - 1;
        }
        float f3 = vector3.dst2(vector2);
        float f4 = vector.dst2(vector2);
        float f5 = vector.dst2(vector3);
        float f6 = (float)Math.sqrt(f3);
        f5 = (f4 + f3 - f5) / (f6 * 2.0f);
        f5 = MathUtils.clamp((f6 - f5) / f6, 0.0f, 1.0f);
        return ((float)n2 + f5) / (float)this.spanCount;
    }

    public float locate(Vector vector) {
        return this.approximate(vector);
    }

    @Override
    public float approxLength(int n2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tmp2.set(this.tmp3);
            CatmullRomSpline catmullRomSpline = this;
            catmullRomSpline.valueAt(catmullRomSpline.tmp3, (float)i2 / ((float)n2 - 1.0f));
            if (i2 <= 0) continue;
            f2 += this.tmp2.dst(this.tmp3);
        }
        return f2;
    }
}

