/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Path;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class Bezier
implements Path {
    public Array points = new Array();
    private Vector tmp;
    private Vector tmp2;
    private Vector tmp3;

    public static Vector linear(Vector vector, float f2, Vector vector2, Vector vector3, Vector vector4) {
        return vector.set(vector2).scl(1.0f - f2).add(vector4.set(vector3).scl(f2));
    }

    public static Vector linear_derivative(Vector vector, float f2, Vector vector2, Vector vector3, Vector vector4) {
        return vector.set(vector3).sub(vector2);
    }

    public static Vector quadratic(Vector vector, float f2, Vector vector2, Vector vector3, Vector vector4, Vector vector5) {
        float f3;
        float f4 = f3 = 1.0f - f2;
        float f5 = f2;
        return vector.set(vector2).scl(f4 * f4).add(vector5.set(vector3).scl(f3 * 2.0f * f2)).add(vector5.set(vector4).scl(f5 * f5));
    }

    public static Vector quadratic_derivative(Vector vector, float f2, Vector vector2, Vector vector3, Vector vector4, Vector vector5) {
        return vector.set(vector3).sub(vector2).scl(2.0f).scl(1.0f - f2).add(vector5.set(vector4).sub(vector3).scl(f2).scl(2.0f));
    }

    public static Vector cubic(Vector vector, float f2, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6) {
        float f3 = 1.0f - f2;
        float f4 = f3 * f3;
        float f5 = f2;
        float f6 = f5 * f5;
        return vector.set(vector2).scl(f4 * f3).add(vector6.set(vector3).scl(3.0f * f4 * f2)).add(vector6.set(vector4).scl(3.0f * f3 * f6)).add(vector6.set(vector5).scl(f6 * f2));
    }

    public static Vector cubic_derivative(Vector vector, float f2, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6) {
        float f3 = 1.0f - f2;
        float f4 = f3 * f3;
        float f5 = f2;
        float f6 = f5 * f5;
        return vector.set(vector3).sub(vector2).scl(f4 * 3.0f).add(vector6.set(vector4).sub(vector3).scl(f3 * f2 * 6.0f)).add(vector6.set(vector5).sub(vector4).scl(f6 * 3.0f));
    }

    public Bezier() {
    }

    public Bezier(Vector ... vectorArray) {
        this.set(vectorArray);
    }

    public Bezier(Vector[] vectorArray, int n2, int n3) {
        this.set(vectorArray, n2, n3);
    }

    public Bezier(Array array, int n2, int n3) {
        this.set(array, n2, n3);
    }

    public Bezier set(Vector ... vectorArray) {
        return this.set(vectorArray, 0, vectorArray.length);
    }

    public Bezier set(Vector[] vectorArray, int n2, int n3) {
        if (n3 < 2 || n3 > 4) {
            throw new GdxRuntimeException("Only first, second and third degree Bezier curves are supported.");
        }
        if (this.tmp == null) {
            this.tmp = vectorArray[0].cpy();
        }
        if (this.tmp2 == null) {
            this.tmp2 = vectorArray[0].cpy();
        }
        if (this.tmp3 == null) {
            this.tmp3 = vectorArray[0].cpy();
        }
        this.points.clear();
        this.points.addAll((Object[])vectorArray, n2, n3);
        return this;
    }

    public Bezier set(Array array, int n2, int n3) {
        if (n3 < 2 || n3 > 4) {
            throw new GdxRuntimeException("Only first, second and third degree Bezier curves are supported.");
        }
        if (this.tmp == null) {
            this.tmp = ((Vector)array.get(0)).cpy();
        }
        if (this.tmp2 == null) {
            this.tmp2 = ((Vector)array.get(0)).cpy();
        }
        if (this.tmp3 == null) {
            this.tmp3 = ((Vector)array.get(0)).cpy();
        }
        this.points.clear();
        this.points.addAll(array, n2, n3);
        return this;
    }

    public Vector valueAt(Vector vector, float f2) {
        int n2 = this.points.size;
        if (n2 == 2) {
            Bezier.linear(vector, f2, (Vector)this.points.get(0), (Vector)this.points.get(1), this.tmp);
        } else if (n2 == 3) {
            Bezier.quadratic(vector, f2, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), this.tmp);
        } else if (n2 == 4) {
            Bezier.cubic(vector, f2, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), (Vector)this.points.get(3), this.tmp);
        }
        return vector;
    }

    public Vector derivativeAt(Vector vector, float f2) {
        int n2 = this.points.size;
        if (n2 == 2) {
            Bezier.linear_derivative(vector, f2, (Vector)this.points.get(0), (Vector)this.points.get(1), this.tmp);
        } else if (n2 == 3) {
            Bezier.quadratic_derivative(vector, f2, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), this.tmp);
        } else if (n2 == 4) {
            Bezier.cubic_derivative(vector, f2, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), (Vector)this.points.get(3), this.tmp);
        }
        return vector;
    }

    public float approximate(Vector vector) {
        Vector vector2 = (Vector)this.points.get(0);
        Vector vector3 = (Vector)this.points.get(this.points.size - 1);
        float f2 = vector2.dst2(vector3);
        float f3 = vector.dst2(vector3);
        float f4 = vector.dst2(vector2);
        float f5 = (float)Math.sqrt(f2);
        f4 = (f3 + f2 - f4) / (f5 * 2.0f);
        return MathUtils.clamp((f5 - f4) / f5, 0.0f, 1.0f);
    }

    public float locate(Vector vector) {
        return this.approximate(vector);
    }

    @Override
    public float approxLength(int n2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tmp2.set(this.tmp3);
            Bezier bezier = this;
            bezier.valueAt(bezier.tmp3, (float)i2 / ((float)n2 - 1.0f));
            if (i2 <= 0) continue;
            f2 += this.tmp2.dst(this.tmp3);
        }
        return f2;
    }
}

