/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Path;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.utils.Array;

public class BSpline
implements Path {
    private static final float d6 = 0.16666667f;
    public Vector[] controlPoints;
    public Array knots;
    public int degree;
    public boolean continuous;
    public int spanCount;
    private Vector tmp;
    private Vector tmp2;
    private Vector tmp3;

    public static Vector cubic(Vector vector, float f2, Vector[] vectorArray, boolean bl2, Vector vector2) {
        int n2 = bl2 ? vectorArray.length : vectorArray.length - 3;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return BSpline.cubic(vector, n3, f3 -= (float)n3, vectorArray, bl2, vector2);
    }

    public static Vector cubic_derivative(Vector vector, float f2, Vector[] vectorArray, boolean bl2, Vector vector2) {
        int n2 = bl2 ? vectorArray.length : vectorArray.length - 3;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return BSpline.cubic(vector, n3, f3 -= (float)n3, vectorArray, bl2, vector2);
    }

    public static Vector cubic(Vector vector, int n2, float f2, Vector[] vectorArray, boolean bl2, Vector vector2) {
        int n3 = vectorArray.length;
        float f3 = 1.0f - f2;
        float f4 = f2;
        float f5 = f4 * f4;
        float f6 = f5 * f2;
        vector.set(vectorArray[n2]).scl((3.0f * f6 - 6.0f * f5 + 4.0f) * 0.16666667f);
        if (bl2 || n2 > 0) {
            float f7 = f3;
            vector.add(vector2.set(vectorArray[(n3 + n2 - 1) % n3]).scl(f7 * f7 * f3 * 0.16666667f));
        }
        if (bl2 || n2 < n3 - 1) {
            vector.add(vector2.set(vectorArray[(n2 + 1) % n3]).scl((-3.0f * f6 + 3.0f * f5 + 3.0f * f2 + 1.0f) * 0.16666667f));
        }
        if (bl2 || n2 < n3 - 2) {
            vector.add(vector2.set(vectorArray[(n2 + 2) % n3]).scl(f6 * 0.16666667f));
        }
        return vector;
    }

    public static Vector cubic_derivative(Vector vector, int n2, float f2, Vector[] vectorArray, boolean bl2, Vector vector2) {
        int n3 = vectorArray.length;
        float f3 = 1.0f - f2;
        float f4 = f2;
        float f5 = f4 * f4;
        vector.set(vectorArray[n2]).scl(1.5f * f5 - f2 * 2.0f);
        if (bl2 || n2 > 0) {
            vector.add(vector2.set(vectorArray[(n3 + n2 - 1) % n3]).scl(-0.5f * f3 * f3));
        }
        if (bl2 || n2 < n3 - 1) {
            vector.add(vector2.set(vectorArray[(n2 + 1) % n3]).scl(-1.5f * f5 + f2 + 0.5f));
        }
        if (bl2 || n2 < n3 - 2) {
            vector.add(vector2.set(vectorArray[(n2 + 2) % n3]).scl(0.5f * f5));
        }
        return vector;
    }

    public static Vector calculate(Vector vector, float f2, Vector[] vectorArray, int n2, boolean bl2, Vector vector2) {
        int n3 = bl2 ? vectorArray.length : vectorArray.length - n2;
        float f3 = f2 * (float)n3;
        int n4 = f2 >= 1.0f ? n3 - 1 : (int)f3;
        return BSpline.calculate(vector, n4, f3 -= (float)n4, vectorArray, n2, bl2, vector2);
    }

    public static Vector derivative(Vector vector, float f2, Vector[] vectorArray, int n2, boolean bl2, Vector vector2) {
        int n3 = bl2 ? vectorArray.length : vectorArray.length - n2;
        float f3 = f2 * (float)n3;
        int n4 = f2 >= 1.0f ? n3 - 1 : (int)f3;
        return BSpline.derivative(vector, n4, f3 -= (float)n4, vectorArray, n2, bl2, vector2);
    }

    public static Vector calculate(Vector vector, int n2, float f2, Vector[] vectorArray, int n3, boolean bl2, Vector vector2) {
        switch (n3) {
            case 3: {
                return BSpline.cubic(vector, n2, f2, vectorArray, bl2, vector2);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Vector derivative(Vector vector, int n2, float f2, Vector[] vectorArray, int n3, boolean bl2, Vector vector2) {
        switch (n3) {
            case 3: {
                return BSpline.cubic_derivative(vector, n2, f2, vectorArray, bl2, vector2);
            }
        }
        throw new IllegalArgumentException();
    }

    public BSpline() {
    }

    public BSpline(Vector[] vectorArray, int n2, boolean bl2) {
        this.set(vectorArray, n2, bl2);
    }

    public BSpline set(Vector[] vectorArray, int n2, boolean bl2) {
        int n3;
        if (this.tmp == null) {
            this.tmp = vectorArray[0].cpy();
        }
        if (this.tmp2 == null) {
            this.tmp2 = vectorArray[0].cpy();
        }
        if (this.tmp3 == null) {
            this.tmp3 = vectorArray[0].cpy();
        }
        this.controlPoints = vectorArray;
        this.degree = n2;
        this.continuous = bl2;
        this.spanCount = bl2 ? vectorArray.length : vectorArray.length - n2;
        int n4 = n3 = bl2 ? vectorArray.length : vectorArray.length - 1;
        if (this.knots == null) {
            this.knots = new Array(n3);
        } else {
            this.knots.clear();
            this.knots.ensureCapacity(n3);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.knots.add(BSpline.calculate(vectorArray[0].cpy(), bl2 ? i2 : i2 + (int)(0.5f * (float)n2), 0.0f, vectorArray, n2, bl2, this.tmp));
        }
        return this;
    }

    public Vector valueAt(Vector vector, float f2) {
        int n2 = this.spanCount;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return this.valueAt(vector, n3, f3 -= (float)n3);
    }

    public Vector valueAt(Vector vector, int n2, float f2) {
        return BSpline.calculate(vector, this.continuous ? n2 : n2 + (int)((float)this.degree * 0.5f), f2, this.controlPoints, this.degree, this.continuous, this.tmp);
    }

    public Vector derivativeAt(Vector vector, float f2) {
        int n2 = this.spanCount;
        float f3 = f2 * (float)n2;
        int n3 = f2 >= 1.0f ? n2 - 1 : (int)f3;
        return this.derivativeAt(vector, n3, f3 -= (float)n3);
    }

    public Vector derivativeAt(Vector vector, int n2, float f2) {
        return BSpline.derivative(vector, this.continuous ? n2 : n2 + (int)((float)this.degree * 0.5f), f2, this.controlPoints, this.degree, this.continuous, this.tmp);
    }

    public int nearest(Vector vector) {
        return this.nearest(vector, 0, this.spanCount);
    }

    public int nearest(Vector vector, int n2, int n3) {
        int n4 = this.knots.size;
        while (n2 < 0) {
            n2 += n4;
        }
        int n5 = n2 % n4;
        float f2 = vector.dst2((Vector)this.knots.get(n5));
        for (int i2 = 1; i2 < n3; ++i2) {
            float f3;
            int n6 = (n2 + i2) % n4;
            float f4 = vector.dst2((Vector)this.knots.get(n6));
            if (!(f3 < f2)) continue;
            f2 = f4;
            n5 = n6;
        }
        return n5;
    }

    public float approximate(Vector vector) {
        return this.approximate(vector, this.nearest(vector));
    }

    public float approximate(Vector vector, int n2, int n3) {
        return this.approximate(vector, this.nearest(vector, n2, n3));
    }

    public float approximate(Vector vector, int n2) {
        Vector vector2 = (Vector)this.knots.get(n2);
        Vector vector3 = (Vector)this.knots.get(n2 > 0 ? n2 - 1 : this.knots.size - 1);
        Vector vector4 = (Vector)this.knots.get((n2 + 1) % this.knots.size);
        float f2 = vector.dst2(vector3);
        if (vector.dst2(vector4) < f2) {
            vector3 = vector2;
            vector2 = vector4;
        } else {
            n2 = n2 > 0 ? n2 - 1 : this.knots.size - 1;
        }
        float f3 = vector3.dst2(vector2) + 1.0E-10f;
        float f4 = vector.dst2(vector2);
        float f5 = vector.dst2(vector3);
        float f6 = (float)Math.sqrt(f3);
        f5 = (f4 + f3 - f5) / (f6 * 2.0f);
        f5 = MathUtils.clamp((f6 - f5) / f6, 0.0f, 1.0f);
        return ((float)n2 + f5) / (float)this.spanCount;
    }

    public float locate(Vector vector) {
        return this.approximate(vector);
    }

    @Override
    public float approxLength(int n2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tmp2.set(this.tmp3);
            BSpline bSpline = this;
            bSpline.valueAt(bSpline.tmp3, (float)i2 / ((float)n2 - 1.0f));
            if (i2 <= 0) continue;
            f2 += this.tmp2.dst(this.tmp3);
        }
        return f2;
    }
}

