/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.profiling;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.GL31;
import com.badlogic.gdx.graphics.GL32;
import com.badlogic.gdx.graphics.profiling.GL20Interceptor;
import com.badlogic.gdx.graphics.profiling.GL30Interceptor;
import com.badlogic.gdx.graphics.profiling.GL31Interceptor;
import com.badlogic.gdx.graphics.profiling.GL32Interceptor;
import com.badlogic.gdx.graphics.profiling.GLErrorListener;
import com.badlogic.gdx.graphics.profiling.GLInterceptor;
import com.badlogic.gdx.h;
import com.badlogic.gdx.math.FloatCounter;

public class GLProfiler {
    private h graphics;
    private GLInterceptor glInterceptor;
    private GLErrorListener listener;
    private boolean enabled = false;

    public GLProfiler(h h2) {
        this.graphics = h2;
        GL32 gL32 = h2.f();
        GL31 gL31 = h2.e();
        GL30 gL30 = h2.d();
        this.glInterceptor = gL32 != null ? new GL32Interceptor(this, gL32) : (gL31 != null ? new GL31Interceptor(this, gL31) : (gL30 != null ? new GL30Interceptor(this, gL30) : new GL20Interceptor(this, h2.c())));
        this.listener = GLErrorListener.LOGGING_LISTENER;
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        if (this.glInterceptor instanceof GL32) {
            this.graphics.a((GL32)((Object)this.glInterceptor));
        }
        if (this.glInterceptor instanceof GL31) {
            this.graphics.a((GL31)((Object)this.glInterceptor));
        }
        if (this.glInterceptor instanceof GL30) {
            this.graphics.a((GL30)((Object)this.glInterceptor));
        }
        this.graphics.a(this.glInterceptor);
        Gdx.k = this.graphics.f();
        Gdx.j = this.graphics.e();
        Gdx.i = this.graphics.d();
        Gdx.h = this.graphics.c();
        Gdx.g = this.graphics.c();
        this.enabled = true;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        if (this.glInterceptor instanceof GL32Interceptor) {
            this.graphics.a(((GL32Interceptor)this.glInterceptor).gl32);
        }
        if (this.glInterceptor instanceof GL31Interceptor) {
            this.graphics.a(((GL31Interceptor)this.glInterceptor).gl31);
        }
        if (this.glInterceptor instanceof GL30Interceptor) {
            this.graphics.a(((GL30Interceptor)this.glInterceptor).gl30);
        }
        if (this.glInterceptor instanceof GL20Interceptor) {
            this.graphics.a(((GL20Interceptor)this.graphics.c()).gl20);
        }
        Gdx.k = this.graphics.f();
        Gdx.j = this.graphics.e();
        Gdx.i = this.graphics.d();
        Gdx.h = this.graphics.c();
        Gdx.g = this.graphics.c();
        this.enabled = false;
    }

    public void setListener(GLErrorListener gLErrorListener) {
        this.listener = gLErrorListener;
    }

    public GLErrorListener getListener() {
        return this.listener;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getCalls() {
        return this.glInterceptor.getCalls();
    }

    public int getTextureBindings() {
        return this.glInterceptor.getTextureBindings();
    }

    public int getDrawCalls() {
        return this.glInterceptor.getDrawCalls();
    }

    public int getShaderSwitches() {
        return this.glInterceptor.getShaderSwitches();
    }

    public FloatCounter getVertexCount() {
        return this.glInterceptor.getVertexCount();
    }

    public void reset() {
        this.glInterceptor.reset();
    }
}

