/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.c;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Blending;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class MipMapGenerator {
    private static boolean useHWMipMap = true;

    private MipMapGenerator() {
    }

    public static void setUseHardwareMipMap(boolean bl2) {
        useHWMipMap = bl2;
    }

    public static void generateMipMap(Pixmap pixmap, int n2, int n3) {
        MipMapGenerator.generateMipMap(3553, pixmap, n2, n3);
    }

    public static void generateMipMap(int n2, Pixmap pixmap, int n3, int n4) {
        if (!useHWMipMap) {
            MipMapGenerator.generateMipMapCPU(n2, pixmap, n3, n4);
            return;
        }
        if (Gdx.a.e() == c.a || Gdx.a.e() == c.d || Gdx.a.e() == c.e) {
            MipMapGenerator.generateMipMapGLES20(n2, pixmap);
            return;
        }
        MipMapGenerator.generateMipMapDesktop(n2, pixmap, n3, n4);
    }

    private static void generateMipMapGLES20(int n2, Pixmap pixmap) {
        Gdx.g.glTexImage2D(n2, 0, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
        Gdx.h.glGenerateMipmap(n2);
    }

    private static void generateMipMapDesktop(int n2, Pixmap pixmap, int n3, int n4) {
        if (Gdx.b.b("GL_ARB_framebuffer_object") || Gdx.b.b("GL_EXT_framebuffer_object") || Gdx.h.getClass().getName().equals("com.badlogic.gdx.backends.lwjgl3.Lwjgl3GLES20") || Gdx.i != null) {
            Gdx.g.glTexImage2D(n2, 0, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
            Gdx.h.glGenerateMipmap(n2);
            return;
        }
        MipMapGenerator.generateMipMapCPU(n2, pixmap, n3, n4);
    }

    private static void generateMipMapCPU(int n2, Pixmap pixmap, int n3, int n4) {
        Gdx.g.glTexImage2D(n2, 0, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
        if (Gdx.h == null && n3 != n4) {
            throw new GdxRuntimeException("texture width and height must be square when using mipmapping.");
        }
        n3 = pixmap.getWidth() / 2;
        n4 = pixmap.getHeight() / 2;
        int n5 = 1;
        while (n3 > 0 && n4 > 0) {
            Pixmap pixmap2 = new Pixmap(n3, n4, pixmap.getFormat());
            pixmap2.setBlending(Pixmap$Blending.None);
            pixmap2.drawPixmap(pixmap, 0, 0, pixmap.getWidth(), pixmap.getHeight(), 0, 0, n3, n4);
            if (n5 > 1) {
                pixmap.dispose();
            }
            pixmap = pixmap2;
            Gdx.g.glTexImage2D(n2, n5, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
            n3 = pixmap.getWidth() / 2;
            n4 = pixmap.getHeight() / 2;
            ++n5;
        }
    }
}

