/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.HdpiMode;

public class HdpiUtils {
    private static HdpiMode mode = HdpiMode.Logical;

    public static void setMode(HdpiMode hdpiMode) {
        mode = hdpiMode;
    }

    public static void glScissor(int n2, int n3, int n4, int n5) {
        if (mode == HdpiMode.Logical && (Gdx.b.g() != Gdx.b.i() || Gdx.b.h() != Gdx.b.j())) {
            Gdx.g.glScissor(HdpiUtils.toBackBufferX(n2), HdpiUtils.toBackBufferY(n3), HdpiUtils.toBackBufferX(n4), HdpiUtils.toBackBufferY(n5));
            return;
        }
        Gdx.g.glScissor(n2, n3, n4, n5);
    }

    public static void glViewport(int n2, int n3, int n4, int n5) {
        if (mode == HdpiMode.Logical && (Gdx.b.g() != Gdx.b.i() || Gdx.b.h() != Gdx.b.j())) {
            Gdx.g.glViewport(HdpiUtils.toBackBufferX(n2), HdpiUtils.toBackBufferY(n3), HdpiUtils.toBackBufferX(n4), HdpiUtils.toBackBufferY(n5));
            return;
        }
        Gdx.g.glViewport(n2, n3, n4, n5);
    }

    public static int toLogicalX(int n2) {
        return (int)((float)(n2 * Gdx.b.g()) / (float)Gdx.b.i());
    }

    public static int toLogicalY(int n2) {
        return (int)((float)(n2 * Gdx.b.h()) / (float)Gdx.b.j());
    }

    public static int toBackBufferX(int n2) {
        return (int)((float)(n2 * Gdx.b.i()) / (float)Gdx.b.g());
    }

    public static int toBackBufferY(int n2) {
        return (int)((float)(n2 * Gdx.b.j()) / (float)Gdx.b.h());
    }
}

