/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.c;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer$FrameBufferTextureAttachmentSpec;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer$GLFrameBufferBuilder;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Array$ArrayIterator;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;

public abstract class GLFrameBuffer
implements Disposable {
    protected static final Map buffers = new HashMap();
    protected static final int GL_DEPTH24_STENCIL8_OES = 35056;
    protected Array textureAttachments = new Array();
    protected static int defaultFramebufferHandle;
    protected static boolean defaultFramebufferHandleInitialized;
    protected int framebufferHandle;
    protected int depthbufferHandle;
    protected int stencilbufferHandle;
    protected int depthStencilPackedBufferHandle;
    protected boolean hasDepthStencilPackedBuffer;
    protected final IntArray colorBufferHandles = new IntArray();
    protected boolean isMRT;
    protected GLFrameBuffer$GLFrameBufferBuilder bufferBuilder;
    private IntBuffer defaultDrawBuffers;
    static final IntBuffer singleInt;

    GLFrameBuffer() {
    }

    protected GLFrameBuffer(GLFrameBuffer$GLFrameBufferBuilder gLFrameBuffer$GLFrameBufferBuilder) {
        this.bufferBuilder = gLFrameBuffer$GLFrameBufferBuilder;
        this.build();
    }

    public GLTexture getColorBufferTexture() {
        return (GLTexture)this.textureAttachments.first();
    }

    public Array getTextureAttachments() {
        return this.textureAttachments;
    }

    protected abstract GLTexture createTexture(GLFrameBuffer$FrameBufferTextureAttachmentSpec var1);

    protected abstract void disposeColorTexture(GLTexture var1);

    protected abstract void attachFrameBufferColorTexture(GLTexture var1);

    protected void build() {
        GL20 gL20 = Gdx.h;
        this.checkValidBuilder();
        if (!defaultFramebufferHandleInitialized) {
            defaultFramebufferHandleInitialized = true;
            if (Gdx.a.e() == c.e) {
                IntBuffer intBuffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
                gL20.glGetIntegerv(36006, intBuffer);
                defaultFramebufferHandle = intBuffer.get(0);
            } else {
                defaultFramebufferHandle = 0;
            }
        }
        this.framebufferHandle = gL20.glGenFramebuffer();
        gL20.glBindFramebuffer(36160, this.framebufferHandle);
        int n2 = this.bufferBuilder.width;
        int n3 = this.bufferBuilder.height;
        if (this.bufferBuilder.hasDepthRenderBuffer) {
            this.depthbufferHandle = gL20.glGenRenderbuffer();
            gL20.glBindRenderbuffer(36161, this.depthbufferHandle);
            if (this.bufferBuilder.samples > 0) {
                Gdx.j.glRenderbufferStorageMultisample(36161, this.bufferBuilder.samples, this.bufferBuilder.depthRenderBufferSpec.internalFormat, n2, n3);
            } else {
                gL20.glRenderbufferStorage(36161, this.bufferBuilder.depthRenderBufferSpec.internalFormat, n2, n3);
            }
        }
        if (this.bufferBuilder.hasStencilRenderBuffer) {
            this.stencilbufferHandle = gL20.glGenRenderbuffer();
            gL20.glBindRenderbuffer(36161, this.stencilbufferHandle);
            if (this.bufferBuilder.samples > 0) {
                Gdx.j.glRenderbufferStorageMultisample(36161, this.bufferBuilder.samples, this.bufferBuilder.stencilRenderBufferSpec.internalFormat, n2, n3);
            } else {
                gL20.glRenderbufferStorage(36161, this.bufferBuilder.stencilRenderBufferSpec.internalFormat, n2, n3);
            }
        }
        if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer) {
            this.depthStencilPackedBufferHandle = gL20.glGenRenderbuffer();
            gL20.glBindRenderbuffer(36161, this.depthStencilPackedBufferHandle);
            if (this.bufferBuilder.samples > 0) {
                Gdx.j.glRenderbufferStorageMultisample(36161, this.bufferBuilder.samples, this.bufferBuilder.packedStencilDepthRenderBufferSpec.internalFormat, n2, n3);
            } else {
                gL20.glRenderbufferStorage(36161, this.bufferBuilder.packedStencilDepthRenderBufferSpec.internalFormat, n2, n3);
            }
            this.hasDepthStencilPackedBuffer = true;
        }
        this.isMRT = this.bufferBuilder.textureAttachmentSpecs.size > 1;
        int n4 = 0;
        if (this.isMRT) {
            for (Object object : this.bufferBuilder.textureAttachmentSpecs) {
                GLTexture gLTexture = this.createTexture((GLFrameBuffer$FrameBufferTextureAttachmentSpec)object);
                this.textureAttachments.add(gLTexture);
                if (((GLFrameBuffer$FrameBufferTextureAttachmentSpec)object).isColorTexture()) {
                    gL20.glFramebufferTexture2D(36160, n4 + 36064, 3553, gLTexture.getTextureObjectHandle(), 0);
                    ++n4;
                    continue;
                }
                if (((GLFrameBuffer$FrameBufferTextureAttachmentSpec)object).isDepth) {
                    gL20.glFramebufferTexture2D(36160, 36096, 3553, gLTexture.getTextureObjectHandle(), 0);
                    continue;
                }
                if (!((GLFrameBuffer$FrameBufferTextureAttachmentSpec)object).isStencil) continue;
                gL20.glFramebufferTexture2D(36160, 36128, 3553, gLTexture.getTextureObjectHandle(), 0);
            }
        } else if (this.bufferBuilder.textureAttachmentSpecs.size > 0) {
            GLFrameBuffer gLFrameBuffer = this;
            GLTexture gLTexture = gLFrameBuffer.createTexture((GLFrameBuffer$FrameBufferTextureAttachmentSpec)gLFrameBuffer.bufferBuilder.textureAttachmentSpecs.first());
            this.textureAttachments.add(gLTexture);
            gL20.glBindTexture(gLTexture.glTarget, gLTexture.getTextureObjectHandle());
        }
        for (Object object : this.bufferBuilder.colorRenderBufferSpecs) {
            int n5 = gL20.glGenRenderbuffer();
            gL20.glBindRenderbuffer(36161, n5);
            if (this.bufferBuilder.samples > 0) {
                Gdx.j.glRenderbufferStorageMultisample(36161, this.bufferBuilder.samples, ((GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec)object).internalFormat, n2, n3);
            } else {
                gL20.glRenderbufferStorage(36161, ((GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec)object).internalFormat, n2, n3);
            }
            Gdx.g.glFramebufferRenderbuffer(36160, n4 + 36064, 36161, n5);
            this.colorBufferHandles.add(n5);
            ++n4;
        }
        if (this.isMRT || this.bufferBuilder.samples > 0) {
            this.defaultDrawBuffers = BufferUtils.newIntBuffer(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                this.defaultDrawBuffers.put(i2 + 36064);
            }
            ((Buffer)this.defaultDrawBuffers).position(0);
            Gdx.i.glDrawBuffers(n4, this.defaultDrawBuffers);
        } else if (this.bufferBuilder.textureAttachmentSpecs.size > 0) {
            GLFrameBuffer gLFrameBuffer = this;
            gLFrameBuffer.attachFrameBufferColorTexture((GLTexture)gLFrameBuffer.textureAttachments.first());
        }
        if (this.bufferBuilder.hasDepthRenderBuffer) {
            gL20.glFramebufferRenderbuffer(36160, 36096, 36161, this.depthbufferHandle);
        }
        if (this.bufferBuilder.hasStencilRenderBuffer) {
            gL20.glFramebufferRenderbuffer(36160, 36128, 36161, this.stencilbufferHandle);
        }
        if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer) {
            gL20.glFramebufferRenderbuffer(36160, 33306, 36161, this.depthStencilPackedBufferHandle);
        }
        gL20.glBindRenderbuffer(36161, 0);
        for (Object object : this.textureAttachments) {
            gL20.glBindTexture(((GLTexture)object).glTarget, 0);
        }
        int n6 = gL20.glCheckFramebufferStatus(36160);
        if (n6 == 36061 && this.bufferBuilder.hasDepthRenderBuffer && this.bufferBuilder.hasStencilRenderBuffer && (Gdx.b.b("GL_OES_packed_depth_stencil") || Gdx.b.b("GL_EXT_packed_depth_stencil"))) {
            if (this.bufferBuilder.hasDepthRenderBuffer) {
                gL20.glDeleteRenderbuffer(this.depthbufferHandle);
                this.depthbufferHandle = 0;
            }
            if (this.bufferBuilder.hasStencilRenderBuffer) {
                gL20.glDeleteRenderbuffer(this.stencilbufferHandle);
                this.stencilbufferHandle = 0;
            }
            if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer) {
                gL20.glDeleteRenderbuffer(this.depthStencilPackedBufferHandle);
                this.depthStencilPackedBufferHandle = 0;
            }
            this.depthStencilPackedBufferHandle = gL20.glGenRenderbuffer();
            this.hasDepthStencilPackedBuffer = true;
            gL20.glBindRenderbuffer(36161, this.depthStencilPackedBufferHandle);
            if (this.bufferBuilder.samples > 0) {
                Gdx.j.glRenderbufferStorageMultisample(36161, this.bufferBuilder.samples, 35056, n2, n3);
            } else {
                gL20.glRenderbufferStorage(36161, 35056, n2, n3);
            }
            gL20.glBindRenderbuffer(36161, 0);
            gL20.glFramebufferRenderbuffer(36160, 36096, 36161, this.depthStencilPackedBufferHandle);
            gL20.glFramebufferRenderbuffer(36160, 36128, 36161, this.depthStencilPackedBufferHandle);
            n6 = gL20.glCheckFramebufferStatus(36160);
        }
        gL20.glBindFramebuffer(36160, defaultFramebufferHandle);
        if (n6 != 36053) {
            for (GLTexture gLTexture : this.textureAttachments) {
                this.disposeColorTexture(gLTexture);
            }
            if (this.hasDepthStencilPackedBuffer) {
                gL20.glDeleteBuffer(this.depthStencilPackedBufferHandle);
            } else {
                if (this.bufferBuilder.hasDepthRenderBuffer) {
                    gL20.glDeleteRenderbuffer(this.depthbufferHandle);
                }
                if (this.bufferBuilder.hasStencilRenderBuffer) {
                    gL20.glDeleteRenderbuffer(this.stencilbufferHandle);
                }
            }
            gL20.glDeleteFramebuffer(this.framebufferHandle);
            if (n6 == 36054) {
                throw new IllegalStateException("Frame buffer couldn't be constructed: incomplete attachment");
            }
            if (n6 == 36057) {
                throw new IllegalStateException("Frame buffer couldn't be constructed: incomplete dimensions");
            }
            if (n6 == 36055) {
                throw new IllegalStateException("Frame buffer couldn't be constructed: missing attachment");
            }
            if (n6 == 36061) {
                throw new IllegalStateException("Frame buffer couldn't be constructed: unsupported combination of formats");
            }
            if (n6 == 36182) {
                throw new IllegalStateException("Frame buffer couldn't be constructed: multisample mismatch");
            }
            throw new IllegalStateException("Frame buffer couldn't be constructed: unknown error ".concat(String.valueOf(n6)));
        }
        GLFrameBuffer.addManagedFrameBuffer(Gdx.a, this);
    }

    private void checkValidBuilder() {
        if (this.bufferBuilder.samples > 0 && !Gdx.b.b()) {
            throw new GdxRuntimeException("Framebuffer multisample requires GLES 3.1+");
        }
        if (this.bufferBuilder.samples > 0 && this.bufferBuilder.textureAttachmentSpecs.size > 0) {
            throw new GdxRuntimeException("Framebuffer multisample with texture attachments not yet supported");
        }
        if (!Gdx.b.a()) {
            boolean bl2;
            boolean bl3 = bl2 = Gdx.b.b("GL_OES_packed_depth_stencil") || Gdx.b.b("GL_EXT_packed_depth_stencil");
            if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer && !bl2) {
                throw new GdxRuntimeException("Packed Stencil/Render render buffers are not available on GLES 2.0");
            }
            if (this.bufferBuilder.textureAttachmentSpecs.size > 1) {
                throw new GdxRuntimeException("Multiple render targets not available on GLES 2.0");
            }
            for (GLFrameBuffer$FrameBufferTextureAttachmentSpec gLFrameBuffer$FrameBufferTextureAttachmentSpec : this.bufferBuilder.textureAttachmentSpecs) {
                if (gLFrameBuffer$FrameBufferTextureAttachmentSpec.isDepth) {
                    throw new GdxRuntimeException("Depth texture FrameBuffer Attachment not available on GLES 2.0");
                }
                if (gLFrameBuffer$FrameBufferTextureAttachmentSpec.isStencil) {
                    throw new GdxRuntimeException("Stencil texture FrameBuffer Attachment not available on GLES 2.0");
                }
                if (!gLFrameBuffer$FrameBufferTextureAttachmentSpec.isFloat || Gdx.b.b("OES_texture_float")) continue;
                throw new GdxRuntimeException("Float texture FrameBuffer Attachment not available on GLES 2.0");
            }
        }
        if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer && (this.bufferBuilder.hasDepthRenderBuffer || this.bufferBuilder.hasStencilRenderBuffer)) {
            throw new GdxRuntimeException("Frame buffer couldn't be constructed: packed stencil depth buffer cannot be specified together with separated depth or stencil buffer");
        }
    }

    @Override
    public void dispose() {
        GL20 gL20 = Gdx.h;
        for (GLTexture gLTexture : this.textureAttachments) {
            this.disposeColorTexture(gLTexture);
        }
        gL20.glDeleteRenderbuffer(this.depthStencilPackedBufferHandle);
        gL20.glDeleteRenderbuffer(this.depthbufferHandle);
        gL20.glDeleteRenderbuffer(this.stencilbufferHandle);
        gL20.glDeleteFramebuffer(this.framebufferHandle);
        if (buffers.get(Gdx.a) != null) {
            ((Array)buffers.get(Gdx.a)).removeValue(this, true);
        }
    }

    public void bind() {
        Gdx.h.glBindFramebuffer(36160, this.framebufferHandle);
    }

    public static void unbind() {
        Gdx.h.glBindFramebuffer(36160, defaultFramebufferHandle);
    }

    public void begin() {
        this.bind();
        this.setFrameBufferViewport();
    }

    protected void setFrameBufferViewport() {
        Gdx.h.glViewport(0, 0, this.bufferBuilder.width, this.bufferBuilder.height);
    }

    public void end() {
        this.end(0, 0, Gdx.b.i(), Gdx.b.j());
    }

    public void end(int n2, int n3, int n4, int n5) {
        GLFrameBuffer.unbind();
        Gdx.h.glViewport(n2, n3, n4, n5);
    }

    public void transfer(GLFrameBuffer gLFrameBuffer) {
        int n2 = 0;
        for (GLFrameBuffer$FrameBufferTextureAttachmentSpec gLFrameBuffer$FrameBufferTextureAttachmentSpec : gLFrameBuffer.bufferBuilder.textureAttachmentSpecs) {
            if (gLFrameBuffer$FrameBufferTextureAttachmentSpec.isDepth && (this.bufferBuilder.hasDepthRenderBuffer || this.bufferBuilder.hasPackedStencilDepthRenderBuffer)) {
                n2 |= 0x100;
                continue;
            }
            if (gLFrameBuffer$FrameBufferTextureAttachmentSpec.isStencil && (this.bufferBuilder.hasStencilRenderBuffer || this.bufferBuilder.hasPackedStencilDepthRenderBuffer)) {
                n2 |= 0x400;
                continue;
            }
            if (this.colorBufferHandles.size <= 0) continue;
            n2 |= 0x4000;
        }
        this.transfer(gLFrameBuffer, n2);
    }

    public void transfer(GLFrameBuffer gLFrameBuffer, int n2) {
        if (gLFrameBuffer.getWidth() != this.getWidth() || gLFrameBuffer.getHeight() != this.getHeight()) {
            throw new IllegalArgumentException("source and destination frame buffers must have same size.");
        }
        Gdx.g.glBindFramebuffer(36008, this.framebufferHandle);
        Gdx.g.glBindFramebuffer(36009, gLFrameBuffer.framebufferHandle);
        int n3 = 0;
        int n4 = 0;
        Array$ArrayIterator array$ArrayIterator = gLFrameBuffer.bufferBuilder.textureAttachmentSpecs.iterator();
        while (array$ArrayIterator.hasNext()) {
            if (((GLFrameBuffer$FrameBufferTextureAttachmentSpec)array$ArrayIterator.next()).isColorTexture()) {
                Gdx.i.glReadBuffer(n3 + 36064);
                singleInt.clear();
                singleInt.put(n4 + 36064);
                singleInt.flip();
                Gdx.i.glDrawBuffers(1, singleInt);
                Gdx.i.glBlitFramebuffer(0, 0, this.getWidth(), this.getHeight(), 0, 0, gLFrameBuffer.getWidth(), gLFrameBuffer.getHeight(), n2, 9728);
                n2 = 16384;
                ++n3;
            }
            ++n4;
        }
        if (n2 != 16384) {
            Gdx.i.glBlitFramebuffer(0, 0, this.getWidth(), this.getHeight(), 0, 0, gLFrameBuffer.getWidth(), gLFrameBuffer.getHeight(), n2, 9728);
        }
        if (gLFrameBuffer.defaultDrawBuffers != null) {
            Gdx.i.glDrawBuffers(gLFrameBuffer.defaultDrawBuffers.limit(), gLFrameBuffer.defaultDrawBuffers);
        }
        Gdx.g.glBindFramebuffer(36008, 0);
        Gdx.g.glBindFramebuffer(36009, 0);
    }

    public int getFramebufferHandle() {
        return this.framebufferHandle;
    }

    public int getDepthBufferHandle() {
        return this.depthbufferHandle;
    }

    public int getColorBufferHandle(int n2) {
        return this.colorBufferHandles.get(n2);
    }

    public int getStencilBufferHandle() {
        return this.stencilbufferHandle;
    }

    protected int getDepthStencilPackedBuffer() {
        return this.depthStencilPackedBufferHandle;
    }

    public int getHeight() {
        return this.bufferBuilder.height;
    }

    public int getWidth() {
        return this.bufferBuilder.width;
    }

    private static void addManagedFrameBuffer(Application application, GLFrameBuffer gLFrameBuffer) {
        Array array = (Array)buffers.get(application);
        if (array == null) {
            array = new Array();
        }
        array.add(gLFrameBuffer);
        buffers.put(application, array);
    }

    public static void invalidateAllFrameBuffers(Application object) {
        if (Gdx.h == null) {
            return;
        }
        if ((object = (Array)buffers.get(object)) == null) {
            return;
        }
        for (int i2 = 0; i2 < ((Array)object).size; ++i2) {
            ((GLFrameBuffer)((Array)object).get(i2)).build();
        }
    }

    public static void clearAllFrameBuffers(Application application) {
        buffers.remove(application);
    }

    public static StringBuilder getManagedStatus(StringBuilder stringBuilder) {
        stringBuilder.append("Managed buffers/app: { ");
        for (Application application : buffers.keySet()) {
            stringBuilder.append(((Array)GLFrameBuffer.buffers.get((Object)application)).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    public static String getManagedStatus() {
        return GLFrameBuffer.getManagedStatus(new StringBuilder()).toString();
    }

    static {
        defaultFramebufferHandleInitialized = false;
        singleInt = BufferUtils.newIntBuffer(1);
    }
}

