/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils.shapebuilders;

import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder$VertexInfo;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.BaseShapeBuilder;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.ShortArray;

public class SphereShapeBuilder
extends BaseShapeBuilder {
    private static final ShortArray tmpIndices = new ShortArray();
    private static final Matrix3 normalTransform = new Matrix3();

    public static void build(MeshPartBuilder meshPartBuilder, float f2, float f3, float f4, int n2, int n3) {
        SphereShapeBuilder.build(meshPartBuilder, f2, f3, f4, n2, n3, 0.0f, 360.0f, 0.0f, 180.0f);
    }

    public static void build(MeshPartBuilder meshPartBuilder, Matrix4 matrix4, float f2, float f3, float f4, int n2, int n3) {
        SphereShapeBuilder.build(meshPartBuilder, matrix4, f2, f3, f4, n2, n3, 0.0f, 360.0f, 0.0f, 180.0f);
    }

    public static void build(MeshPartBuilder meshPartBuilder, float f2, float f3, float f4, int n2, int n3, float f5, float f6, float f7, float f8) {
        SphereShapeBuilder.build(meshPartBuilder, matTmp1.idt(), f2, f3, f4, n2, n3, f5, f6, f7, f8);
    }

    public static void build(MeshPartBuilder meshPartBuilder, Matrix4 matrix4, float f2, float f3, float f4, int n2, int n3, float f5, float f6, float f7, float f8) {
        boolean bl2 = MathUtils.isEqual(f7, 0.0f);
        boolean bl3 = MathUtils.isEqual(f8, 180.0f);
        f2 *= 0.5f;
        f3 *= 0.5f;
        f4 *= 0.5f;
        float f9 = (float)Math.PI / 180 * f5;
        f5 = (float)Math.PI / 180 * (f6 - f5) / (float)n2;
        f6 = (float)Math.PI / 180 * f7;
        f7 = (float)Math.PI / 180 * (f8 - f7) / (float)n3;
        f8 = 1.0f / (float)n2;
        float f10 = 1.0f / (float)n3;
        MeshPartBuilder$VertexInfo meshPartBuilder$VertexInfo = vertTmp3.set(null, null, null, null);
        vertTmp3.set(null, null, null, null).hasNormal = true;
        vertTmp3.set(null, null, null, null).hasPosition = true;
        vertTmp3.set(null, null, null, null).hasUV = true;
        normalTransform.set(matrix4);
        int n4 = n2 + 3;
        tmpIndices.clear();
        tmpIndices.ensureCapacity(n2 << 1);
        SphereShapeBuilder.tmpIndices.size = n4;
        int n5 = 0;
        meshPartBuilder.ensureVertices((n3 + 1) * (n2 + 1));
        meshPartBuilder.ensureRectangleIndices(n2);
        for (int i2 = 0; i2 <= n3; ++i2) {
            float f11 = f6 + f7 * (float)i2;
            float f12 = f10 * (float)i2;
            float f13 = MathUtils.sin(f11);
            float f14 = MathUtils.cos(f11) * f3;
            for (int i3 = 0; i3 <= n2; ++i3) {
                float f15 = f9 + f5 * (float)i3;
                f11 = i2 == 0 && bl2 || i2 == n3 && bl3 ? 1.0f - f8 * ((float)i3 - 0.5f) : 1.0f - f8 * (float)i3;
                meshPartBuilder$VertexInfo.position.set(MathUtils.cos(f15) * f2 * f13, f14, MathUtils.sin(f15) * f4 * f13);
                meshPartBuilder$VertexInfo.normal.set(meshPartBuilder$VertexInfo.position).mul(normalTransform).nor();
                meshPartBuilder$VertexInfo.position.mul(matrix4);
                meshPartBuilder$VertexInfo.uv.set(f11, f12);
                tmpIndices.set(n5, meshPartBuilder.vertex(meshPartBuilder$VertexInfo));
                int n6 = n5 + n4;
                if (i2 > 0 && i3 > 0) {
                    if (i2 == 1 && bl2) {
                        meshPartBuilder.triangle(tmpIndices.get(n5), tmpIndices.get((n6 - 1) % n4), tmpIndices.get((n6 - (n2 + 1)) % n4));
                    } else if (i2 == n3 && bl3) {
                        meshPartBuilder.triangle(tmpIndices.get(n5), tmpIndices.get((n6 - (n2 + 2)) % n4), tmpIndices.get((n6 - (n2 + 1)) % n4));
                    } else {
                        meshPartBuilder.rect(tmpIndices.get(n5), tmpIndices.get((n6 - 1) % n4), tmpIndices.get((n6 - (n2 + 2)) % n4), tmpIndices.get((n6 - (n2 + 1)) % n4));
                    }
                }
                n5 = (n5 + 1) % SphereShapeBuilder.tmpIndices.size;
            }
        }
    }
}

