/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.utils.TextureBinder;

public class RenderContext {
    public final TextureBinder textureBinder;
    private boolean blending;
    private int blendSFactor;
    private int blendDFactor;
    private int depthFunc;
    private float depthRangeNear;
    private float depthRangeFar;
    private boolean depthMask;
    private int cullFace;

    public RenderContext(TextureBinder textureBinder) {
        this.textureBinder = textureBinder;
    }

    public void begin() {
        Gdx.g.glDisable(2929);
        this.depthFunc = 0;
        Gdx.g.glDepthMask(true);
        this.depthMask = true;
        Gdx.g.glDisable(3042);
        this.blending = false;
        Gdx.g.glDisable(2884);
        RenderContext renderContext = this;
        this.blendDFactor = 0;
        renderContext.blendSFactor = 0;
        renderContext.cullFace = 0;
        this.textureBinder.begin();
    }

    public void end() {
        if (this.depthFunc != 0) {
            Gdx.g.glDisable(2929);
        }
        if (!this.depthMask) {
            Gdx.g.glDepthMask(true);
        }
        if (this.blending) {
            Gdx.g.glDisable(3042);
        }
        if (this.cullFace > 0) {
            Gdx.g.glDisable(2884);
        }
        this.textureBinder.end();
    }

    public void setDepthMask(boolean bl2) {
        if (this.depthMask != bl2) {
            this.depthMask = bl2;
            Gdx.g.glDepthMask(this.depthMask);
        }
    }

    public void setDepthTest(int n2) {
        this.setDepthTest(n2, 0.0f, 1.0f);
    }

    public void setDepthTest(int n2, float f2, float f3) {
        boolean bl2;
        boolean bl3 = this.depthFunc != 0;
        boolean bl4 = bl2 = n2 != 0;
        if (this.depthFunc != n2) {
            this.depthFunc = n2;
            if (bl2) {
                Gdx.g.glEnable(2929);
                Gdx.g.glDepthFunc(n2);
            } else {
                Gdx.g.glDisable(2929);
            }
        }
        if (bl2) {
            if (!bl3 || this.depthFunc != n2) {
                this.depthFunc = n2;
                Gdx.g.glDepthFunc(this.depthFunc);
            }
            if (!bl3 || this.depthRangeNear != f2 || this.depthRangeFar != f3) {
                this.depthRangeNear = f2;
                this.depthRangeFar = f3;
                Gdx.g.glDepthRangef(this.depthRangeNear, this.depthRangeFar);
            }
        }
    }

    public void setBlending(boolean bl2, int n2, int n3) {
        if (bl2 != this.blending) {
            this.blending = bl2;
            if (bl2) {
                Gdx.g.glEnable(3042);
            } else {
                Gdx.g.glDisable(3042);
            }
        }
        if (bl2 && (this.blendSFactor != n2 || this.blendDFactor != n3)) {
            Gdx.g.glBlendFunc(n2, n3);
            this.blendSFactor = n2;
            this.blendDFactor = n3;
        }
    }

    public void setCullFace(int n2) {
        if (n2 != this.cullFace) {
            this.cullFace = n2;
            if (n2 == 1028 || n2 == 1029 || n2 == 1032) {
                Gdx.g.glEnable(2884);
                Gdx.g.glCullFace(n2);
                return;
            }
            Gdx.g.glDisable(2884);
        }
    }
}

