/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Array$ArrayIterator;
import com.badlogic.gdx.utils.GdxRuntimeException;

public abstract class BaseShaderProvider
implements ShaderProvider {
    protected Array shaders = new Array();

    @Override
    public Shader getShader(Renderable renderable) {
        Object object = renderable.shader;
        if (object != null && object.canRender(renderable)) {
            return object;
        }
        for (Shader shader : this.shaders) {
            if (!shader.canRender(renderable)) continue;
            return shader;
        }
        object = this.createShader(renderable);
        if (!object.canRender(renderable)) {
            throw new GdxRuntimeException("unable to provide a shader for this renderable");
        }
        object.init();
        this.shaders.add(object);
        return object;
    }

    protected abstract Shader createShader(Renderable var1);

    @Override
    public void dispose() {
        Array$ArrayIterator array$ArrayIterator = this.shaders.iterator();
        while (array$ArrayIterator.hasNext()) {
            ((Shader)array$ArrayIterator.next()).dispose();
        }
        this.shaders.clear();
    }
}

