/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.graphics.g3d.utils.BaseAnimationController$Transform;
import com.badlogic.gdx.graphics.g3d.utils.b;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Array$ArrayIterator;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Entry;
import com.badlogic.gdx.utils.Pool;

public class BaseAnimationController {
    private final Pool transformPool = new b(this);
    private static final ObjectMap transforms = new ObjectMap();
    private boolean applying = false;
    public final ModelInstance target;
    private static final BaseAnimationController$Transform tmpT = new BaseAnimationController$Transform();

    public BaseAnimationController(ModelInstance modelInstance) {
        this.target = modelInstance;
    }

    protected void begin() {
        if (this.applying) {
            throw new GdxRuntimeException("You must call end() after each call to being()");
        }
        this.applying = true;
    }

    protected void apply(Animation animation, float f2, float f3) {
        if (!this.applying) {
            throw new GdxRuntimeException("You must call begin() before adding an animation");
        }
        BaseAnimationController.applyAnimation(transforms, this.transformPool, f3, animation, f2);
    }

    protected void end() {
        if (!this.applying) {
            throw new GdxRuntimeException("You must call begin() first");
        }
        for (ObjectMap$Entry objectMap$Entry : transforms.entries()) {
            ((BaseAnimationController$Transform)objectMap$Entry.value).toMatrix4(((Node)objectMap$Entry.key).localTransform);
            this.transformPool.free((BaseAnimationController$Transform)objectMap$Entry.value);
        }
        transforms.clear();
        this.target.calculateTransforms();
        this.applying = false;
    }

    protected void applyAnimation(Animation animation, float f2) {
        if (this.applying) {
            throw new GdxRuntimeException("Call end() first");
        }
        BaseAnimationController.applyAnimation(null, null, 1.0f, animation, f2);
        this.target.calculateTransforms();
    }

    protected void applyAnimations(Animation animation, float f2, Animation animation2, float f3, float f4) {
        if (animation2 == null || f4 == 0.0f) {
            this.applyAnimation(animation, f2);
            return;
        }
        if (animation == null || f4 == 1.0f) {
            this.applyAnimation(animation2, f3);
            return;
        }
        if (this.applying) {
            throw new GdxRuntimeException("Call end() first");
        }
        this.begin();
        this.apply(animation, f2, 1.0f);
        this.apply(animation2, f3, f4);
        this.end();
    }

    static final int getFirstKeyframeIndexAtTime(Array array, float f2) {
        int n2 = array.size - 1;
        if (n2 <= 0 || f2 < ((NodeKeyframe)array.get((int)0)).keytime || f2 > ((NodeKeyframe)array.get((int)n2)).keytime) {
            return 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (n3 + n2) / 2;
            if (f2 > ((NodeKeyframe)array.get((int)(n4 + 1))).keytime) {
                n3 = n4 + 1;
                continue;
            }
            if (f2 < ((NodeKeyframe)array.get((int)n4)).keytime) {
                n2 = n4 - 1;
                continue;
            }
            return n4;
        }
        return n3;
    }

    private static final Vector3 getTranslationAtTime(NodeAnimation object, float f2, Vector3 vector3) {
        if (((NodeAnimation)object).translation == null) {
            return vector3.set(((NodeAnimation)object).node.translation);
        }
        if (((NodeAnimation)object).translation.size == 1) {
            return vector3.set((Vector3)((NodeKeyframe)((NodeAnimation)object).translation.get((int)0)).value);
        }
        int n2 = BaseAnimationController.getFirstKeyframeIndexAtTime(((NodeAnimation)object).translation, f2);
        NodeKeyframe nodeKeyframe = (NodeKeyframe)((NodeAnimation)object).translation.get(n2);
        vector3.set((Vector3)nodeKeyframe.value);
        if (++n2 < ((NodeAnimation)object).translation.size) {
            object = (NodeKeyframe)((NodeAnimation)object).translation.get(n2);
            f2 = (f2 - nodeKeyframe.keytime) / (((NodeKeyframe)object).keytime - nodeKeyframe.keytime);
            vector3.lerp((Vector3)((NodeKeyframe)object).value, f2);
        }
        return vector3;
    }

    private static final Quaternion getRotationAtTime(NodeAnimation object, float f2, Quaternion quaternion) {
        if (((NodeAnimation)object).rotation == null) {
            return quaternion.set(((NodeAnimation)object).node.rotation);
        }
        if (((NodeAnimation)object).rotation.size == 1) {
            return quaternion.set((Quaternion)((NodeKeyframe)((NodeAnimation)object).rotation.get((int)0)).value);
        }
        int n2 = BaseAnimationController.getFirstKeyframeIndexAtTime(((NodeAnimation)object).rotation, f2);
        NodeKeyframe nodeKeyframe = (NodeKeyframe)((NodeAnimation)object).rotation.get(n2);
        quaternion.set((Quaternion)nodeKeyframe.value);
        if (++n2 < ((NodeAnimation)object).rotation.size) {
            object = (NodeKeyframe)((NodeAnimation)object).rotation.get(n2);
            f2 = (f2 - nodeKeyframe.keytime) / (((NodeKeyframe)object).keytime - nodeKeyframe.keytime);
            quaternion.slerp((Quaternion)((NodeKeyframe)object).value, f2);
        }
        return quaternion;
    }

    private static final Vector3 getScalingAtTime(NodeAnimation object, float f2, Vector3 vector3) {
        if (((NodeAnimation)object).scaling == null) {
            return vector3.set(((NodeAnimation)object).node.scale);
        }
        if (((NodeAnimation)object).scaling.size == 1) {
            return vector3.set((Vector3)((NodeKeyframe)((NodeAnimation)object).scaling.get((int)0)).value);
        }
        int n2 = BaseAnimationController.getFirstKeyframeIndexAtTime(((NodeAnimation)object).scaling, f2);
        NodeKeyframe nodeKeyframe = (NodeKeyframe)((NodeAnimation)object).scaling.get(n2);
        vector3.set((Vector3)nodeKeyframe.value);
        if (++n2 < ((NodeAnimation)object).scaling.size) {
            object = (NodeKeyframe)((NodeAnimation)object).scaling.get(n2);
            f2 = (f2 - nodeKeyframe.keytime) / (((NodeKeyframe)object).keytime - nodeKeyframe.keytime);
            vector3.lerp((Vector3)((NodeKeyframe)object).value, f2);
        }
        return vector3;
    }

    private static final BaseAnimationController$Transform getNodeAnimationTransform(NodeAnimation nodeAnimation, float f2) {
        BaseAnimationController$Transform baseAnimationController$Transform = tmpT;
        BaseAnimationController.getTranslationAtTime(nodeAnimation, f2, baseAnimationController$Transform.translation);
        BaseAnimationController.getRotationAtTime(nodeAnimation, f2, baseAnimationController$Transform.rotation);
        BaseAnimationController.getScalingAtTime(nodeAnimation, f2, baseAnimationController$Transform.scale);
        return baseAnimationController$Transform;
    }

    private static final void applyNodeAnimationDirectly(NodeAnimation nodeAnimation, float f2) {
        Node node = nodeAnimation.node;
        nodeAnimation.node.isAnimated = true;
        BaseAnimationController.getNodeAnimationTransform(nodeAnimation, f2).toMatrix4(node.localTransform);
    }

    private static final void applyNodeAnimationBlending(NodeAnimation object, ObjectMap objectMap, Pool pool, float f2, float f3) {
        Node node = ((NodeAnimation)object).node;
        ((NodeAnimation)object).node.isAnimated = true;
        object = BaseAnimationController.getNodeAnimationTransform((NodeAnimation)object, f3);
        BaseAnimationController$Transform baseAnimationController$Transform = (BaseAnimationController$Transform)objectMap.get(node, null);
        if (baseAnimationController$Transform != null) {
            if (f2 > 0.999999f) {
                baseAnimationController$Transform.set((BaseAnimationController$Transform)object);
                return;
            }
            baseAnimationController$Transform.lerp((BaseAnimationController$Transform)object, f2);
            return;
        }
        if (f2 > 0.999999f) {
            objectMap.put(node, ((BaseAnimationController$Transform)pool.obtain()).set((BaseAnimationController$Transform)object));
            return;
        }
        objectMap.put(node, ((BaseAnimationController$Transform)pool.obtain()).set(node.translation, node.rotation, node.scale).lerp((BaseAnimationController$Transform)object, f2));
    }

    protected static void applyAnimation(ObjectMap object2, Pool pool, float f2, Animation animation, float f3) {
        if (object2 == null) {
            Array$ArrayIterator array$ArrayIterator = animation.nodeAnimations.iterator();
            while (array$ArrayIterator.hasNext()) {
                BaseAnimationController.applyNodeAnimationDirectly((NodeAnimation)array$ArrayIterator.next(), f3);
            }
            return;
        }
        Iterable iterable = ((ObjectMap)object2).keys().iterator();
        while (iterable.hasNext()) {
            ((Node)iterable.next()).isAnimated = false;
        }
        iterable = animation.nodeAnimations.iterator();
        while (iterable.hasNext()) {
            BaseAnimationController.applyNodeAnimationBlending((NodeAnimation)iterable.next(), (ObjectMap)object2, pool, f2, f3);
        }
        for (Object object2 : ((ObjectMap)object2).entries()) {
            if (((Node)((ObjectMap$Entry)object2).key).isAnimated) continue;
            ((Node)((ObjectMap$Entry)object2).key).isAnimated = true;
            ((BaseAnimationController$Transform)((ObjectMap$Entry)object2).value).lerp(((Node)((ObjectMap$Entry)object2).key).translation, ((Node)((ObjectMap$Entry)object2).key).rotation, ((Node)((ObjectMap$Entry)object2).key).scale, f2);
        }
    }

    protected void removeAnimation(Animation object) {
        object = ((Animation)object).nodeAnimations.iterator();
        while (object.hasNext()) {
            ((NodeAnimation)object.next()).node.isAnimated = false;
        }
    }
}

