/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController$AnimationDesc;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController$AnimationListener;
import com.badlogic.gdx.graphics.g3d.utils.BaseAnimationController;
import com.badlogic.gdx.graphics.g3d.utils.a;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;

public class AnimationController
extends BaseAnimationController {
    protected final Pool animationPool = new a(this);
    public AnimationController$AnimationDesc current;
    public AnimationController$AnimationDesc queued;
    public float queuedTransitionTime;
    public AnimationController$AnimationDesc previous;
    public float transitionCurrentTime;
    public float transitionTargetTime;
    public boolean inAction;
    public boolean paused;
    public boolean allowSameAnimation;
    private boolean justChangedAnimation = false;

    public AnimationController(ModelInstance modelInstance) {
        super(modelInstance);
    }

    private AnimationController$AnimationDesc obtain(Animation animation, float f2, float f3, int n2, float f4, AnimationController$AnimationListener animationController$AnimationListener) {
        if (animation == null) {
            return null;
        }
        AnimationController$AnimationDesc animationController$AnimationDesc = (AnimationController$AnimationDesc)this.animationPool.obtain();
        ((AnimationController$AnimationDesc)this.animationPool.obtain()).animation = animation;
        animationController$AnimationDesc.listener = animationController$AnimationListener;
        animationController$AnimationDesc.loopCount = n2;
        animationController$AnimationDesc.speed = f4;
        animationController$AnimationDesc.offset = f2;
        animationController$AnimationDesc.duration = f3 < 0.0f ? animation.duration - f2 : f3;
        animationController$AnimationDesc.time = f4 < 0.0f ? animationController$AnimationDesc.duration : 0.0f;
        return animationController$AnimationDesc;
    }

    private AnimationController$AnimationDesc obtain(String string, float f2, float f3, int n2, float f4, AnimationController$AnimationListener animationController$AnimationListener) {
        if (string == null) {
            return null;
        }
        Animation animation = this.target.getAnimation(string);
        if (animation == null) {
            throw new GdxRuntimeException("Unknown animation: ".concat(String.valueOf(string)));
        }
        return this.obtain(animation, f2, f3, n2, f4, animationController$AnimationListener);
    }

    private AnimationController$AnimationDesc obtain(AnimationController$AnimationDesc animationController$AnimationDesc) {
        return this.obtain(animationController$AnimationDesc.animation, animationController$AnimationDesc.offset, animationController$AnimationDesc.duration, animationController$AnimationDesc.loopCount, animationController$AnimationDesc.speed, animationController$AnimationDesc.listener);
    }

    public void update(float f2) {
        float f3;
        if (this.paused) {
            return;
        }
        if (this.previous != null) {
            float f4;
            this.transitionCurrentTime += f2;
            if (f4 >= this.transitionTargetTime) {
                AnimationController animationController = this;
                animationController.removeAnimation(animationController.previous.animation);
                this.justChangedAnimation = true;
                this.animationPool.free(this.previous);
                this.previous = null;
            }
        }
        if (this.justChangedAnimation) {
            this.target.calculateTransforms();
            this.justChangedAnimation = false;
        }
        if (this.current == null || this.current.loopCount == 0 || this.current.animation == null) {
            return;
        }
        f2 = this.current.update(f2);
        if (f3 >= 0.0f && this.queued != null) {
            this.inAction = false;
            AnimationController animationController = this;
            animationController.animate(animationController.queued, this.queuedTransitionTime);
            this.queued = null;
            if (f2 > 0.0f) {
                this.update(f2);
            }
            return;
        }
        if (this.previous != null) {
            AnimationController animationController = this;
            animationController.applyAnimations(animationController.previous.animation, this.previous.offset + this.previous.time, this.current.animation, this.current.offset + this.current.time, this.transitionCurrentTime / this.transitionTargetTime);
            return;
        }
        AnimationController animationController = this;
        animationController.applyAnimation(animationController.current.animation, this.current.offset + this.current.time);
    }

    public AnimationController$AnimationDesc setAnimation(String string) {
        return this.setAnimation(string, 1, 1.0f, null);
    }

    public AnimationController$AnimationDesc setAnimation(String string, int n2) {
        return this.setAnimation(string, n2, 1.0f, null);
    }

    public AnimationController$AnimationDesc setAnimation(String string, AnimationController$AnimationListener animationController$AnimationListener) {
        return this.setAnimation(string, 1, 1.0f, animationController$AnimationListener);
    }

    public AnimationController$AnimationDesc setAnimation(String string, int n2, AnimationController$AnimationListener animationController$AnimationListener) {
        return this.setAnimation(string, n2, 1.0f, animationController$AnimationListener);
    }

    public AnimationController$AnimationDesc setAnimation(String string, int n2, float f2, AnimationController$AnimationListener animationController$AnimationListener) {
        return this.setAnimation(string, 0.0f, -1.0f, n2, f2, animationController$AnimationListener);
    }

    public AnimationController$AnimationDesc setAnimation(String string, float f2, float f3, int n2, float f4, AnimationController$AnimationListener animationController$AnimationListener) {
        AnimationController animationController = this;
        return animationController.setAnimation(animationController.obtain(string, f2, f3, n2, f4, animationController$AnimationListener));
    }

    protected AnimationController$AnimationDesc setAnimation(Animation animation, float f2, float f3, int n2, float f4, AnimationController$AnimationListener animationController$AnimationListener) {
        AnimationController animationController = this;
        return animationController.setAnimation(animationController.obtain(animation, f2, f3, n2, f4, animationController$AnimationListener));
    }

    protected AnimationController$AnimationDesc setAnimation(AnimationController$AnimationDesc animationController$AnimationDesc) {
        if (this.current == null) {
            this.current = animationController$AnimationDesc;
        } else {
            if (!this.allowSameAnimation && animationController$AnimationDesc != null && this.current.animation == animationController$AnimationDesc.animation) {
                animationController$AnimationDesc.time = this.current.time;
            } else {
                AnimationController animationController = this;
                animationController.removeAnimation(animationController.current.animation);
            }
            this.animationPool.free(this.current);
            this.current = animationController$AnimationDesc;
        }
        this.justChangedAnimation = true;
        return animationController$AnimationDesc;
    }

    public AnimationController$AnimationDesc animate(String string, float f2) {
        return this.animate(string, 1, 1.0f, null, f2);
    }

    public AnimationController$AnimationDesc animate(String string, AnimationController$AnimationListener animationController$AnimationListener, float f2) {
        return this.animate(string, 1, 1.0f, animationController$AnimationListener, f2);
    }

    public AnimationController$AnimationDesc animate(String string, int n2, AnimationController$AnimationListener animationController$AnimationListener, float f2) {
        return this.animate(string, n2, 1.0f, animationController$AnimationListener, f2);
    }

    public AnimationController$AnimationDesc animate(String string, int n2, float f2, AnimationController$AnimationListener animationController$AnimationListener, float f3) {
        return this.animate(string, 0.0f, -1.0f, n2, f2, animationController$AnimationListener, f3);
    }

    public AnimationController$AnimationDesc animate(String string, float f2, float f3, int n2, float f4, AnimationController$AnimationListener animationController$AnimationListener, float f5) {
        AnimationController animationController = this;
        return animationController.animate(animationController.obtain(string, f2, f3, n2, f4, animationController$AnimationListener), f5);
    }

    protected AnimationController$AnimationDesc animate(Animation animation, float f2, float f3, int n2, float f4, AnimationController$AnimationListener animationController$AnimationListener, float f5) {
        AnimationController animationController = this;
        return animationController.animate(animationController.obtain(animation, f2, f3, n2, f4, animationController$AnimationListener), f5);
    }

    protected AnimationController$AnimationDesc animate(AnimationController$AnimationDesc animationController$AnimationDesc, float f2) {
        if (this.current == null || this.current.loopCount == 0) {
            this.current = animationController$AnimationDesc;
        } else if (this.inAction) {
            this.queue(animationController$AnimationDesc, f2);
        } else if (!this.allowSameAnimation && animationController$AnimationDesc != null && this.current.animation == animationController$AnimationDesc.animation) {
            animationController$AnimationDesc.time = this.current.time;
            this.animationPool.free(this.current);
            this.current = animationController$AnimationDesc;
        } else {
            if (this.previous != null) {
                AnimationController animationController = this;
                animationController.removeAnimation(animationController.previous.animation);
                this.animationPool.free(this.previous);
            }
            this.previous = this.current;
            this.current = animationController$AnimationDesc;
            this.transitionCurrentTime = 0.0f;
            this.transitionTargetTime = f2;
        }
        return animationController$AnimationDesc;
    }

    public AnimationController$AnimationDesc queue(String string, int n2, float f2, AnimationController$AnimationListener animationController$AnimationListener, float f3) {
        return this.queue(string, 0.0f, -1.0f, n2, f2, animationController$AnimationListener, f3);
    }

    public AnimationController$AnimationDesc queue(String string, float f2, float f3, int n2, float f4, AnimationController$AnimationListener animationController$AnimationListener, float f5) {
        AnimationController animationController = this;
        return animationController.queue(animationController.obtain(string, f2, f3, n2, f4, animationController$AnimationListener), f5);
    }

    protected AnimationController$AnimationDesc queue(Animation animation, float f2, float f3, int n2, float f4, AnimationController$AnimationListener animationController$AnimationListener, float f5) {
        AnimationController animationController = this;
        return animationController.queue(animationController.obtain(animation, f2, f3, n2, f4, animationController$AnimationListener), f5);
    }

    protected AnimationController$AnimationDesc queue(AnimationController$AnimationDesc animationController$AnimationDesc, float f2) {
        if (this.current == null || this.current.loopCount == 0) {
            this.animate(animationController$AnimationDesc, f2);
        } else {
            if (this.queued != null) {
                this.animationPool.free(this.queued);
            }
            this.queued = animationController$AnimationDesc;
            this.queuedTransitionTime = f2;
            if (this.current.loopCount < 0) {
                this.current.loopCount = 1;
            }
        }
        return animationController$AnimationDesc;
    }

    public AnimationController$AnimationDesc action(String string, int n2, float f2, AnimationController$AnimationListener animationController$AnimationListener, float f3) {
        return this.action(string, 0.0f, -1.0f, n2, f2, animationController$AnimationListener, f3);
    }

    public AnimationController$AnimationDesc action(String string, float f2, float f3, int n2, float f4, AnimationController$AnimationListener animationController$AnimationListener, float f5) {
        AnimationController animationController = this;
        return animationController.action(animationController.obtain(string, f2, f3, n2, f4, animationController$AnimationListener), f5);
    }

    protected AnimationController$AnimationDesc action(Animation animation, float f2, float f3, int n2, float f4, AnimationController$AnimationListener animationController$AnimationListener, float f5) {
        AnimationController animationController = this;
        return animationController.action(animationController.obtain(animation, f2, f3, n2, f4, animationController$AnimationListener), f5);
    }

    protected AnimationController$AnimationDesc action(AnimationController$AnimationDesc animationController$AnimationDesc, float f2) {
        if (animationController$AnimationDesc.loopCount < 0) {
            throw new GdxRuntimeException("An action cannot be continuous");
        }
        if (this.current == null || this.current.loopCount == 0) {
            this.animate(animationController$AnimationDesc, f2);
        } else {
            AnimationController$AnimationDesc animationController$AnimationDesc2;
            if (this.inAction) {
                animationController$AnimationDesc2 = null;
            } else {
                AnimationController animationController = this;
                animationController$AnimationDesc2 = animationController.obtain(animationController.current);
            }
            AnimationController$AnimationDesc animationController$AnimationDesc3 = animationController$AnimationDesc2;
            this.inAction = false;
            this.animate(animationController$AnimationDesc, f2);
            this.inAction = true;
            if (animationController$AnimationDesc3 != null) {
                this.queue(animationController$AnimationDesc3, f2);
            }
        }
        return animationController$AnimationDesc;
    }
}

