/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.FloatAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader$Config;
import com.badlogic.gdx.graphics.g3d.shaders.DepthShader$Config;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class DepthShader
extends DefaultShader {
    private static String defaultVertexShader = null;
    private static String defaultFragmentShader = null;
    public final int numBones;
    private final FloatAttribute alphaTestAttribute;
    private static final Attributes tmpAttributes = new Attributes();

    public static final String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.e.a("com/badlogic/gdx/graphics/g3d/shaders/depth.vertex.glsl").i();
        }
        return defaultVertexShader;
    }

    public static final String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.e.a("com/badlogic/gdx/graphics/g3d/shaders/depth.fragment.glsl").i();
        }
        return defaultFragmentShader;
    }

    public static String createPrefix(Renderable object, DepthShader$Config depthShader$Config) {
        object = DefaultShader.createPrefix((Renderable)object, depthShader$Config);
        if (!depthShader$Config.depthBufferOnly) {
            object = (String)object + "#define PackedDepthFlag\n";
        }
        return object;
    }

    public DepthShader(Renderable renderable) {
        this(renderable, new DepthShader$Config());
    }

    public DepthShader(Renderable renderable, DepthShader$Config depthShader$Config) {
        this(renderable, depthShader$Config, DepthShader.createPrefix(renderable, depthShader$Config));
    }

    public DepthShader(Renderable renderable, DepthShader$Config depthShader$Config, String string) {
        this(renderable, depthShader$Config, string, depthShader$Config.vertexShader != null ? depthShader$Config.vertexShader : DepthShader.getDefaultVertexShader(), depthShader$Config.fragmentShader != null ? depthShader$Config.fragmentShader : DepthShader.getDefaultFragmentShader());
    }

    public DepthShader(Renderable renderable, DepthShader$Config depthShader$Config, String string, String string2, String string3) {
        this(renderable, depthShader$Config, new ShaderProgram(string + string2, string + string3));
    }

    public DepthShader(Renderable renderable, DepthShader$Config depthShader$Config, ShaderProgram shaderProgram) {
        super(renderable, (DefaultShader$Config)depthShader$Config, shaderProgram);
        DepthShader.combineAttributes(renderable);
        if (renderable.bones != null && renderable.bones.length > depthShader$Config.numBones) {
            throw new GdxRuntimeException("too many bones: " + renderable.bones.length + ", max configured: " + depthShader$Config.numBones);
        }
        this.numBones = renderable.bones == null ? 0 : depthShader$Config.numBones;
        int n2 = renderable.meshPart.mesh.getVertexAttributes().getBoneWeights();
        if (n2 > depthShader$Config.numBoneWeights) {
            throw new GdxRuntimeException("too many bone weights: " + n2 + ", max configured: " + depthShader$Config.numBoneWeights);
        }
        this.alphaTestAttribute = new FloatAttribute(FloatAttribute.AlphaTest, depthShader$Config.defaultAlphaTest);
    }

    @Override
    public void begin(Camera camera, RenderContext renderContext) {
        super.begin(camera, renderContext);
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public boolean canRender(Renderable renderable) {
        boolean bl2;
        if (renderable.bones != null) {
            if (renderable.bones.length > this.config.numBones) {
                return false;
            }
            if (renderable.meshPart.mesh.getVertexAttributes().getBoneWeights() > this.config.numBoneWeights) {
                return false;
            }
        }
        Attributes attributes = DepthShader.combineAttributes(renderable);
        boolean bl3 = (this.attributesMask & BlendingAttribute.Type) == BlendingAttribute.Type && (this.attributesMask & TextureAttribute.Diffuse) == TextureAttribute.Diffuse;
        boolean bl4 = bl2 = attributes.has(BlendingAttribute.Type) && attributes.has(TextureAttribute.Diffuse);
        if (bl3 != bl2) {
            return false;
        }
        return renderable.bones != null == this.numBones > 0;
    }

    @Override
    public void render(Renderable renderable, Attributes attributes) {
        if (attributes.has(BlendingAttribute.Type)) {
            BlendingAttribute blendingAttribute = (BlendingAttribute)attributes.get(BlendingAttribute.Type);
            attributes.remove(BlendingAttribute.Type);
            boolean bl2 = attributes.has(FloatAttribute.AlphaTest);
            if (!bl2) {
                attributes.set((Attribute)this.alphaTestAttribute);
            }
            if (blendingAttribute.opacity >= ((FloatAttribute)attributes.get((long)FloatAttribute.AlphaTest)).value) {
                super.render(renderable, attributes);
            }
            if (!bl2) {
                attributes.remove(FloatAttribute.AlphaTest);
            }
            attributes.set((Attribute)blendingAttribute);
            return;
        }
        super.render(renderable, attributes);
    }

    private static final Attributes combineAttributes(Renderable renderable) {
        tmpAttributes.clear();
        if (renderable.environment != null) {
            tmpAttributes.set(renderable.environment);
        }
        if (renderable.material != null) {
            tmpAttributes.set(renderable.material);
        }
        return tmpAttributes;
    }
}

