/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.values;

import com.badlogic.gdx.graphics.g3d.particles.values.ParticleValue;
import com.badlogic.gdx.graphics.g3d.particles.values.PrimitiveSpawnShapeValue;
import com.badlogic.gdx.graphics.g3d.particles.values.PrimitiveSpawnShapeValue$SpawnSide;
import com.badlogic.gdx.graphics.g3d.particles.values.SpawnShapeValue;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public final class EllipseSpawnShapeValue
extends PrimitiveSpawnShapeValue {
    PrimitiveSpawnShapeValue$SpawnSide side = PrimitiveSpawnShapeValue$SpawnSide.both;

    public EllipseSpawnShapeValue(EllipseSpawnShapeValue ellipseSpawnShapeValue) {
        super(ellipseSpawnShapeValue);
        ((ParticleValue)this).load(ellipseSpawnShapeValue);
    }

    public EllipseSpawnShapeValue() {
    }

    @Override
    public final void spawnAux(Vector3 vector3, float f2) {
        float f3;
        float f4 = this.spawnWidth + this.spawnWidthDiff * this.spawnWidthValue.getScale(f2);
        float f5 = this.spawnHeight + this.spawnHeightDiff * this.spawnHeightValue.getScale(f2);
        f2 = this.spawnDepth + this.spawnDepthDiff * this.spawnDepthValue.getScale(f2);
        float f6 = (float)Math.PI * 2;
        if (this.side == PrimitiveSpawnShapeValue$SpawnSide.top) {
            f6 = (float)Math.PI;
        } else if (this.side == PrimitiveSpawnShapeValue$SpawnSide.bottom) {
            f6 = (float)(-Math.PI);
        }
        f6 = MathUtils.random(0.0f, f6);
        if (this.edges) {
            if (f4 == 0.0f) {
                vector3.set(0.0f, f5 / 2.0f * MathUtils.sin(f6), f2 / 2.0f * MathUtils.cos(f6));
                return;
            }
            if (f5 == 0.0f) {
                vector3.set(f4 / 2.0f * MathUtils.cos(f6), 0.0f, f2 / 2.0f * MathUtils.sin(f6));
                return;
            }
            if (f2 == 0.0f) {
                vector3.set(f4 / 2.0f * MathUtils.cos(f6), f5 / 2.0f * MathUtils.sin(f6), 0.0f);
                return;
            }
            f4 /= 2.0f;
            f5 /= 2.0f;
            f2 /= 2.0f;
        } else {
            f4 = MathUtils.random(f4 / 2.0f);
            f5 = MathUtils.random(f5 / 2.0f);
            f2 = MathUtils.random(f2 / 2.0f);
        }
        float f7 = f3 = MathUtils.random(-1.0f, 1.0f);
        float f8 = (float)Math.sqrt(1.0f - f7 * f7);
        vector3.set(f4 * f8 * MathUtils.cos(f6), f5 * f8 * MathUtils.sin(f6), f2 * f3);
    }

    public final PrimitiveSpawnShapeValue$SpawnSide getSide() {
        return this.side;
    }

    public final void setSide(PrimitiveSpawnShapeValue$SpawnSide primitiveSpawnShapeValue$SpawnSide) {
        this.side = primitiveSpawnShapeValue$SpawnSide;
    }

    @Override
    public final void load(ParticleValue particleValue) {
        super.load(particleValue);
        particleValue = (EllipseSpawnShapeValue)particleValue;
        this.side = ((EllipseSpawnShapeValue)particleValue).side;
    }

    @Override
    public final SpawnShapeValue copy() {
        return new EllipseSpawnShapeValue(this);
    }

    @Override
    public final void write(Json json) {
        super.write(json);
        json.writeValue("side", (Object)this.side);
    }

    @Override
    public final void read(Json json, JsonValue jsonValue) {
        super.read(json, jsonValue);
        this.side = (PrimitiveSpawnShapeValue$SpawnSide)((Object)json.readValue("side", PrimitiveSpawnShapeValue$SpawnSide.class, jsonValue));
    }
}

