/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.a.d;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$FloatChannel;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData$SaveData;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.graphics.g3d.particles.influencers.RegionInfluencer$AspectTextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public abstract class RegionInfluencer
extends Influencer {
    public Array regions;
    ParallelArray$FloatChannel regionChannel;
    public String atlasName;
    private static final String ASSET_DATA = "atlasAssetData";

    public RegionInfluencer(int n2) {
        this.regions = new Array(false, n2, RegionInfluencer$AspectTextureRegion[]::new);
    }

    public RegionInfluencer() {
        this(1);
        RegionInfluencer$AspectTextureRegion regionInfluencer$AspectTextureRegion = new RegionInfluencer$AspectTextureRegion();
        new RegionInfluencer$AspectTextureRegion().v = 0.0f;
        new RegionInfluencer$AspectTextureRegion().u = 0.0f;
        RegionInfluencer$AspectTextureRegion regionInfluencer$AspectTextureRegion2 = regionInfluencer$AspectTextureRegion;
        regionInfluencer$AspectTextureRegion2.v2 = 1.0f;
        regionInfluencer$AspectTextureRegion2.u2 = 1.0f;
        regionInfluencer$AspectTextureRegion.halfInvAspectRatio = 0.5f;
        this.regions.add(regionInfluencer$AspectTextureRegion);
    }

    public RegionInfluencer(TextureRegion ... textureRegionArray) {
        this.setAtlasName(null);
        this.regions = new Array(false, textureRegionArray.length, RegionInfluencer$AspectTextureRegion[]::new);
        this.add(textureRegionArray);
    }

    public RegionInfluencer(Texture texture) {
        this(new TextureRegion(texture));
    }

    public RegionInfluencer(RegionInfluencer regionInfluencer) {
        this(regionInfluencer.regions.size);
        this.regions.ensureCapacity(regionInfluencer.regions.size);
        for (int i2 = 0; i2 < regionInfluencer.regions.size; ++i2) {
            this.regions.add(new RegionInfluencer$AspectTextureRegion((RegionInfluencer$AspectTextureRegion)regionInfluencer.regions.get(i2)));
        }
    }

    public void setAtlasName(String string) {
        this.atlasName = string;
    }

    public void add(TextureRegion ... textureRegionArray) {
        this.regions.ensureCapacity(textureRegionArray.length);
        for (TextureRegion textureRegion : textureRegionArray) {
            this.regions.add(new RegionInfluencer$AspectTextureRegion(textureRegion));
        }
    }

    public void clear() {
        this.atlasName = null;
        this.regions.clear();
    }

    @Override
    public void load(d disposable, ResourceData object) {
        super.load((d)disposable, (ResourceData)object);
        object = ((ResourceData)object).getSaveData(ASSET_DATA);
        if (object == null) {
            return;
        }
        disposable = (TextureAtlas)disposable.a(((ResourceData$SaveData)object).loadAsset());
        object = this.regions.iterator();
        while (object.hasNext()) {
            ((RegionInfluencer$AspectTextureRegion)object.next()).updateUV((TextureAtlas)disposable);
        }
    }

    @Override
    public void save(d object, ResourceData resourceData) {
        super.save((d)object, resourceData);
        if (this.atlasName != null) {
            object = resourceData.getSaveData(ASSET_DATA);
            if (object == null) {
                object = resourceData.createSaveData(ASSET_DATA);
            }
            ((ResourceData$SaveData)object).saveAsset(this.atlasName, TextureAtlas.class);
        }
    }

    @Override
    public void allocateChannels() {
        this.regionChannel = (ParallelArray$FloatChannel)this.controller.particles.addChannel(ParticleChannels.TextureRegion);
    }

    @Override
    public void write(Json json) {
        json.writeValue("regions", this.regions, Array.class, RegionInfluencer$AspectTextureRegion.class);
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        this.regions.clear();
        this.regions.addAll((Array)json.readValue("regions", Array.class, RegionInfluencer$AspectTextureRegion.class, jsonValue));
    }
}

