/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$FloatChannel;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.influencers.DynamicsModifier$Angular;
import com.badlogic.gdx.math.MathUtils;

public class DynamicsModifier$Rotational3D
extends DynamicsModifier$Angular {
    ParallelArray$FloatChannel rotationChannel;
    ParallelArray$FloatChannel rotationalForceChannel;

    public DynamicsModifier$Rotational3D() {
    }

    public DynamicsModifier$Rotational3D(DynamicsModifier$Rotational3D dynamicsModifier$Rotational3D) {
        super(dynamicsModifier$Rotational3D);
    }

    @Override
    public void allocateChannels() {
        super.allocateChannels();
        this.rotationChannel = (ParallelArray$FloatChannel)this.controller.particles.addChannel(ParticleChannels.Rotation3D);
        this.rotationalForceChannel = (ParallelArray$FloatChannel)this.controller.particles.addChannel(ParticleChannels.AngularVelocity3D);
    }

    @Override
    public void update() {
        int n2 = 0;
        int n3 = 2;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.controller.particles.size * this.rotationalForceChannel.strideSize;
        while (n2 < n6) {
            float f2 = this.lifeChannel.data[n3];
            float f3 = this.strengthChannel.data[n4] + this.strengthChannel.data[n4 + 1] * this.strengthValue.getScale(f2);
            float f4 = this.angularChannel.data[n5 + 2] + this.angularChannel.data[n5 + 3] * this.phiValue.getScale(f2);
            f2 = this.angularChannel.data[n5] + this.angularChannel.data[n5 + 1] * this.thetaValue.getScale(f2);
            float f5 = MathUtils.cosDeg(f2);
            f2 = MathUtils.sinDeg(f2);
            float f6 = MathUtils.cosDeg(f4);
            f4 = MathUtils.sinDeg(f4);
            TMP_V3.set(f5 * f4, f6, f2 * f4);
            TMP_V3.scl(f3 * ((float)Math.PI / 180));
            int n7 = n2;
            this.rotationalForceChannel.data[n7] = this.rotationalForceChannel.data[n7] + DynamicsModifier$Rotational3D.TMP_V3.x;
            int n8 = n2 + 1;
            this.rotationalForceChannel.data[n8] = this.rotationalForceChannel.data[n8] + DynamicsModifier$Rotational3D.TMP_V3.y;
            int n9 = n2 + 2;
            this.rotationalForceChannel.data[n9] = this.rotationalForceChannel.data[n9] + DynamicsModifier$Rotational3D.TMP_V3.z;
            n4 += this.strengthChannel.strideSize;
            n2 += this.rotationalForceChannel.strideSize;
            n5 += this.angularChannel.strideSize;
            n3 += this.lifeChannel.strideSize;
        }
    }

    @Override
    public DynamicsModifier$Rotational3D copy() {
        return new DynamicsModifier$Rotational3D(this);
    }
}

